package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.bean.SubPicketageRefsupplierEntity;
import com.ejianc.business.tender.sub.mapper.SubPicketageRefsupplierMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 * 
 * @author generator
 * 
 */
@Service("subPicketageRefsupplierService")
public class SubPicketageRefsupplierServiceImpl extends BaseServiceImpl<SubPicketageRefsupplierMapper, SubPicketageRefsupplierEntity> implements ISubPicketageRefsupplierService {
    @Autowired
    private ISubPicketageService subPicketageService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private ISubInviteDetailBidderService subInviteDetailBidderService;
    @Autowired
    private ISubInviteDetailService subInviteDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Transactional
    @Override
    public String updateById(Long id,Integer occupyFlag) {
//        占用状态0-未占用,1-已占用,2-已完成
        SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = super.selectById(id);
        subPicketageRefsupplierEntity.setOccupyFlag(occupyFlag);
        super.updateById(subPicketageRefsupplierEntity);
        return "更新成功!";
    }

    @Override
    @Transactional
    public String updateStatus(TenderPicketageVO tenderPicketageVO,Integer type) {
        logger.info("修改类型"+type);
        String stringFb = JSONObject.toJSONString(tenderPicketageVO);
        logger.info("分包定标占用参数"+stringFb);
        SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = super.selectById(tenderPicketageVO.getId());
        //picketageFlag 定标类型0-流程定标,1-直接定标

        Integer picketageFlag = subPicketageRefsupplierEntity.getPicketageFlag();
        if (type == 1){
            tenderPicketageVO.setContractMoney(tenderPicketageVO.getContractMoney().negate());
            tenderPicketageVO.setContractMoneyTax(tenderPicketageVO.getContractMoneyTax().negate());
            for (TenderPicketageDetailVO tenderPicketageDetailVO : tenderPicketageVO.getTenderPicketageDetailList()){
                tenderPicketageDetailVO.setSignNum(tenderPicketageDetailVO.getSignNum().negate());
            }
        }
        SubPicketageEntity subPicketageEntity = subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId());
        SubInviteEntity subInviteEntity = null;
        if(picketageFlag == 0){
            subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());
        }
        if(picketageFlag == 1){
            subInviteEntity = subInviteService.selectById(subPicketageRefsupplierEntity.getPicketageId());
        }

        //根据子表id更新签订数量
        List<TenderPicketageDetailVO> tenderPicketageDetailList = tenderPicketageVO.getTenderPicketageDetailList();
        List<Long> sellIds = tenderPicketageDetailList.stream().map(TenderPicketageDetailVO::getId).collect(Collectors.toList());
        Map<Long, TenderPicketageDetailVO> detailVOMap = tenderPicketageDetailList.stream().collect(Collectors.toMap(TenderPicketageDetailVO::getId, Function.identity()));
        if (picketageFlag == 0) {
            LambdaQueryWrapper<SubDocumentSellEntity> lambdaSell = Wrappers.<SubDocumentSellEntity>lambdaQuery();
            lambdaSell.in(SubDocumentSellEntity::getId, sellIds);
            List<SubDocumentSellEntity> sellEntityList = subDocumentSellService.list(lambdaSell);
            for (SubDocumentSellEntity subDocumentSellEntity : sellEntityList) {
                TenderPicketageDetailVO tenderPicketageDetailVO = detailVOMap.get(subDocumentSellEntity.getId());
                BigDecimal num = subDocumentSellEntity.getSignNum() == null ? BigDecimal.ZERO : subDocumentSellEntity.getSignNum();
                BigDecimal signNum = num.add(tenderPicketageDetailVO.getSignNum());
                subDocumentSellEntity.setSignNum(signNum);
            }
            if(CollectionUtils.isNotEmpty(sellEntityList)){
                subDocumentSellService.updateBatchById(sellEntityList);
            }
        }
        if (picketageFlag == 1) {
            LambdaQueryWrapper<SubInviteDetailBidderEntity> lambdaBidder = Wrappers.<SubInviteDetailBidderEntity>lambdaQuery();
            lambdaBidder.in(SubInviteDetailBidderEntity::getId, sellIds);
            List<SubInviteDetailBidderEntity> bidderEntityList = subInviteDetailBidderService.list(lambdaBidder);
            for (SubInviteDetailBidderEntity subInviteDetailBidderEntity : bidderEntityList) {
                TenderPicketageDetailVO tenderPicketageDetailVO = detailVOMap.get(subInviteDetailBidderEntity.getId());
                BigDecimal num = subInviteDetailBidderEntity.getSignNum() == null ? BigDecimal.ZERO : subInviteDetailBidderEntity.getSignNum();
                BigDecimal signNum = num.add(tenderPicketageDetailVO.getSignNum());
                subInviteDetailBidderEntity.setSignNum(signNum);
            }
            if(CollectionUtils.isNotEmpty(bidderEntityList)){
                subInviteDetailBidderService.updateBatchById(bidderEntityList);
            }

        }
        Boolean allSign = null;
        Boolean wqSign = null;
        if (picketageFlag == 0) {

            LambdaQueryWrapper<SubDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(SubDocumentSellEntity::getDocumentId,subPicketageEntity.getDocumentId());
            listWrapper.eq(SubDocumentSellEntity::getSupplierId,subPicketageRefsupplierEntity.getSupplierId());
            if (subPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(SubDocumentSellEntity::getProjectId,subPicketageRefsupplierEntity.getProjectId());
            }

            listWrapper.eq(SubDocumentSellEntity::getTenderFlag,1);
            List<SubDocumentSellEntity> documentSellList = subDocumentSellService.list(listWrapper);

            //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
            allSign = documentSellList.stream().allMatch(e -> (e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(e.getTenderNum()) > -1);
            wqSign = documentSellList.stream().allMatch(e ->(e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(BigDecimal.ZERO) == 0);

        }
        if (picketageFlag == 1) {

            List<SubInviteDetailBidderEntity> detailBidderList = subInviteDetailBidderService.selectSonDetail(subPicketageRefsupplierEntity.getPicketageId());

            allSign = detailBidderList.stream().allMatch(e -> (e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(e.getNum()) > -1);
            wqSign = detailBidderList.stream().allMatch(e ->(e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(BigDecimal.ZERO) == 0);

        }

        Integer signStatus = null;
        if (allSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (wqSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (!subPicketageRefsupplierEntity.getSignStatus().equals(TenderSignStatusEnum.已关闭.getCode()) && !allSign && !wqSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }
        if (subPicketageRefsupplierEntity.getSignStatus().equals(TenderSignStatusEnum.已关闭.getCode())) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }

        subPicketageRefsupplierEntity.setSignStatus(signStatus);
        //更新参照表状态
        BigDecimal contractMoney = subPicketageRefsupplierEntity.getContractMoney() == null ? BigDecimal.ZERO : subPicketageRefsupplierEntity.getContractMoney();
        BigDecimal contractMoneyTax = subPicketageRefsupplierEntity.getContractMoneyTax() == null ? BigDecimal.ZERO : subPicketageRefsupplierEntity.getContractMoneyTax();
        subPicketageRefsupplierEntity.setContractMoney(contractMoney.add(tenderPicketageVO.getContractMoney()));
        subPicketageRefsupplierEntity.setContractMoneyTax(contractMoneyTax.add(tenderPicketageVO.getContractMoneyTax()));
        super.updateById(subPicketageRefsupplierEntity);

        //更新招标状态
        LambdaQueryWrapper<SubPicketageRefsupplierEntity> lambdaRef = Wrappers.<SubPicketageRefsupplierEntity>lambdaQuery();
        lambdaRef.eq(SubPicketageRefsupplierEntity::getPicketageId, subPicketageRefsupplierEntity.getPicketageId());
        List<SubPicketageRefsupplierEntity> picketageRefsupplierList = super.list(lambdaRef);
        //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
        Boolean inviteWSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.未签订.getCode());
        Boolean inviteAllSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.全部已签.getCode());
        Boolean inviteAllCloseSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.已关闭.getCode());
        if (inviteWSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (inviteAllSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }
        if (!inviteWSign && !inviteAllSign && !inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }

        subInviteEntity.setSignStatus(signStatus);
        //更新参照表状态
        subInviteService.updateById(subInviteEntity);

        return "更新成功";
    }
}
