package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.vo.WinDetailVO;
import com.ejianc.business.tender.stuff.vo.WinVO;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubWinnoticeMapper;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.SubPicketageSupplierVO;
import com.ejianc.business.tender.sub.vo.SubWinnoticeVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * 中标公告表
 * 
 * @author generator
 * 
 */
@Service("subWinnoticeService")
public class SubWinnoticeServiceImpl extends BaseServiceImpl<SubWinnoticeMapper, SubWinnoticeEntity> implements ISubWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISubPicketageService subPicketageService;
    @Autowired
    private ISubNoticeService subNoticeService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubBidDetailService subBidDetailService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private ISubBidSupplierService subBidSupplierService;
    @Autowired
    private ISubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value("${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISubPicketageSupplierService subPicketageSupplierService;
    @Transactional
    @Override
    public SubWinnoticeVO saveWinnotice(Long picketageId) {
        SubWinnoticeEntity entity = new SubWinnoticeEntity();
        entity.setPicketageId(picketageId);
        SubPicketageEntity subPicketageEntity = subPicketageService.selectById(picketageId);
        SubInviteEntity inviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());
        entity.setInviteId(subPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName()+"中标公告");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());

        //采购方式(0-项目采购,1-单位采购)
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setProjectCode(inviteEntity.getProjectCode());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());

        SubDocumentEntity subDocumentEntity = subDocumentService.selectById(subPicketageEntity.getDocumentId());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setLineTypeName(CommonUtils.getTypeName(1));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate(entity, false);

        //回写定标数据
        subPicketageEntity.setWinnoticeStatus(1);
        subPicketageEntity.setWinnoticeId(entity.getId());
        subPicketageService.updateById(subPicketageEntity);
//回写定标子表数据
        List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        for (SubPicketageSupplierEntity subPicketageSupplierEntity : picketageSupplierList){
            subPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        subPicketageSupplierService.updateBatchById(picketageSupplierList);
        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        subInviteService.updateById(inviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(CommonUtils.TYPE_SUB);
        processEntity.setFrontendUrl("sub/winnotice");
        processService.saveOrUpdate(processEntity);
        SubWinnoticeVO subWinnoticeVO = BeanMapper.map(entity, SubWinnoticeVO.class);
        return subWinnoticeVO;
    }

    @Override
    public SubWinnoticeVO queryDetail(Long id) {
        SubWinnoticeEntity subWinnoticeEntity = super.selectById(id);
        SubWinnoticeVO subWinnoticeVO = BeanMapper.map(subWinnoticeEntity, SubWinnoticeVO.class);
        SubPicketageEntity subPicketageEntity = subPicketageService.selectById(subWinnoticeEntity.getPicketageId());
        List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List<SubPicketageSupplierVO> subPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, SubPicketageSupplierVO.class);
        subWinnoticeVO.setPicketageSupplierList(subPicketageSupplierList);
        return subWinnoticeVO;
    }

    @Override
    public SubWinnoticeVO publishWinnotice(Long id) {
        
        //更新发布状态
        SubWinnoticeEntity subWinnoticeEntity = super.selectById(id);
        subWinnoticeEntity.setPublishFlag(0);
        super.updateById(subWinnoticeEntity);

        //回写定标数据
        SubPicketageEntity subPicketageEntity = subPicketageService.selectById(subWinnoticeEntity.getPicketageId());
        subPicketageEntity.setWinnoticeStatus(2);
        subPicketageService.updateById(subPicketageEntity);

        SubInviteEntity subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());

        //调用供方接口
        //调用第三方报名接口
        //推送供应商
        SubWinVO winVO = new SubWinVO();
        winVO.setSourceType("云南建投中标公告");
        winVO.setSourceId(Long.toString(subWinnoticeEntity.getInviteId()));
        winVO.setBillCode(subInviteEntity.getBillCode());
        //采购方式(0-项目采购,1-单位采购)
        if (subInviteEntity.getPurchaseType() == 0){
            winVO.setSourceProjectId(Long.toString(subInviteEntity.getProjectId()));
            winVO.setProjectName(subInviteEntity.getProjectName());
            winVO.setProjectCode(subInviteEntity.getProjectCode());
        }

        if (subInviteEntity.getPurchaseType() == 1){
            winVO.setOrgName(subInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(subInviteEntity.getOrgId()));

        }
        winVO.setSourceUnitId(Long.toString(subInviteEntity.getUnitId()));
        winVO.setUnitName(subInviteEntity.getUnitName());
        winVO.setType("MATERIAL");
        winVO.setTenderName(subInviteEntity.getTenderName());
        winVO.setTenderType(subInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(subWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(subWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(subWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(subInviteEntity.getPurchaseType());
        winVO.setWinDate(subWinnoticeEntity.getWinDate());
        winVO.setWinTitle(subWinnoticeEntity.getTitleName());
        winVO.setStopDate(subWinnoticeEntity.getStopDate());
        winVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());


        //明细设置
        List<SubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List<SubWinDetailVO> winDetailVOS = new ArrayList<>();
        for (SubPicketageSupplierEntity subPicketageSupplierEntity : picketageSupplierList){
            SubWinDetailVO subWinDetailVO = new SubWinDetailVO();
            subWinDetailVO.setWinId(subWinnoticeEntity.getId());
            subWinDetailVO.setSupplierName(subPicketageSupplierEntity.getSupplierName());
            subWinDetailVO.setTenderFlag(subPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = shareSupplierApi.queryById(subPicketageSupplierEntity.getSupplierId()).getData();
            subWinDetailVO.setTenantId(supplierVO.getTenant());
            subWinDetailVO.setMoney(subPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(subWinDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString(winVO);
        logger.info("中标公告发布" + stringFb);
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winSaveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标公告同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public SubWinnoticeVO saveOrUpdates(SubWinnoticeEntity entity) {
        super.saveOrUpdate(entity,false);
        return queryDetail(entity.getId());
    }
}
