package com.ejianc.business.tender.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSchemeMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentPicketageMapper;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.*;
import com.ejianc.business.tender.rmat.bean.RmatPicketageSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageSupplierEntity;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标主表
 * 
 * @author generator
 * 
 */
@Service("equipmentPicketageService")
public class EquipmentPicketageServiceImpl extends BaseServiceImpl<EquipmentPicketageMapper, EquipmentPicketageEntity> implements IEquipmentPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private EquipmentDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IEquipmentTalkService equipmentTalkService;
    @Autowired
    private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public EquipmentPicketageVO savePicketage(Long evaluationId) {

        EquipmentPicketageEntity entity = new EquipmentPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //转换数据
        ExpertEvaluatingEntity equipmentEvaluationEntity = IExpertEvaluatingService.selectById(evaluationId);
        EquipmentInviteEntity inviteEntity = equipmentInviteService.selectById(equipmentEvaluationEntity.getInviteId());
        EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.selectById(equipmentEvaluationEntity.getDocumentId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setPurchaseType(inviteEntity.getPurchaseType());

        entity.setEmployeeId(equipmentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        entity.setValueType(equipmentDocumentEntity.getValueType());
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId());
        entity.setPurchaseId(equipmentInviteEntity.getPurchaseId());
        entity.setPurchaseName(equipmentInviteEntity.getPurchaseName());
        entity.setDocumentId(equipmentEvaluationEntity.getDocumentId());
        entity.setEvaluationId(equipmentEvaluationEntity.getId());
        entity.setInviteId(equipmentEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
//材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(2));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        EquipmentPicketageVO vo = BeanMapper.map(entity, EquipmentPicketageVO.class);

        //回写招标阶段
        equipmentInviteEntity.setTenderStage(5);
        equipmentInviteService.updateById(equipmentInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/picketage");
        processService.saveOrUpdate(processEntity);

        //回写方案得分
        List<EquipmentDocumentSchemeEntity> schemeList = schemeMapper.selectSupplier(equipmentDocumentEntity.getId());
        for (EquipmentDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score  = recordMapper.selectScore(schemeEntity.getId(),schemeEntity.getSupplierId(),equipmentDocumentEntity.getId());
            Boolean scoreBoolean = schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), equipmentDocumentEntity.getId(), score);
            if (!scoreBoolean){
                throw new BusinessException("回写方案得分失败!");
            }
        }
        return vo;
    }
    @Transactional
    @Override
    public EquipmentPicketageVO queryDetail(Long id) {
        EquipmentPicketageEntity equipmentPicketageEntity = super.selectById(id);
        //查询最大轮数
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambdaSupplier = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, equipmentPicketageEntity.getDocumentId());
        List<EquipmentDocumentSupplierEntity> supplierEntityList = equipmentDocumentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(EquipmentDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();


        EquipmentDocumentEntity entity = equipmentDocumentService.selectById(equipmentPicketageEntity.getDocumentId());
        EquipmentDocumentVO equipmentDocumentVO = BeanMapper.map(entity, EquipmentDocumentVO.class);
        //按材料查看报价
        List<EquipmentDocumentDetailVO> equipmentDocumentDetailList = equipmentDocumentVO.getEquipmentDocumentDetailList();
        //获取材料明细报价
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, equipmentPicketageEntity.getDocumentId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, talkNumMax);
        lambdaSell.eq(EquipmentDocumentSellEntity::getPassFlag, 1);
        lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSchemeName);
        List<EquipmentDocumentSellEntity> sellList = equipmentDocumentSellService.list(lambdaSell);
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = BeanMapper.mapList(sellList, EquipmentDocumentSellVO.class);
        //查询所有方案
        LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId, equipmentPicketageEntity.getDocumentId());
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum, talkNumMax);
        lambdaScheme.orderByAsc(EquipmentDocumentSchemeEntity::getSchemeName);
        List<EquipmentDocumentSchemeEntity> schemeList = equipmentDocumentSchemeService.list(lambdaScheme);
        for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : schemeList){
            for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOS){
                if (equipmentDocumentSellVO.getSchemeId().equals(equipmentDocumentSchemeEntity.getId())){
                    equipmentDocumentSellVO.setScore(equipmentDocumentSchemeEntity.getScore());
                }

            }

        }

        //排序
        EquipmentDocumentSellVO equipmentDocumentSellFirst = equipmentDocumentSellVOS.stream().findFirst().get();
        if (equipmentDocumentSellFirst.getScore() == null){
            equipmentDocumentSellVOS.sort(Comparator.comparing(EquipmentDocumentSellVO::getCreateTime).reversed());
        }
        if (equipmentDocumentSellFirst.getScore() != null){
            equipmentDocumentSellVOS.sort(Comparator.comparing(EquipmentDocumentSellVO::getScore).reversed());
        }
        //根据物料详情主键分组
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOS.stream().
                collect(Collectors.groupingBy(EquipmentDocumentSellVO::getDetailId));
        for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList){
            List<EquipmentDocumentSellVO> equipmentDocumentSellEntities = sellMap.get(equipmentDocumentDetailVO.getId());
            equipmentDocumentDetailVO.setEquipmentDocumentSellVOList(equipmentDocumentSellEntities);
        }

        EquipmentPicketageVO equipmentPicketageVO = BeanMapper.map(equipmentPicketageEntity, EquipmentPicketageVO.class);
        equipmentPicketageVO.setEquipmentDocumentDetailList(equipmentDocumentDetailList);
        if (equipmentDocumentSellFirst.getScore() == null) {
            equipmentPicketageVO.setScoreStatus(1);
        }
        if (equipmentDocumentSellFirst.getScore() != null) {
            equipmentPicketageVO.setScoreStatus(0);
        }
        
        return equipmentPicketageVO;

    }

    @Override
    public EquipmentPicketageVO saveOrUpdates(EquipmentPicketageVO saveorUpdateVO) {
        EquipmentPicketageEntity entity = BeanMapper.map(saveorUpdateVO, EquipmentPicketageEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity,false);

        //先删后增供应商定标数据
        LambdaQueryWrapper<EquipmentPicketageSupplierEntity> lambdaSupplier = Wrappers.<EquipmentPicketageSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(EquipmentPicketageSupplierEntity::getPicketageId,entity.getId());
        equipmentPicketageSupplierService.remove(lambdaSupplier);
        List<EquipmentPicketageSupplierVO> picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for(EquipmentPicketageSupplierVO equipmentPicketageSupplierVO : picketageSupplierList){
            equipmentPicketageSupplierVO.setTenderFlag(0);
        }
        List<EquipmentPicketageSupplierEntity> equipmentPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, EquipmentPicketageSupplierEntity.class);
        equipmentPicketageSupplierService.saveBatch(equipmentPicketageSupplierList);

        //更新中标信息
        List<EquipmentDocumentDetailVO> equipmentDocumentDetailList = saveorUpdateVO.getEquipmentDocumentDetailList();
        ArrayList<EquipmentDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList){
            documentSellVOArrayList.addAll(equipmentDocumentDetailVO.getEquipmentDocumentSellVOList());
        }
        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, EquipmentDocumentSellEntity.class);
        equipmentDocumentSellService.saveOrUpdateBatch(equipmentDocumentSellEntityList);
        EquipmentPicketageVO equipmentPicketageVO = queryDetail(saveorUpdateVO.getId());
        return equipmentPicketageVO;
    }

    @Override
    public EquipmentPicketageVO saveManyPicketage(Long documentId) {
        EquipmentPicketageEntity entity = new EquipmentPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //更新状态
        EquipmentDocumentEntity documentEntity = equipmentDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        equipmentDocumentService.saveOrUpdate(documentEntity);

        //更新洽商谈判状态
        LambdaQueryWrapper<EquipmentTalkEntity> lambdaTalk = Wrappers.<EquipmentTalkEntity>lambdaQuery();
        lambdaTalk.eq(EquipmentTalkEntity::getBillId, documentId);
        EquipmentTalkEntity equipmentTalkEntity = equipmentTalkService.getOne(lambdaTalk);
        if (equipmentTalkEntity != null){
            equipmentTalkEntity.setNextFlag(0);
            equipmentTalkService.updateById(equipmentTalkEntity);
        }

        //转换数据
        EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.selectById(documentId);
        EquipmentInviteEntity inviteEntity = equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setEmployeeId(equipmentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        entity.setValueType(equipmentDocumentEntity.getValueType());
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId());
        entity.setPurchaseId(equipmentInviteEntity.getPurchaseId());
        entity.setPurchaseName(equipmentInviteEntity.getPurchaseName());
        entity.setPurchaseType(equipmentInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(equipmentDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        EquipmentPicketageVO vo = BeanMapper.map(entity, EquipmentPicketageVO.class);

        //回写招标阶段
        equipmentInviteEntity.setTenderStage(5);
        equipmentInviteService.updateById(equipmentInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/picketage");
        processService.saveOrUpdate(processEntity);
        return vo;
    }

    @Override
    public List<EquipmentPicketageSupplierVO> querySupplierList(Long picketageId) {
        EquipmentPicketageEntity equipmentPicketageEntity = super.selectById(picketageId);
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        List<EquipmentPicketageSupplierVO> list = BeanMapper.mapList(picketageSupplierList, EquipmentPicketageSupplierVO.class);

        return list;
    }

    @Override
    public EquipmentPicketageVO saveSupplierBatch(EquipmentPicketageVO saveorUpdateVO) {
        EquipmentPicketageEntity stuffPicketageEntity = super.selectById(saveorUpdateVO.getId());
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)){
            return queryDetail(saveorUpdateVO.getId());
        }
        List<EquipmentPicketageSupplierEntity> equipmentPicketageSupplierEntities = BeanMapper.mapList(saveorUpdateVO.getPicketageSupplierList(), EquipmentPicketageSupplierEntity.class);
        for (EquipmentPicketageSupplierEntity equipmentPicketageSupplierEntity : equipmentPicketageSupplierEntities){
            equipmentPicketageSupplierEntity.setTenderFlag(0);
        }
        equipmentPicketageSupplierService.saveBatch(equipmentPicketageSupplierEntities);

        //更新中标信息
        List<EquipmentDocumentDetailVO> equipmentDocumentDetailList = saveorUpdateVO.getEquipmentDocumentDetailList();
        ArrayList<EquipmentDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList){
            documentSellVOArrayList.addAll(equipmentDocumentDetailVO.getEquipmentDocumentSellVOList());
        }
        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,EquipmentDocumentSellEntity.class);
        equipmentDocumentSellService.saveOrUpdateBatch(equipmentDocumentSellEntityList);

        return queryDetail(saveorUpdateVO.getId());
    }

}
