package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.rent.bean.RentDocumentDetailEntity;
import com.ejianc.business.tender.rent.bean.RentInviteDetailEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeEntity;
import com.ejianc.business.tender.rent.vo.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.mapper.RentDocumentMapper;
import com.ejianc.business.tender.rent.mapper.RentDocumentSellMapper;
import com.ejianc.business.tender.rent.mapper.RentDocumentSupplierDetailMapper;
import com.ejianc.business.tender.rent.mapper.RentDocumentSupplierMapper;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 *
 */
@Service("rentDocumentService")
public class RentDocumentServiceImpl extends BaseServiceImpl<RentDocumentMapper, RentDocumentEntity> implements IRentDocumentService {
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private RentDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private RentDocumentSupplierMapper supplierMapper;
    @Autowired
    private IRentDocumentSchemeService rentDocumentSchemeService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private RentDocumentSellMapper rentDocumentSellMapper;
    @Autowired
    private IRentDocumentRecordService rentDocumentRecordService;
    @Autowired
    private IRentDocumentDetailService rentDocumentDetailService;
    @Autowired
    private IRentTalkService rentTalkService;
    @Autowired
    private IRentTalkRecordService rentTalkRecordService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentDocumentExpertService documentExpertService;
    @Autowired
    private IRentDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IRentDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IRentDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000003";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRentNoticeSupplierService rentNoticeSupplierService;



    @Transactional
    @Override
    public RentDocumentVO publishDocument(Long id) {
        //更新发布状态
        RentDocumentEntity rentDocumentEntity = super.selectById(id);
        rentDocumentEntity.setPublishFlag(0);
        super.updateById(rentDocumentEntity);

        //推送供应商
        RentDocumentSupplierTbVO rentDocumentSupplierTbVO = new RentDocumentSupplierTbVO();
        rentDocumentSupplierTbVO.setSourceId(rentDocumentEntity.getInviteId().toString());
        rentDocumentSupplierTbVO.setSourceType("郑州一建招标文件");
        rentDocumentSupplierTbVO.setNoticeType(1);
        rentDocumentSupplierTbVO.setProjectLinkName(rentDocumentEntity.getProjectLinkName());
        rentDocumentSupplierTbVO.setProjectLinkPhone(rentDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rentDocumentEntity.getOfferStartTime());
        rentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rentDocumentEntity.getOfferEndTime());
        rentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rentDocumentSupplierTbVO.setContent(rentDocumentEntity.getDocumentContent());
        rentDocumentSupplierTbVO.setBrandFlag(rentDocumentEntity.getBrandFlag());
        rentDocumentSupplierTbVO.setMemo(rentDocumentEntity.getMemo());
        rentDocumentSupplierTbVO.setTenderName(rentDocumentEntity.getDocumentName());
        CommonResponse<String> stringCommonResponse = proSupplierApi.getEjcCloudSystemCode();
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件获取systemId失败" + stringCommonResponse.getMsg());
        }
        rentDocumentSupplierTbVO.setSystemId(stringCommonResponse.getData());

        // 处理租赁方式
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentDocumentEntity.getInviteId());
        rentDocumentSupplierTbVO.setRentType(rentInviteEntity.getRentType());

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(rentDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if(zbwjFile.isSuccess()){
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(rentDocumentSupplierTbVO);
        Map<String,String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()){
            files = new HashMap<>();
            files.put("file",streamMap);
        }

        //推送供方
        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl,params,files, appId, appSecret, appHost);
        if(!stringCommonResponses.isSuccess()) {
            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
        }

        RentDocumentVO rentDocumentVO = queryDetail(id);
        return rentDocumentVO;
    }




    @Override
    public RentDocumentVO bidDocument(Long id) {
        //更新开标状态
        RentDocumentEntity rentDocumentEntity = super.selectById(id);
        rentDocumentEntity.setBidFlag(0);
        rentDocumentEntity.setBidTime(new Date());
        super.updateById(rentDocumentEntity);
        RentDocumentVO rentDocumentVO = queryDetail(id);
//        开标之后给专家发送微信+内部消息通知：xx专家您好，XXX（项目名称）已开标，后续的评标开始时间我们会以短信+消息
        List<RentDocumentExpertEntity> entityList = documentExpertService.list(new QueryWrapper<RentDocumentExpertEntity>().eq("document_id", rentDocumentVO.getId()).eq("dr", 0));
        for (RentDocumentExpertEntity entity : entityList) {
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            //messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(entity.getExpertId() + "");
            String name = rentDocumentVO.getPurchaseType()==0?rentDocumentVO.getProjectName():rentDocumentVO.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            String content = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
        }
        return rentDocumentVO;
    }

    @Override
    public RentDocumentVO queryDetail(Long id) {
        return queryDocDetail(id,0);
    }

    @Override
    public RentDocumentVO queryDetail1(Long id, Integer num) {
        return queryDocDetail(id,num);
    }

    @Override
    public RentDocumentVO queryDetailNum(Long id) {
        RentDocumentSchemeEntity rentDocumentSchemeEntity = rentDocumentSchemeService.list(new QueryWrapper<RentDocumentSchemeEntity>().eq("document_id", id).orderByDesc("talk_num")).get(0);
        return queryDocDetail(id,rentDocumentSchemeEntity.getTalkNum());
    }

    @Transactional
    @Override
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {

        logger.info("进入报价接口request-{},file-{}", request, file);
        String notice = request.getParameter("bjNoticeVO");
        logger.info("实体信息-{}",notice);
        RentSupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<RentSupplierSellVO>() { });

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = rentInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10){
            talkNum = 0;
        }
        if (tenderStage == 7){
            //查询轮数
            LambdaQueryWrapper<RentTalkEntity> lambdaTalk = Wrappers.<RentTalkEntity>lambdaQuery();
            lambdaTalk.eq(RentTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            RentTalkEntity rentTalkEntity = rentTalkService.getOne(lambdaTalk);
            talkNum = rentTalkEntity.getTalkNum();
        }

        //转换
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();

        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<RentDocumentEntity> lambdaDocument = Wrappers.<RentDocumentEntity>lambdaQuery();
        lambdaDocument.eq(RentDocumentEntity::getInviteId, inviteId);
        RentDocumentEntity rentDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambdaSupplier = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId,rentDocumentEntity.getId());
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum,talkNum);
        RentDocumentSupplierEntity rentDocumentSupplierEntity = rentDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (rentDocumentSupplierEntity != null){
            //更新供应商信息
            rentDocumentSupplierEntity.setOfferTime(new Date());
            rentDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            rentDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            rentDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            rentDocumentSupplierService.updateById(rentDocumentSupplierEntity);
            documentSupplierId = rentDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId,rentDocumentSupplierEntity.getId() );
            rentDocumentSchemeService.remove(lambdaScheme);
        }
        if (rentDocumentSupplierEntity == null){
            //新增供应商信息
            RentDocumentSupplierEntity rentDocumentSupplierEntityAdd = new RentDocumentSupplierEntity();
            rentDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            rentDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            rentDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            rentDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            rentDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            rentDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            rentDocumentSupplierEntityAdd.setOfferTime(new Date());
            rentDocumentSupplierEntityAdd.setDocumentId(rentDocumentEntity.getId());
            rentDocumentSupplierEntityAdd.setTalkNum(talkNum);
            rentDocumentSupplierService.save(rentDocumentSupplierEntityAdd);
            documentSupplierId = rentDocumentSupplierEntityAdd.getId();
        }

        //处理方案信息
        List<RentSupplierSellSchemeVO> schemeList = pushVO.getRentSchemeList();
        List<RentDocumentSchemeEntity> rentDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<RentDocumentSellVO> rentDocumentSellVOList = new ArrayList<>();
        for (RentSupplierSellSchemeVO supplierSellSchemeVO : schemeList){
            RentDocumentSchemeEntity rentDocumentSchemeEntity = new RentDocumentSchemeEntity();
            rentDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            rentDocumentSchemeEntity.setDocumentId(rentDocumentEntity.getId());
            rentDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            rentDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            rentDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            rentDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            rentDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            rentDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            rentDocumentSchemeEntity.setTalkNum(talkNum);
            rentDocumentSchemeEntity.setId(IdWorker.getId());
            rentDocumentSchemeEntity.setPassFlag(1);
            rentDocumentSchemeEntityArrayList.add(rentDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<RentSupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getRentSchemeDetailList();
            for (RentSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList){
                RentDocumentSellVO rentDocumentSellVO = new RentDocumentSellVO();
//                rentDocumentSellVO.setProjectId(rentDocumentEntity.getProjectId());
//                rentDocumentSellVO.setProjectName(rentDocumentEntity.getProjectName());
                rentDocumentSellVO.setSchemeId(rentDocumentSchemeEntity.getId());
                rentDocumentSellVO.setDocumentId(rentDocumentEntity.getId());
                rentDocumentSellVO.setSupplierId(sourceSupplierId);
                rentDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                rentDocumentSellVO.setSupplierName(supplierVO.getName());
                rentDocumentSellVO.setMaterialId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()));
                rentDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                rentDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                rentDocumentSellVO.setMaterialTypeId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()));
                rentDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                rentDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                rentDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                rentDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                rentDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                rentDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                rentDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                rentDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                rentDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                rentDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                rentDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                rentDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                rentDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                rentDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                rentDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                rentDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                rentDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                rentDocumentSellVO.setPlanDay(supplierSellSchemeDetailVO.getPlanDay());
                rentDocumentSellVO.setPlanEnterDate(supplierSellSchemeDetailVO.getPlanEnterDate());
                rentDocumentSellVO.setPlanLeaveDate(supplierSellSchemeDetailVO.getPlanLeaveDate());
                rentDocumentSellVO.setReferFlag(2);
                rentDocumentSellVO.setPassFlag(1);
                rentDocumentSellVO.setTalkNum(talkNum);

                rentDocumentSellVOList.add(rentDocumentSellVO);

            }

        }
        //新增方案
        rentDocumentSchemeService.saveBatch(rentDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getSupplierId,sourceSupplierId);
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum,talkNum);
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId,rentDocumentEntity.getId());
        rentDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<RentDocumentDetailEntity> lambdaDetail = Wrappers.<RentDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(RentDocumentDetailEntity::getDocumentId,rentDocumentEntity.getId());
        List<RentDocumentDetailEntity> rentDocumentDetailList = rentDocumentDetailService.list(lambdaDetail);

        List<RentDocumentSellEntity> rentDocumentSellEntityArrayList = new ArrayList<>();
        for (RentDocumentDetailEntity rentDocumentDetailEntity : rentDocumentDetailList){
            for (RentDocumentSellVO rentDocumentSellVO : rentDocumentSellVOList){
                //判断是否只有分类
                if (rentDocumentDetailEntity.getMaterialId() != null) {
                    if (rentDocumentDetailEntity.getMaterialTypeId().equals(rentDocumentSellVO.getMaterialTypeId()) &&
                            rentDocumentDetailEntity.getMaterialId().equals(rentDocumentSellVO.getMaterialId()) &&
                            rentDocumentDetailEntity.getRate().equals(rentDocumentSellVO.getDetailRate()) &&
                            (rentDocumentDetailEntity.getPlanEnterDate() == null ? "1":rentDocumentDetailEntity.getPlanEnterDate()).
                                    equals(rentDocumentSellVO.getPlanEnterDate() ==  null ? "1":rentDocumentSellVO.getPlanEnterDate()) &&
                            (rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rentDocumentDetailEntity.getPlanLeaveDate())
                            .equals(rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rentDocumentDetailEntity.getPlanLeaveDate())){
                        RentDocumentSellEntity rentDocumentSellEntity = BeanMapper.map(rentDocumentSellVO, RentDocumentSellEntity.class);
                        rentDocumentSellEntity.setDetailId(rentDocumentDetailEntity.getId());
                        rentDocumentSellEntity.setProjectId(rentDocumentDetailEntity.getDetailProjectId());
                        rentDocumentSellEntity.setProjectName(rentDocumentDetailEntity.getDetailProjectName());
                        rentDocumentSellEntity.setNum(rentDocumentDetailEntity.getNum());
                        if (rentInviteEntity.getRentType() == 0) {
                            rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice())));
                            rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax())));
                        }else{
                            rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice()));
                            rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax()));
                        }
                        rentDocumentSellEntity.setSellTax(rentDocumentSellEntity.getMoneyTax().subtract(rentDocumentSellEntity.getMoney()));
                        rentDocumentSellEntityArrayList.add(rentDocumentSellEntity);
                    }
                }
                if (rentDocumentDetailEntity.getMaterialId() == null) {
                    if (rentDocumentDetailEntity.getMaterialTypeId().equals(rentDocumentSellVO.getMaterialTypeId()) &&
                            rentDocumentDetailEntity.getRate().equals(rentDocumentSellVO.getDetailRate()) &&
                            (rentDocumentDetailEntity.getPlanEnterDate() == null ? "1":rentDocumentDetailEntity.getPlanEnterDate()).
                                    equals(rentDocumentSellVO.getPlanEnterDate() ==  null ? "1":rentDocumentSellVO.getPlanEnterDate()) &&
                            (rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rentDocumentDetailEntity.getPlanLeaveDate())
                                    .equals(rentDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rentDocumentDetailEntity.getPlanLeaveDate())){
                        RentDocumentSellEntity rentDocumentSellEntity = BeanMapper.map(rentDocumentSellVO, RentDocumentSellEntity.class);
                        rentDocumentSellEntity.setDetailId(rentDocumentDetailEntity.getId());
                        rentDocumentSellEntity.setProjectId(rentDocumentDetailEntity.getDetailProjectId());
                        rentDocumentSellEntity.setProjectName(rentDocumentDetailEntity.getDetailProjectName());
                        rentDocumentSellEntity.setNum(rentDocumentDetailEntity.getNum());
                        if (rentInviteEntity.getRentType() == 0) {
                            rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice())));
                            rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getPlanDay().multiply(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax())));
                        }else{
                            rentDocumentSellEntity.setMoney(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPrice()));
                            rentDocumentSellEntity.setMoneyTax(rentDocumentDetailEntity.getNum().multiply(rentDocumentSellEntity.getPriceTax()));
                        }
                        rentDocumentSellEntity.setSellTax(rentDocumentSellEntity.getMoneyTax().subtract(rentDocumentSellEntity.getMoney()));
                        rentDocumentSellEntityArrayList.add(rentDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        rentDocumentSellService.saveBatch(rentDocumentSellEntityArrayList);

        //先删除附件
        if(documentSupplierId != null){
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]",documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId,BILL_SUPPLIER_TYPE,"supplierFileType",null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)){
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}",deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            }
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId,Long inviteId) {
        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //文件stream处理
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String datawj = zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject(datawj);
        Map<String, byte[]> wjMap = JSONObject.parseObject(wListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        wjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });


        Map<String,String> params = new HashMap<>();
        params.put("sourceId", Long.toString(inviteId));
        Map<String,String> headers = new HashMap<>();
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        files.put("file",streamMap);

        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataAndFilesWithUniversal(addFileUrl, params, files, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附件批量修改同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        Map<String,Object> map = new HashMap<>();
        map.put("sourceId",sourceId);
        map.put("fileNames",fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(delFileUrl, RequestMethod.POST, stringInfo, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
                throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
            }
        return "同步成功";
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {

        RentDocumentEntity rentDocumentEntity = super.selectById(documentId);
        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSchemeEntity rentDocumentSchemeEntity = rentDocumentSchemeService.selectById(schemeId);
        RentDocumentSupplierEntity rentDocumentSupplierEntity = rentDocumentSupplierService.selectById(rentDocumentSchemeEntity.getDocumentSupplierId());
        Long supplierDetailId = rentDocumentSupplierEntity.getId();
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setSupplierName(rentDocumentSupplierEntity.getSupplierName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        rentDocumentSupplierSellVO.setPurchaseType(rentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<RentDocumentSchemeEntity> rentDocumentSchemeEntityList = rentDocumentSchemeService.list(lambdaScheme);
        List<RentDocumentSchemeVO> rentDocumentSchemeVOList = BeanMapper.mapList(rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId,rentDocumentSupplierEntity.getDocumentId());
        List<RentDocumentSellEntity> rentDocumentSellEntityList = rentDocumentSellService.list(lambdaSell);
        List<RentDocumentSellVO> rentDocumentSellVOList = BeanMapper.mapList(rentDocumentSellEntityList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().
                collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
        for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList){
            List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
            rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
        }
        rentDocumentSupplierSellVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return rentDocumentSupplierSellVO;
    }

    @Override
    public RentDocumentVO saveOrUpdates(RentDocumentVO saveorUpdateVO) {
        RentDocumentEntity entity = BeanMapper.map(saveorUpdateVO, RentDocumentEntity.class);
        service.saveOrUpdate(entity, false);
        RentDocumentVO vo = BeanMapper.map(entity, RentDocumentVO.class);
        RentInviteEntity subInviteEntity = rentInviteService.selectById(entity.getInviteId());
        List<RentInviteDetailRecordVO> subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getRentDetailRecord(), RentInviteDetailRecordVO.class);
        vo.setRentDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }


    @Override
    public RentDocumentVO queryDocDetail(Long id,Integer talkNum) {

        RentDocumentEntity entity = super.selectById(id);
        RentDocumentVO rentDocumentVO = BeanMapper.map(entity, RentDocumentVO.class);

        rentDocumentVO.setRentDocumentSchemeList(null);
        rentDocumentVO.setRentDocumentSellList(null);
        //处理报名供应商信息
        if(rentDocumentVO.getNoticeId()!=null){
            LambdaQueryWrapper<RentNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(RentNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(RentNoticeSupplierEntity::getState, 1);
            List<RentNoticeSupplierEntity> list = rentNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if(CollectionUtils.isNotEmpty(list)){
                List<RentNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, RentNoticeSupplierVO.class);
                Map<Long, RentDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(rentDocumentVO.getRentDocumentSupplierList())){
                    documentSupplierVOMap = rentDocumentVO.getRentDocumentSupplierList().stream().filter(t->t.getSupplierId()!=null).collect(Collectors.toMap(RentDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (RentNoticeSupplierVO noticeSupplier :  noticeSupplierVOS) {
                    if(documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())){
                        noticeSupplier.setDocumentType(0);//已报价
                    }else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                rentDocumentVO.setRentDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<RentDocumentSupplierEntity> lambda = Wrappers.<RentDocumentSupplierEntity>lambdaQuery();
        lambda.eq(RentDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(RentDocumentSupplierEntity::getTalkNum, talkNum);
        List<RentDocumentSupplierEntity> supplierList = rentDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)){
            List<RentDocumentSupplierVO> rentDocumentSupplierVOS = BeanMapper.mapList(supplierList, RentDocumentSupplierVO.class);
            LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(RentDocumentSchemeEntity::getSchemeName);
            List<RentDocumentSchemeEntity> schemeList = rentDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<RentDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(RentDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0){
                for (RentDocumentSupplierVO rentDocumentSupplierEntity : rentDocumentSupplierVOS){
                    List<RentDocumentSchemeEntity> rentDocumentSchemeEntities = schemeMap.get(rentDocumentSupplierEntity.getId());
                    String schemeMoney  = "";
                    for (RentDocumentSchemeEntity rentDocumentSchemeEntity : rentDocumentSchemeEntities){
                        schemeMoney = schemeMoney + rentDocumentSchemeEntity.getSchemeName() + ":" + rentDocumentSchemeEntity.getMoneyTax().setScale(2,BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    rentDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(rentDocumentSupplierVOS)){
                    List<Long> attachIds = rentDocumentSupplierVOS.stream().map(RentDocumentSupplierVO::getId).collect(Collectors.toList());
                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds",attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess()){
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)){
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                            for (RentDocumentSupplierVO rentDocumentSupplierVO : rentDocumentSupplierVOS){
                                AttachmentVO attachmentVO = attacMap.get(rentDocumentSupplierVO.getId());
                                if(attachmentVO != null){
                                    rentDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    rentDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }
                }
            }

            //是否开标,0-是,1-否
//            if (entity.getBidFlag() == 1){
//                for (RentDocumentSupplierVO rentDocumentSupplierVO : rentDocumentSupplierVOS){
//                    rentDocumentSupplierVO.setRegisterDate(null);
//                }
//            }
            //按供应商查看报价
            rentDocumentVO.setRentDocumentSupplierList(rentDocumentSupplierVOS);
            //前端键值重复设计
            rentDocumentVO.setRentDocumentSupplierSchemeList(rentDocumentSupplierVOS);
            //按材料查看报价
            List<RentDocumentDetailVO> rentDocumentDetailList = rentDocumentVO.getRentDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(RentDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(RentDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(RentDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(RentDocumentSellEntity::getSchemeName);
            List<RentDocumentSellEntity> sellList = rentDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)){
                List<RentDocumentSellVO> rentDocumentSellVOS = BeanMapper.mapList(sellList, RentDocumentSellVO.class);
                for (RentDocumentSellVO rentDocumentSellVO : rentDocumentSellVOS){
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1){
                        rentDocumentSellVO.setPrice(null);
                        rentDocumentSellVO.setPriceTax(null);
                        rentDocumentSellVO.setMoney(null);
                        rentDocumentSellVO.setMoneyTax(null);
                        rentDocumentSellVO.setSellTax(null);
                        rentDocumentSellVO.setTenderNum(null);
                        rentDocumentSellVO.setTenderMoney(null);
                        rentDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0){
                        rentDocumentSellVO.setTenderNum(null);
                        rentDocumentSellVO.setTenderMoney(null);
                        rentDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(RentDocumentSellVO::getDetailId));
                for (RentDocumentDetailVO rentDocumentDetailVO : rentDocumentDetailList){
                    List<RentDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<RentDocumentSellVO> rentDocumentSellEntities = sellMap.get(rentDocumentDetailVO.getId());
                    Map<Long, List<RentDocumentSellVO>> sellDetailMap = rentDocumentSellEntities.stream().
                            collect(Collectors.groupingBy(RentDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key,value) ->{
                        RentDocumentSupplierVO rentDocumentSupplierVO = new RentDocumentSupplierVO();
                        rentDocumentSupplierVO.setSupplierId(key);
                        RentDocumentSellVO rentDocumentSellVO = value.stream().findFirst().get();
                        rentDocumentSupplierVO.setSupplierName(rentDocumentSellVO.getSupplierName());
                        rentDocumentSupplierVO.setRentDocumentSellVOList(value);
                        documentSupplierVOS.add(rentDocumentSupplierVO);
                    });
                    rentDocumentDetailVO.setRentDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<RentDocumentDetailVO> rentDocumentDetailSellList = rentDocumentVO.getRentDocumentDetailList();
                rentDocumentVO.setRentDocumentDetailSellList(rentDocumentDetailSellList);
            }
        }
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentDocumentVO.getInviteId());
        rentDocumentVO.setRentDetailRecord(BeanMapper.mapList(rentInviteEntity.getRentDetailRecord(),RentInviteDetailRecordVO.class));
        return rentDocumentVO;
    }


    @Override
    public List<RentDocumentSellVO> getSchemeDetail(RentDocumentSellVO rentDocumentSellVO) {
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getSupplierId,rentDocumentSellVO.getSupplierId() );
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId,rentDocumentSellVO.getDocumentId() );
        lambdaSell.eq(RentDocumentSellEntity::getSchemeId,rentDocumentSellVO.getSchemeId() );
        List<RentDocumentSellEntity> list = rentDocumentSellService.list(lambdaSell);
        List<RentDocumentSellVO> rentDocumentSellVOList = BeanMapper.mapList(list,RentDocumentSellVO.class);
        return rentDocumentSellVOList;
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        RentDocumentEntity rentDocumentEntity = super.selectById(documentId);
        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSupplierEntity rentDocumentSupplierEntity = rentDocumentSupplierService.selectById(supplierDetailId);
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setSupplierId(rentDocumentSupplierEntity.getSupplierId());
        rentDocumentSupplierSellVO.setSupplierName(rentDocumentSupplierEntity.getSupplierName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        rentDocumentSupplierSellVO.setPurchaseType(rentDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<RentDocumentSchemeEntity> rentDocumentSchemeEntityList = rentDocumentSchemeService.list(lambdaScheme);
        List<RentDocumentSchemeVO> rentDocumentSchemeVOList = BeanMapper.mapList(rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId,rentDocumentSupplierEntity.getDocumentId());
        List<RentDocumentSellEntity> rentDocumentSellEntityList = rentDocumentSellService.list(lambdaSell);
        List<RentDocumentSellVO> rentDocumentSellVOList = BeanMapper.mapList(rentDocumentSellEntityList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().
                collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
        for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList){
            List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
            rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
        }
        rentDocumentSupplierSellVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return rentDocumentSupplierSellVO;
    }
    @Transactional
    @Override
    public RentDocumentVO extendDocument(RentDocumentRecordVO rentDocumentRecordVO) {
        RentDocumentRecordEntity rentDocumentRecordEntity = BeanMapper.map(rentDocumentRecordVO, RentDocumentRecordEntity.class);
        rentDocumentRecordService.save(rentDocumentRecordEntity);
        RentDocumentEntity rentDocumentEntity = super.selectById(rentDocumentRecordVO.getDocumentId());
        rentDocumentEntity.setOfferEndTime(rentDocumentRecordVO.getNewTime());
        boolean b = super.updateById(rentDocumentEntity);

        //推送供方
        RentSupplierSellVO supplierSellVO = new RentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rentDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rentDocumentRecordVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件同步供方接口报错" + stringCommonResponse.getMsg());
        }

        RentDocumentVO rentDocumentVO = queryDetail(rentDocumentRecordVO.getDocumentId());
        return rentDocumentVO;
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {

        RentTalkEntity rentTalkEntity = rentTalkService.selectById(talkId);
        Integer talkNum = rentTalkEntity.getTalkNum();
        if(rentTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        List<RentTalkVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0;a <= talkNum;a++){
            RentTalkVO rentTalkVO = new RentTalkVO();
            rentTalkVO.setTalkNum(a);
            if (a == 0){
                name = "首次报价";
            }else {
                name = "第" + a + "轮报价";
            }
            rentTalkVO.setTalkNumName(name);
            talkVOArrayList.add(rentTalkVO);
        }

        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSupplierEntity rentDocumentSupplierEntity = rentDocumentSupplierService.selectById(supplierDetailId);
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        rentDocumentSupplierSellVO.setSupplierName(rentDocumentSupplierEntity.getSupplierName());

        for (RentTalkVO rentTalkVO : talkVOArrayList){
            LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentId,rentDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(RentDocumentSchemeEntity::getSupplierId,rentDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(RentDocumentSchemeEntity::getTalkNum,rentTalkVO.getTalkNum());
            List<RentDocumentSchemeEntity> rentDocumentSchemeEntityList = rentDocumentSchemeService.list(lambdaScheme);
            if(CollectionUtils.isEmpty(rentDocumentSchemeEntityList)){
                continue;
            }
            List<RentDocumentSchemeVO> rentDocumentSchemeVOList = BeanMapper.mapList(rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);

            //获取报价方案详情
            List<Long> schemePkList = rentDocumentSchemeVOList.stream().map(RentDocumentSchemeVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
            lambdaSell.in(RentDocumentSellEntity::getSchemeId,schemePkList);
            List<RentDocumentSellEntity> rentDocumentSellEntityList = rentDocumentSellService.list(lambdaSell);
            List<RentDocumentSellVO> rentDocumentSellVOList = BeanMapper.mapList(rentDocumentSellEntityList, RentDocumentSellVO.class);
            Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().
                    collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
            for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList){
                List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
                rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
            }
            rentTalkVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);
        }
        rentDocumentSupplierSellVO.setRentTalkVOList(talkVOArrayList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if(fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return rentDocumentSupplierSellVO;
    }

    private Map<String,Object> getFileInfo(Long sourceId) {
        Map<String, Object> map = new HashMap<>();
        //查询附件
        CommonResponse<List<AttachmentVO>> attachResponse = attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess()){
            List<AttachmentVO> data = attachResponse.getData();
            if(CollectionUtils.isNotEmpty(data)){
                AttachmentVO attachmentVO = data.stream().findFirst().get();
                if(attachmentVO != null){
                    map.put("fileName",attachmentVO.getFileName());
                    map.put("attachId",attachmentVO.getId());
                }


            }
        }
        return map;
    }

    @Override
    public RentDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        //更新发布状态
        RentDocumentEntity rentDocumentEntity = super.selectById(id);
        rentDocumentEntity.setPublishFlag(0);
        super.updateById(rentDocumentEntity);


        RentNoticeSupplierTbVO rentNoticeSupplierTbVO = new RentNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rentNoticeSupplierTbVO.setSourceType("郑州一建招标文件");
        rentNoticeSupplierTbVO.setSourceId(rentDocumentEntity.getInviteId().toString());
        RentInviteEntity inviteEntity = rentInviteService.selectById(rentDocumentEntity.getInviteId());
        if (rentDocumentEntity.getTenderType()==2){
            rentNoticeSupplierTbVO.setNoticeType(2);
        }else {
            rentNoticeSupplierTbVO.setNoticeType(3);
        }
        if (rentDocumentEntity.getPurchaseType()==1){
            rentNoticeSupplierTbVO.setSourceProjectId(null);
            rentNoticeSupplierTbVO.setProjectName(null);
            rentNoticeSupplierTbVO.setProjectCode(null);
        }else {
            rentNoticeSupplierTbVO.setSourceProjectId(rentDocumentEntity.getProjectId().toString());
            rentNoticeSupplierTbVO.setProjectName(rentDocumentEntity.getProjectName());
            rentNoticeSupplierTbVO.setProjectCode(rentDocumentEntity.getProjectCode());
        }

        rentNoticeSupplierTbVO.setSourceOrgId(rentDocumentEntity.getOrgId().toString());
        rentNoticeSupplierTbVO.setOrgName(rentDocumentEntity.getOrgName());
        rentNoticeSupplierTbVO.setSourceUnitId(rentDocumentEntity.getUnitId().toString());
        rentNoticeSupplierTbVO.setUnitName(rentDocumentEntity.getUnitName());
        rentNoticeSupplierTbVO.setMemo(rentDocumentEntity.getMemo());
        rentNoticeSupplierTbVO.setType("RENT");
        rentNoticeSupplierTbVO.setTenderName(rentDocumentEntity.getDocumentName());
        rentNoticeSupplierTbVO.setTenderType(rentDocumentEntity.getTenderType());
        rentNoticeSupplierTbVO.setPurchaseType(rentDocumentEntity.getPurchaseType().toString());
        rentNoticeSupplierTbVO.setPurchaseName(rentDocumentEntity.getPurchaseName());
        rentNoticeSupplierTbVO.setSourceEmployeeId(rentDocumentEntity.getEmployeeId().toString());
        rentNoticeSupplierTbVO.setEmployeeName(rentDocumentEntity.getEmployeeName());
        rentNoticeSupplierTbVO.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        rentNoticeSupplierTbVO.setValueType(rentDocumentEntity.getValueType());
        rentNoticeSupplierTbVO.setContent(rentDocumentEntity.getDocumentContent());
        rentNoticeSupplierTbVO.setOfferStartTime(sdf.format(rentDocumentEntity.getOfferStartTime()));
        rentNoticeSupplierTbVO.setOfferEndTime(sdf.format(rentDocumentEntity.getOfferEndTime()));
        rentNoticeSupplierTbVO.setBrandFlag(rentDocumentEntity.getBrandFlag());
        rentNoticeSupplierTbVO.setProjectLinkName(rentDocumentEntity.getProjectLinkName());
        rentNoticeSupplierTbVO.setProjectLinkPhone(rentDocumentEntity.getProjectLinkPhone());
        rentNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        rentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        rentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        rentNoticeSupplierTbVO.setRentType(inviteEntity.getRentType());
        //插入物资
        List<RentNoticeDetailTbVO> rentNoticeDetailVOS = new ArrayList<>();
        List<RentDocumentDetailVO> documentDetailEntityList =  baseMapper.selectSumDetail(rentDocumentEntity.getId());
        for (RentDocumentDetailVO rentDocumentDetailEntity : documentDetailEntityList) {
            RentNoticeDetailTbVO rentNoticeDetailTbVO = new RentNoticeDetailTbVO();
            BeanUtils.copyProperties(rentNoticeDetailTbVO,rentDocumentDetailEntity);
            rentNoticeDetailTbVO.setNum(rentDocumentDetailEntity.getSumNum());
            rentNoticeDetailTbVO.setMoney(rentDocumentDetailEntity.getSumMoney());
            rentNoticeDetailTbVO.setMoneyTax(rentDocumentDetailEntity.getSumMoneyTax());
            rentNoticeDetailTbVO.setSourceId(rentDocumentEntity.getInviteId().toString());
            rentNoticeDetailTbVO.setSourceMaterialId(rentDocumentDetailEntity.getMaterialId()==null?null:rentDocumentDetailEntity.getMaterialId().toString());
            rentNoticeDetailTbVO.setSourceMaterialTypeId(rentDocumentDetailEntity.getMaterialTypeId()==null?null:rentDocumentDetailEntity.getMaterialTypeId().toString());
            rentNoticeDetailVOS.add(rentNoticeDetailTbVO);
        }
        rentNoticeSupplierTbVO.setRentDetailList(rentNoticeDetailVOS);
        //是否是邀请招标
        if (rentDocumentEntity.getTenderType()!=2){
            List<RentDocumentSupplierDetailEntity> detailEntityList = supplierDetailService.list(new LambdaQueryWrapper<RentDocumentSupplierDetailEntity>().eq(RentDocumentSupplierDetailEntity::getInviteId, rentDocumentEntity.getInviteId()).eq(RentDocumentSupplierDetailEntity::getDr, 0));
            List<RentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (RentDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                RentNoticeSupplierDetailTbVO rentNoticeSupplierDetailTbVO = new RentNoticeSupplierDetailTbVO();
                rentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                rentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                rentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

                supplierDetailTbVOList.add(rentNoticeSupplierDetailTbVO);
            }
            rentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString(rentNoticeSupplierTbVO);
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId,appSecret,appHost);
            if (!response.isSuccess()){
                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
        }
        return queryDetail(id);
    }
    @Override
    public CommonResponse delSupplier(Long id) {
        RentDocumentEntity rentDocumentEntity = baseMapper.selectById(id);
        List<RentDocumentSupplierEntity> rentDocumentSupplierList = supplierMapper.selectList(new QueryWrapper<RentDocumentSupplierEntity>().eq("document_id", rentDocumentEntity.getId()).eq("dr", 0));
        List<RentDocumentSupplierDetailEntity> supplierDetailList = supplierDetailMapper.selectList(new QueryWrapper<RentDocumentSupplierDetailEntity>().eq("invite_id", rentDocumentEntity.getInviteId()).eq("dr", 0));
        List<Long> oldIds = new ArrayList<>();
        List<Long> newIds = new ArrayList<>();
        rentDocumentSupplierList.stream().forEach(it->oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it->newIds.add(it.getSupplierId()));
        List<Long> newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List<RentDocumentSupplierDetailEntity> newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        //装填数据
        List<RentNoticeSupplierDetailTbVO> signVOList = new ArrayList<>();
        for (RentDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            RentNoticeSupplierDetailTbVO rentNoticeSupplierDetailTbVO = new RentNoticeSupplierDetailTbVO();
            rentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            rentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            rentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

            rentNoticeSupplierDetailTbVO.setOutReason("超时未报价");
            signVOList.add(rentNoticeSupplierDetailTbVO);
        }
        logger.info("剔除的供应商"+JSON.toJSONString(signVOList));
        //调用第三方接口
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("剔除供应商成功");
    }

    @Override
    public RentDocumentVO saveManyDocument(Long id) {
        RentDocumentEntity rentDocumentEntity = new RentDocumentEntity();
        //查询招标主表信息
        RentInviteEntity inviteEntity = rentInviteService.selectById(id);
        //复制主表
        rentDocumentEntity.setInviteId(inviteEntity.getId());
        rentDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType()==0){
            rentDocumentEntity.setProjectId(inviteEntity.getProjectId());
            rentDocumentEntity.setProjectName(inviteEntity.getProjectName());
            rentDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        rentDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        rentDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        rentDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        rentDocumentEntity.setOrgId(inviteEntity.getOrgId());
        rentDocumentEntity.setOrgName(inviteEntity.getOrgName());
        rentDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        rentDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        rentDocumentEntity.setValueType(inviteEntity.getValueType());
        rentDocumentEntity.setUnitId(inviteEntity.getUnitId());
        rentDocumentEntity.setUnitName(inviteEntity.getUnitName());
        rentDocumentEntity.setTenderType(inviteEntity.getTenderType());

        //设置计价方式
        rentDocumentEntity.setBidFlag(1);
        rentDocumentEntity.setPublishFlag(1);
        rentDocumentEntity.setNextFlag(1);


        //复制物资详情
        List<RentInviteDetailEntity> rentNoticeDetailList = inviteEntity.getRentDetail();
        List<RentDocumentDetailEntity> rentDocumentDetailList = BeanMapper.mapList(rentNoticeDetailList, RentDocumentDetailEntity.class);
        for (RentDocumentDetailEntity rentDocumentDetailEntity : rentDocumentDetailList){
            rentDocumentDetailEntity.setId(null);
        }
        rentDocumentEntity.setRentDocumentDetailList(rentDocumentDetailList);

        //复制供应商
        List<RentInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List<RentDocumentSupplierDetailEntity> rentDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, RentDocumentSupplierDetailEntity.class);
        for (RentDocumentSupplierDetailEntity rentDocumentSupplierDetailVO : rentDocumentSupplierDetailVOS) {
            rentDocumentSupplierDetailVO.setId(null);
            documentSupplierDetailService.saveOrUpdate(rentDocumentSupplierDetailVO);
        }

        service.saveOrUpdate(rentDocumentEntity, false);

        ProcessEntity processEntity = new ProcessEntity();
        //回写招标阶段
        switch(inviteEntity.getTenderType()){
            case 3:
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("竞争性谈判");
                break;
            case 4:
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("单一来源");
                break;
            case 5:
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("紧急招标");
                break;
            case 2:
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("询价公告");
                break;
        }
        rentInviteService.updateById(inviteEntity);
        //回写进展表
        processEntity.setBillId(rentDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/fourJzDyJjXj");
        processService.saveOrUpdate(processEntity);
        RentDocumentVO vo = BeanMapper.map(rentDocumentEntity, RentDocumentVO.class);
        return vo;
    }

    @Override
    public RentDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        //获取轮数
        RentTalkRecordEntity rentTalkRecordEntity = rentTalkRecordService.selectById(talkId);
        Integer talkNum = rentTalkRecordEntity.getTalkNum();
        if (rentTalkRecordEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }

        //
        RentDocumentSupplierSellVO rentDocumentSupplierSellVO = new RentDocumentSupplierSellVO();
        RentDocumentSupplierEntity rentDocumentSupplierEntity = rentDocumentSupplierService.selectById(supplierDetailId);
        rentDocumentSupplierSellVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
        rentDocumentSupplierSellVO.setLinkMobile(rentDocumentSupplierEntity.getLinkMobile());
        rentDocumentSupplierSellVO.setOfferTime(rentDocumentSupplierEntity.getOfferTime());
        rentDocumentSupplierSellVO.setTaxMemo(rentDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper<RentDocumentSchemeEntity> lambdaScheme = Wrappers.<RentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RentDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<RentDocumentSchemeEntity> rentDocumentSchemeEntityList = rentDocumentSchemeService.list(lambdaScheme);
        List<RentDocumentSchemeVO> rentDocumentSchemeVOList = BeanMapper.mapList(rentDocumentSchemeEntityList, RentDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<RentDocumentSellEntity> lambdaSell = Wrappers.<RentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId,rentDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(RentDocumentSellEntity::getTalkNum,talkNum);
        List<RentDocumentSellEntity> rentDocumentSellEntityList = rentDocumentSellService.list(lambdaSell);
        List<RentDocumentSellVO> rentDocumentSellVOList = BeanMapper.mapList(rentDocumentSellEntityList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOList.stream().
                collect(Collectors.groupingBy(RentDocumentSellVO::getSchemeId));
        for (RentDocumentSchemeVO rentDocumentSchemeVO : rentDocumentSchemeVOList){
            List<RentDocumentSellVO> rentDocumentSellVOS = sellMap.get(rentDocumentSchemeVO.getId());
            rentDocumentSchemeVO.setRentDocumentSellList(rentDocumentSellVOS);
        }
        rentDocumentSupplierSellVO.setRentDocumentSchemeList(rentDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rentDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                rentDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return rentDocumentSupplierSellVO;
    }

    @Override
    public RentDocumentVO saveDocument(Long noticeId) {
        RentDocumentEntity entity = new RentDocumentEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询公告主表信息
        RentNoticeEntity rentNoticeEntity = rentNoticeService.selectById(noticeId);
        RentInviteEntity rentInvite = rentInviteService.selectById(rentNoticeEntity.getInviteId());

        //复制物资详情
        List<RentInviteDetailEntity> rentInviteDetailList = rentInvite.getRentDetail();
        List<RentDocumentDetailEntity> rentDocumentDetailList = BeanMapper.mapList(rentInviteDetailList, RentDocumentDetailEntity.class);

        for (RentDocumentDetailEntity rentDocumentDetailEntity : rentDocumentDetailList){
            rentDocumentDetailEntity.setId(null);
        }

        entity.setRentDocumentDetailList(rentDocumentDetailList);

        //复制主表信息
        entity.setProjectId(rentNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(rentNoticeEntity.getProjectName());
        entity.setOrgId(rentNoticeEntity.getOrgId());
        entity.setOrgName(rentNoticeEntity.getOrgName());
        entity.setParentOrgId(rentNoticeEntity.getParentOrgId());
        entity.setParentOrgName(rentNoticeEntity.getParentOrgName());
        entity.setProjectCode(rentNoticeEntity.getProjectCode());
        entity.setDocumentName(rentNoticeEntity.getNoticeName());
        entity.setEmployeeId(rentNoticeEntity.getEmployeeId());
        entity.setEmployeeName(rentNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(rentNoticeEntity.getEmployeeMobile());
        entity.setInviteId(rentNoticeEntity.getInviteId());
        entity.setPurchaseId(rentNoticeEntity.getPurchaseId());
        entity.setPurchaseName(rentNoticeEntity.getPurchaseName());
        entity.setPurchaseType(rentNoticeEntity.getPurchaseType());
        entity.setTenderType(rentNoticeEntity.getTenderType());
        //设置计价方式
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(rentNoticeEntity.getInviteId());
        entity.setValueType(rentInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);

        service.saveOrUpdate(entity, false);

        //回写招标阶段
        rentInviteEntity.setTenderStage(3);
        rentInviteService.updateById(rentInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("招标文件");
        processEntity.setTenderId(rentNoticeEntity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/document");
        processService.saveOrUpdate(processEntity);
        RentDocumentVO vo = BeanMapper.map(entity, RentDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        //根据documentId查询数据库中专家数量
        List<RentDocumentExpertEntity> expertEntityList = documentExpertService.list(Wrappers.<RentDocumentExpertEntity>lambdaQuery()
                .eq(RentDocumentExpertEntity::getDocumentId, documentId)
                .eq(RentDocumentExpertEntity::getDr, 0)
        );
        int totalNum = expertEntityList.size();
        if(totalNum < 3){
            return CommonResponse.error("所选专家数量至少为3人！",false);
        }
        //判断专家数量是否为单数
        if(totalNum % 2 == 0){
            return CommonResponse.error("所选专家数量必须为单数！",false);
        }

        /**
         * !!!数据量大时会损失精度，目前业务不可能超过，所以进行强制转换
         */
        //筛选出库中集团、项目专家数量
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "集团".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "项目".equals(entity.getExpertFromName())).count();
        //实际需要的数量
        int trueDepartmentExpertNum = (int)Math.ceil(totalNum * 1.0 / 3);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if(departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum){
            return CommonResponse.error("所选专家数量不符合要求！" +
                    "集团专家" + trueDepartmentExpertNum + "个," +
                    "项目专家" + trueProjectExpertNum + "个！",false);
        }
        return CommonResponse.success("专家选取成功！",true);
    }



}
