package com.ejianc.business.tender.report.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tender.cost.vo.SupbidNoticeVO;
import com.ejianc.business.tender.report.vo.BidDataVO;
import com.ejianc.business.tender.report.vo.ReportVO;
import com.ejianc.business.tender.report.vo.SupplierReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 报表
 * 
 * @author generator
 * 
 */
public interface IReportService{

    Map<String,Object> queryData(QueryParam param);

    IPage<SupplierReportVO> querySupplierReportData(QueryParam param, Long supplierId);

    BigDecimal queryMoney(Integer tenderType, String tenderTypeName,String firstDayOfMonth,String lastDayOfMonth);

    Map queryBidData(QueryParam param) throws ParseException;

    List<SupbidNoticeVO> queryTenderMaterialAmountProportion(Integer year);

    List<SupbidNoticeVO> queryTenderResultTrend(Integer year);


    List<SupbidNoticeVO> queryWinbidMoneyTop6(Integer year);

    List<SupbidNoticeVO> queryPicketageMoneyProportion(Integer year);


    IPage<SupbidNoticeVO> tenderSupplierRank(QueryParam param);

    IPage<SupbidNoticeVO> tenderSupplierRankProsub(QueryParam param);

    List<SupbidNoticeVO> queryPicketageMoneyProportionNew(String time);
}
