package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.vo.*;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentMapper;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSellMapper;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSupplierDetailMapper;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSupplierMapper;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.business.tender.util.ThirdSystemUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标文件主表
 *
 * @author generator
 *
 */
@Service("rmatDocumentService")
public class RmatDocumentServiceImpl extends BaseServiceImpl<RmatDocumentMapper, RmatDocumentEntity> implements IRmatDocumentService {
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private RmatDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private RmatDocumentSupplierMapper supplierMapper;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private RmatDocumentSellMapper rmatDocumentSellMapper;
    @Autowired
    private IRmatDocumentRecordService rmatDocumentRecordService;
    @Autowired
    private IRmatDocumentDetailService rmatDocumentDetailService;
    @Autowired
    private IRmatTalkService rmatTalkService;
    @Autowired
    private IRmatTalkRecordService rmatTalkRecordService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatDocumentExpertService documentExpertService;
    @Autowired
    private IRmatDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IRmatDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IRmatDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IRmatNoticeService rmatNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000005";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRmatNoticeSupplierService rmatNoticeSupplierService;



    @Transactional
    @Override
    public RmatDocumentVO publishDocument(Long id) {
        //更新发布状态
        RmatDocumentEntity rmatDocumentEntity = super.selectById(id);
        rmatDocumentEntity.setPublishFlag(0);
        super.updateById(rmatDocumentEntity);

        //推送供应商
        RmatDocumentSupplierTbVO rmatDocumentSupplierTbVO = new RmatDocumentSupplierTbVO();
        rmatDocumentSupplierTbVO.setSourceId(rmatDocumentEntity.getInviteId().toString());
        rmatDocumentSupplierTbVO.setSourceType("郑州一建招标文件");
        rmatDocumentSupplierTbVO.setNoticeType(1);
        rmatDocumentSupplierTbVO.setProjectLinkName(rmatDocumentEntity.getProjectLinkName());
        rmatDocumentSupplierTbVO.setProjectLinkPhone(rmatDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rmatDocumentEntity.getOfferStartTime());
        rmatDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rmatDocumentEntity.getOfferEndTime());
        rmatDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rmatDocumentSupplierTbVO.setContent(rmatDocumentEntity.getDocumentContent());
        rmatDocumentSupplierTbVO.setBrandFlag(rmatDocumentEntity.getBrandFlag());
        rmatDocumentSupplierTbVO.setMemo(rmatDocumentEntity.getMemo());
        rmatDocumentSupplierTbVO.setTenderName(rmatDocumentEntity.getDocumentName());
        CommonResponse<String> stringCommonResponse = proSupplierApi.getEjcCloudSystemCode();
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件获取systemId失败" + stringCommonResponse.getMsg());
        }
        rmatDocumentSupplierTbVO.setSystemId(stringCommonResponse.getData());

        // 处理租赁方式
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatDocumentEntity.getInviteId());
        rmatDocumentSupplierTbVO.setRentType(rmatInviteEntity.getRentType());

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(rmatDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if(zbwjFile.isSuccess()){
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(rmatDocumentSupplierTbVO);
        Map<String,String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()){
            files = new HashMap<>();
            files.put("file",streamMap);
        }

        //推送供方
        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl,params,files, appId, appSecret, appHost);
        if(!stringCommonResponses.isSuccess()) {
            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
        }

        RmatDocumentVO rmatDocumentVO = queryDetail(id);
        return rmatDocumentVO;
    }




    @Override
    public RmatDocumentVO bidDocument(Long id) {
        //更新开标状态
        RmatDocumentEntity rmatDocumentEntity = super.selectById(id);
        rmatDocumentEntity.setBidFlag(0);
        rmatDocumentEntity.setBidTime(new Date());
        super.updateById(rmatDocumentEntity);
        RmatDocumentVO rmatDocumentVO = queryDetail(id);
//        开标之后给专家发送微信+内部消息通知：xx专家您好，XXX（项目名称）已开标，后续的评标开始时间我们会以短信+消息
        List<RmatDocumentExpertEntity> entityList = documentExpertService.list(new QueryWrapper<RmatDocumentExpertEntity>().eq("document_id", rmatDocumentVO.getId()).eq("dr", 0));
        for (RmatDocumentExpertEntity entity : entityList) {
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            //messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(entity.getExpertId() + "");
            String name = rmatDocumentVO.getPurchaseType()==0?rmatDocumentVO.getProjectName():rmatDocumentVO.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            String content = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
        }
        return rmatDocumentVO;
    }

    @Override
    public RmatDocumentVO queryDetail(Long id) {
        return queryDocDetail(id,0);
    }
    @Override
    public RmatDocumentVO queryDetail1(Long id, Integer num) {
        return queryDocDetail(id,num);
    }

    @Override
    public RmatDocumentVO queryDetailNum(Long id) {
        RmatDocumentSchemeEntity rmatDocumentSchemeEntity = rmatDocumentSchemeService.list(new QueryWrapper<RmatDocumentSchemeEntity>().eq("document_id", id).orderByDesc("talk_num")).get(0);
        return queryDocDetail(id,rmatDocumentSchemeEntity.getTalkNum());
    }

    @Transactional
    @Override
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {

        logger.info("进入报价接口request-{},file-{}", request, file);
        String notice = request.getParameter("bjNoticeVO");
        logger.info("实体信息-{}",notice);
        RmatSupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<RmatSupplierSellVO>() { });

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = rmatInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10){
            talkNum = 0;
        }
        if (tenderStage == 7){
            //查询轮数
            LambdaQueryWrapper<RmatTalkEntity> lambdaTalk = Wrappers.<RmatTalkEntity>lambdaQuery();
            lambdaTalk.eq(RmatTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            RmatTalkEntity rmatTalkEntity = rmatTalkService.getOne(lambdaTalk);
            talkNum = rmatTalkEntity.getTalkNum();
        }

        //转换
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();

        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<RmatDocumentEntity> lambdaDocument = Wrappers.<RmatDocumentEntity>lambdaQuery();
        lambdaDocument.eq(RmatDocumentEntity::getInviteId, inviteId);
        RmatDocumentEntity rmatDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambdaSupplier = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId,rmatDocumentEntity.getId());
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum,talkNum);
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = rmatDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (rmatDocumentSupplierEntity != null){
            //更新供应商信息
            rmatDocumentSupplierEntity.setOfferTime(new Date());
            rmatDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            rmatDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            rmatDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            rmatDocumentSupplierService.updateById(rmatDocumentSupplierEntity);
            documentSupplierId = rmatDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId,rmatDocumentSupplierEntity.getId() );
            rmatDocumentSchemeService.remove(lambdaScheme);
        }
        if (rmatDocumentSupplierEntity == null){
            //新增供应商信息
            RmatDocumentSupplierEntity rmatDocumentSupplierEntityAdd = new RmatDocumentSupplierEntity();
            rmatDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            rmatDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            rmatDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            rmatDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            rmatDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            rmatDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            rmatDocumentSupplierEntityAdd.setOfferTime(new Date());
            rmatDocumentSupplierEntityAdd.setDocumentId(rmatDocumentEntity.getId());
            rmatDocumentSupplierEntityAdd.setTalkNum(talkNum);
            rmatDocumentSupplierService.save(rmatDocumentSupplierEntityAdd);
            documentSupplierId = rmatDocumentSupplierEntityAdd.getId();
        }

        //处理方案信息
        List<RmatSupplierSellSchemeVO> schemeList = pushVO.getRmatSchemeList();
        List<RmatDocumentSchemeEntity> rmatDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<RmatDocumentSellVO> rmatDocumentSellVOList = new ArrayList<>();
        for (RmatSupplierSellSchemeVO supplierSellSchemeVO : schemeList){
            RmatDocumentSchemeEntity rmatDocumentSchemeEntity = new RmatDocumentSchemeEntity();
            rmatDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            rmatDocumentSchemeEntity.setDocumentId(rmatDocumentEntity.getId());
            rmatDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            rmatDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            rmatDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            rmatDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            rmatDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            rmatDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            rmatDocumentSchemeEntity.setTalkNum(talkNum);
            rmatDocumentSchemeEntity.setId(IdWorker.getId());
            rmatDocumentSchemeEntity.setPassFlag(1);
            rmatDocumentSchemeEntityArrayList.add(rmatDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<RmatSupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getRmatSchemeDetailList();
            for (RmatSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList){
                RmatDocumentSellVO rmatDocumentSellVO = new RmatDocumentSellVO();
//                rmatDocumentSellVO.setProjectId(rmatDocumentEntity.getProjectId());
//                rmatDocumentSellVO.setProjectName(rmatDocumentEntity.getProjectName());
                rmatDocumentSellVO.setSchemeId(rmatDocumentSchemeEntity.getId());
                rmatDocumentSellVO.setDocumentId(rmatDocumentEntity.getId());
                rmatDocumentSellVO.setSupplierId(sourceSupplierId);
                rmatDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                rmatDocumentSellVO.setSupplierName(supplierVO.getName());
                rmatDocumentSellVO.setMaterialId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId()));
                rmatDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                rmatDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                rmatDocumentSellVO.setMaterialTypeId(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()));
                rmatDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                rmatDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                rmatDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                rmatDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                rmatDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                rmatDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                rmatDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                rmatDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                rmatDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                rmatDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                rmatDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                rmatDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                rmatDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                rmatDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                rmatDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                rmatDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                rmatDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                rmatDocumentSellVO.setPlanDay(supplierSellSchemeDetailVO.getPlanDay());
                rmatDocumentSellVO.setPlanEnterDate(supplierSellSchemeDetailVO.getPlanEnterDate());
                rmatDocumentSellVO.setPlanLeaveDate(supplierSellSchemeDetailVO.getPlanLeaveDate());
                rmatDocumentSellVO.setReferFlag(2);
                rmatDocumentSellVO.setPassFlag(1);
                rmatDocumentSellVO.setTalkNum(talkNum);

                rmatDocumentSellVOList.add(rmatDocumentSellVO);

            }

        }
        //新增方案
        rmatDocumentSchemeService.saveBatch(rmatDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getSupplierId,sourceSupplierId);
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum,talkNum);
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId,rmatDocumentEntity.getId());
        rmatDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<RmatDocumentDetailEntity> lambdaDetail = Wrappers.<RmatDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(RmatDocumentDetailEntity::getDocumentId,rmatDocumentEntity.getId());
        List<RmatDocumentDetailEntity> rmatDocumentDetailList = rmatDocumentDetailService.list(lambdaDetail);

        List<RmatDocumentSellEntity> rmatDocumentSellEntityArrayList = new ArrayList<>();
        for (RmatDocumentDetailEntity rmatDocumentDetailEntity : rmatDocumentDetailList){
            for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOList){
                //判断是否只有分类
                if (rmatDocumentDetailEntity.getMaterialId() != null) {
                    if (rmatDocumentDetailEntity.getMaterialTypeId().equals(rmatDocumentSellVO.getMaterialTypeId()) &&
                            rmatDocumentDetailEntity.getMaterialId().equals(rmatDocumentSellVO.getMaterialId()) &&
                            rmatDocumentDetailEntity.getRate().equals(rmatDocumentSellVO.getDetailRate()) &&
                            (rmatDocumentDetailEntity.getPlanEnterDate() == null ? "1":rmatDocumentDetailEntity.getPlanEnterDate()).
                            equals(rmatDocumentSellVO.getPlanEnterDate() ==  null ? "1":rmatDocumentSellVO.getPlanEnterDate()) &&
                            (rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rmatDocumentDetailEntity.getPlanLeaveDate())
                                    .equals(rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rmatDocumentDetailEntity.getPlanLeaveDate())){
                        RmatDocumentSellEntity rmatDocumentSellEntity = BeanMapper.map(rmatDocumentSellVO, RmatDocumentSellEntity.class);
                        rmatDocumentSellEntity.setDetailId(rmatDocumentDetailEntity.getId());
                        rmatDocumentSellEntity.setProjectId(rmatDocumentDetailEntity.getDetailProjectId());
                        rmatDocumentSellEntity.setProjectName(rmatDocumentDetailEntity.getDetailProjectName());
                        rmatDocumentSellEntity.setNum(rmatDocumentDetailEntity.getNum());
                        rmatDocumentSellEntity.setMoney(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPrice()));
                        rmatDocumentSellEntity.setMoneyTax(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPriceTax()));
                        rmatDocumentSellEntity.setSellTax(rmatDocumentSellEntity.getMoneyTax().subtract(rmatDocumentSellEntity.getMoney()));
                        rmatDocumentSellEntityArrayList.add(rmatDocumentSellEntity);
                    }
                }
                if (rmatDocumentDetailEntity.getMaterialId() == null) {
                    if (rmatDocumentDetailEntity.getMaterialTypeId().equals(rmatDocumentSellVO.getMaterialTypeId()) &&
                            rmatDocumentDetailEntity.getRate().equals(rmatDocumentSellVO.getDetailRate()) &&
                            (rmatDocumentDetailEntity.getPlanEnterDate() == null ? "1":rmatDocumentDetailEntity.getPlanEnterDate()).
                                    equals(rmatDocumentSellVO.getPlanEnterDate() ==  null ? "1":rmatDocumentSellVO.getPlanEnterDate()) &&
                            (rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rmatDocumentDetailEntity.getPlanLeaveDate())
                                    .equals(rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1":rmatDocumentDetailEntity.getPlanLeaveDate())){
                        RmatDocumentSellEntity rmatDocumentSellEntity = BeanMapper.map(rmatDocumentSellVO, RmatDocumentSellEntity.class);
                        rmatDocumentSellEntity.setDetailId(rmatDocumentDetailEntity.getId());
                        rmatDocumentSellEntity.setProjectId(rmatDocumentDetailEntity.getDetailProjectId());
                        rmatDocumentSellEntity.setProjectName(rmatDocumentDetailEntity.getDetailProjectName());
                        rmatDocumentSellEntity.setNum(rmatDocumentDetailEntity.getNum());
                        rmatDocumentSellEntity.setMoney(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPrice()));
                        rmatDocumentSellEntity.setMoneyTax(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPriceTax()));
                        rmatDocumentSellEntity.setSellTax(rmatDocumentSellEntity.getMoneyTax().subtract(rmatDocumentSellEntity.getMoney()));
                        rmatDocumentSellEntityArrayList.add(rmatDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        rmatDocumentSellService.saveBatch(rmatDocumentSellEntityArrayList);

        //先删除附件
        if(documentSupplierId != null){
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]",documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId,BILL_SUPPLIER_TYPE,"supplierFileType",null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)){
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}",deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            }
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId,Long inviteId) {
        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //文件stream处理
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String datawj = zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject(datawj);
        Map<String, byte[]> wjMap = JSONObject.parseObject(wListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        wjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });


        Map<String,String> params = new HashMap<>();
        params.put("sourceId", Long.toString(inviteId));
        Map<String,String> headers = new HashMap<>();
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        files.put("file",streamMap);

        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataAndFilesWithUniversal(addFileUrl, params, files, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附件批量修改同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        Map<String,Object> map = new HashMap<>();
        map.put("sourceId",sourceId);
        map.put("fileNames",fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(delFileUrl, RequestMethod.POST, stringInfo, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
                throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
            }
        return "同步成功";
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {

        RmatDocumentEntity rmatDocumentEntity = super.selectById(documentId);
        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSchemeEntity rmatDocumentSchemeEntity = rmatDocumentSchemeService.selectById(schemeId);
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = rmatDocumentSupplierService.selectById(rmatDocumentSchemeEntity.getDocumentSupplierId());
        Long supplierDetailId = rmatDocumentSupplierEntity.getId();
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setSupplierName(rmatDocumentSupplierEntity.getSupplierName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        rmatDocumentSupplierSellVO.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<RmatDocumentSchemeEntity> rmatDocumentSchemeEntityList = rmatDocumentSchemeService.list(lambdaScheme);
        List<RmatDocumentSchemeVO> rmatDocumentSchemeVOList = BeanMapper.mapList(rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId,rmatDocumentSupplierEntity.getDocumentId());
        List<RmatDocumentSellEntity> rmatDocumentSellEntityList = rmatDocumentSellService.list(lambdaSell);
        List<RmatDocumentSellVO> rmatDocumentSellVOList = BeanMapper.mapList(rmatDocumentSellEntityList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().
                collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
        for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList){
            List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
            rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
        }
        rmatDocumentSupplierSellVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return rmatDocumentSupplierSellVO;
    }

    @Override
    public RmatDocumentVO saveOrUpdates(RmatDocumentVO saveorUpdateVO) {
        RmatDocumentEntity entity = BeanMapper.map(saveorUpdateVO, RmatDocumentEntity.class);
        service.saveOrUpdate(entity, false);
        RmatDocumentVO vo = BeanMapper.map(entity, RmatDocumentVO.class);
        RmatInviteEntity subInviteEntity = rmatInviteService.selectById(entity.getInviteId());
        List<RmatInviteDetailRecordVO> subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getRmatDetailRecord(), RmatInviteDetailRecordVO.class);
        vo.setRmatDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }


    @Override
    public RmatDocumentVO queryDocDetail(Long id,Integer talkNum) {

        RmatDocumentEntity entity = super.selectById(id);
        RmatDocumentVO rmatDocumentVO = BeanMapper.map(entity, RmatDocumentVO.class);

        rmatDocumentVO.setRmatDocumentSchemeList(null);
        rmatDocumentVO.setRmatDocumentSellList(null);
        //处理报名供应商信息
        if(rmatDocumentVO.getNoticeId()!=null){
            LambdaQueryWrapper<RmatNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(RmatNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(RmatNoticeSupplierEntity::getState, 1);
            List<RmatNoticeSupplierEntity> list = rmatNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if(CollectionUtils.isNotEmpty(list)){
                List<RmatNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, RmatNoticeSupplierVO.class);
                Map<Long, RmatDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(rmatDocumentVO.getRmatDocumentSupplierList())){
                    documentSupplierVOMap = rmatDocumentVO.getRmatDocumentSupplierList().stream().filter(t->t.getSupplierId()!=null).collect(Collectors.toMap(RmatDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (RmatNoticeSupplierVO noticeSupplier :  noticeSupplierVOS) {
                    if(documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())){
                        noticeSupplier.setDocumentType(0);//已报价
                    }else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                rmatDocumentVO.setRmatDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<RmatDocumentSupplierEntity> lambda = Wrappers.<RmatDocumentSupplierEntity>lambdaQuery();
        lambda.eq(RmatDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(RmatDocumentSupplierEntity::getTalkNum, talkNum);
        List<RmatDocumentSupplierEntity> supplierList = rmatDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)){
            List<RmatDocumentSupplierVO> rmatDocumentSupplierVOS = BeanMapper.mapList(supplierList, RmatDocumentSupplierVO.class);
            LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(RmatDocumentSchemeEntity::getSchemeName);
            List<RmatDocumentSchemeEntity> schemeList = rmatDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<RmatDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(RmatDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0){
                for (RmatDocumentSupplierVO rmatDocumentSupplierEntity : rmatDocumentSupplierVOS){
                    List<RmatDocumentSchemeEntity> rmatDocumentSchemeEntities = schemeMap.get(rmatDocumentSupplierEntity.getId());
                    String schemeMoney  = "";
                    for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : rmatDocumentSchemeEntities){
                        schemeMoney = schemeMoney + rmatDocumentSchemeEntity.getSchemeName() + ":" + rmatDocumentSchemeEntity.getMoneyTax().setScale(2,BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    rmatDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(rmatDocumentSupplierVOS)){
                    List<Long> attachIds = rmatDocumentSupplierVOS.stream().map(RmatDocumentSupplierVO::getId).collect(Collectors.toList());
                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds",attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess()){
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)){
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                            for (RmatDocumentSupplierVO rmatDocumentSupplierVO : rmatDocumentSupplierVOS){
                                AttachmentVO attachmentVO = attacMap.get(rmatDocumentSupplierVO.getId());
                                if(attachmentVO != null){
                                    rmatDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    rmatDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }
                }
            }

            //是否开标,0-是,1-否
//            if (entity.getBidFlag() == 1){
//                for (RmatDocumentSupplierVO rmatDocumentSupplierVO : rmatDocumentSupplierVOS){
//                    rmatDocumentSupplierVO.setRegisterDate(null);
//                }
//            }
            //按供应商查看报价
            rmatDocumentVO.setRmatDocumentSupplierList(rmatDocumentSupplierVOS);
            //前端键值重复设计
            rmatDocumentVO.setRmatDocumentSupplierSchemeList(rmatDocumentSupplierVOS);
            //按材料查看报价
            List<RmatDocumentDetailVO> rmatDocumentDetailList = rmatDocumentVO.getRmatDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(RmatDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(RmatDocumentSellEntity::getSchemeName);
            List<RmatDocumentSellEntity> sellList = rmatDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)){
                List<RmatDocumentSellVO> rmatDocumentSellVOS = BeanMapper.mapList(sellList, RmatDocumentSellVO.class);
                for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOS){
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1){
                        rmatDocumentSellVO.setPrice(null);
                        rmatDocumentSellVO.setPriceTax(null);
                        rmatDocumentSellVO.setMoney(null);
                        rmatDocumentSellVO.setMoneyTax(null);
                        rmatDocumentSellVO.setSellTax(null);
                        rmatDocumentSellVO.setTenderNum(null);
                        rmatDocumentSellVO.setTenderMoney(null);
                        rmatDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0){
                        rmatDocumentSellVO.setTenderNum(null);
                        rmatDocumentSellVO.setTenderMoney(null);
                        rmatDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(RmatDocumentSellVO::getDetailId));
                for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList){
                    List<RmatDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<RmatDocumentSellVO> rmatDocumentSellEntities = sellMap.get(rmatDocumentDetailVO.getId());
                    Map<Long, List<RmatDocumentSellVO>> sellDetailMap = rmatDocumentSellEntities.stream().
                            collect(Collectors.groupingBy(RmatDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key,value) ->{
                        RmatDocumentSupplierVO rmatDocumentSupplierVO = new RmatDocumentSupplierVO();
                        rmatDocumentSupplierVO.setSupplierId(key);
                        RmatDocumentSellVO rmatDocumentSellVO = value.stream().findFirst().get();
                        rmatDocumentSupplierVO.setSupplierName(rmatDocumentSellVO.getSupplierName());
                        rmatDocumentSupplierVO.setRmatDocumentSellVOList(value);
                        documentSupplierVOS.add(rmatDocumentSupplierVO);
                    });
                    rmatDocumentDetailVO.setRmatDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<RmatDocumentDetailVO> rmatDocumentDetailSellList = rmatDocumentVO.getRmatDocumentDetailList();
                rmatDocumentVO.setRmatDocumentDetailSellList(rmatDocumentDetailSellList);
            }
        }
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatDocumentVO.getInviteId());
        rmatDocumentVO.setRmatDetailRecord(BeanMapper.mapList(rmatInviteEntity.getRmatDetailRecord(),RmatInviteDetailRecordVO.class));
        return rmatDocumentVO;
    }


    @Override
    public List<RmatDocumentSellVO> getSchemeDetail(RmatDocumentSellVO rmatDocumentSellVO) {
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getSupplierId,rmatDocumentSellVO.getSupplierId() );
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId,rmatDocumentSellVO.getDocumentId() );
        lambdaSell.eq(RmatDocumentSellEntity::getSchemeId,rmatDocumentSellVO.getSchemeId() );
        List<RmatDocumentSellEntity> list = rmatDocumentSellService.list(lambdaSell);
        List<RmatDocumentSellVO> rmatDocumentSellVOList = BeanMapper.mapList(list,RmatDocumentSellVO.class);
        return rmatDocumentSellVOList;
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        RmatDocumentEntity rmatDocumentEntity = super.selectById(documentId);
        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = rmatDocumentSupplierService.selectById(supplierDetailId);
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setSupplierId(rmatDocumentSupplierEntity.getSupplierId());
        rmatDocumentSupplierSellVO.setSupplierName(rmatDocumentSupplierEntity.getSupplierName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        rmatDocumentSupplierSellVO.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<RmatDocumentSchemeEntity> rmatDocumentSchemeEntityList = rmatDocumentSchemeService.list(lambdaScheme);
        List<RmatDocumentSchemeVO> rmatDocumentSchemeVOList = BeanMapper.mapList(rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId,rmatDocumentSupplierEntity.getDocumentId());
        List<RmatDocumentSellEntity> rmatDocumentSellEntityList = rmatDocumentSellService.list(lambdaSell);
        List<RmatDocumentSellVO> rmatDocumentSellVOList = BeanMapper.mapList(rmatDocumentSellEntityList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().
                collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
        for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList){
            List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
            rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
        }
        rmatDocumentSupplierSellVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return rmatDocumentSupplierSellVO;
    }
    @Transactional
    @Override
    public RmatDocumentVO extendDocument(RmatDocumentRecordVO rmatDocumentRecordVO) {
        RmatDocumentRecordEntity rmatDocumentRecordEntity = BeanMapper.map(rmatDocumentRecordVO, RmatDocumentRecordEntity.class);
        rmatDocumentRecordService.save(rmatDocumentRecordEntity);
        RmatDocumentEntity rmatDocumentEntity = super.selectById(rmatDocumentRecordVO.getDocumentId());
        rmatDocumentEntity.setOfferEndTime(rmatDocumentRecordVO.getNewTime());
        boolean b = super.updateById(rmatDocumentEntity);

        //推送供方
        RmatSupplierSellVO supplierSellVO = new RmatSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rmatDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rmatDocumentRecordVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件同步供方接口报错" + stringCommonResponse.getMsg());
        }

        RmatDocumentVO rmatDocumentVO = queryDetail(rmatDocumentRecordVO.getDocumentId());
        return rmatDocumentVO;
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {

        RmatTalkEntity rmatTalkEntity = rmatTalkService.selectById(talkId);
        Integer talkNum = rmatTalkEntity.getTalkNum();
        if(rmatTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        List<RmatTalkVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0;a <= talkNum;a++){
            RmatTalkVO rmatTalkVO = new RmatTalkVO();
            rmatTalkVO.setTalkNum(a);
            if (a == 0){
                name = "首次报价";
            }else {
                name = "第" + a + "轮报价";
            }
            rmatTalkVO.setTalkNumName(name);
            talkVOArrayList.add(rmatTalkVO);
        }

        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = rmatDocumentSupplierService.selectById(supplierDetailId);
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        rmatDocumentSupplierSellVO.setSupplierName(rmatDocumentSupplierEntity.getSupplierName());

        for (RmatTalkVO rmatTalkVO : talkVOArrayList){
            LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId,rmatDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(RmatDocumentSchemeEntity::getSupplierId,rmatDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum,rmatTalkVO.getTalkNum());
            List<RmatDocumentSchemeEntity> rmatDocumentSchemeEntityList = rmatDocumentSchemeService.list(lambdaScheme);
            if(CollectionUtils.isEmpty(rmatDocumentSchemeEntityList)){
                continue;
            }
            List<RmatDocumentSchemeVO> rmatDocumentSchemeVOList = BeanMapper.mapList(rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);

            //获取报价方案详情
            List<Long> schemePkList = rmatDocumentSchemeVOList.stream().map(RmatDocumentSchemeVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
            lambdaSell.in(RmatDocumentSellEntity::getSchemeId,schemePkList);
            List<RmatDocumentSellEntity> rmatDocumentSellEntityList = rmatDocumentSellService.list(lambdaSell);
            List<RmatDocumentSellVO> rmatDocumentSellVOList = BeanMapper.mapList(rmatDocumentSellEntityList, RmatDocumentSellVO.class);
            Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().
                    collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
            for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList){
                List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
                rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
            }
            rmatTalkVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);
        }
        rmatDocumentSupplierSellVO.setRmatTalkVOList(talkVOArrayList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if(fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return rmatDocumentSupplierSellVO;
    }

    private Map<String,Object> getFileInfo(Long sourceId) {
        Map<String, Object> map = new HashMap<>();
        //查询附件
        CommonResponse<List<AttachmentVO>> attachResponse = attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess()){
            List<AttachmentVO> data = attachResponse.getData();
            if(CollectionUtils.isNotEmpty(data)){
                AttachmentVO attachmentVO = data.stream().findFirst().get();
                if(attachmentVO != null){
                    map.put("fileName",attachmentVO.getFileName());
                    map.put("attachId",attachmentVO.getId());
                }


            }
        }
        return map;
    }

    @Override
    public RmatDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        //更新发布状态
        RmatDocumentEntity rmatDocumentEntity = super.selectById(id);
        rmatDocumentEntity.setPublishFlag(0);
        super.updateById(rmatDocumentEntity);


        RmatNoticeSupplierTbVO rmatNoticeSupplierTbVO = new RmatNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rmatNoticeSupplierTbVO.setSourceType("郑州一建招标文件");
        rmatNoticeSupplierTbVO.setSourceId(rmatDocumentEntity.getInviteId().toString());
        RmatInviteEntity inviteEntity = rmatInviteService.selectById(rmatDocumentEntity.getInviteId());
        if (rmatDocumentEntity.getTenderType()==2){
            rmatNoticeSupplierTbVO.setNoticeType(2);
        }else {
            rmatNoticeSupplierTbVO.setNoticeType(3);
        }
        if (rmatDocumentEntity.getPurchaseType()==1){
            rmatNoticeSupplierTbVO.setSourceProjectId(null);
            rmatNoticeSupplierTbVO.setProjectName(null);
            rmatNoticeSupplierTbVO.setProjectCode(null);
        }else {
            rmatNoticeSupplierTbVO.setSourceProjectId(rmatDocumentEntity.getProjectId().toString());
            rmatNoticeSupplierTbVO.setProjectName(rmatDocumentEntity.getProjectName());
            rmatNoticeSupplierTbVO.setProjectCode(rmatDocumentEntity.getProjectCode());
        }

        rmatNoticeSupplierTbVO.setSourceOrgId(rmatDocumentEntity.getOrgId().toString());
        rmatNoticeSupplierTbVO.setOrgName(rmatDocumentEntity.getOrgName());
        rmatNoticeSupplierTbVO.setSourceUnitId(rmatDocumentEntity.getUnitId().toString());
        rmatNoticeSupplierTbVO.setUnitName(rmatDocumentEntity.getUnitName());
        rmatNoticeSupplierTbVO.setMemo(rmatDocumentEntity.getMemo());
        rmatNoticeSupplierTbVO.setType("RMAT");
        rmatNoticeSupplierTbVO.setTenderName(rmatDocumentEntity.getDocumentName());
        rmatNoticeSupplierTbVO.setTenderType(rmatDocumentEntity.getTenderType());
        rmatNoticeSupplierTbVO.setPurchaseType(rmatDocumentEntity.getPurchaseType().toString());
        rmatNoticeSupplierTbVO.setPurchaseName(rmatDocumentEntity.getPurchaseName());
        rmatNoticeSupplierTbVO.setSourceEmployeeId(rmatDocumentEntity.getEmployeeId().toString());
        rmatNoticeSupplierTbVO.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        rmatNoticeSupplierTbVO.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        rmatNoticeSupplierTbVO.setValueType(rmatDocumentEntity.getValueType());
        rmatNoticeSupplierTbVO.setContent(rmatDocumentEntity.getDocumentContent());
        rmatNoticeSupplierTbVO.setOfferStartTime(sdf.format(rmatDocumentEntity.getOfferStartTime()));
        rmatNoticeSupplierTbVO.setOfferEndTime(sdf.format(rmatDocumentEntity.getOfferEndTime()));
        rmatNoticeSupplierTbVO.setBrandFlag(rmatDocumentEntity.getBrandFlag());
        rmatNoticeSupplierTbVO.setProjectLinkName(rmatDocumentEntity.getProjectLinkName());
        rmatNoticeSupplierTbVO.setProjectLinkPhone(rmatDocumentEntity.getProjectLinkPhone());
        rmatNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        rmatNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        rmatNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        rmatNoticeSupplierTbVO.setRentType(inviteEntity.getRentType());
        //插入物资
        List<RmatNoticeDetailTbVO> rmatNoticeDetailVOS = new ArrayList<>();
        List<RmatDocumentDetailVO> documentDetailEntityList =  baseMapper.selectSumDetail(rmatDocumentEntity.getId());
        for (RmatDocumentDetailVO rmatDocumentDetailEntity : documentDetailEntityList) {
            RmatNoticeDetailTbVO rmatNoticeDetailTbVO = new RmatNoticeDetailTbVO();
            BeanUtils.copyProperties(rmatNoticeDetailTbVO,rmatDocumentDetailEntity);
            rmatNoticeDetailTbVO.setNum(rmatDocumentDetailEntity.getSumNum());
            rmatNoticeDetailTbVO.setMoney(rmatDocumentDetailEntity.getSumMoney());
            rmatNoticeDetailTbVO.setMoneyTax(rmatDocumentDetailEntity.getSumMoneyTax());
            rmatNoticeDetailTbVO.setSourceId(rmatDocumentEntity.getInviteId().toString());
            rmatNoticeDetailTbVO.setSourceMaterialId(rmatDocumentDetailEntity.getMaterialId()==null?null:rmatDocumentDetailEntity.getMaterialId().toString());
            rmatNoticeDetailTbVO.setSourceMaterialTypeId(rmatDocumentDetailEntity.getMaterialTypeId().toString());
            rmatNoticeDetailVOS.add(rmatNoticeDetailTbVO);
        }
        rmatNoticeSupplierTbVO.setRmatDetailList(rmatNoticeDetailVOS);
        //是否是邀请招标
        if (rmatDocumentEntity.getTenderType()!=2){
            List<RmatDocumentSupplierDetailEntity> detailEntityList = supplierDetailService.list(new LambdaQueryWrapper<RmatDocumentSupplierDetailEntity>().eq(RmatDocumentSupplierDetailEntity::getInviteId, rmatDocumentEntity.getInviteId()).eq(RmatDocumentSupplierDetailEntity::getDr, 0));
            List<RmatNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (RmatDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                RmatNoticeSupplierDetailTbVO rmatNoticeSupplierDetailTbVO = new RmatNoticeSupplierDetailTbVO();
                rmatNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                rmatNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                rmatNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

                supplierDetailTbVOList.add(rmatNoticeSupplierDetailTbVO);
            }
            rmatNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString(rmatNoticeSupplierTbVO);
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId,appSecret,appHost);
            if (!response.isSuccess()){
                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
        }
        return queryDetail(id);
    }
    @Override
    public CommonResponse delSupplier(Long id) {
        RmatDocumentEntity rmatDocumentEntity = baseMapper.selectById(id);
        List<RmatDocumentSupplierEntity> rmatDocumentSupplierList = supplierMapper.selectList(new QueryWrapper<RmatDocumentSupplierEntity>().eq("document_id", rmatDocumentEntity.getId()).eq("dr", 0));
        List<RmatDocumentSupplierDetailEntity> supplierDetailList = supplierDetailMapper.selectList(new QueryWrapper<RmatDocumentSupplierDetailEntity>().eq("invite_id", rmatDocumentEntity.getInviteId()).eq("dr", 0));
        List<Long> oldIds = new ArrayList<>();
        List<Long> newIds = new ArrayList<>();
        rmatDocumentSupplierList.stream().forEach(it->oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it->newIds.add(it.getSupplierId()));
        List<Long> newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List<RmatDocumentSupplierDetailEntity> newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        //装填数据
        List<RmatNoticeSupplierDetailTbVO> signVOList = new ArrayList<>();
        for (RmatDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            RmatNoticeSupplierDetailTbVO rmatNoticeSupplierDetailTbVO = new RmatNoticeSupplierDetailTbVO();
            rmatNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            rmatNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            rmatNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));

            rmatNoticeSupplierDetailTbVO.setOutReason("超时未报价");
            signVOList.add(rmatNoticeSupplierDetailTbVO);
        }
        logger.info("剔除的供应商"+JSON.toJSONString(signVOList));
        //调用第三方接口
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("剔除供应商成功");
    }

    @Override
    public RmatDocumentVO saveManyDocument(Long id) {
        RmatDocumentEntity rmatDocumentEntity = new RmatDocumentEntity();
        //查询招标主表信息
        RmatInviteEntity inviteEntity = rmatInviteService.selectById(id);
        //复制主表
        rmatDocumentEntity.setInviteId(inviteEntity.getId());
        rmatDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType()==0){
            rmatDocumentEntity.setProjectId(inviteEntity.getProjectId());
            rmatDocumentEntity.setProjectName(inviteEntity.getProjectName());
            rmatDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        rmatDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        rmatDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        rmatDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        rmatDocumentEntity.setOrgId(inviteEntity.getOrgId());
        rmatDocumentEntity.setOrgName(inviteEntity.getOrgName());
        rmatDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        rmatDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        rmatDocumentEntity.setValueType(inviteEntity.getValueType());
        rmatDocumentEntity.setUnitId(inviteEntity.getUnitId());
        rmatDocumentEntity.setUnitName(inviteEntity.getUnitName());
        rmatDocumentEntity.setTenderType(inviteEntity.getTenderType());

        //设置计价方式
        rmatDocumentEntity.setBidFlag(1);
        rmatDocumentEntity.setPublishFlag(1);
        rmatDocumentEntity.setNextFlag(1);


        //复制物资详情
        List<RmatInviteDetailEntity> rmatNoticeDetailList = inviteEntity.getRmatDetail();
        List<RmatDocumentDetailEntity> rmatDocumentDetailList = BeanMapper.mapList(rmatNoticeDetailList, RmatDocumentDetailEntity.class);
        for (RmatDocumentDetailEntity rmatDocumentDetailEntity : rmatDocumentDetailList){
            rmatDocumentDetailEntity.setId(null);
        }
        rmatDocumentEntity.setRmatDocumentDetailList(rmatDocumentDetailList);

        //复制供应商
        List<RmatInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List<RmatDocumentSupplierDetailEntity> rmatDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, RmatDocumentSupplierDetailEntity.class);
        for (RmatDocumentSupplierDetailEntity rmatDocumentSupplierDetailVO : rmatDocumentSupplierDetailVOS) {
            rmatDocumentSupplierDetailVO.setId(null);
            documentSupplierDetailService.saveOrUpdate(rmatDocumentSupplierDetailVO);
        }

        service.saveOrUpdate(rmatDocumentEntity, false);

        ProcessEntity processEntity = new ProcessEntity();
        //回写招标阶段
        switch(inviteEntity.getTenderType()){
            case 3:
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("竞争性谈判");
                break;
            case 4:
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("单一来源");
                break;
            case 5:
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("紧急招标");
                break;
            case 2:
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("询价公告");
                break;
        }
        rmatInviteService.updateById(inviteEntity);
        //回写进展表
        processEntity.setBillId(rmatDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(4);
        processEntity.setFrontendUrl("rmat/fourJzDyJjXj");
        processService.saveOrUpdate(processEntity);
        RmatDocumentVO vo = BeanMapper.map(rmatDocumentEntity, RmatDocumentVO.class);
        return vo;
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        //获取轮数
        RmatTalkRecordEntity rmatTalkRecordEntity = rmatTalkRecordService.selectById(talkId);
        Integer talkNum = rmatTalkRecordEntity.getTalkNum();
        if (rmatTalkRecordEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }

        //
        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = rmatDocumentSupplierService.selectById(supplierDetailId);
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper<RmatDocumentSchemeEntity> lambdaScheme = Wrappers.<RmatDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<RmatDocumentSchemeEntity> rmatDocumentSchemeEntityList = rmatDocumentSchemeService.list(lambdaScheme);
        List<RmatDocumentSchemeVO> rmatDocumentSchemeVOList = BeanMapper.mapList(rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<RmatDocumentSellEntity> lambdaSell = Wrappers.<RmatDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId,rmatDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum,talkNum);
        List<RmatDocumentSellEntity> rmatDocumentSellEntityList = rmatDocumentSellService.list(lambdaSell);
        List<RmatDocumentSellVO> rmatDocumentSellVOList = BeanMapper.mapList(rmatDocumentSellEntityList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().
                collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
        for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList){
            List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
            rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
        }
        rmatDocumentSupplierSellVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return rmatDocumentSupplierSellVO;
    }

    @Override
    public RmatDocumentVO saveDocument(Long noticeId) {
        RmatDocumentEntity entity = new RmatDocumentEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询公告主表信息
        RmatNoticeEntity rmatNoticeEntity = rmatNoticeService.selectById(noticeId);
        RmatInviteEntity rmatInvite = rmatInviteService.selectById(rmatNoticeEntity.getInviteId());

        //复制物资详情
        List<RmatInviteDetailEntity> rmatInviteDetailList = rmatInvite.getRmatDetail();
        List<RmatDocumentDetailEntity> rmatDocumentDetailList = BeanMapper.mapList(rmatInviteDetailList, RmatDocumentDetailEntity.class);

        for (RmatDocumentDetailEntity rmatDocumentDetailEntity : rmatDocumentDetailList){
            rmatDocumentDetailEntity.setId(null);
        }

        entity.setRmatDocumentDetailList(rmatDocumentDetailList);

        //复制主表信息
        entity.setProjectId(rmatNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(rmatNoticeEntity.getProjectName());
        entity.setOrgId(rmatNoticeEntity.getOrgId());
        entity.setOrgName(rmatNoticeEntity.getOrgName());
        entity.setParentOrgId(rmatNoticeEntity.getParentOrgId());
        entity.setParentOrgName(rmatNoticeEntity.getParentOrgName());
        entity.setProjectCode(rmatNoticeEntity.getProjectCode());
        entity.setDocumentName(rmatNoticeEntity.getNoticeName());
        entity.setEmployeeId(rmatNoticeEntity.getEmployeeId());
        entity.setEmployeeName(rmatNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatNoticeEntity.getEmployeeMobile());
        entity.setInviteId(rmatNoticeEntity.getInviteId());
        entity.setPurchaseId(rmatNoticeEntity.getPurchaseId());
        entity.setPurchaseName(rmatNoticeEntity.getPurchaseName());
        entity.setPurchaseType(rmatNoticeEntity.getPurchaseType());
        entity.setTenderType(rmatNoticeEntity.getTenderType());
        //设置计价方式
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatNoticeEntity.getInviteId());
        entity.setValueType(rmatInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);

        service.saveOrUpdate(entity, false);

        //回写招标阶段
        rmatInviteEntity.setTenderStage(3);
        rmatInviteService.updateById(rmatInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("招标文件");
        processEntity.setTenderId(rmatNoticeEntity.getInviteId());
        processEntity.setType(4);
        processEntity.setFrontendUrl("rmat/document");
        processService.saveOrUpdate(processEntity);
        RmatDocumentVO vo = BeanMapper.map(entity, RmatDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        //根据documentId查询数据库中专家数量
        List<RmatDocumentExpertEntity> expertEntityList = documentExpertService.list(Wrappers.<RmatDocumentExpertEntity>lambdaQuery()
                .eq(RmatDocumentExpertEntity::getDocumentId, documentId)
                .eq(RmatDocumentExpertEntity::getDr, 0)
        );
        int totalNum = expertEntityList.size();
        if(totalNum < 3){
            return CommonResponse.error("所选专家数量至少为3人！",false);
        }
        //判断专家数量是否为单数
        if(totalNum % 2 == 0){
            return CommonResponse.error("所选专家数量必须为单数！",false);
        }

        /**
         * !!!数据量大时会损失精度，目前业务不可能超过，所以进行强制转换
         */
        //筛选出库中集团、项目专家数量
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "集团".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "项目".equals(entity.getExpertFromName())).count();
        //实际需要的数量
        int trueDepartmentExpertNum = (int)Math.ceil(totalNum * 1.0 / 3);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if(departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum){
            return CommonResponse.error("所选专家数量不符合要求！" +
                    "集团专家" + trueDepartmentExpertNum + "个," +
                    "项目专家" + trueProjectExpertNum + "个！",false);
        }
        return CommonResponse.success("专家选取成功！",true);
    }

}
