package com.ejianc.business.tender.rmat.service.impl;

import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.vo.RmatTalkRecordVO;
import com.ejianc.business.tender.rmat.bean.RmatTalkRecordEntity;
import com.ejianc.business.tender.rmat.mapper.RmatTalkRecordMapper;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatTalkRecordService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 洽商谈判记录主表
 * 
 * @author generator
 * 
 */
@Service("rmatTalkRecordService")
public class RmatTalkRecordServiceImpl extends BaseServiceImpl<RmatTalkRecordMapper, RmatTalkRecordEntity> implements IRmatTalkRecordService {
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Override
    public RmatTalkRecordVO queryDetail(Long id) {
        RmatTalkRecordEntity rmatTalkRecordEntity = super.selectById(id);
        RmatTalkRecordVO rmatTalkRecordVO = BeanMapper.map(rmatTalkRecordEntity, RmatTalkRecordVO.class);

        //确认轮数
        Integer talkNum = rmatTalkRecordVO.getTalkNum();
        RmatDocumentVO rmatDocumentVO = rmatDocumentService.queryDocDetail(rmatTalkRecordVO.getBillId(), talkNum);
        rmatTalkRecordVO.setRmatDocumentDetailSellList(rmatDocumentVO.getRmatDocumentDetailSellList());
        rmatTalkRecordVO.setRmatDocumentSupplierSchemeList(rmatDocumentVO.getRmatDocumentSupplierSchemeList());

        return rmatTalkRecordVO;
    }
}
