package com.ejianc.business.tender.stuff.service;

import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.sun.mail.imap.protocol.BODY;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
public interface IStuffDocumentService extends IBaseService<StuffDocumentEntity> {

    StuffDocumentVO publishDocument(Long id) throws Exception;

    StuffDocumentVO bidDocument(Long id);

    StuffDocumentVO queryDetail(Long id);

    StuffDocumentVO queryDocDetail(Long id,Integer talkNum);


    List<StuffDocumentSellVO> getSchemeDetail(StuffDocumentSellVO stuffDocumentSellVO);

    StuffDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId);

    StuffDocumentVO extendDocument(StuffDocumentRecordVO stuffDocumentRecordVO);

    StuffDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId);

    StuffDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException;

    CommonResponse delSupplier(Long id);

    StuffDocumentVO saveManyDocument(Long id);

    StuffDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId);

    StuffDocumentVO saveDocument(Long noticeId);

    StuffDocumentVO queryDetailNum(Long documentId);

    Boolean supplierPushSell(HttpServletRequest request, MultipartFile file);

    Boolean localPushSell(Map<String,Object> params, MultipartFile file);

    String uploadById(Long attachId,Long inviteId,String billFlag,Long billId);

    String deleteFileById(Long sourceId, List<String> fileNames);

    StuffDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId);

    StuffDocumentVO queryDetail1(Long documentId, Integer num);

    SupplierDTO querySupplierIdByTaxPayerIdentifier(String taxPayerIdentifier);

    /**
     * 检验是否进行过报价
     * @param supplierId
     * @param documentId
     * @param phone
     * @return
     */
    Boolean checkDetail(Long supplierId, Long documentId,String phone);

    /**
     * 查询报价详情
     * @param supplierId
     * @param documentId
     * @param phone
     * @return
     */
    List<StuffDocumentSellVO> queryDetailSell(Long supplierId, Long documentId,Long phone);

    /**
     * 检查所选专家数量
     * 规则：
     *      1.集团专家、项目专家比例1:2，集团专家向上取整
     *      2.评标专家数必须为单数
     * @param documentId
     * @return
     */
    CommonResponse<Boolean> checkExpertNum(Long documentId);


    /**
     * 同步非在库供应商
     *      1.询价招标手机报价时，匿名报价后不允许定标
     *      2.补充入库后，点击同步按钮将supplierId同步到招标模块
     *      3.同步相关表格
     *          3.1 ejc_tender_stuff_document_supplier 供应商
     *          3.2 ejc_tender_stuff_document_sell 供应商报价详情表
     *          3.3 ejc_tender_stuff_document_scheme 供应商报价方案表
     * @param documentId
     * @return
     */
    CommonResponse<Boolean> synSupplier(Long documentId);
}
