package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.pricelib.api.IMaterialPriceHistoryApi;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceContractVO;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteVO;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.vo.ProsubInviteVO;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.vo.RentInviteVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.vo.RmatInviteVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteVO;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.stuff.mapper.StuffInviteMapper;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("stuffInviteService")
public class StuffInviteServiceImpl extends BaseServiceImpl<StuffInviteMapper, StuffInviteEntity> implements IStuffInviteService{
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IProsubInviteService prosubInviteService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IOtherInviteService otherInviteService;

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private StuffInviteMapper mapper;

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id,tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id,abolishType);
    }

    @Override
    public List<StuffInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<StuffInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        LambdaQueryWrapper<ProcessEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProcessEntity::getTenderId, tenderId);
        lambda.eq(ProcessEntity::getBillId, tenderId);
        List<ProcessEntity> list = processService.list(lambda);
        switch (list.get(0).getType()){
            case 0: map = stuffInviteService.getSuffAbolishType(tenderId);break;
            case 1: map = stuffInviteService.getSubAbolishType(tenderId);break;
            case 2: map = stuffInviteService.getEquipmnetAbolishType(tenderId);break;
            case 3: map = stuffInviteService.getRentAbolishType(tenderId);break;
            case 4: map = stuffInviteService.getRmatAbolishType(tenderId);break;
            case 5: map = stuffInviteService.getOtherAbolishType(tenderId);break;
            case 6: map = stuffInviteService.getProsubAbolishType(tenderId);break;
        }
        return map;
    }
//材料
    @Override
    public Map<String, Object> getSuffAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(tenderId);
        StuffInviteVO vo = BeanMapper.map(stuffInviteEntity, StuffInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }
//分包
    @Override
    public Map<String, Object> getSubAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        SubInviteEntity subInviteEntity = subInviteService.selectById(tenderId);
        SubInviteVO vo = BeanMapper.map(subInviteEntity, SubInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }
//设备采购
    @Override
    public Map<String, Object> getEquipmnetAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(tenderId);
        EquipmentInviteVO vo = BeanMapper.map(equipmentInviteEntity, EquipmentInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }
    //设备租赁
    @Override
    public Map<String, Object> getRentAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(tenderId);
        RentInviteVO vo = BeanMapper.map(rentInviteEntity, RentInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }
    //周转材租赁
    @Override
    public Map<String, Object> getRmatAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(tenderId);
        RmatInviteVO vo = BeanMapper.map(rmatInviteEntity, RmatInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }
    //其他
    @Override
    public Map<String, Object> getOtherAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);
        OtherInviteVO vo = BeanMapper.map(otherInviteEntity, OtherInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    //专业分包
    @Override
    public Map<String, Object> getProsubAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        ProsubInviteEntity subInviteEntity = prosubInviteService.selectById(tenderId);
        ProsubInviteVO vo = BeanMapper.map(subInviteEntity, ProsubInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }
    @Override
    public List<StuffInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Autowired
    private IMaterialPriceHistoryApi iMaterialPriceHistoryApi;
    @Override
    public IPage<MaterialPriceHistoryApiVO> queryHistoryPrice(Map<String,Object> param) {
        logger.info("进入材料查询历史价格区间查询接口param-{}", param);
        //获取子表档案id
        List<Long> ids = JSON.parseArray(JSON.toJSONString(param.get("ids")), Long.class);
        //对子表信息按照档案id进行合并
        List<Long> docIdList = ids.stream().distinct().collect(Collectors.toList());
        //调用价格库接口查询历史价格信息
        CommonResponse<List<MaterialPriceHistoryApiVO>> materialPriceHistoryApiVOS = iMaterialPriceHistoryApi.getMaterialPriceHistoryApiVOS(docIdList);
        List<MaterialPriceHistoryApiVO> priceHistoryApiVOList = materialPriceHistoryApiVOS.getData();

        /**
         * 实现分页、非分页二合一
         */
        if(param.get("pageIndex") == null || param.get("pageSize") == null){
            IPage<MaterialPriceHistoryApiVO> page = new Page<>();
            page.setRecords(priceHistoryApiVOList);
            return page;

        }
        //获取分页信息
        long pageIndex = Long.parseLong(param.get("pageIndex").toString());//当前页
        long pageSize = Long.parseLong(param.get("pageSize").toString());//每页显示条数
        IPage<MaterialPriceHistoryApiVO> page = new Page<>(pageIndex,pageSize);
        //分页操作
        page.setTotal(priceHistoryApiVOList.size());
        page.setRecords(priceHistoryApiVOList);

        return page;
    }
}
