package com.ejianc.business.tender.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
@TableName("ejc_tender_sub_invite")
public class SubInviteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="employee_id")
    private Long employeeId; // 编制人
    @TableField(value="employee_name")
    private String employeeName; // 编制人名称
    @TableField(value="unit_id")
    private Long unitId; // 招标单位ID
    @TableField(value="unit_name")
    private String unitName; // 招标单位名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="establish_type")
    private Integer establishType; // 立项类型(0-招标立项，1-定标立项)
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="tender_name")
    private String tenderName; // 招标名称
    @TableField(value="tender_type")
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    @TableField(value="tender_stage")
    private Integer tenderStage; // 招标阶段(0-定标立项,1-招标立项,2-招标公告,3-招标文件,4-专家评标,5-已完成,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告,11-流标，12-费标)
    @TableField(value="tender_unit_num")
    private String tenderUnitNum; // 中标单位及数量
    @TableField(value="create_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 编制日期
    @TableField(value="value_type")
    private Integer valueType; // 计价方式(0-可调单价,1-固定总价,2-成本加酬金)
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="tender_money")
    private BigDecimal tenderMoney; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="abolish_type")
    private Integer abolishType; // 流/废标（0-正常，1-流标，2-废标）
    @TableField(value="sub_type")
    private Long subType; // 分包类型（0-专业分包，1-劳务分包）
    @TableField(value="project_qualification_id")
    private Long projectQualificationId; // 工程资质id
    @TableField(value="project_qualification")
    private String projectQualification; // 工程资质
    @TableField(value="payment_id")
    private String paymentId; // 付款方式
    @TableField(value="payment_name")
    private String paymentName; // 付款方式
    @TableField(value="pay_scale")
    private BigDecimal payScale; // 付款比例
    @TableField(value="entry_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date entryTime; // 进场时间
    @TableField(value="purchase_id")
    private String purchaseId; // 分包内容
    @TableField(value="purchase_name")
    private String purchaseName; // 分包内容
    @TableField(value="score")
    private BigDecimal score; // 专家评分
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商ID
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="money")
    private java.math.BigDecimal money; // 定标金额(无税)
    @TableField(value="tax_money")
    private java.math.BigDecimal taxMoney; // 定标金额(含税)
    @TableField(value="tender_platform")
    private java.lang.Integer tenderPlatform; // 招标平台(1-招采平台，2-云上营家)
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="sub_content")
    private String subContent; // 分包类别
    @TableField(value="sub_content_name")
    private String subContentName; // 分包类别名称


    @TableField(value="team_id")
    private Long teamId; // 班组ID
    @TableField(value="team_code")
    private String teamCode; // 班组code
    @TableField(value="team_name")
    private String teamName; // 班组名称
    @TableField(value="price_show_flag")
    private Integer priceShowFlag; // 招标控制价是否显示0否1是
    @TableField(value="sub_describe")
    private String subDescribe; // 分包范围及作业内容简述


    public String getSubDescribe() {
        return subDescribe;
    }

    public void setSubDescribe(String subDescribe) {
        this.subDescribe = subDescribe;
    }

    public Integer getPriceShowFlag() {
        return priceShowFlag;
    }

    public void setPriceShowFlag(Integer priceShowFlag) {
        this.priceShowFlag = priceShowFlag;
    }

    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }


    @TableField(exist=false)
    @SubEntity(serviceName="subInviteDetailService", pidName= "inviteId")
    private List<SubInviteDetailEntity> subDetail = new ArrayList<>(); // 材料招标立项采购清单表
    @TableField(exist=false)
    @SubEntity(serviceName="subInviteDetailRecordService", pidName= "inviteId")
    private List<SubInviteDetailRecordEntity> subDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
    @TableField(exist=false)
    @SubEntity(serviceName="subInviteSupplierService", pidName= "inviteId")
    private List<SubInviteSupplierEntity> supplierDetail = new ArrayList<>(); // 材料招标立项供应商表
//    @TableField(exist=false)
//    @SubEntity(serviceName="subInviteExpertService", pidName= "inviteId")
//    private List<SubInviteExpertEntity> expertDetail = new ArrayList<>(); // 材料招标立项专家表
    @TableField(exist=false)
    @SubEntity(serviceName="subInviteDetailBidderService", pidName= "inviteId")
    private List<SubInviteDetailBidderEntity> subDetailBidder = new ArrayList<>(); // 材料定标立项定标情况表
    @TableField(value="sign_status")
    private Integer signStatus; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    @TableField(value="occupy_state")
    private Integer occupyState; //占用状态:0-未占用,1-已占用
    @TableField(value="is_low_price")
    private java.lang.Integer isLowPrice; // 低价中标


    public Integer getIsLowPrice() {
        return isLowPrice;
    }

    public void setIsLowPrice(Integer isLowPrice) {
        this.isLowPrice = isLowPrice;
    }
    public Integer getOccupyState() {
        return occupyState;
    }

    public void setOccupyState(Integer occupyState) {
        this.occupyState = occupyState;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getTenderPlatform() {
        return tenderPlatform;
    }

    public void setTenderPlatform(Integer tenderPlatform) {
        this.tenderPlatform = tenderPlatform;
    }

    public Long getProjectQualificationId() {
        return projectQualificationId;
    }

    public void setProjectQualificationId(Long projectQualificationId) {
        this.projectQualificationId = projectQualificationId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    /**
     * 流/废标状态
     */
    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标阶段
     */
    public Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 招标阶段
     */
    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 中标单位及数量
     */
    public String getTenderUnitNum() {
        return tenderUnitNum;
    }

    /**
     * 中标单位及数量
     */
    public void setTenderUnitNum(String tenderUnitNum) {
        this.tenderUnitNum = tenderUnitNum;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 招标金额
     */
    public java.math.BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 招标金额
     */
    public void setTenderMoney(java.math.BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public Integer getEstablishType() {
        return establishType;
    }

    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public void setEstablishType(Integer establishType) {
        this.establishType = establishType;
    }

    public List<SubInviteSupplierEntity> getSupplierDetail() {
        return supplierDetail;
    }

    public void setSupplierDetail(List<SubInviteSupplierEntity> supplierDetail) {
        this.supplierDetail = supplierDetail;
    }

    public List<SubInviteDetailEntity> getSubDetail() {
        return subDetail;
    }

    public void setSubDetail(List<SubInviteDetailEntity> subDetail) {
        this.subDetail = subDetail;
    }

    public List<SubInviteDetailRecordEntity> getSubDetailRecord() {
        return subDetailRecord;
    }

    public void setSubDetailRecord(List<SubInviteDetailRecordEntity> subDetailRecord) {
        this.subDetailRecord = subDetailRecord;
    }

    public List<SubInviteDetailBidderEntity> getSubDetailBidder() {
        return subDetailBidder;
    }

    public void setSubDetailBidder(List<SubInviteDetailBidderEntity> subDetailBidder) {
        this.subDetailBidder = subDetailBidder;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public String getProjectQualification() {
        return projectQualification;
    }

    public void setProjectQualification(String projectQualification) {
        this.projectQualification = projectQualification;
    }

    public String getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public Date getEntryTime() {
        return entryTime;
    }

    public void setEntryTime(Date entryTime) {
        this.entryTime = entryTime;
    }

    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public String getSubContentName() {
        return subContentName;
    }

    public void setSubContentName(String subContentName) {
        this.subContentName = subContentName;
    }
}
