/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.buildmaterial.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.buildmaterial.service.ISystemRequestService;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderVO;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="systemRequestService")
public class SystemRequestService
implements ISystemRequestService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String sendGetRequest(String queryUrl) {
        String responseObiect = "";
        try {
            String responseBody;
            StringBuilder response;
            BufferedReader reader;
            InputStream inputStream;
            String merchant = "ZZYJ";
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary((byte[])dst);
            }
            catch (Exception e) {
                this.logger.error("\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38:", (Throwable)e);
            }
            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/" + queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                inputStream = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            } else {
                throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            reader.close();
            inputStream.close();
            responseObiect = responseBody = response.toString();
            connection.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseObiect;
    }

    @Override
    public String sendPostRequest(String queryUrl, JSONObject queryParam) {
        String responseObiect = "";
        try {
            String merchant = "ZZYJ";
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp).append(queryParam);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary((byte[])dst);
            }
            catch (Exception e) {
                this.logger.error("\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38:", (Throwable)e);
            }
            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/" + queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());
            outputStream.flush();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String responseBody;
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                inputStream.close();
                responseObiect = responseBody = response.toString();
            } else {
                responseObiect = "{code:" + responseCode + ",message:\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25" + responseCode + "}";
            }
            connection.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseObiect;
    }

    @Override
    public String sendPutRequest(String queryUrl, JSONObject queryParam) {
        String responseObiect = "";
        try {
            String responseBody;
            StringBuilder response;
            BufferedReader reader;
            InputStream inputStream;
            String merchant = "ZZYJ";
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp).append(queryParam);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary((byte[])dst);
            }
            catch (Exception e) {
                this.logger.error("\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38:", (Throwable)e);
            }
            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/" + queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());
            outputStream.flush();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                inputStream = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            } else {
                throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            reader.close();
            inputStream.close();
            responseObiect = responseBody = response.toString();
            connection.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseObiect;
    }

    @Override
    public String sendDeleteRequest(String queryUrl) {
        String responseObiect = "";
        try {
            String responseBody;
            StringBuilder response;
            BufferedReader reader;
            InputStream inputStream;
            String merchant = "ZZYJ";
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary((byte[])dst);
            }
            catch (Exception e) {
                this.logger.error("\u5f02\u5e38:", (Throwable)e);
                throw new BusinessException("\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38:", (Throwable)e);
            }
            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/" + queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                inputStream = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            } else {
                throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            reader.close();
            inputStream.close();
            responseObiect = responseBody = response.toString();
            connection.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseObiect;
    }

    @Override
    public String publishNotice(PublishTenderVO publishTenderVO) {
        String s = JSONObject.toJSONString((Object)publishTenderVO);
        this.logger.info("--------------:{}", (Object)s);
        JSONObject param = JSONObject.parseObject((String)JSONObject.toJSONString((Object)publishTenderVO));
        String responseBody = this.sendPostRequest("bid/releaseBid", param);
        return responseBody;
    }
}

