/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSchemeEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSellEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubTalkEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSchemeMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubPicketageMapper;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSchemeService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSellService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubTalkService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="prosubPicketageService")
public class ProsubPicketageServiceImpl
extends BaseServiceImpl<ProsubPicketageMapper, ProsubPicketageEntity>
implements IProsubPicketageService {
    private static final String BILL_CODE = "PROSUB_PICKETAGE_CODE";
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private ProsubDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IProsubTalkService subTalkService;
    @Autowired
    private IProsubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public ProsubPicketageVO savePicketage(Long evaluationId) {
        ProsubPicketageEntity entity = new ProsubPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ExpertEvaluatingEntity subEvaluationEntity = (ExpertEvaluatingEntity)((Object)this.IExpertEvaluatingService.selectById(evaluationId));
        ProsubInviteEntity inviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subEvaluationEntity.getInviteId()));
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(subEvaluationEntity.getDocumentId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setDocumentId(subEvaluationEntity.getDocumentId());
        entity.setEvaluationId(subEvaluationEntity.getId());
        entity.setInviteId(subEvaluationEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(6));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        ProsubPicketageVO vo = (ProsubPicketageVO)BeanMapper.map((Object)((Object)entity), ProsubPicketageVO.class);
        subInviteEntity.setTenderStage(5);
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        List<ProsubDocumentSchemeEntity> schemeList = this.schemeMapper.selectSupplier(subDocumentEntity.getId());
        for (ProsubDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score = this.recordMapper.selectScore(schemeEntity.getId(), schemeEntity.getSupplierId(), subDocumentEntity.getId());
            Boolean scoreBoolean = this.schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), subDocumentEntity.getId(), score);
            if (scoreBoolean.booleanValue()) continue;
            throw new BusinessException("\u56de\u5199\u65b9\u6848\u5f97\u5206\u5931\u8d25!");
        }
        return vo;
    }

    @Override
    @Transactional
    public ProsubPicketageVO queryDetail(Long id) {
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)super.selectById((Serializable)id));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        List supplierEntityList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(ProsubDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        ProsubDocumentEntity entity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(subPicketageEntity.getDocumentId()));
        ProsubDocumentVO subDocumentVO = (ProsubDocumentVO)BeanMapper.map((Object)((Object)entity), ProsubDocumentVO.class);
        List subDocumentDetailList = subDocumentVO.getSubDocumentDetailList();
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, (Object)talkNumMax);
        lambdaSell.eq(ProsubDocumentSellEntity::getPassFlag, (Object)1);
        lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSchemeName);
        List sellList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, ProsubDocumentSellVO.class);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, (Object)talkNumMax);
        lambdaScheme.orderByAsc(ProsubDocumentSchemeEntity::getSchemeName);
        List schemeList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
        for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                if (!subDocumentSellVO.getSchemeId().equals(subDocumentSchemeEntity.getId())) continue;
                subDocumentSellVO.setScore(subDocumentSchemeEntity.getScore());
            }
        }
        ProsubDocumentSellVO subDocumentSellFirst = (ProsubDocumentSellVO)subDocumentSellVOS.stream().findFirst().get();
        if (subDocumentSellFirst.getScore() == null) {
            subDocumentSellVOS.sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        }
        if (subDocumentSellFirst.getScore() != null) {
            subDocumentSellVOS.sort(Comparator.comparing(ProsubDocumentSellVO::getScore).reversed());
        }
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getDetailId));
        for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList) {
            List<ProsubDocumentSellVO> subDocumentSellEntities = sellMap.get(subDocumentDetailVO.getId());
            subDocumentDetailVO.setProsubDocumentSellVOList(subDocumentSellEntities);
        }
        ProsubPicketageVO subPicketageVO = (ProsubPicketageVO)BeanMapper.map((Object)((Object)subPicketageEntity), ProsubPicketageVO.class);
        subPicketageVO.setSubDocumentDetailList(subDocumentDetailList);
        if (subDocumentSellFirst.getScore() == null) {
            subPicketageVO.setScoreStatus(Integer.valueOf(1));
        }
        if (subDocumentSellFirst.getScore() != null) {
            subPicketageVO.setScoreStatus(Integer.valueOf(0));
        }
        return subPicketageVO;
    }

    @Override
    public ProsubPicketageVO saveOrUpdates(ProsubPicketageVO saveorUpdateVO) {
        ProsubPicketageEntity entity = (ProsubPicketageEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProsubPicketageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List picketageSupplierListMoney = saveorUpdateVO.getPicketageSupplierList();
        for (ProsubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierListMoney) {
            money = money.add(subPicketageSupplierVO.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierVO.getMoneyTax());
        }
        entity.setMoneyTax(moneyTax);
        entity.setMoney(money);
        super.saveOrUpdate((Object)entity, false);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(ProsubPicketageSupplierEntity::getPicketageId, (Object)entity.getId());
        this.subPicketageSupplierService.remove((Wrapper)lambdaSupplier);
        List picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for (ProsubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierList) {
            subPicketageSupplierVO.setTenderFlag(Integer.valueOf(0));
        }
        List subPicketageSupplierList = BeanMapper.mapList((Iterable)picketageSupplierList, ProsubPicketageSupplierEntity.class);
        this.subPicketageSupplierService.saveBatch(subPicketageSupplierList);
        List subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList) {
            documentSellVOArrayList.addAll(subDocumentDetailVO.getProsubDocumentSellVOList());
        }
        List subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, ProsubDocumentSellEntity.class);
        this.subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        ProsubPicketageVO subPicketageVO = this.queryDetail(saveorUpdateVO.getId());
        return subPicketageVO;
    }

    @Override
    public ProsubPicketageVO saveManyPicketage(Long documentId) {
        ProsubPicketageEntity entity = new ProsubPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProsubDocumentEntity documentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.subDocumentService.saveOrUpdate((Object)documentEntity);
        LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(ProsubTalkEntity::getBillId, (Object)documentId);
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)this.subTalkService.getOne((Wrapper)lambdaTalk));
        if (subTalkEntity != null) {
            subTalkEntity.setNextFlag(0);
            this.subTalkService.updateById((Object)subTalkEntity);
        }
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        ProsubInviteEntity inviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setDocumentId(documentId);
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        ProsubPicketageVO vo = (ProsubPicketageVO)BeanMapper.map((Object)((Object)entity), ProsubPicketageVO.class);
        subInviteEntity.setTenderStage(5);
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        return vo;
    }

    @Override
    public List<ProsubPicketageSupplierVO> querySupplierList(Long picketageId) {
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)super.selectById((Serializable)picketageId));
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List list = BeanMapper.mapList(picketageSupplierList, ProsubPicketageSupplierVO.class);
        return list;
    }

    @Override
    public ProsubPicketageVO saveSupplierBatch(ProsubPicketageVO saveorUpdateVO) {
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)) {
            return this.queryDetail(saveorUpdateVO.getId());
        }
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List subPicketageSupplierEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getPicketageSupplierList(), ProsubPicketageSupplierEntity.class);
        for (ProsubPicketageSupplierEntity subPicketageSupplierEntity : subPicketageSupplierEntities) {
            subPicketageSupplierEntity.setTenderFlag(0);
            money = money.add(subPicketageSupplierEntity.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierEntity.getMoneyTax());
        }
        this.subPicketageSupplierService.saveBatch(subPicketageSupplierEntities);
        subPicketageEntity.setMoney(money);
        subPicketageEntity.setMoneyTax(moneyTax);
        super.updateById((Object)subPicketageEntity);
        List subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList) {
            documentSellVOArrayList.addAll(subDocumentDetailVO.getProsubDocumentSellVOList());
        }
        List subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, ProsubDocumentSellEntity.class);
        this.subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        return this.queryDetail(saveorUpdateVO.getId());
    }
}

