/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.buildmaterial.service.ISystemRequestService;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderAttachmentsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderProductsVO;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderVO;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffNoticeEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import com.ejianc.foundation.bulidMaterialMdm.api.IBulidMaterialUserApi;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="stuffNotice")
public class StuffNoticeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStuffNoticeService noticeService;
    @Autowired
    private IStuffInviteService inviteService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBulidMaterialUserApi bulidMaterialUserApi;
    @Autowired
    private ISystemRequestService systemRequestService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StuffNoticeEntity stuffNoticeEntity = (StuffNoticeEntity)((Object)this.noticeService.selectById(billId));
        if (stuffNoticeEntity.getTenderType() == 0 && stuffNoticeEntity.getValueType() != 1) {
            this.logger.info("\u63a8\u9001\u7b51\u6750\u7f51\u53d1\u5e03\u62db\u6807\u4fe1\u606f\uff1a{}", (Object)stuffNoticeEntity.getId());
            String notice = this.systemRequestService.publishNotice(this.assemblingData(stuffNoticeEntity));
            this.logger.info("\u63a8\u9001\u7b51\u6750\u7f51\u53d1\u5e03\u62db\u6807\u4fe1\u606f\u8fd4\u56de\uff1a{}", (Object)notice);
            JSONObject jsonObject = JSONObject.parseObject((String)notice);
            if (jsonObject.containsKey((Object)"code") && "0".equals(jsonObject.get((Object)"code"))) {
                String zcwCode = jsonObject.getString("object");
                this.inviteService.updateIsPushZcw(stuffNoticeEntity.getInviteId().toString(), 1, zcwCode);
                this.logger.info("\u62db\u6807\u7acb\u9879\u9875\u9762\u56de\u5199\u63a8\u9001\u7b51\u6750\u7f51");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u529f\u80fd\u4e0d\u652f\u6301\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public PublishTenderVO assemblingData(StuffNoticeEntity stuffNoticeEntity) {
        List data;
        PublishTenderVO publishTenderVO = new PublishTenderVO();
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.inviteService.selectById(stuffNoticeEntity.getInviteId()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        publishTenderVO.setBizKey(stuffNoticeEntity.getId() + "");
        publishTenderVO.setBidWay(Integer.valueOf(1));
        publishTenderVO.setBidType(Integer.valueOf(1));
        publishTenderVO.setAdditionalRemarks(stuffNoticeEntity.getMemo() + "(\u4ea4\u4ed8\u65e5\u671f\u5f85\u5b9a\uff01)");
        publishTenderVO.setContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});
        publishTenderVO.setDateExpired(sdf.format(stuffNoticeEntity.getNoticeEndTime()));
        String[] split = stuffInviteEntity.getAreaName().split("/");
        if (split.length == 3) {
            publishTenderVO.setDeliveryAddress(new String[]{split[0], split[1], split[2], stuffInviteEntity.getAreaDetail()});
        } else {
            publishTenderVO.setDeliveryAddress(new String[]{split[0], split[1], "", stuffInviteEntity.getAreaDetail()});
        }
        publishTenderVO.setInviteSuppliers(null);
        publishTenderVO.setInvoiceRequire(null);
        if (stuffInviteEntity.getTenderMoney().compareTo(new BigDecimal(1000)) > 0) {
            publishTenderVO.setMoneyEstimated(Integer.valueOf(stuffInviteEntity.getTenderMoney().round(new MathContext(2, RoundingMode.HALF_UP)).intValue()));
        } else {
            publishTenderVO.setMoneyEstimated(Integer.valueOf(1000));
        }
        publishTenderVO.setPaymentAgreement(stuffInviteEntity.getSettlementClause());
        publishTenderVO.setProjectName(stuffNoticeEntity.getProjectName());
        publishTenderVO.setReceivingDateExpect(sdf1.format(this.addOneDay(stuffNoticeEntity.getNoticeEndTime())));
        CommonResponse userInfoByMdmId = this.bulidMaterialUserApi.getUserInfoByMdmId(stuffNoticeEntity.getEmployeeId());
        if (userInfoByMdmId.getCode() == 0) {
            publishTenderVO.setUsername(((UserVO)userInfoByMdmId.getData()).getUsername());
        }
        publishTenderVO.setTechContactPerson(new String[]{stuffNoticeEntity.getEmployeeName(), stuffNoticeEntity.getEmployeeMobile()});
        publishTenderVO.setTaxInclude(null);
        ArrayList<PublishTenderProductsVO> products = new ArrayList<PublishTenderProductsVO>();
        if (stuffNoticeEntity.getNoticeDetail() != null) {
            for (StuffInviteDetailEntity stuffNoticeDetailEntity : stuffInviteEntity.getStuffDetail()) {
                PublishTenderProductsVO publishTenderProductsVO = new PublishTenderProductsVO();
                publishTenderProductsVO.setBizKey(stuffNoticeDetailEntity.getId() + "");
                publishTenderProductsVO.setCategoryCode(null);
                publishTenderProductsVO.setCategoryName(stuffNoticeDetailEntity.getMaterialTypeName());
                publishTenderProductsVO.setLeaseDuration(null);
                publishTenderProductsVO.setProductName(stuffNoticeDetailEntity.getMaterialName());
                publishTenderProductsVO.setProductParameter(null);
                publishTenderProductsVO.setProductPlace(null);
                publishTenderProductsVO.setProductQuantity(stuffNoticeDetailEntity.getNum().floatValue());
                publishTenderProductsVO.setProductUnit(stuffNoticeDetailEntity.getUnit());
                publishTenderProductsVO.setProductSize(stuffNoticeDetailEntity.getSpec());
                publishTenderProductsVO.setRemark(stuffNoticeDetailEntity.getMemo());
                products.add(publishTenderProductsVO);
            }
        }
        publishTenderVO.setProducts(products);
        ArrayList<PublishTenderAttachmentsVO> publishTenderAttachmentsVOS = new ArrayList<PublishTenderAttachmentsVO>();
        PublishTenderAttachmentsVO publishTenderAttachmentsVO1 = new PublishTenderAttachmentsVO();
        publishTenderAttachmentsVO1.setBizKey(new Date().getTime() + "" + new Random().nextInt(10000));
        publishTenderAttachmentsVO1.setFileName("\u62db\u6807\u8bf4\u660e.docx");
        publishTenderAttachmentsVO1.setFileUrl("http://csqlh.zzyjjt.com/group1/M00/00/86/rBABl2WFMVGAOurvAAAo4w5Eydo01.docx");
        publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO1);
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(stuffNoticeEntity.getId(), "BT211110000000002", "zcwfile", null);
        if (listCommonResponse.getCode() == 0 && (data = (List)listCommonResponse.getData()) != null && data.size() > 0) {
            for (AttachmentVO datum : data) {
                PublishTenderAttachmentsVO publishTenderAttachmentsVO = new PublishTenderAttachmentsVO();
                publishTenderAttachmentsVO.setBizKey(datum.getId() + "");
                publishTenderAttachmentsVO.setFileName(datum.getFileName());
                publishTenderAttachmentsVO.setFileUrl(datum.getTruePath());
                publishTenderAttachmentsVOS.add(publishTenderAttachmentsVO);
            }
        }
        publishTenderVO.setAttachments(publishTenderAttachmentsVOS);
        return publishTenderVO;
    }

    public Date addOneDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        return calendar.getTime();
    }
}

