/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatBidDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatBidEntity;
import com.ejianc.business.tender.rmat.bean.RmatBidSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSellEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatWinnoticeEntity;
import com.ejianc.business.tender.rmat.mapper.RmatBidMapper;
import com.ejianc.business.tender.rmat.service.IRmatBidDetailService;
import com.ejianc.business.tender.rmat.service.IRmatBidService;
import com.ejianc.business.tender.rmat.service.IRmatBidSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSellService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatWinnoticeService;
import com.ejianc.business.tender.rmat.vo.RmatBidDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatBidSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatBidVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.rmat.vo.RmatPicketageSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatPicketageVO;
import com.ejianc.business.tender.rmat.vo.RmatWinbidDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatWinbidVO;
import com.ejianc.business.tender.rmat.vo.TenderStageEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rmatBidService")
public class RmatBidServiceImpl
extends BaseServiceImpl<RmatBidMapper, RmatBidEntity>
implements IRmatBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatNoticeService rmatNoticeService;
    @Autowired
    private IRmatWinnoticeService rmatWinnoticeService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatBidDetailService rmatBidDetailService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatBidSupplierService rmatBidSupplierService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRmatPicketageSupplierService rmatPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";

    @Override
    public RmatBidVO saveBid(Long picketageId) {
        RmatBidEntity entity = new RmatBidEntity();
        entity.setPicketageId(picketageId);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)this.rmatPicketageService.selectById(picketageId));
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatPicketageEntity.getInviteId()));
        entity.setInviteId(rmatPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate((Object)entity, false);
        RmatBidVO vo = (RmatBidVO)BeanMapper.map((Object)((Object)entity), RmatBidVO.class);
        rmatPicketageEntity.setBidId(entity.getId());
        this.rmatPicketageService.updateById((Object)rmatPicketageEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)rmatPicketageEntity.getDocumentId());
        lambdaSell.eq(RmatDocumentSellEntity::getTenderFlag, (Object)1);
        List sellList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
        List rmatDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOS.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getSupplierId));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)rmatPicketageEntity.getDocumentId());
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.rmatDocumentSupplierService.list((Wrapper)lambdaSupplier);
        Map suppliermatityMap = supplierList.stream().collect(Collectors.toMap(RmatDocumentSupplierEntity::getSupplierId, Function.identity()));
        ArrayList supplierVOList = new ArrayList();
        ArrayList rmatBidDetailEntityList = new ArrayList();
        sellMap.forEach((key, value) -> {
            RmatBidSupplierVO rmatBidSupplierVO = new RmatBidSupplierVO();
            rmatBidSupplierVO.setSupplierId(key);
            rmatBidSupplierVO.setSupplierName(((RmatDocumentSellVO)value.stream().findFirst().get()).getSupplierName());
            RmatDocumentSupplierEntity rmatDocumentSupplierEntity = (RmatDocumentSupplierEntity)((Object)((Object)suppliermatityMap.get(key)));
            rmatBidSupplierVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
            rmatBidSupplierVO.setSupplierMobile(rmatDocumentSupplierEntity.getLinkMobile());
            rmatBidSupplierVO.setId(Long.valueOf(IdWorker.getId()));
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;
            for (RmatDocumentSellVO rmatDocumentSellVO : value) {
                tenderMoneyTax = tenderMoneyTax.add(rmatDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : rmatDocumentSellVO.getTenderMoneyTax());
                tenderMoney = tenderMoney.add(rmatDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : rmatDocumentSellVO.getTenderMoney());
                RmatBidDetailEntity rmatBidDetailEntity = (RmatBidDetailEntity)((Object)((Object)BeanMapper.map((Object)rmatDocumentSellVO, RmatBidDetailEntity.class)));
                rmatBidDetailEntity.setMoney(rmatDocumentSellVO.getTenderMoney());
                rmatBidDetailEntity.setMoneyTax(rmatDocumentSellVO.getTenderMoneyTax());
                rmatBidDetailEntity.setId(null);
                rmatBidDetailEntity.setBidSupplierId(rmatBidSupplierVO.getId());
                rmatBidDetailEntity.setBidId(entity.getId());
                rmatBidDetailEntityList.add(rmatBidDetailEntity);
            }
            rmatBidSupplierVO.setMoneyTax(tenderMoneyTax);
            rmatBidSupplierVO.setMoney(tenderMoney);
            rmatBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(rmatBidSupplierVO);
        });
        List rmatBidSuppliermatities = BeanMapper.mapList(supplierVOList, RmatBidSupplierEntity.class);
        this.rmatBidSupplierService.saveBatch(rmatBidSuppliermatities);
        this.rmatBidDetailService.saveBatch(rmatBidDetailEntityList);
        String tenderUnitNum = "";
        List<RmatBidDetailEntity> bidDetailEntityList = ((RmatBidMapper)this.baseMapper).selectBidSupplier(entity.getId());
        for (RmatBidDetailEntity rmatBidDetailEntity : bidDetailEntityList) {
            RmatBidSupplierEntity suppliermatity = (RmatBidSupplierEntity)((Object)this.rmatBidSupplierService.selectById(rmatBidDetailEntity.getBidSupplierId()));
            BigDecimal sumNum = rmatBidDetailEntity.getTenderNum().setScale(4, 4);
            String name = suppliermatity.getSupplierName() + "(" + sumNum + "),";
            tenderUnitNum = tenderUnitNum + name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        this.rmatInviteService.saveOrUpdate((Object)inviteEntity);
        RmatBidVO rmatBidVO = (RmatBidVO)BeanMapper.map((Object)((Object)entity), RmatBidVO.class);
        return rmatBidVO;
    }

    @Override
    public RmatBidVO queryDetail(Long bidId) {
        RmatBidEntity rmatBidEntity = (RmatBidEntity)((Object)super.selectById((Serializable)bidId));
        RmatBidVO rmatBidVO = (RmatBidVO)BeanMapper.map((Object)((Object)rmatBidEntity), RmatBidVO.class);
        List rmatBidDetailList = rmatBidVO.getRmatBidDetailList();
        Map<Long, List<RmatBidDetailVO>> detailMap = rmatBidDetailList.stream().collect(Collectors.groupingBy(RmatBidDetailVO::getBidSupplierId));
        List rmatBidSupplierList = rmatBidVO.getRmatBidSupplierList();
        for (RmatBidSupplierVO rmatBidSupplierVO : rmatBidSupplierList) {
            rmatBidSupplierVO.setRmatBidDetailList(detailMap.get(rmatBidSupplierVO.getId()));
        }
        rmatBidVO.setRmatBidSupplierList(rmatBidSupplierList);
        return rmatBidVO;
    }

    @Override
    @Transactional
    public RmatBidVO publishBid(RmatBidVO saveorUpdateVO) {
        RmatBidEntity entity = (RmatBidEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        RmatBidVO vo = (RmatBidVO)BeanMapper.map((Object)((Object)entity), RmatBidVO.class);
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(entity.getInviteId()));
        RmatWinbidVO winbidVO = new RmatWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(rmatInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType() == null || winbidVO.getPurchaseType() == 1) {
            winbidVO.setSourceProjectId(null);
        } else {
            winbidVO.setSourceProjectId(Long.toString(rmatInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(rmatInviteEntity.getProjectName());
        winbidVO.setProjectCode(rmatInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(rmatInviteEntity.getOrgId()));
        winbidVO.setOrgName(rmatInviteEntity.getOrgName());
        winbidVO.setUnitName(rmatInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(rmatInviteEntity.getUnitId()));
        winbidVO.setType("RMAT");
        winbidVO.setTenderName(rmatInviteEntity.getTenderName());
        winbidVO.setTenderType(rmatInviteEntity.getTenderType());
        winbidVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(RmatDocumentEntity::getInviteId, (Object)entity.getInviteId());
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.getOne((Wrapper)lambdaDoc));
        winbidVO.setNoticeBidTime(rmatDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());
        if (rmatInviteEntity.getTenderType() == 2 || rmatInviteEntity.getTenderType() == 3 || rmatInviteEntity.getTenderType() == 4 || rmatInviteEntity.getTenderType() == 5) {
            winbidVO.setSourceEmployeeId(Long.toString(rmatDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(rmatDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        } else {
            LambdaQueryWrapper lambdaNotice = Wrappers.lambdaQuery();
            lambdaNotice.eq(RmatNoticeEntity::getInviteId, (Object)entity.getInviteId());
            RmatNoticeEntity noticeEntity = (RmatNoticeEntity)((Object)this.rmatNoticeService.getOne((Wrapper)lambdaNotice));
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }
        RmatBidVO rmatBidVO = this.queryDetail(entity.getId());
        List rmatBidSupplierList = rmatBidVO.getRmatBidSupplierList();
        ArrayList<RmatWinbidVO> winbidVOList = new ArrayList<RmatWinbidVO>();
        for (RmatBidSupplierVO rmatBidSupplierVO : rmatBidSupplierList) {
            RmatWinbidVO winbidVONew = (RmatWinbidVO)BeanMapper.map((Object)winbidVO, RmatWinbidVO.class);
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(rmatBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(rmatBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(rmatBidSupplierVO.getMoney());
            winbidVONew.setContent(rmatBidVO.getBidContent());
            winbidVONew.setWinbidType(Integer.valueOf(0));
            List rmatBidDetailList = rmatBidSupplierVO.getRmatBidDetailList();
            HashMap<String, List> map = new HashMap<String, List>();
            for (RmatBidDetailVO rmatBidDetailVO : rmatBidDetailList) {
                String s = null;
                if (rmatBidDetailVO.getMaterialId() == null) {
                    s = rmatBidDetailVO.getMaterialTypeId().toString() + rmatBidDetailVO.getRate() + rmatBidDetailVO.getSchemeId() + rmatBidDetailVO.getPlanEnterDate() + rmatBidDetailVO.getPlanLeaveDate();
                }
                if (rmatBidDetailVO.getMaterialId() != null) {
                    s = rmatBidDetailVO.getMaterialId().toString() + rmatBidDetailVO.getMaterialTypeId().toString() + rmatBidDetailVO.getRate() + rmatBidDetailVO.getSchemeId() + rmatBidDetailVO.getPlanEnterDate() + rmatBidDetailVO.getPlanLeaveDate();
                }
                if (map.containsKey(s)) {
                    List rmatBidDetailVOS = (List)map.get(s);
                    rmatBidDetailVOS.add(rmatBidDetailVO);
                    map.put(s, rmatBidDetailVOS);
                    continue;
                }
                ArrayList<RmatBidDetailVO> rmatBidDetailVOList = new ArrayList<RmatBidDetailVO>();
                rmatBidDetailVOList.add(rmatBidDetailVO);
                map.put(s, rmatBidDetailVOList);
            }
            ArrayList winbidDetailVOList = new ArrayList();
            map.forEach((key, value) -> {
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (RmatBidDetailVO rmatBidDetailVOLast : value) {
                    tenderNum = tenderNum.add(rmatBidDetailVOLast.getTenderNum() == null ? BigDecimal.ZERO : rmatBidDetailVOLast.getTenderNum());
                    money = money.add(rmatBidDetailVOLast.getMoney() == null ? BigDecimal.ZERO : rmatBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add(rmatBidDetailVOLast.getMoneyTax() == null ? BigDecimal.ZERO : rmatBidDetailVOLast.getMoneyTax());
                    tax = tax.add(rmatBidDetailVOLast.getSellTax() == null ? BigDecimal.ZERO : rmatBidDetailVOLast.getSellTax());
                }
                RmatBidDetailVO first = (RmatBidDetailVO)value.stream().findFirst().get();
                RmatWinbidDetailVO winbidDetailVO = new RmatWinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setRmatWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        this.logger.info("\u63a8\u9001\u4f9b\u65b9\u4e2d\u6807\u4fe1\u606f:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSavesUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u540c\u6b65\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(vo.getId());
    }

    @Override
    public RmatBidVO queryDbDetail(Long picketage) {
        return null;
    }

    @Override
    public RmatBidVO nextPaper(Long winnoticeId) {
        RmatBidEntity entity = new RmatBidEntity();
        RmatWinnoticeEntity rmatWinnoticeEntity = (RmatWinnoticeEntity)((Object)this.rmatWinnoticeService.selectById(winnoticeId));
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatWinnoticeEntity.getInviteId()));
        entity.setInviteId(rmatWinnoticeEntity.getInviteId());
        entity.setBidName(rmatInviteEntity.getTenderName());
        entity.setPurchaseType(rmatInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate((Object)entity, false);
        rmatWinnoticeEntity.setNextFlag(1);
        this.rmatWinnoticeService.updateById((Object)rmatWinnoticeEntity);
        rmatInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.rmatInviteService.updateById((Object)rmatInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rmat/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        RmatBidVO rmatBidVO = (RmatBidVO)BeanMapper.map((Object)((Object)entity), RmatBidVO.class);
        return rmatBidVO;
    }

    @Override
    public List<RmatPicketageSupplierVO> querySupplierList(Long picketageId) {
        RmatBidEntity rmatBidEntity = (RmatBidEntity)((Object)super.selectById((Serializable)picketageId));
        RmatWinnoticeEntity rmatWinnoticeEntity = (RmatWinnoticeEntity)((Object)this.rmatWinnoticeService.selectById(rmatBidEntity.getWinnoticeId()));
        LambdaQueryWrapper lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(RmatPicketageSupplierEntity::getPicketageId, (Object)rmatWinnoticeEntity.getPicketageId());
        List listSupplier = this.rmatPicketageSupplierService.list((Wrapper)lambdaSupplierList);
        List rmatPicketageSupplierVOS = BeanMapper.mapList((Iterable)listSupplier, RmatPicketageSupplierVO.class);
        return rmatPicketageSupplierVOS;
    }

    @Override
    @Transactional
    public RmatPicketageVO insertProcess(Long picketageId) {
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)this.rmatPicketageService.selectById(picketageId));
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatPicketageEntity.getInviteId()));
        rmatInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.rmatInviteService.updateById((Object)rmatInviteEntity);
        rmatPicketageEntity.setBidStatus(1);
        this.rmatPicketageService.updateById((Object)rmatPicketageEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(rmatPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(rmatInviteEntity.getId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rmat/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        RmatPicketageVO rmatPicketageVO = (RmatPicketageVO)BeanMapper.map((Object)((Object)rmatPicketageEntity), RmatPicketageVO.class);
        return rmatPicketageVO;
    }

    @Override
    public List<RmatPicketageSupplierVO> querySupplierDetail(Long id) {
        RmatBidEntity rmatBidEntity = (RmatBidEntity)((Object)super.selectById((Serializable)id));
        return this.rmatPicketageService.querySupplierList(rmatBidEntity.getPicketageId());
    }
}

