/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.sub.service.ISubTalkService;
import com.ejianc.business.tender.sub.vo.SubTalkDetailVO;
import com.ejianc.business.tender.sub.vo.SubTalkVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subTalk"})
@Api(value="\u6d3d\u5546\u8c08\u5224\u4e3b\u8868", tags={"\u6d3d\u5546\u8c08\u5224\u4e3b\u8868"})
public class SubTalkController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private ISubTalkService service;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubTalkVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SubTalkVO saveorUpdateVO) {
        SubTalkVO subTalkVO = this.service.saveOrUpdates(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)subTalkVO);
    }

    @ApiOperation(value="\u53d1\u5e03\u63a5\u53e3")
    @RequestMapping(value={"/publishTalk"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubTalkVO> publishTalk(@RequestParam Long id) {
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01", (Object)this.service.publishTalk(id));
    }

    @ApiOperation(value="\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\u63a5\u53e3")
    @RequestMapping(value={"/extendTalk"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubTalkVO> extendTalk(@RequestBody SubTalkDetailVO subDocumentRecordVO) {
        return CommonResponse.success((String)"\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\u6210\u529f\uff01", (Object)this.service.extendTalk(subDocumentRecordVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubTalkVO> queryDetail(@RequestParam Long id) {
        SubTalkVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u5176\u4ed6\u5355\u636e\u70b9\u51fb\u4e0b\u4e00\u6b65\u63a5\u53e3")
    @RequestMapping(value={"/saveTalk"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubTalkVO> saveTalk(@RequestParam Long documentId) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)this.service.saveTalk(documentId));
    }

    @ApiOperation(value="\u518d\u6b21\u6d3d\u5546")
    @RequestMapping(value={"/againSaveTalk"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubTalkVO> againSaveTalk(@RequestParam Long id) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)this.service.againSaveTalk(id));
    }

    @ApiOperation(value="\u4e0b\u4e00\u6b65\u8865\u5145\u6570\u636e\u63a5\u53e3")
    @RequestMapping(value={"/replenishSell"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubTalkVO> replenishSell(@RequestParam Long id) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)this.service.replenishSell(id));
    }

    @ApiOperation(value="\u83b7\u53d6\u4f9b\u5e94\u5546\u62a5\u4ef7\u662f\u5426\u62a5\u5168")
    @RequestMapping(value={"/getSellFull"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> getSellFull(@RequestParam Long id) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)this.service.getSellFull(id));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubTalkVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u591a\u4e2a\u4f9b\u5e94\u5546\u8be6\u60c5\u67e5\u8be2")
    @RequestMapping(value={"/querySupplierList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> querySupplierList(Long talkId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.service.querySupplierList(talkId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubTalkVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubTalkVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubTalk-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSubTalkData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubTalkVO>> refSubTalkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubTalkVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

