/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.other.bean.OtherAdviceEntity;
import com.ejianc.business.tender.other.bean.OtherBidEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.mapper.OtherAdviceMapper;
import com.ejianc.business.tender.other.service.IOtherAdviceService;
import com.ejianc.business.tender.other.service.IOtherBidService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherAdviceSupplierPushVO;
import com.ejianc.business.tender.other.vo.OtherAdviceVO;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="otherAdviceService")
public class OtherAdviceServiceImpl
extends BaseServiceImpl<OtherAdviceMapper, OtherAdviceEntity>
implements IOtherAdviceService {
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000004";
    @Autowired
    private IOtherBidService otherBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        OtherAdviceEntity otherAdviceEntity = (OtherAdviceEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            otherAdviceEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            otherAdviceEntity.setSignFlag(1);
        }
        if (status == 4) {
            otherAdviceEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(otherAdviceEntity.getId());
            cv.setContractName(otherAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)otherAdviceEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        OtherAdviceEntity otherAdviceEntity = (OtherAdviceEntity)((Object)super.selectById((Serializable)id));
        otherAdviceEntity.setSendFlag(0);
        super.updateById((Object)otherAdviceEntity);
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherAdviceEntity.getInviteId()));
        OtherAdviceSupplierPushVO otherAdviceSupplierPushVO = (OtherAdviceSupplierPushVO)BeanMapper.map((Object)((Object)otherAdviceEntity), OtherAdviceSupplierPushVO.class);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        }
        otherAdviceSupplierPushVO.setSystemId((String)ejcCloudSystemCode.getData());
        otherAdviceSupplierPushVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6750\u6599\u4e2d\u6807\u901a\u77e5\u4e66");
        otherAdviceSupplierPushVO.setSourceId(otherAdviceEntity.getId().toString());
        otherAdviceSupplierPushVO.setBidTitle(otherAdviceEntity.getTitleName());
        otherAdviceSupplierPushVO.setSourceProjectId(otherAdviceEntity.getProjectId() != null ? otherAdviceEntity.getProjectId().toString() : null);
        otherAdviceSupplierPushVO.setSourceOrgId(otherAdviceEntity.getOrgId().toString());
        otherAdviceSupplierPushVO.setSourceUnitId(otherAdviceEntity.getUnitId().toString());
        otherAdviceSupplierPushVO.setType(CommonUtils.getGysType(5));
        otherAdviceSupplierPushVO.setTenderType(otherInviteEntity.getTenderType());
        otherAdviceSupplierPushVO.setBidDate(otherAdviceEntity.getNoticeDate());
        otherAdviceSupplierPushVO.setMoney(otherAdviceEntity.getMoney());
        otherAdviceSupplierPushVO.setMoneyTax(otherAdviceEntity.getMoneyTax());
        String dataInfo = JSONObject.toJSONString((Object)otherAdviceSupplierPushVO);
        boolean b = this.stuffAdviceService.pushBillToSupCenter(dataInfo, otherAdviceEntity.getSupplierId(), otherAdviceEntity.getId(), BILL_TYPE, "/ejc-supbid-web/openapi/bid/saveBid", otherAdviceEntity.getTitleName());
        if (!b) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25!");
        }
        return null;
    }

    @Override
    public List<OtherAdviceVO> queryAdviceList(Long id) {
        OtherBidEntity otherBidEntity = (OtherBidEntity)((Object)this.otherBidService.selectById(id));
        LambdaQueryWrapper lambdaAdvice = Wrappers.lambdaQuery();
        lambdaAdvice.eq(OtherAdviceEntity::getInviteId, (Object)otherBidEntity.getInviteId());
        List list = super.list((Wrapper)lambdaAdvice);
        List otherAdviceVOS = BeanMapper.mapList((Iterable)list, OtherAdviceVO.class);
        if (CollectionUtils.isNotEmpty((Collection)otherAdviceVOS)) {
            List data;
            List attachIds = otherAdviceVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (OtherAdviceVO otherAdviceVO : otherAdviceVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(otherAdviceVO.getId());
                    if (attachmentVO == null) continue;
                    otherAdviceVO.setAttachId(attachmentVO.getId());
                    otherAdviceVO.setFileName(attachmentVO.getFileName());
                    otherAdviceVO.setFilePath(attachmentVO.getFilePath());
                }
            }
        }
        return otherAdviceVOS;
    }
}

