/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentExpertEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentRecordEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSchemeEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSellEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSupplierDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailRecordEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubNoticeEntity;
import com.ejianc.business.tender.prosub.bean.ProsubNoticeSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubTalkEntity;
import com.ejianc.business.tender.prosub.bean.ProsubTalkRecordEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSellMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSupplierDetailMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSupplierMapper;
import com.ejianc.business.tender.prosub.service.IProsubDocumentDetailService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentExpertService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentRecordService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSchemeService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSellService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSupplierDetailService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubInviteDetailRecordService;
import com.ejianc.business.tender.prosub.service.IProsubInviteDetailService;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubNoticeService;
import com.ejianc.business.tender.prosub.service.IProsubNoticeSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubTalkRecordService;
import com.ejianc.business.tender.prosub.service.IProsubTalkService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentRecordVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSchemeVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSupplierSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSupplierTbVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailRecordVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteVO;
import com.ejianc.business.tender.prosub.vo.ProsubNoticeDetailTbVO;
import com.ejianc.business.tender.prosub.vo.ProsubNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.prosub.vo.ProsubNoticeSupplierTbVO;
import com.ejianc.business.tender.prosub.vo.ProsubNoticeSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubSupplierSellSchemeDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubSupplierSellSchemeVO;
import com.ejianc.business.tender.prosub.vo.ProsubSupplierSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubTalkVO;
import com.ejianc.business.tender.stuff.vo.SupplierSellVO;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Service(value="prosubDocumentService")
public class ProsubDocumentServiceImpl
extends BaseServiceImpl<ProsubDocumentMapper, ProsubDocumentEntity>
implements IProsubDocumentService {
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private ProsubDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private ProsubDocumentSupplierMapper supplierMapper;
    @Autowired
    private IProsubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private ProsubDocumentSellMapper subDocumentSellMapper;
    @Autowired
    private IProsubDocumentRecordService subDocumentRecordService;
    @Autowired
    private IProsubDocumentDetailService subDocumentDetailService;
    @Autowired
    private IProsubInviteDetailService subInviteDetailService;
    @Autowired
    private IProsubTalkService subTalkService;
    @Autowired
    private IProsubTalkRecordService subTalkRecordService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentExpertService documentExpertService;
    @Autowired
    private IProsubDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IProsubDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IProsubDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IProsubInviteDetailRecordService subInviteDetailRecordService;
    @Autowired
    private IProsubNoticeService subNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Value(value="${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value(value="${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000002";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "invite-document-code";
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IProsubNoticeSupplierService subNoticeSupplierService;

    @Override
    @Transactional
    public ProsubDocumentVO publishDocument(Long id) {
        CommonResponse stringCommonResponses;
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)super.selectById((Serializable)id));
        subDocumentEntity.setPublishFlag(0);
        super.updateById((Object)subDocumentEntity);
        ProsubDocumentSupplierTbVO subDocumentSupplierTbVO = new ProsubDocumentSupplierTbVO();
        subDocumentSupplierTbVO.setSourceId(subDocumentEntity.getInviteId().toString());
        subDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        subDocumentSupplierTbVO.setNoticeType(Integer.valueOf(1));
        subDocumentSupplierTbVO.setProjectLinkName(subDocumentEntity.getProjectLinkName());
        subDocumentSupplierTbVO.setProjectLinkPhone(subDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(subDocumentEntity.getOfferStartTime());
        subDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(subDocumentEntity.getOfferEndTime());
        subDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        subDocumentSupplierTbVO.setContent(subDocumentEntity.getDocumentContent());
        subDocumentSupplierTbVO.setBrandFlag(subDocumentEntity.getBrandFlag());
        subDocumentSupplierTbVO.setMemo(subDocumentEntity.getMemo());
        subDocumentSupplierTbVO.setTenderName(subDocumentEntity.getDocumentName());
        CommonResponse stringCommonResponse = this.proSupplierApi.getEjcCloudSystemCode();
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u83b7\u53d6systemId\u5931\u8d25" + stringCommonResponse.getMsg());
        }
        subDocumentSupplierTbVO.setSystemId((String)stringCommonResponse.getData());
        CommonResponse zbwjFile = this.attachmentApi.queryListBySourceId(subDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Object> zbwjAttachIdList = new ArrayList();
        if (zbwjFile.isSuccess()) {
            List data = (List)zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonZbwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String dataZbwj = (String)zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject((String)dataZbwj);
        Map zbwjMap = (Map)JSONObject.parseObject((String)zbwListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        zbwjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        String stringFb = JSONObject.toJSONString((Object)subDocumentSupplierTbVO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("noticeEntity", stringFb);
        HashMap files = null;
        if (!streamMap.isEmpty()) {
            files = new HashMap();
            files.put("file", streamMap);
        }
        if (!(stringCommonResponses = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.saveWjUrl, params, files, this.appId, this.appSecret, this.appHost)).isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u53d1\u5e03\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponses.getMsg());
        }
        ProsubDocumentVO subDocumentVO = this.queryDetail(id);
        return subDocumentVO;
    }

    @Override
    public ProsubDocumentVO bidDocument(Long id) {
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)super.selectById((Serializable)id));
        subDocumentEntity.setBidFlag(0);
        subDocumentEntity.setBidTime(new Date());
        super.updateById((Object)subDocumentEntity);
        ProsubDocumentVO subDocumentVO = this.queryDetail(id);
        List entityList = this.documentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)subDocumentVO.getId())).eq((Object)"dr", (Object)0));
        for (ProsubDocumentExpertEntity entity : entityList) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            ArrayList<String> sender = new ArrayList<String>();
            sender.add(entity.getExpertId() + "");
            String name = subDocumentVO.getPurchaseType() == 0 ? subDocumentVO.getProjectName() : subDocumentVO.getOrgName();
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + sender);
            String subject = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            String content = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, this.pushMessageApi);
        }
        return subDocumentVO;
    }

    @Override
    public ProsubDocumentVO queryDetail(Long id) {
        return this.queryDocDetail(id, 0);
    }

    @Override
    public ProsubDocumentVO queryDetail1(Long id, Integer num) {
        return this.queryDocDetail(id, num);
    }

    @Override
    public ProsubDocumentVO queryDetailNum(Long id) {
        ProsubDocumentSchemeEntity subDocumentSchemeEntity = (ProsubDocumentSchemeEntity)((Object)this.subDocumentSchemeService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)id)).orderByDesc((Object)"talk_num")).get(0));
        return this.queryDocDetail(id, subDocumentSchemeEntity.getTalkNum());
    }

    @Override
    @Transactional
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {
        this.logger.info("\u4e13\u4e1a\u5206\u5305\u8fdb\u5165\u62a5\u4ef7\u63a5\u53e3request-{},file-{}", (Object)request, (Object)file);
        String notice = request.getParameter("bjNoticeVO");
        this.logger.info("\u4e13\u4e1a\u5206\u5305\u5b9e\u4f53\u4fe1\u606f-{}", (Object)notice);
        ProsubSupplierSellVO pushVO = (ProsubSupplierSellVO)JSON.parseObject((String)notice, (TypeReference)new TypeReference<ProsubSupplierSellVO>(){}, (Feature[])new Feature[0]);
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(Long.valueOf(Long.parseLong(pushVO.getSourceId()))));
        Integer tenderStage = subInviteEntity.getTenderStage();
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
            lambdaTalk.eq(ProsubTalkEntity::getInviteId, (Object)Long.parseLong(pushVO.getSourceId()));
            ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)this.subTalkService.getOne((Wrapper)lambdaTalk));
            talkNum = subTalkEntity.getTalkNum();
        }
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(Long.valueOf(sourceSupplierId)).getData();
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper lambdaDocument = Wrappers.lambdaQuery();
        lambdaDocument.eq(ProsubDocumentEntity::getInviteId, (Object)inviteId);
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)((ProsubDocumentMapper)this.baseMapper).selectOne((Wrapper)lambdaDocument));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)subDocumentEntity.getId());
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = (ProsubDocumentSupplierEntity)((Object)this.subDocumentSupplierService.getOne((Wrapper)lambdaSupplier));
        Long documentSupplierId = null;
        if (subDocumentSupplierEntity != null) {
            subDocumentSupplierEntity.setOfferTime(new Date());
            subDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            subDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            subDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            this.subDocumentSupplierService.updateById((Object)subDocumentSupplierEntity);
            documentSupplierId = subDocumentSupplierEntity.getId();
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId, (Object)subDocumentSupplierEntity.getId());
            this.subDocumentSchemeService.remove((Wrapper)lambdaScheme);
        }
        if (subDocumentSupplierEntity == null) {
            ProsubDocumentSupplierEntity subDocumentSupplierEntityAdd = new ProsubDocumentSupplierEntity();
            subDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            subDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            subDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            subDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            subDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            subDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            subDocumentSupplierEntityAdd.setOfferTime(new Date());
            subDocumentSupplierEntityAdd.setDocumentId(subDocumentEntity.getId());
            subDocumentSupplierEntityAdd.setTalkNum(talkNum);
            this.subDocumentSupplierService.save((Object)subDocumentSupplierEntityAdd);
            documentSupplierId = subDocumentSupplierEntityAdd.getId();
        }
        List schemeList = pushVO.getSubSchemeList();
        ArrayList<ProsubDocumentSchemeEntity> subDocumentSchemeEntityArrayList = new ArrayList<ProsubDocumentSchemeEntity>();
        ArrayList<ProsubDocumentSellVO> subDocumentSellVOList = new ArrayList<ProsubDocumentSellVO>();
        for (ProsubSupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            ProsubDocumentSchemeEntity subDocumentSchemeEntity = new ProsubDocumentSchemeEntity();
            subDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            subDocumentSchemeEntity.setDocumentId(subDocumentEntity.getId());
            subDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            subDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            subDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            subDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            subDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMny());
            subDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getTaxMny());
            subDocumentSchemeEntity.setTalkNum(talkNum);
            subDocumentSchemeEntity.setId(IdWorker.getId());
            subDocumentSchemeEntity.setPassFlag(1);
            subDocumentSchemeEntityArrayList.add(subDocumentSchemeEntity);
            List schemeDetailList = supplierSellSchemeVO.getSubSchemeDetailList();
            for (ProsubSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                ProsubDocumentSellVO subDocumentSellVO = new ProsubDocumentSellVO();
                subDocumentSellVO.setSchemeId(subDocumentSchemeEntity.getId());
                subDocumentSellVO.setDocumentId(subDocumentEntity.getId());
                subDocumentSellVO.setSupplierId(Long.valueOf(sourceSupplierId));
                subDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                subDocumentSellVO.setSupplierName(supplierVO.getName());
                subDocumentSellVO.setDetailId(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceDetailId())));
                ProsubInviteDetailRecordEntity subRecordEntity = (ProsubInviteDetailRecordEntity)((Object)this.subInviteDetailRecordService.selectById(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceDetailId()))));
                subDocumentSellVO.setMaterialId(subRecordEntity.getDocId());
                subDocumentSellVO.setMaterialTypeId(subRecordEntity.getDocCategoryId());
                subDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getDetailName());
                subDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getDetailCode());
                subDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                subDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
                subDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                subDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                subDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                subDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getTaxPrice());
                subDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                subDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                subDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                subDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                subDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                subDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                subDocumentSellVO.setReferFlag(Integer.valueOf(2));
                subDocumentSellVO.setPassFlag(Integer.valueOf(1));
                subDocumentSellVO.setTalkNum(talkNum);
                subDocumentSellVO.setContent(supplierSellSchemeDetailVO.getContent());
                subDocumentSellVO.setRule(supplierSellSchemeDetailVO.getRule());
                subDocumentSellVO.setInfoPrice(supplierSellSchemeDetailVO.getInfoPrice());
                subDocumentSellVO.setFallRate(supplierSellSchemeDetailVO.getFallRate());
                subDocumentSellVOList.add(subDocumentSellVO);
            }
        }
        this.subDocumentSchemeService.saveBatch(subDocumentSchemeEntityArrayList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subDocumentEntity.getId());
        this.subDocumentSellService.remove((Wrapper)lambdaSell);
        LambdaQueryWrapper lambdaDetail = Wrappers.lambdaQuery();
        lambdaDetail.eq(ProsubDocumentDetailEntity::getDocumentId, (Object)subDocumentEntity.getId());
        List subDocumentDetailList = this.subDocumentDetailService.list((Wrapper)lambdaDetail);
        ArrayList<ProsubDocumentSellEntity> subDocumentSellEntityArrayList = new ArrayList<ProsubDocumentSellEntity>();
        for (ProsubDocumentDetailEntity subDocumentDetailEntity : subDocumentDetailList) {
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                ProsubDocumentSellEntity subDocumentSellEntity;
                if (subDocumentDetailEntity.getMaterialId() != null) {
                    if (subInviteEntity.getPurchaseType() == 1) {
                        if (subDocumentDetailEntity.getContent() != null && subDocumentSellVO.getContent() != null) {
                            if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) && subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) && subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) && subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule()) && subDocumentDetailEntity.getContent().equals(subDocumentSellVO.getContent())) {
                                subDocumentSellEntity = (ProsubDocumentSellEntity)((Object)BeanMapper.map((Object)subDocumentSellVO, ProsubDocumentSellEntity.class));
                                subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                                subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                                subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                                subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                                subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                                subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                                subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                                subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                                subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                            }
                        } else if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) && subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) && subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) && subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule())) {
                            subDocumentSellEntity = (ProsubDocumentSellEntity)((Object)BeanMapper.map((Object)subDocumentSellVO, ProsubDocumentSellEntity.class));
                            subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                            subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                            subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                            subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                            subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                            subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                            subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                            subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                            subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                        }
                    } else if (subDocumentDetailEntity.getContent() != null && subDocumentSellVO.getContent() != null) {
                        if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) && subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) && subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) && subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule()) && subDocumentDetailEntity.getContent().equals(subDocumentSellVO.getContent())) {
                            subDocumentSellEntity = (ProsubDocumentSellEntity)((Object)BeanMapper.map((Object)subDocumentSellVO, ProsubDocumentSellEntity.class));
                            subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                            subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                            subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                            subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                            subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                            subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                            subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                            subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                            subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                        }
                    } else if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) && subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) && subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) && subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule())) {
                        subDocumentSellEntity = (ProsubDocumentSellEntity)((Object)BeanMapper.map((Object)subDocumentSellVO, ProsubDocumentSellEntity.class));
                        subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                        subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                        subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                        subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                        subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                        subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                        subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                        subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                        subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                    }
                }
                if (subDocumentDetailEntity.getMaterialId() != null || !subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) || !subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate())) continue;
                subDocumentSellEntity = (ProsubDocumentSellEntity)((Object)BeanMapper.map((Object)subDocumentSellVO, ProsubDocumentSellEntity.class));
                subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                subDocumentSellEntityArrayList.add(subDocumentSellEntity);
            }
        }
        this.subDocumentSellService.saveBatch(subDocumentSellEntityArrayList);
        if (documentSupplierId != null) {
            this.logger.info("\u5220\u9664\u4f9b\u5e94\u5546[{}]\u9644\u4ef6\u4fe1\u606f\uff0cbillType[{}]\uff0csourceType[supplierFileType]", (Object)documentSupplierId, (Object)BILL_SUPPLIER_TYPE);
            CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List attachmentVOList = (List)attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOList)) {
                this.logger.info("\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u4fe1\u606f-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse deleteResponse = this.attachmentApi.delete(ids);
                this.logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}", deleteResponse.getData());
            }
        }
        List pzList = pushVO.getSupplyFileList();
        this.logger.info("\u62a5\u540d\u6587\u4ef6:{}", (Object)JSONObject.toJSONString((Object)pzList));
        if (CollectionUtils.isNotEmpty((Collection)pzList)) {
            ArrayList<AttachmentVO> list = new ArrayList<AttachmentVO>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            }
            CommonResponse stringCommonResponse = this.attachmentApi.insertBatch(list);
            this.logger.info(request + "\u62a5\u540d\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId, Long inviteId) {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String datawj = (String)zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject((String)datawj);
        Map wjMap = (Map)JSONObject.parseObject((String)wListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        wjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceId", Long.toString(inviteId));
        HashMap headers = new HashMap();
        HashMap files = new HashMap();
        files.put("file", streamMap);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.addFileUrl, params, files, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u4ef6\u6279\u91cf\u4fee\u6539\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", sourceId);
        map.put("fileNames", fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.delFileUrl, RequestMethod.POST, stringInfo, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u52a0\u6279\u91cf\u5220\u9664\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return "\u540c\u6b65\u6210\u529f";
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)super.selectById((Serializable)documentId));
        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSchemeEntity subDocumentSchemeEntity = (ProsubDocumentSchemeEntity)((Object)this.subDocumentSchemeService.selectById(schemeId));
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = (ProsubDocumentSupplierEntity)((Object)this.subDocumentSupplierService.selectById(subDocumentSchemeEntity.getDocumentSupplierId()));
        Long supplierDetailId = subDocumentSupplierEntity.getId();
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setSupplierName(subDocumentSupplierEntity.getSupplierName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        subDocumentSupplierSellVO.setPurchaseType(subDocumentEntity.getPurchaseType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List subDocumentSchemeEntityList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
        List subDocumentSchemeVOList = BeanMapper.mapList((Iterable)subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subDocumentSupplierEntity.getDocumentId());
        List subDocumentSellEntityList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOList = BeanMapper.mapList((Iterable)subDocumentSellEntityList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
        for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList) {
            List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
            if (CollectionUtils.isNotEmpty(subDocumentSellVOS)) {
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    ProsubInviteDetailEntity subInviteDetailEntity = (ProsubInviteDetailEntity)((Object)this.subInviteDetailService.selectById(subDocumentSellVO.getDetailId()));
                    subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                    subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                }
            }
            subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
        }
        subDocumentSupplierSellVO.setSubDocumentSchemeList(subDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return subDocumentSupplierSellVO;
    }

    @Override
    public ProsubDocumentVO saveOrUpdate(ProsubDocumentVO saveorUpdateVO) {
        ProsubDocumentEntity entity = (ProsubDocumentEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProsubDocumentEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ProsubDocumentVO vo = (ProsubDocumentVO)BeanMapper.map((Object)((Object)entity), ProsubDocumentVO.class);
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(entity.getInviteId()));
        List subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getSubDetailRecord(), ProsubInviteDetailRecordVO.class);
        vo.setSubDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }

    @Override
    public ProsubDocumentVO queryDocDetail(Long id, Integer talkNum) {
        ProsubDocumentEntity entity = (ProsubDocumentEntity)((Object)super.selectById((Serializable)id));
        ProsubDocumentVO subDocumentVO = (ProsubDocumentVO)BeanMapper.map((Object)((Object)entity), ProsubDocumentVO.class);
        subDocumentVO.setSubDocumentSchemeList(null);
        subDocumentVO.setSubDocumentSellList(null);
        if (subDocumentVO.getNoticeId() != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ProsubNoticeSupplierEntity::getNoticeId, (Object)entity.getNoticeId());
            wrapper.ne(ProsubNoticeSupplierEntity::getState, (Object)1);
            List list = this.subNoticeSupplierService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List noticeSupplierVOS = BeanMapper.mapList((Iterable)list, ProsubNoticeSupplierVO.class);
                Map<Object, Object> documentSupplierVOMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)subDocumentVO.getSubDocumentSupplierList())) {
                    documentSupplierVOMap = subDocumentVO.getSubDocumentSupplierList().stream().filter(t -> t.getSupplierId() != null).collect(Collectors.toMap(ProsubDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (ProsubNoticeSupplierVO noticeSupplier : noticeSupplierVOS) {
                    if (documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())) {
                        noticeSupplier.setDocumentType(Integer.valueOf(0));
                        continue;
                    }
                    noticeSupplier.setDocumentType(Integer.valueOf(1));
                }
                subDocumentVO.setSubDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)id);
        lambda.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)supplierList)) {
            List subDocumentSupplierVOS = BeanMapper.mapList((Iterable)supplierList, ProsubDocumentSupplierVO.class);
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, (Object)id);
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, (Object)talkNum);
            lambdaScheme.orderByAsc(ProsubDocumentSchemeEntity::getSchemeName);
            List schemeList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
            Map<Long, List<ProsubDocumentSchemeEntity>> schemeMap = schemeList.stream().collect(Collectors.groupingBy(ProsubDocumentSchemeEntity::getDocumentSupplierId));
            if (entity.getBidFlag() == 0) {
                for (ProsubDocumentSupplierVO subDocumentSupplierEntity : subDocumentSupplierVOS) {
                    List<ProsubDocumentSchemeEntity> subDocumentSchemeEntities = schemeMap.get(subDocumentSupplierEntity.getId());
                    String schemeMoney = "";
                    for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : subDocumentSchemeEntities) {
                        schemeMoney = schemeMoney + subDocumentSchemeEntity.getSchemeName() + ":" + subDocumentSchemeEntity.getMoneyTax().setScale(2, 5) + "\u5143;";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    subDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }
                if (CollectionUtils.isNotEmpty((Collection)subDocumentSupplierVOS)) {
                    List data;
                    List attachIds = subDocumentSupplierVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
                    HashMap map = new HashMap();
                    map.put("sourceIds", attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
                    CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                        Map attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (key1, key2) -> key2));
                        for (ProsubDocumentSupplierVO subDocumentSupplierVO : subDocumentSupplierVOS) {
                            AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(subDocumentSupplierVO.getId());
                            if (attachmentVO == null) continue;
                            subDocumentSupplierVO.setAttachId(attachmentVO.getId());
                            subDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                        }
                    }
                }
            }
            subDocumentVO.setSubDocumentSupplierList(subDocumentSupplierVOS);
            subDocumentVO.setSubDocumentSupplierSchemeList(subDocumentSupplierVOS);
            List subDocumentDetailList = subDocumentVO.getSubDocumentDetailList();
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)id);
            lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, (Object)talkNum);
            lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSchemeName);
            List sellList = this.subDocumentSellService.list((Wrapper)lambdaSell);
            if (CollectionUtils.isNotEmpty((Collection)sellList)) {
                List subDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, ProsubDocumentSellVO.class);
                for (Object subDocumentSellVO : subDocumentSellVOS) {
                    if (entity.getBidFlag() == 1) {
                        subDocumentSellVO.setPrice(null);
                        subDocumentSellVO.setPriceTax(null);
                        subDocumentSellVO.setMoney(null);
                        subDocumentSellVO.setMoneyTax(null);
                        subDocumentSellVO.setSellTax(null);
                        subDocumentSellVO.setTenderNum(null);
                        subDocumentSellVO.setTenderMoney(null);
                        subDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() != 0) continue;
                    subDocumentSellVO.setTenderNum(null);
                    subDocumentSellVO.setTenderMoney(null);
                    subDocumentSellVO.setTenderFlag(null);
                }
                Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getDetailId));
                for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList) {
                    ArrayList documentSupplierVOS = new ArrayList();
                    List<ProsubDocumentSellVO> subDocumentSellEntities = sellMap.get(subDocumentDetailVO.getId());
                    Map<Long, List<ProsubDocumentSellVO>> sellDetailMap = subDocumentSellEntities.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key, value) -> {
                        ProsubDocumentSupplierVO subDocumentSupplierVO = new ProsubDocumentSupplierVO();
                        subDocumentSupplierVO.setSupplierId(key);
                        ProsubDocumentSellVO subDocumentSellVO = (ProsubDocumentSellVO)value.stream().findFirst().get();
                        subDocumentSupplierVO.setSupplierName(subDocumentSellVO.getSupplierName());
                        subDocumentSupplierVO.setProsubDocumentSellVOList(value);
                        documentSupplierVOS.add(subDocumentSupplierVO);
                    });
                    subDocumentDetailVO.setProsubDocumentSupplierVOList(documentSupplierVOS);
                }
                List subDocumentDetailSellList = subDocumentVO.getSubDocumentDetailList();
                subDocumentVO.setSubDocumentDetailSellList(subDocumentDetailSellList);
            }
        }
        ProsubInviteVO subInviteVO = this.subInviteService.queryDetailTree(entity.getInviteId());
        List subDetailRecord = subInviteVO.getSubDetailRecord();
        subDocumentVO.setSubDetailRecord(subDetailRecord);
        subDocumentVO.setSubDetailRecord(subDetailRecord);
        return subDocumentVO;
    }

    @Override
    public List<ProsubDocumentSellVO> getSchemeDetail(ProsubDocumentSellVO subDocumentSellVO) {
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getSupplierId, (Object)subDocumentSellVO.getSupplierId());
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subDocumentSellVO.getDocumentId());
        lambdaSell.eq(ProsubDocumentSellEntity::getSchemeId, (Object)subDocumentSellVO.getSchemeId());
        List list = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOList = BeanMapper.mapList((Iterable)list, ProsubDocumentSellVO.class);
        return subDocumentSellVOList;
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)super.selectById((Serializable)documentId));
        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = (ProsubDocumentSupplierEntity)((Object)this.subDocumentSupplierService.selectById(supplierDetailId));
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setSupplierId(subDocumentSupplierEntity.getSupplierId());
        subDocumentSupplierSellVO.setSupplierName(subDocumentSupplierEntity.getSupplierName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        subDocumentSupplierSellVO.setPurchaseType(subDocumentEntity.getPurchaseType());
        subDocumentSupplierSellVO.setValueType(subDocumentEntity.getValueType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List subDocumentSchemeEntityList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
        List subDocumentSchemeVOList = BeanMapper.mapList((Iterable)subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subDocumentSupplierEntity.getDocumentId());
        List subDocumentSellEntityList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOList = BeanMapper.mapList((Iterable)subDocumentSellEntityList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
        for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList) {
            List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
            if (CollectionUtils.isNotEmpty(subDocumentSellVOS)) {
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    ProsubInviteDetailEntity subInviteDetailEntity = (ProsubInviteDetailEntity)((Object)this.subInviteDetailService.selectById(subDocumentSellVO.getDetailId()));
                    subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                    subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                }
            }
            subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
        }
        subDocumentSupplierSellVO.setSubDocumentSchemeList(subDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return subDocumentSupplierSellVO;
    }

    @Override
    @Transactional
    public ProsubDocumentVO extendDocument(ProsubDocumentRecordVO subDocumentRecordVO) {
        ProsubDocumentRecordEntity subDocumentRecordEntity = (ProsubDocumentRecordEntity)((Object)BeanMapper.map((Object)subDocumentRecordVO, ProsubDocumentRecordEntity.class));
        this.subDocumentRecordService.save((Object)subDocumentRecordEntity);
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)super.selectById((Serializable)subDocumentRecordVO.getDocumentId()));
        subDocumentEntity.setOfferEndTime(subDocumentRecordVO.getNewTime());
        boolean b = super.updateById((Object)subDocumentEntity);
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(subDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(subDocumentRecordVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        ProsubDocumentVO subDocumentVO = this.queryDetail(subDocumentRecordVO.getDocumentId());
        return subDocumentVO;
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {
        ProsubTalkEntity subTalkEntity = (ProsubTalkEntity)((Object)this.subTalkService.selectById(talkId));
        Integer talkNum = subTalkEntity.getTalkNum();
        if (subTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        ArrayList<ProsubTalkVO> talkVOArrayList = new ArrayList<ProsubTalkVO>();
        String name = null;
        for (int a = 0; a <= talkNum; ++a) {
            ProsubTalkVO subTalkVO = new ProsubTalkVO();
            subTalkVO.setTalkNum(Integer.valueOf(a));
            name = a == 0 ? "\u9996\u6b21\u62a5\u4ef7" : "\u7b2c" + a + "\u8f6e\u62a5\u4ef7";
            subTalkVO.setTalkNumName(name);
            talkVOArrayList.add(subTalkVO);
        }
        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = (ProsubDocumentSupplierEntity)((Object)this.subDocumentSupplierService.selectById(supplierDetailId));
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        subDocumentSupplierSellVO.setSupplierName(subDocumentSupplierEntity.getSupplierName());
        for (ProsubTalkVO subTalkVO : talkVOArrayList) {
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, (Object)subDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getSupplierId, (Object)subDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, (Object)subTalkVO.getTalkNum());
            List subDocumentSchemeEntityList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
            if (CollectionUtils.isEmpty((Collection)subDocumentSchemeEntityList)) continue;
            List subDocumentSchemeVOList = BeanMapper.mapList((Iterable)subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);
            List schemePkList = subDocumentSchemeVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.in(ProsubDocumentSellEntity::getSchemeId, schemePkList);
            List subDocumentSellEntityList = this.subDocumentSellService.list((Wrapper)lambdaSell);
            List subDocumentSellVOList = BeanMapper.mapList((Iterable)subDocumentSellEntityList, ProsubDocumentSellVO.class);
            Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
            for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList) {
                List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
                if (CollectionUtils.isNotEmpty(subDocumentSellVOS)) {
                    for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                        ProsubInviteDetailEntity subInviteDetailEntity = (ProsubInviteDetailEntity)((Object)this.subInviteDetailService.selectById(subDocumentSellVO.getDetailId()));
                        subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                        subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                    }
                }
                subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
            }
            subTalkVO.setSubDocumentSchemeList(subDocumentSchemeVOList);
        }
        subDocumentSupplierSellVO.setProsubTalkVOList(talkVOArrayList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return subDocumentSupplierSellVO;
    }

    private Map<String, Object> getFileInfo(Long sourceId) {
        AttachmentVO attachmentVO;
        List data;
        HashMap<String, Object> map = new HashMap<String, Object>();
        CommonResponse attachResponse = this.attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)attachResponse.getData())) && (attachmentVO = (AttachmentVO)data.stream().findFirst().get()) != null) {
            map.put("fileName", attachmentVO.getFileName());
            map.put("attachId", attachmentVO.getId());
        }
        return map;
    }

    @Override
    public ProsubDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)super.selectById((Serializable)id));
        subDocumentEntity.setPublishFlag(0);
        super.updateById((Object)subDocumentEntity);
        ProsubNoticeSupplierTbVO subNoticeSupplierTbVO = new ProsubNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        subNoticeSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        subNoticeSupplierTbVO.setSourceId(subDocumentEntity.getInviteId().toString());
        ProsubInviteEntity inviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        if (subDocumentEntity.getTenderType() == 2) {
            subNoticeSupplierTbVO.setNoticeType(Integer.valueOf(2));
        } else {
            subNoticeSupplierTbVO.setNoticeType(Integer.valueOf(3));
        }
        if (subDocumentEntity.getPurchaseType() == 1) {
            subNoticeSupplierTbVO.setSourceProjectId(null);
            subNoticeSupplierTbVO.setProjectName(null);
            subNoticeSupplierTbVO.setProjectCode(null);
        } else {
            subNoticeSupplierTbVO.setSourceProjectId(subDocumentEntity.getProjectId().toString());
            subNoticeSupplierTbVO.setProjectName(subDocumentEntity.getProjectName());
            subNoticeSupplierTbVO.setProjectCode(subDocumentEntity.getProjectCode());
        }
        subNoticeSupplierTbVO.setSourceOrgId(subDocumentEntity.getOrgId().toString());
        subNoticeSupplierTbVO.setOrgName(subDocumentEntity.getOrgName());
        subNoticeSupplierTbVO.setSourceUnitId(subDocumentEntity.getUnitId().toString());
        subNoticeSupplierTbVO.setUnitName(subDocumentEntity.getUnitName());
        subNoticeSupplierTbVO.setMemo(subDocumentEntity.getMemo());
        subNoticeSupplierTbVO.setType("SUB");
        subNoticeSupplierTbVO.setTenderName(subDocumentEntity.getDocumentName());
        subNoticeSupplierTbVO.setTenderType(subDocumentEntity.getTenderType());
        subNoticeSupplierTbVO.setPurchaseType(subDocumentEntity.getPurchaseType().toString());
        subNoticeSupplierTbVO.setPurchaseName(subDocumentEntity.getPurchaseName());
        subNoticeSupplierTbVO.setSourceEmployeeId(subDocumentEntity.getEmployeeId().toString());
        subNoticeSupplierTbVO.setEmployeeName(subDocumentEntity.getEmployeeName());
        subNoticeSupplierTbVO.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        subNoticeSupplierTbVO.setValueType(subDocumentEntity.getValueType());
        subNoticeSupplierTbVO.setContent(subDocumentEntity.getDocumentContent());
        subNoticeSupplierTbVO.setOfferStartTime(sdf.format(subDocumentEntity.getOfferStartTime()));
        subNoticeSupplierTbVO.setOfferEndTime(sdf.format(subDocumentEntity.getOfferEndTime()));
        subNoticeSupplierTbVO.setBrandFlag(subDocumentEntity.getBrandFlag());
        subNoticeSupplierTbVO.setProjectLinkName(subDocumentEntity.getProjectLinkName());
        subNoticeSupplierTbVO.setProjectLinkPhone(subDocumentEntity.getProjectLinkPhone());
        subNoticeSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        subNoticeSupplierTbVO.setSubType(inviteEntity.getSubType());
        subNoticeSupplierTbVO.setProjectQualification(inviteEntity.getProjectQualification());
        subNoticeSupplierTbVO.setPaymentId(inviteEntity.getPaymentId());
        subNoticeSupplierTbVO.setPaymentName(inviteEntity.getPaymentName());
        subNoticeSupplierTbVO.setPayScale(inviteEntity.getPayScale());
        subNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        subNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        subNoticeSupplierTbVO.setSubDescribe(subDocumentEntity.getSubDescribe());
        subNoticeSupplierTbVO.setSettlementClause(inviteEntity.getSettlementClause());
        ArrayList<Object> subNoticeDetailVOS = new ArrayList<Object>();
        List<ProsubInviteDetailVO> subInviteDetailVOS = ((ProsubDocumentMapper)this.baseMapper).selectSumDetail(subDocumentEntity.getInviteId());
        for (ProsubInviteDetailVO subDocumentDetailEntity : subInviteDetailVOS) {
            ProsubNoticeDetailTbVO subNoticeDetailTbVO = new ProsubNoticeDetailTbVO();
            BeanUtils.copyProperties((Object)subNoticeDetailTbVO, (Object)subDocumentDetailEntity);
            subNoticeDetailTbVO.setSourceId(subDocumentEntity.getInviteId().toString());
            subNoticeDetailTbVO.setSourceDetailId(subDocumentDetailEntity.getId().toString());
            subNoticeDetailTbVO.setRate(subDocumentDetailEntity.getTaxRate());
            subNoticeDetailTbVO.setMemo(subDocumentDetailEntity.getSumMemo());
            subNoticeDetailTbVO.setNum(subDocumentDetailEntity.getSumNum());
            subNoticeDetailTbVO.setMny(subDocumentDetailEntity.getSumMoney());
            subNoticeDetailTbVO.setTaxMny(subDocumentDetailEntity.getSumMoneyTax());
            subNoticeDetailVOS.add(subNoticeDetailTbVO);
        }
        subNoticeSupplierTbVO.setSubDetailList(subNoticeDetailVOS);
        if (subDocumentEntity.getTenderType() != 2) {
            List detailEntityList = this.supplierDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProsubDocumentSupplierDetailEntity::getInviteId, (Object)subDocumentEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
            ArrayList<ProsubNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<ProsubNoticeSupplierDetailTbVO>();
            for (ProsubDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                ProsubNoticeSupplierDetailTbVO subNoticeSupplierDetailTbVO = new ProsubNoticeSupplierDetailTbVO();
                subNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                subNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                subNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(subNoticeSupplierDetailTbVO);
            }
            subNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString((Object)subNoticeSupplierTbVO);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public CommonResponse delSupplier(Long id) {
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)((ProsubDocumentMapper)this.baseMapper).selectById(id));
        List subDocumentSupplierList = this.supplierMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)subDocumentEntity.getId())).eq((Object)"dr", (Object)0));
        List supplierDetailList = this.supplierDetailMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"invite_id", (Object)subDocumentEntity.getInviteId())).eq((Object)"dr", (Object)0));
        ArrayList oldIds = new ArrayList();
        ArrayList newIds = new ArrayList();
        subDocumentSupplierList.stream().forEach(it -> oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it -> newIds.add(it.getSupplierId()));
        List newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        ArrayList<ProsubNoticeSupplierDetailTbVO> signVOList = new ArrayList<ProsubNoticeSupplierDetailTbVO>();
        for (ProsubDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            ProsubNoticeSupplierDetailTbVO subNoticeSupplierDetailTbVO = new ProsubNoticeSupplierDetailTbVO();
            subNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            subNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            subNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
            subNoticeSupplierDetailTbVO.setOutReason("\u8d85\u65f6\u672a\u62a5\u4ef7");
            signVOList.add(subNoticeSupplierDetailTbVO);
        }
        this.logger.info("\u5254\u9664\u7684\u4f9b\u5e94\u5546" + JSON.toJSONString(signVOList));
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5254\u9664\u4f9b\u5e94\u5546\u6210\u529f");
    }

    @Override
    public ProsubDocumentVO saveManyDocument(Long id) {
        ProsubDocumentEntity subDocumentEntity = new ProsubDocumentEntity();
        ProsubInviteEntity inviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(id));
        subDocumentEntity.setInviteId(inviteEntity.getId());
        subDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType() == 0) {
            subDocumentEntity.setProjectId(inviteEntity.getProjectId());
            subDocumentEntity.setProjectName(inviteEntity.getProjectName());
            subDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        subDocumentEntity.setSubType(inviteEntity.getSubType());
        subDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        subDocumentEntity.setOrgId(inviteEntity.getOrgId());
        subDocumentEntity.setOrgName(inviteEntity.getOrgName());
        subDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        subDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        subDocumentEntity.setValueType(inviteEntity.getValueType());
        subDocumentEntity.setUnitId(inviteEntity.getUnitId());
        subDocumentEntity.setUnitName(inviteEntity.getUnitName());
        subDocumentEntity.setTenderType(inviteEntity.getTenderType());
        subDocumentEntity.setSubDescribe(inviteEntity.getSubDescribe());
        subDocumentEntity.setSettlementClause(inviteEntity.getSettlementClause());
        subDocumentEntity.setBidFlag(1);
        subDocumentEntity.setPublishFlag(1);
        subDocumentEntity.setNextFlag(1);
        List<ProsubInviteDetailEntity> subInviteDetailList = inviteEntity.getSubDetail();
        List subDocumentDetailList = BeanMapper.mapList(subInviteDetailList, ProsubDocumentDetailEntity.class);
        Map detailInviteMap = subInviteDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (ProsubDocumentDetailEntity subDocumentDetailEntity : subDocumentDetailList) {
            ProsubInviteDetailEntity subInviteDetailEntity = (ProsubInviteDetailEntity)((Object)detailInviteMap.get(subDocumentDetailEntity.getId()));
            subDocumentDetailEntity.setMaterialName(subInviteDetailEntity.getDetailName());
            subDocumentDetailEntity.setMaterialCode(subInviteDetailEntity.getDetailCode());
            subDocumentDetailEntity.setMaterialId(subInviteDetailEntity.getDocId());
            subDocumentDetailEntity.setMaterialTypeId(subInviteDetailEntity.getDocCategoryId());
            subDocumentDetailEntity.setRate(subInviteDetailEntity.getTaxRate());
        }
        subDocumentEntity.setSubDocumentDetailList(subDocumentDetailList);
        List<ProsubInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List subDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, ProsubDocumentSupplierDetailEntity.class);
        for (ProsubDocumentSupplierDetailEntity subDocumentSupplierDetailVO : subDocumentSupplierDetailVOS) {
            subDocumentSupplierDetailVO.setId(null);
            this.documentSupplierDetailService.saveOrUpdate((Object)subDocumentSupplierDetailVO);
        }
        this.service.saveOrUpdate((Object)subDocumentEntity, false);
        ProcessEntity processEntity = new ProcessEntity();
        switch (inviteEntity.getTenderType()) {
            case 3: {
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("\u7ade\u4e89\u6027\u8c08\u5224");
                break;
            }
            case 4: {
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("\u5355\u4e00\u6765\u6e90");
                break;
            }
            case 5: {
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("\u7d27\u6025\u62db\u6807");
                break;
            }
            case 2: {
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("\u8be2\u4ef7\u516c\u544a");
            }
        }
        this.subInviteService.updateById((Object)inviteEntity);
        processEntity.setBillId(subDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/fourJzDyJjXj");
        this.processService.saveOrUpdate((Object)processEntity);
        ProsubDocumentVO vo = (ProsubDocumentVO)BeanMapper.map((Object)((Object)subDocumentEntity), ProsubDocumentVO.class);
        return vo;
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        ProsubTalkRecordEntity subTalkRecordEntity = (ProsubTalkRecordEntity)((Object)this.subTalkRecordService.selectById(talkId));
        Integer talkNum = subTalkRecordEntity.getTalkNum();
        if (subTalkRecordEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = (ProsubDocumentSupplierEntity)((Object)this.subDocumentSupplierService.selectById(supplierDetailId));
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List subDocumentSchemeEntityList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
        List subDocumentSchemeVOList = BeanMapper.mapList((Iterable)subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, (Object)talkNum);
        List subDocumentSellEntityList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOList = BeanMapper.mapList((Iterable)subDocumentSellEntityList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
        for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList) {
            List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
            if (CollectionUtils.isNotEmpty(subDocumentSellVOS)) {
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    ProsubInviteDetailEntity subInviteDetailEntity = (ProsubInviteDetailEntity)((Object)this.subInviteDetailService.selectById(subDocumentSellVO.getDetailId()));
                    subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                    subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                }
            }
            subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
        }
        subDocumentSupplierSellVO.setSubDocumentSchemeList(subDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return subDocumentSupplierSellVO;
    }

    @Override
    public ProsubDocumentVO saveDocument(Long noticeId) {
        ProsubDocumentEntity entity = new ProsubDocumentEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProsubNoticeEntity subNoticeEntity = (ProsubNoticeEntity)((Object)this.subNoticeService.selectById(noticeId));
        ProsubInviteEntity subInvite = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subNoticeEntity.getInviteId()));
        List<ProsubInviteDetailEntity> subInviteDetailList = subInvite.getSubDetail();
        List subDocumentDetailList = BeanMapper.mapList(subInviteDetailList, ProsubDocumentDetailEntity.class);
        Map detailInviteMap = subInviteDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (ProsubDocumentDetailEntity subDocumentDetailEntity : subDocumentDetailList) {
            ProsubInviteDetailEntity subInviteDetailEntity = (ProsubInviteDetailEntity)((Object)detailInviteMap.get(subDocumentDetailEntity.getId()));
            subDocumentDetailEntity.setMaterialName(subInviteDetailEntity.getDetailName());
            subDocumentDetailEntity.setMaterialCode(subInviteDetailEntity.getDetailCode());
            subDocumentDetailEntity.setMaterialId(subInviteDetailEntity.getDocId());
            subDocumentDetailEntity.setMaterialTypeId(subInviteDetailEntity.getDocCategoryId());
            subDocumentDetailEntity.setRate(subInviteDetailEntity.getTaxRate());
        }
        entity.setSubDocumentDetailList(subDocumentDetailList);
        entity.setProjectId(subNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(subNoticeEntity.getProjectName());
        entity.setOrgId(subNoticeEntity.getOrgId());
        entity.setOrgName(subNoticeEntity.getOrgName());
        entity.setParentOrgId(subNoticeEntity.getParentOrgId());
        entity.setParentOrgName(subNoticeEntity.getParentOrgName());
        entity.setProjectCode(subNoticeEntity.getProjectCode());
        entity.setDocumentName(subNoticeEntity.getNoticeName());
        entity.setEmployeeId(subNoticeEntity.getEmployeeId());
        entity.setEmployeeName(subNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(subNoticeEntity.getEmployeeMobile());
        entity.setInviteId(subNoticeEntity.getInviteId());
        entity.setPurchaseType(subNoticeEntity.getPurchaseType());
        entity.setTenderType(subNoticeEntity.getTenderType());
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subNoticeEntity.getInviteId()));
        entity.setValueType(subInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSubType(subInviteEntity.getSubType());
        this.service.saveOrUpdate((Object)entity, false);
        subInviteEntity.setTenderStage(3);
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u62db\u6807\u6587\u4ef6");
        processEntity.setTenderId(subNoticeEntity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/document");
        this.processService.saveOrUpdate((Object)processEntity);
        ProsubDocumentVO vo = (ProsubDocumentVO)BeanMapper.map((Object)((Object)entity), ProsubDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        List expertEntityList = this.documentExpertService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProsubDocumentExpertEntity::getDocumentId, (Object)documentId)).eq(BaseEntity::getDr, (Object)0));
        int totalNum = expertEntityList.size();
        if (totalNum < 3) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u81f3\u5c11\u4e3a3\u4eba\uff01", (Object)false);
        }
        if (totalNum % 2 == 0) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u5fc5\u987b\u4e3a\u5355\u6570\uff01", (Object)false);
        }
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "\u96c6\u56e2".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "\u9879\u76ee".equals(entity.getExpertFromName())).count();
        int trueDepartmentExpertNum = (int)Math.ceil((double)totalNum * 1.0 / 3.0);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if (departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum) {
            return CommonResponse.error((String)("\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u96c6\u56e2\u4e13\u5bb6" + trueDepartmentExpertNum + "\u4e2a,\u9879\u76ee\u4e13\u5bb6" + trueProjectExpertNum + "\u4e2a\uff01"), (Object)false);
        }
        return CommonResponse.success((String)"\u4e13\u5bb6\u9009\u53d6\u6210\u529f\uff01", (Object)true);
    }
}

