/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.api.IBatchPlanApi;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageRefsupplierEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteDetailService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageRefsupplierService;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailBidderVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rmatInvite")
public class RmatInviteBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRmatInviteService service;
    @Autowired
    private IRmatInviteDetailService detailService;
    @Autowired
    private IRmatPicketageRefsupplierService picketageRefsupplierService;
    @Autowired
    private IBatchPlanApi batPlanApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state || BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
            RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.service.selectById(billId));
            List<Object> detailVOList = new ArrayList();
            detailVOList = inviteEntity.getPurchaseType() == 0 ? this.service.selectSumDetail(billId) : this.service.selectOrgSumDetail(billId);
            for (RmatInviteDetailVO rmatInviteDetailVO : detailVOList) {
                rmatInviteDetailVO.setNum(rmatInviteDetailVO.getSumNum());
                rmatInviteDetailVO.setMoney(rmatInviteDetailVO.getSumMoney());
                rmatInviteDetailVO.setMoneyTax(rmatInviteDetailVO.getSumMoneyTax());
                rmatInviteDetailVO.setPlanNum(rmatInviteDetailVO.getSumPlanNum());
                this.detailService.saveOrUpdate(BeanMapper.map((Object)rmatInviteDetailVO, RmatInviteDetailEntity.class));
            }
            if (inviteEntity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(inviteEntity.getRmatDetailRecord())) {
                List planIdList = inviteEntity.getRmatDetailRecord().stream().map(RmatInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
                this.service.updateApiState(inviteEntity, BatchPlanEnum.PLAN_STATE_OVER.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_OVER.getPlanState());
            }
            String tenderUnitNum = new String();
            List<RmatInviteDetailBidderVO> list = this.service.selectDetailBidder(billId);
            for (RmatInviteDetailBidderVO detailBidderVO : list) {
                RmatPicketageRefsupplierEntity rmatPicketageRefsupplierEntity = new RmatPicketageRefsupplierEntity();
                rmatPicketageRefsupplierEntity.setPicketageId(billId);
                rmatPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
                rmatPicketageRefsupplierEntity.setPicketageDate(new Date());
                rmatPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
                rmatPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
                rmatPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
                rmatPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
                rmatPicketageRefsupplierEntity.setProjectId(detailBidderVO.getDetailProjectId());
                rmatPicketageRefsupplierEntity.setProjectName(detailBidderVO.getDetailProjectName());
                if (inviteEntity.getPurchaseType() == 0) {
                    JSONArray data;
                    List projectRegisterVOS;
                    ProjectPoolSetVO projectPoolSetVO;
                    Map<Object, Object> proMap = new HashMap();
                    CommonResponse jsonArrayCommonResponse = this.projectPoolApi.queryProjectByIds(Collections.singletonList(detailBidderVO.getDetailProjectId()));
                    if (jsonArrayCommonResponse.isSuccess() && (projectPoolSetVO = (ProjectPoolSetVO)(proMap = (projectRegisterVOS = (data = (JSONArray)jsonArrayCommonResponse.getData()).toJavaList(ProjectPoolSetVO.class)).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()))).get(detailBidderVO.getDetailProjectId())) != null) {
                        rmatPicketageRefsupplierEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
                        rmatPicketageRefsupplierEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
                    }
                } else {
                    rmatPicketageRefsupplierEntity.setOrgId(detailBidderVO.getDetailOrgId());
                    rmatPicketageRefsupplierEntity.setOrgName(detailBidderVO.getDetailOrgName());
                }
                rmatPicketageRefsupplierEntity.setOccupyFlag(0);
                rmatPicketageRefsupplierEntity.setPicketageFlag(1);
                rmatPicketageRefsupplierEntity.setRentType(inviteEntity.getRentType());
                rmatPicketageRefsupplierEntity.setSignStatus(0);
                rmatPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
                this.picketageRefsupplierService.saveOrUpdate((Object)rmatPicketageRefsupplierEntity);
                BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4, 4);
                tenderUnitNum = tenderUnitNum + detailBidderVO.getSupplierName() + "(" + sumNum + "),";
            }
            if (tenderUnitNum.length() > 1) {
                tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
            }
            inviteEntity.setTenderUnitNum(tenderUnitNum);
            this.service.saveOrUpdate((Object)inviteEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.service.selectById(billId));
        if (inviteEntity.getOccupyState() != null && inviteEntity.getOccupyState() == 1) {
            return CommonResponse.error((String)"\u62db\u6807\u5df2\u88ab\u5360\u7528,\u4e0d\u80fd\u64a4\u56de!");
        }
        if (inviteEntity.getTenderStage() > 1) {
            return CommonResponse.error((String)("\u62db\u6807\u5904\u4e8e" + TenderStageEnum.getEnumByStateCode((Integer)inviteEntity.getTenderStage()).getDescription() + ",\u4e0d\u80fd\u64a4\u56de!"));
        }
        if (inviteEntity.getEstablishType() == 1) {
            QueryWrapper refWrapper = new QueryWrapper();
            refWrapper.eq((Object)"picketage_id", (Object)inviteEntity.getId());
            List refsupplierEntityList = this.picketageRefsupplierService.list((Wrapper)refWrapper);
            for (RmatPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
                if (refsupplierEntity.getSignStatus() == 0) continue;
                return CommonResponse.error((String)"\u5b58\u5728\u5df2\u7b7e\u8ba2\u5408\u540c,\u4e0d\u80fd\u64a4\u56de!");
            }
            this.picketageRefsupplierService.remove((Wrapper)refWrapper);
        }
        this.detailService.delByInviteId(inviteEntity.getId());
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.service.selectById(billId));
        if (inviteEntity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(inviteEntity.getRmatDetailRecord())) {
            List planIdList = inviteEntity.getRmatDetailRecord().stream().map(RmatInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
            this.service.updateApiState(inviteEntity, BatchPlanEnum.PLAN_STATE_EXEC.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_EXEC.getPlanState());
        }
        return CommonResponse.success();
    }
}

