/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSchemeEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSellEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkRecordDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkRecordEntity;
import com.ejianc.business.tender.rmat.mapper.RmatTalkMapper;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSchemeService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSellService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatTalkDetailService;
import com.ejianc.business.tender.rmat.service.IRmatTalkRecordDetailService;
import com.ejianc.business.tender.rmat.service.IRmatTalkRecordService;
import com.ejianc.business.tender.rmat.service.IRmatTalkService;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSupplierTbVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.vo.RmatQuotationMaterialVO;
import com.ejianc.business.tender.rmat.vo.RmatQuotationSchemeVO;
import com.ejianc.business.tender.rmat.vo.RmatQuotationSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatSupplierSellVO;
import com.ejianc.business.tender.rmat.vo.RmatTalkDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatTalkRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatTalkVO;
import com.ejianc.business.tender.rmat.vo.SupplierReplenishVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rmatTalkService")
public class RmatTalkServiceImpl
extends BaseServiceImpl<RmatTalkMapper, RmatTalkEntity>
implements IRmatTalkService {
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IRmatTalkDetailService rmatTalkDetailService;
    @Autowired
    private IRmatTalkRecordService rmatTalkRecordService;
    @Autowired
    private IRmatTalkRecordDetailService rmatTalkRecordDetailService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000005";
    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    @Transactional
    public RmatTalkVO publishTalk(Long id) {
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)super.selectById((Serializable)id));
        rmatTalkEntity.setPublishFlag(0);
        super.updateById((Object)rmatTalkEntity);
        RmatDocumentSupplierTbVO rmatDocumentSupplierTbVO = new RmatDocumentSupplierTbVO();
        rmatDocumentSupplierTbVO.setSourceId(rmatTalkEntity.getInviteId().toString());
        rmatDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6d3d\u5546\u8c08\u5224");
        rmatDocumentSupplierTbVO.setNoticeType(Integer.valueOf(4));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rmatTalkEntity.getTalkStartTime());
        rmatDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rmatTalkEntity.getTalkEndTime());
        rmatDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rmatDocumentSupplierTbVO.setMemo(rmatTalkEntity.getMemo());
        rmatDocumentSupplierTbVO.setTalkMoney(rmatTalkEntity.getTalkMoney());
        rmatDocumentSupplierTbVO.setTalkNum(rmatTalkEntity.getTalkNum());
        rmatDocumentSupplierTbVO.setTenderName(rmatTalkEntity.getTalkName());
        rmatDocumentSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString((Object)rmatDocumentSupplierTbVO);
        this.logger.info("\u6d3d\u5546\u8c08\u5224\u53d1\u5e03" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public RmatTalkVO extendTalk(RmatTalkDetailVO rmatTalkDetailVO) {
        RmatTalkDetailEntity rmatDocumentRecordEntity = (RmatTalkDetailEntity)((Object)BeanMapper.map((Object)rmatTalkDetailVO, RmatTalkDetailEntity.class));
        this.rmatTalkDetailService.save((Object)rmatDocumentRecordEntity);
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)super.selectById((Serializable)rmatTalkDetailVO.getTalkId()));
        rmatTalkEntity.setTalkEndTime(rmatTalkDetailVO.getNewTime());
        boolean b = super.updateById((Object)rmatTalkEntity);
        RmatSupplierSellVO supplierSellVO = new RmatSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rmatTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rmatTalkDetailVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(rmatTalkDetailVO.getTalkId());
    }

    @Override
    public RmatTalkVO saveTalk(Long documentId) {
        RmatTalkEntity entity = new RmatTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RmatDocumentEntity documentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.rmatDocumentService.saveOrUpdate((Object)documentEntity);
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(documentId));
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatDocumentEntity.getInviteId()));
        entity.setProjectCode(rmatDocumentEntity.getProjectCode());
        entity.setInviteId(rmatDocumentEntity.getInviteId());
        entity.setProjectId(rmatDocumentEntity.getProjectId());
        entity.setProjectName(rmatDocumentEntity.getProjectName());
        entity.setOrgId(rmatDocumentEntity.getOrgId());
        entity.setOrgName(rmatDocumentEntity.getOrgName());
        entity.setParentOrgId(rmatDocumentEntity.getParentOrgId());
        entity.setParentOrgName(rmatDocumentEntity.getParentOrgName());
        entity.setBrandFlag(rmatDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        entity.setTalkName(rmatInviteEntity.getTenderName());
        super.save((Object)entity);
        rmatInviteEntity.setTenderStage(7);
        this.rmatInviteService.updateById((Object)rmatInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(rmatDocumentEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("rmat/talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        RmatTalkVO vo = (RmatTalkVO)BeanMapper.map((Object)((Object)entity), RmatTalkVO.class);
        RmatTalkVO rmatTalkVO = this.queryDetail(vo.getId());
        return rmatTalkVO;
    }

    @Override
    public RmatTalkVO queryDetail(Long id) {
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)super.selectById((Serializable)id));
        RmatTalkVO rmatTalkVO = (RmatTalkVO)BeanMapper.map((Object)((Object)rmatTalkEntity), RmatTalkVO.class);
        Integer talkNum = rmatTalkEntity.getTalkNum();
        if (rmatTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        RmatDocumentVO rmatDocumentVO = this.rmatDocumentService.queryDocDetail(rmatTalkEntity.getBillId(), talkNum);
        rmatTalkVO.setRmatDocumentDetailSellList(rmatDocumentVO.getRmatDocumentDetailSellList());
        rmatTalkVO.setRmatDocumentSupplierSchemeList(rmatDocumentVO.getRmatDocumentSupplierSchemeList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)rmatTalkEntity.getBillId());
        lambda.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.rmatDocumentSupplierService.list((Wrapper)lambda);
        List documentSupplierVOList = BeanMapper.mapList((Iterable)supplierList, RmatDocumentSupplierVO.class);
        rmatTalkVO.setRmatDocumentSupplierList(documentSupplierVOList);
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(RmatTalkRecordEntity::getBillId, (Object)rmatTalkEntity.getBillId());
        lambdaRecord.orderByAsc(RmatTalkRecordEntity::getTalkNum);
        List rmatTalkRecordEntityList = this.rmatTalkRecordService.list((Wrapper)lambdaRecord);
        List rmatTalkRecordList = BeanMapper.mapList((Iterable)rmatTalkRecordEntityList, RmatTalkRecordVO.class);
        rmatTalkVO.setTalkRecordEntityList(rmatTalkRecordList);
        return rmatTalkVO;
    }

    @Override
    @Transactional
    public RmatTalkVO againSaveTalk(Long id) {
        RmatTalkEntity entity = new RmatTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(rmatTalkEntity.getProjectCode());
        entity.setProjectId(rmatTalkEntity.getProjectId());
        entity.setProjectName(rmatTalkEntity.getProjectName());
        entity.setOrgId(rmatTalkEntity.getOrgId());
        entity.setOrgName(rmatTalkEntity.getOrgName());
        entity.setParentOrgId(rmatTalkEntity.getParentOrgId());
        entity.setParentOrgName(rmatTalkEntity.getParentOrgName());
        entity.setBrandFlag(rmatTalkEntity.getBrandFlag());
        entity.setBillId(rmatTalkEntity.getBillId());
        entity.setInviteId(rmatTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(rmatTalkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(rmatTalkEntity.getPurchaseType());
        super.save((Object)entity);
        RmatTalkRecordEntity rmatTalkRecordEntity = (RmatTalkRecordEntity)((Object)BeanMapper.map((Object)((Object)rmatTalkEntity), RmatTalkRecordEntity.class));
        rmatTalkRecordEntity.setTalkId(rmatTalkEntity.getId());
        rmatTalkRecordEntity.setId(null);
        this.rmatTalkRecordService.save((Object)rmatTalkRecordEntity);
        List<RmatTalkDetailEntity> rmatTalkDetailList = rmatTalkEntity.getRmatTalkDetailList();
        List rmatTalkRecordDetailEntityList = BeanMapper.mapList(rmatTalkDetailList, RmatTalkRecordDetailEntity.class);
        for (RmatTalkRecordDetailEntity rmatTalkRecordDetailEntity : rmatTalkRecordDetailEntityList) {
            rmatTalkRecordDetailEntity.setId(null);
            rmatTalkRecordDetailEntity.setRecordId(rmatTalkRecordEntity.getId());
        }
        this.rmatTalkRecordDetailService.saveBatch(rmatTalkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)rmatTalkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        RmatTalkVO vo = (RmatTalkVO)BeanMapper.map((Object)((Object)entity), RmatTalkVO.class);
        this.addLastSell(rmatTalkEntity.getTalkNum(), rmatTalkEntity.getBillId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public RmatTalkVO replenishSell(Long id) {
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = rmatTalkEntity.getTalkNum();
        Long billId = rmatTalkEntity.getBillId();
        this.addLastSell(talkNum, billId);
        return new RmatTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = rmatTalkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)rmatTalkEntity.getBillId());
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.rmatDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)rmatTalkEntity.getBillId());
        lambdaSupplierFirst.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.rmatDocumentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        HashMap<String, Object> stringListMap = new HashMap<String, Object>();
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)((RmatTalkMapper)this.baseMapper).selectById(talkId));
        ArrayList<RmatQuotationMaterialVO> materialVOList = new ArrayList<RmatQuotationMaterialVO>();
        List<RmatDocumentSellEntity> rmatDocumentSellEntities = this.rmatDocumentSellService.selectMaterialType(rmatTalkEntity.getBillId());
        Integer talkNum = rmatDocumentSellEntities.get(0).getTalkNum();
        List sellEntityList = BeanMapper.mapList(rmatDocumentSellEntities, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getProjectId));
        for (List<RmatDocumentSellVO> sellVOS : collect.values()) {
            Map<Long, List<RmatDocumentSellVO>> listMap = sellVOS.stream().filter(map -> map.getMaterialId() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                RmatQuotationMaterialVO materialVO = new RmatQuotationMaterialVO();
                List<RmatDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (RmatDocumentSellVO sellVO : materialTypeList) {
                    materialVO = (RmatQuotationMaterialVO)BeanMapper.map((Object)sellVO, RmatQuotationMaterialVO.class);
                }
                List rmatQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, RmatQuotationSupplierVO.class);
                List supplierVOS = rmatQuotationSupplierVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RmatQuotationSupplierVO>(Comparator.comparing(RmatQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                Map<Long, List<RmatDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map -> map.getSupplierId() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getSupplierId));
                for (RmatQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    List<RmatDocumentSellVO> rmatDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOS) {
                        supplierVO.setSupplierName(rmatDocumentSellVO.getSupplierName());
                    }
                    List rmatQuotationSchemeVOS = BeanMapper.mapList(rmatDocumentSellVOS, RmatQuotationSchemeVO.class);
                    List schemeVOS = rmatQuotationSchemeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RmatQuotationSchemeVO>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<RmatDocumentSellVO>> schemeMap = rmatDocumentSellVOS.stream().filter(map -> map.getSchemeName() != null).collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeName));
                    for (RmatQuotationSchemeVO rmatQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<RmatDocumentSellVO> priceList = schemeMap.get(rmatQuotationSchemeVO.getSchemeName());
                        if (priceList.size() < talkNum + 1) {
                            RmatDocumentSellVO documentSellVO = new RmatDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1L));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0, documentSellVO);
                        }
                        rmatQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList", materialVOList);
        stringListMap.put("offerNum", rmatDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public RmatTalkVO saveOrUpdates(RmatTalkVO saveorUpdateVO) {
        RmatTalkEntity entity = (RmatTalkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RmatTalkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        RmatTalkVO vo = (RmatTalkVO)BeanMapper.map((Object)((Object)entity), RmatTalkVO.class);
        RmatTalkVO rmatTalkVO = this.queryDetail(vo.getId());
        return rmatTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.rmatDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.rmatDocumentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(RmatDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSuppliermatityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSuppliermatityNewList = BeanMapper.mapList(documentSuppliermatityDataList, RmatDocumentSupplierEntity.class);
        if (documentSuppliermatityNewList.size() == 0) {
            return;
        }
        ArrayList<SupplierReplenishVO> replenishVOArrayList = new ArrayList<SupplierReplenishVO>();
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(docId));
        for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(rmatDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(rmatDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        this.logger.info("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636e:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupOffer, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636eresponse:" + stringCommonResponse.getMsg());
        }
        List supplierPkNew = documentSuppliermatityNewList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList) {
            rmatDocumentSupplierEntity.setId(IdWorker.getId());
            rmatDocumentSupplierEntity.setTalkNum(talkNum);
        }
        this.rmatDocumentSupplierService.saveBatch(documentSuppliermatityNewList);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId, (Object)docId);
        lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaScheme.in(RmatDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List schemeList = this.rmatDocumentSchemeService.list((Wrapper)lambdaScheme);
        List schemePkList = schemeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : schemeList) {
            rmatDocumentSchemeEntity.setId(IdWorker.getId());
            rmatDocumentSchemeEntity.setTalkNum(talkNum);
            for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList) {
                if (!rmatDocumentSchemeEntity.getSupplierId().equals(rmatDocumentSupplierEntity.getSupplierId())) continue;
                rmatDocumentSchemeEntity.setDocumentSupplierId(rmatDocumentSupplierEntity.getId());
            }
        }
        this.rmatDocumentSchemeService.saveBatch(schemeList);
        for (RmatDocumentSupplierEntity rmatDocumentSupplierEntity : documentSuppliermatityNewList) {
            for (RmatDocumentSupplierEntity rmatDocumentSupplierLastEntity : supplierListLast) {
                CommonResponse responseCopy;
                if (!rmatDocumentSupplierEntity.getSupplierId().equals(rmatDocumentSupplierLastEntity.getSupplierId()) || (responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(rmatDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", rmatDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess()) continue;
                throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(RmatDocumentSellEntity::getSchemeId, schemePkList);
        List sellList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
        for (RmatDocumentSellEntity rmatDocumentSellEntity : sellList) {
            rmatDocumentSellEntity.setId(null);
            rmatDocumentSellEntity.setTalkNum(talkNum);
            for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : schemeList) {
                if (!rmatDocumentSellEntity.getSupplierId().equals(rmatDocumentSchemeEntity.getSupplierId()) || !rmatDocumentSellEntity.getSchemeName().equals(rmatDocumentSchemeEntity.getSchemeName())) continue;
                rmatDocumentSellEntity.setSchemeId(rmatDocumentSchemeEntity.getId());
            }
        }
        this.rmatDocumentSellService.saveBatch(sellList);
    }
}

