package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.other.bean.OtherDocumentExpertEntity;
import com.ejianc.business.tender.other.mapper.OtherDocumentExpertMapper;
import com.ejianc.business.tender.other.service.IOtherDocumentExpertService;
import com.ejianc.business.tender.other.vo.OtherDocumentExpertVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@Service("otherDocumentExpertService")
public class OtherDocumentExpertServiceImpl extends BaseServiceImpl<OtherDocumentExpertMapper, OtherDocumentExpertEntity> implements IOtherDocumentExpertService {

    @Override
    public List<OtherDocumentExpertEntity> addBatch(OtherDocumentVO otherDocumentVO) {

        //先删后增
        LambdaQueryWrapper<OtherDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(OtherDocumentExpertEntity::getDocumentId,otherDocumentVO.getId());
        super.remove(expertWrapper);

        //新增
        List<OtherDocumentExpertVO> expertVOList = otherDocumentVO.getExpertVOList();
        if(CollectionUtils.isNotEmpty(expertVOList)){
            for (OtherDocumentExpertVO otherDocument: expertVOList){
                otherDocument.setDocumentId(otherDocumentVO.getId());
                otherDocument.setId(null);
            }
            List<OtherDocumentExpertEntity> otherDocumentExpertEntities = BeanMapper.mapList(expertVOList, OtherDocumentExpertEntity.class);
            super.saveBatch(otherDocumentExpertEntities);
            return otherDocumentExpertEntities;
        }

        return null;
    }

    @Override
    public List<OtherDocumentExpertEntity> deleteByIds(List<Long> vos) {
        Long pk = vos.stream().findFirst().get();
        OtherDocumentExpertEntity otherDocumentExpertEntity = super.selectById(pk);
        Long documentId = otherDocumentExpertEntity.getDocumentId();
        super.removeByIds(vos,true);
        LambdaQueryWrapper<OtherDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(OtherDocumentExpertEntity::getDocumentId,documentId);
        List<OtherDocumentExpertEntity> list = super.list(expertWrapper);
        return list;
    }
}
