package com.ejianc.business.tender.prosub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageSupplierEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubPicketageSupplierMapper;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubWinnoticeService;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageSupplierVO;
import com.ejianc.business.tender.sub.bean.SubPicketageSupplierEntity;
import com.ejianc.business.tender.sub.mapper.SubPicketageSupplierMapper;
import com.ejianc.business.tender.sub.vo.SubPicketageSupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 定标供应商表
 *
 * @author generator
 *
 */
@Service("prosubPicketageSupplierService")
public class ProsubPicketageSupplierServiceImpl extends BaseServiceImpl<ProsubPicketageSupplierMapper, ProsubPicketageSupplierEntity> implements IProsubPicketageSupplierService {
    @Autowired
    private IProsubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private IProsubPicketageService subPicketageService;
    @Autowired
    private IProsubWinnoticeService subWinnoticeService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProcessService processService;
    @Override
    public List<ProsubPicketageSupplierVO> queryDetail(Long id) {
        LambdaQueryWrapper<ProsubPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(ProsubPicketageSupplierEntity::getPicketageId,id);
        List<ProsubPicketageSupplierEntity> listSupplier = subPicketageSupplierService.list(lambdaSupplierList);
        List<ProsubPicketageSupplierVO> subPicketageSupplierVOS = BeanMapper.mapList(listSupplier, ProsubPicketageSupplierVO.class);

        return subPicketageSupplierVOS;
    }
}
