package com.ejianc.business.tender.cost.mapper;

import com.ejianc.business.tender.cost.bean.PlanControlRuleDetailEntity;
import com.ejianc.business.tender.cost.vo.TargetcostDutyDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.tender.cost.bean.AllPlanDetailEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 采购计划中间库
 * 
 * @author generator
 * 
 */
@Mapper
public interface AllPlanDetailMapper extends BaseCrudMapper<AllPlanDetailEntity> {
    List<TargetcostDutyDetailVO> getTargetcostDutyDetail(@Param("projectId") Long projectId);
    List<AllPlanDetailEntity> getAllPlanDetail(@Param("projectId") Long projectId);

    @Select("SELECT d.id, d.parent_id, d.doc_id, d.doc_code, d.doc_name, d.unit_id, d.unit_name, d.inner_code, d.type, d.description, d.sequence, \n" +
            "d.create_user_code, d.create_time, d.update_user_code, d.update_time, d.tenant_id, d.version, d.dr, d.source_id, d.system_id, \n" +
            "d.asset_type, d.subject_id, d.subject_name, d.control_rule, d.p_id, d.sync_es_flag, t.enabled, t.control_type, t.control_rule_num\n" +
            "FROM ejc_plan_control_rule_detail AS d LEFT JOIN ejc_plan_control_rule_detail_type AS t ON d.id = t.parent_id\n" +
            "WHERE d.dr = 0 AND t.enabled = 1 AND d.p_id = 693064658269032522 AND t.dr = 0")
    List<PlanControlRuleDetailEntity> getControlList();
}
