package com.ejianc.business.tender.equipment.controller.api;

import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageRefsupplierService;
import com.ejianc.business.tender.stuff.service.IStuffPicketageRefsupplierService;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/23 10:30
 */
@RestController
@RequestMapping("/api/equipmentPicketageRefsupplier/")
public class EquipmentTenderApi {


    @Autowired
    private IEquipmentPicketageRefsupplierService equipmentPicketageRefsupplierService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "updateById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateById(@RequestParam Long id,@RequestParam Integer occupyFlag) {
        String s = equipmentPicketageRefsupplierService.updateById(id,occupyFlag);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("更新签订状态")
    @RequestMapping(value = "updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody TenderPicketageVO tenderPicketageVO) {
        String s = equipmentPicketageRefsupplierService.updateStatus(tenderPicketageVO,0);
        return CommonResponse.success(s);
    }
    @ApiOperation("删除操作-更新签订状态")
    @RequestMapping(value = "delUpdateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delUpdateStatus(@RequestBody TenderPicketageVO tenderPicketageVO) {
        String s = equipmentPicketageRefsupplierService.updateStatus(tenderPicketageVO,1);
        return CommonResponse.success(s);
    }

}
