package com.ejianc.business.tender.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.proequipmentcorppur.purchaseplan.api.ICorpPurchasePlanApi;
import com.ejianc.business.proequipmentcorprent.rent.api.ICorpRentPlanApi;
import com.ejianc.business.rent.api.IRentPlanApi;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailRecordEntity;
import com.ejianc.business.tender.rent.bean.RentInviteDetailRecordEntity;
import com.ejianc.business.tender.rent.vo.RentInviteDetailBidderVO;
import com.ejianc.business.tender.rent.vo.RentInviteDetailVO;
import com.ejianc.business.tender.rent.vo.RentInviteVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.mapper.RentInviteMapper;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Service("rentInviteService")
public class RentInviteServiceImpl extends BaseServiceImpl<RentInviteMapper, RentInviteEntity> implements IRentInviteService {
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IRentPlanApi batPlanApi;
    @Autowired
    private ICorpRentPlanApi corpRentPlanApi;

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id,tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id,abolishType);
    }

    @Override
    public List<RentInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<RentInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        LambdaQueryWrapper<ProcessEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProcessEntity::getTenderId, tenderId);
        lambda.eq(ProcessEntity::getBillId, tenderId);
        List<ProcessEntity> list = processService.list(lambda);
        switch (list.get(0).getType()){
            case 0: map = rentInviteService.getSuffAbolishType(tenderId);break;
            case 1: map = rentInviteService.getSubAbolishType(tenderId);break;
        }
        return map;
    }

    @Override
    public Map<String, Object> getSuffAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        RentInviteEntity rentInviteEntity = rentInviteService.selectById(tenderId);
        RentInviteVO vo = BeanMapper.map(rentInviteEntity, RentInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public Map<String, Object> getSubAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        SubInviteEntity subInviteEntity = subInviteService.selectById(tenderId);
        SubInviteVO vo = BeanMapper.map(subInviteEntity, SubInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return map;
    }

    @Override
    public List<RentInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Override
    public void updateApiState(RentInviteEntity entity, Integer BatchPlanState, Integer MaterialBatchPlanState) {
        List<String> batPlanList = entity.getRentDetailRecord().stream().map(RentInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
//        if (entity.getPurchaseType()==0){
            if (CollectionUtils.isNotEmpty(batPlanList)) {
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(batPlanList, BatchPlanState);
                if (!response.isSuccess()) {
                    throw new BusinessException("修改计划状态失败" + response.getMsg());
                }
            }
//        }else {
//            if (CollectionUtils.isNotEmpty(batPlanList)) {
//                CommonResponse<String> response = corpRentPlanApi.updateBatPlanQuote(batPlanList, MaterialBatchPlanState);
//                if (!response.isSuccess()) {
//                    throw new BusinessException("修改公司设备租赁计划状态失败" + response.getMsg());
//                }
//            }
//        }
    }
}
