/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentWinnoticeEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentWinnoticeMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentBidDetailService;
import com.ejianc.business.tender.equipment.service.IEquipmentBidSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSellService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentWinnoticeService;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentWinDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentWinVO;
import com.ejianc.business.tender.equipment.vo.EquipmentWinnoticeVO;
import com.ejianc.business.tender.equipment.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="equipmentWinnoticeService")
public class EquipmentWinnoticeServiceImpl
extends BaseServiceImpl<EquipmentWinnoticeMapper, EquipmentWinnoticeEntity>
implements IEquipmentWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentBidDetailService equipmentBidDetailService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentBidSupplierService equipmentBidSupplierService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220119000000004";
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional
    public EquipmentWinnoticeVO saveWinnotice(Long picketageId) {
        EquipmentWinnoticeEntity entity = new EquipmentWinnoticeEntity();
        entity.setPicketageId(picketageId);
        EquipmentPicketageEntity equipmentPicketageEntity = (EquipmentPicketageEntity)((Object)this.equipmentPicketageService.selectById(picketageId));
        EquipmentInviteEntity inviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId()));
        entity.setInviteId(equipmentPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName() + "\u4e2d\u6807\u516c\u544a");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        if (inviteEntity.getPurchaseType().equals(0)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(equipmentPicketageEntity.getDocumentId()));
        entity.setEmployeeId(equipmentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);
        entity.setLineTypeName(CommonUtils.getTypeName(2));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate((Object)entity, false);
        equipmentPicketageEntity.setWinnoticeStatus(1);
        equipmentPicketageEntity.setWinnoticeId(entity.getId());
        this.equipmentPicketageService.updateById((Object)equipmentPicketageEntity);
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        this.equipmentInviteService.updateById((Object)inviteEntity);
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        for (EquipmentPicketageSupplierEntity equipmentPicketageSupplierEntity : picketageSupplierList) {
            equipmentPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        this.equipmentPicketageSupplierService.updateBatchById(picketageSupplierList);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/winnotice");
        this.processService.saveOrUpdate((Object)processEntity);
        EquipmentWinnoticeVO equipmentWinnoticeVO = (EquipmentWinnoticeVO)BeanMapper.map((Object)((Object)entity), EquipmentWinnoticeVO.class);
        return equipmentWinnoticeVO;
    }

    @Override
    public EquipmentWinnoticeVO queryDetail(Long id) {
        Map attacMap;
        AttachmentVO attachmentVO;
        List data;
        Long id1;
        CommonResponse listCommonResponse;
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = (EquipmentWinnoticeEntity)((Object)super.selectById((Serializable)id));
        EquipmentWinnoticeVO equipmentWinnoticeVO = (EquipmentWinnoticeVO)BeanMapper.map((Object)((Object)equipmentWinnoticeEntity), EquipmentWinnoticeVO.class);
        EquipmentPicketageEntity equipmentPicketageEntity = (EquipmentPicketageEntity)((Object)this.equipmentPicketageService.selectById(equipmentWinnoticeEntity.getPicketageId()));
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        List equipmentPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, EquipmentPicketageSupplierVO.class);
        equipmentWinnoticeVO.setPicketageSupplierList(equipmentPicketageSupplierList);
        if (equipmentWinnoticeVO != null && (listCommonResponse = this.attachmentApi.queryListBySourceId(id1 = equipmentWinnoticeVO.getId(), BILL_TYPE, "tenderWinnotice", "")).isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData())) && (attachmentVO = (AttachmentVO)(attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()))).get(equipmentWinnoticeVO.getId())) != null) {
            equipmentWinnoticeVO.setAttachId(attachmentVO.getId());
            equipmentWinnoticeVO.setFileName(attachmentVO.getFileName());
            equipmentWinnoticeVO.setFilePath(attachmentVO.getFilePath());
        }
        return equipmentWinnoticeVO;
    }

    @Override
    public EquipmentWinnoticeVO publishWinnotice(Long id) {
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = (EquipmentWinnoticeEntity)((Object)super.selectById((Serializable)id));
        equipmentWinnoticeEntity.setPublishFlag(0);
        super.updateById((Object)equipmentWinnoticeEntity);
        EquipmentPicketageEntity equipmentPicketageEntity = (EquipmentPicketageEntity)((Object)this.equipmentPicketageService.selectById(equipmentWinnoticeEntity.getPicketageId()));
        equipmentPicketageEntity.setWinnoticeStatus(2);
        this.equipmentPicketageService.updateById((Object)equipmentPicketageEntity);
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId()));
        EquipmentWinVO winVO = new EquipmentWinVO();
        winVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u4e2d\u6807\u516c\u544a");
        winVO.setSourceId(Long.toString(equipmentWinnoticeEntity.getInviteId()));
        winVO.setBillCode(equipmentInviteEntity.getBillCode());
        if (equipmentInviteEntity.getPurchaseType() == 0) {
            winVO.setSourceProjectId(Long.toString(equipmentInviteEntity.getProjectId()));
            winVO.setProjectName(equipmentInviteEntity.getProjectName());
            winVO.setProjectCode(equipmentInviteEntity.getProjectCode());
        }
        if (equipmentInviteEntity.getPurchaseType() == 1) {
            winVO.setOrgName(equipmentInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(equipmentInviteEntity.getOrgId()));
        }
        winVO.setSourceUnitId(Long.toString(equipmentInviteEntity.getUnitId()));
        winVO.setUnitName(equipmentInviteEntity.getUnitName());
        winVO.setType("PURCHASE");
        winVO.setTenderName(equipmentInviteEntity.getTenderName());
        winVO.setTenderType(equipmentInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(equipmentWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(equipmentWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(equipmentWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(equipmentInviteEntity.getPurchaseType());
        winVO.setWinDate(equipmentWinnoticeEntity.getWinDate());
        winVO.setStopDate(equipmentWinnoticeEntity.getStopDate());
        winVO.setWinTitle(equipmentWinnoticeEntity.getTitleName());
        winVO.setMemo(equipmentWinnoticeEntity.getMemo());
        winVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        ArrayList<EquipmentWinDetailVO> winDetailVOS = new ArrayList<EquipmentWinDetailVO>();
        for (EquipmentPicketageSupplierEntity equipmentPicketageSupplierEntity : picketageSupplierList) {
            EquipmentWinDetailVO winDetailVO = new EquipmentWinDetailVO();
            winDetailVO.setWinId(equipmentWinnoticeEntity.getId());
            winDetailVO.setSupplierName(equipmentPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(equipmentPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(equipmentPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(equipmentPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString((Object)winVO);
        this.logger.info("\u4e2d\u6807\u516c\u544a\u53d1\u5e03" + stringFb);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winSaveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u516c\u544a\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public EquipmentWinnoticeVO saveOrUpdates(EquipmentWinnoticeEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        EquipmentWinnoticeEntity equipmentWinnoticeEntity = (EquipmentWinnoticeEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            equipmentWinnoticeEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            equipmentWinnoticeEntity.setSignFlag(1);
        }
        if (status == 4) {
            equipmentWinnoticeEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(equipmentWinnoticeEntity.getId());
            cv.setContractName(equipmentWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)equipmentWinnoticeEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }
}

