package com.ejianc.business.tender.cost.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.cost.bean.SupplierOrderEntity;
import com.ejianc.business.tender.cost.service.ISupplierOrderService;
import com.ejianc.business.tender.cost.vo.SupbidNoticeVO;
import com.ejianc.business.tender.cost.vo.SupplierOrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.sql.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("supbidData")
public class SupbidDataController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISupplierOrderService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierOrderVO> saveOrUpdate(@RequestBody SupplierOrderVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierOrderVO> queryDetail(Long id) {
    	SupplierOrderEntity entity = service.selectById(id);
    	SupplierOrderVO vo = BeanMapper.map(entity, SupplierOrderVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryAllWinNotice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryAllWinNotice() {
        List<SupbidNoticeVO> supbidNotice = getSupbidNotice();
        for (SupbidNoticeVO supbidNoticeVO : supbidNotice) {
            if ("MATERIAL".equals(supbidNoticeVO.getType())){
                supbidNoticeVO.setType("材料招标");
            } else if ("SUB".equals(supbidNoticeVO.getType())){
                if ("1471313685275983873".equals(supbidNoticeVO.getSubType())){
                    //劳务
                    supbidNoticeVO.setType("劳务分包");
                }else {
                    supbidNoticeVO.setType("专业分包");
                }
            }else if ("PURCHASE".equals(supbidNoticeVO.getType())){
                supbidNoticeVO.setType("设备购置");
            } else if ("RENT".equals(supbidNoticeVO.getType())){
                supbidNoticeVO.setType("设备租赁");
            } else if ("RMAT".equals(supbidNoticeVO.getType())){
                supbidNoticeVO.setType("周转材租赁");
            } else if ("OTHER".equals(supbidNoticeVO.getType())){
                supbidNoticeVO.setType("其他");
            }
        }
        return CommonResponse.success("查询详情数据成功！",supbidNotice);
    }

    // MySQL8.0以下版本 - JDBC驱动名及数据库URL
    static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
    // test为数据库名,?后面这句很重要,设置useSSl=false
    static final String DB_URL = "jdbc:mysql://172.16.1.122:3306/ejc-supbid?characterEncoding=UTF8&autoReconnect=true&useSSL=false";
    // 数据库的用户名与密码，需要根据自己的设置
    static final String USER = "root";
    static final String PASS = "17Liancloud";

    public List<SupbidNoticeVO>  getSupbidNotice() {
        Connection conn = null;
        Statement stmt = null;
        List<SupbidNoticeVO> supbidNoticeVOS = new ArrayList<>();
        try{
            // 注册 JDBC 驱动,加载驱动
            Class.forName(JDBC_DRIVER);

            // 打开链接,连接数据库
            System.out.println("数据库连接中...");
            conn = DriverManager.getConnection(DB_URL,USER,PASS);

            // 执行查询
            System.out.println(" 实例化Statement对象...");
            stmt = conn.createStatement();
            String sql;
            sql = "SELECT d.id,w.project_name,d.money,d.supplier_name,n.type,n.sub_type,w.win_date FROM `ejc_supbid_win` w\n" +
                    "LEFT JOIN ejc_supbid_win_detail d\n" +
                    "on w.id = d.win_id\n" +
                    "LEFT JOIN ejc_supbid_notice n\n" +
                    "on w.source_id = n.source_id\n" +
                    "where w.dr= 0\n" +
                    "order by w.create_time desc\n" +
                    "limit 10";
            ResultSet rs = stmt.executeQuery(sql);

            // 展开结果集数据库
            while(rs.next()){
                // 通过字段检索
                SupbidNoticeVO supbidNoticeVO = new SupbidNoticeVO();
                supbidNoticeVO.setId(rs.getLong("id"));
                supbidNoticeVO.setProjectName(rs.getString("project_name"));
                supbidNoticeVO.setMoney(rs.getString("money"));
                supbidNoticeVO.setSupplierName(rs.getString("supplier_name"));
                supbidNoticeVO.setType(rs.getString("type"));
                supbidNoticeVO.setSubType(rs.getString("sub_type"));
                supbidNoticeVO.setWinDate(rs.getDate("win_date"));

                supbidNoticeVOS.add(supbidNoticeVO);
            }
            // 完成后关闭
            rs.close();
            stmt.close();
            conn.close();
        }catch(SQLException se){
            // 处理 JDBC 错误
            se.printStackTrace();
        }catch(Exception e){
            // 处理 Class.forName 错误
            e.printStackTrace();
        }finally{
            // 关闭资源
            try{
                if(stmt!=null) stmt.close();
            }catch(SQLException se2){
            }
            try{
                if(conn!=null) conn.close();
            }catch(SQLException se){
                se.printStackTrace();
            }
        }
       return supbidNoticeVOS;
    }

}
