package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.IStuffCheckService;
import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSellMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSupplierDetailMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSupplierMapper;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.*;
import com.ejianc.business.tender.stuff.vo.SupplierSellVO;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**.
 *
 * 招标文件主表
 *
 * @author generator
 *
 */
@Service("prosubDocumentService")
public class ProsubDocumentServiceImpl extends BaseServiceImpl<ProsubDocumentMapper, ProsubDocumentEntity> implements IProsubDocumentService {
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private ProsubDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private ProsubDocumentSupplierMapper supplierMapper;
    @Autowired
    private IProsubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private ProsubDocumentSellMapper subDocumentSellMapper;
    @Autowired
    private IProsubDocumentRecordService subDocumentRecordService;
    @Autowired
    private IProsubDocumentDetailService subDocumentDetailService;
    @Autowired
    private IProsubInviteDetailService subInviteDetailService;
    @Autowired
    private IProsubTalkService subTalkService;
    @Autowired
    private IProsubTalkRecordService subTalkRecordService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentExpertService documentExpertService;
    @Autowired
    private IProsubDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IProsubDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IProsubDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IProsubInviteDetailRecordService subInviteDetailRecordService;

    @Autowired
    private IProsubNoticeService subNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Value("${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value("${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000002";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String BILL_CODE = "invite-document-code";//此处需要根据实际修改

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IProsubNoticeSupplierService subNoticeSupplierService;




    @Transactional
    @Override
    public ProsubDocumentVO publishDocument(Long id) {
        //更新发布状态
        ProsubDocumentEntity subDocumentEntity = super.selectById(id);
        subDocumentEntity.setPublishFlag(0);
        super.updateById(subDocumentEntity);

        //推送供应商
        ProsubDocumentSupplierTbVO subDocumentSupplierTbVO = new ProsubDocumentSupplierTbVO();
        subDocumentSupplierTbVO.setSourceId(subDocumentEntity.getInviteId().toString());
        subDocumentSupplierTbVO.setSourceType("郑州一建招标文件");
        subDocumentSupplierTbVO.setNoticeType(1);
        subDocumentSupplierTbVO.setProjectLinkName(subDocumentEntity.getProjectLinkName());
        subDocumentSupplierTbVO.setProjectLinkPhone(subDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(subDocumentEntity.getOfferStartTime());
        subDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(subDocumentEntity.getOfferEndTime());
        subDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        subDocumentSupplierTbVO.setContent(subDocumentEntity.getDocumentContent());
        subDocumentSupplierTbVO.setBrandFlag(subDocumentEntity.getBrandFlag());
        subDocumentSupplierTbVO.setMemo(subDocumentEntity.getMemo());
        subDocumentSupplierTbVO.setTenderName(subDocumentEntity.getDocumentName());
        CommonResponse<String> stringCommonResponse = proSupplierApi.getEjcCloudSystemCode();
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件获取systemId失败" + stringCommonResponse.getMsg());
        }
        subDocumentSupplierTbVO.setSystemId(stringCommonResponse.getData());

        //处理附件
        //查询招标文件
        CommonResponse<List<AttachmentVO>> zbwjFile = attachmentApi.queryListBySourceId(subDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Long> zbwjAttachIdList = new ArrayList<>();
        if(zbwjFile.isSuccess()){
            List<AttachmentVO> data = zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }

        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //招标文件stream处理
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonZbwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String dataZbwj = zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject(dataZbwj);
        Map<String, byte[]> zbwjMap = JSONObject.parseObject(zbwListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        zbwjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });

        String stringFb = JSONObject.toJSONString(subDocumentSupplierTbVO);
        Map<String,String> params = new HashMap<>();
        params.put("noticeEntity", stringFb);
        Map<String, Map<String, InputStream>> files = null;
        if (!streamMap.isEmpty()){
            files = new HashMap<>();
            files.put("file",streamMap);
        }

        //推送供方
        CommonResponse<String> stringCommonResponses = systemDataPushService.exchangeDataAndFilesWithUniversal(saveWjUrl,params,files, appId, appSecret, appHost);
        if(!stringCommonResponses.isSuccess()) {
            throw new BusinessException("招标文件发布推送供方接口报错" + stringCommonResponses.getMsg());
        }

        ProsubDocumentVO subDocumentVO = queryDetail(id);
        return subDocumentVO;
    }




    @Override
    public ProsubDocumentVO bidDocument(Long id) {
        //更新开标状态
        ProsubDocumentEntity subDocumentEntity = super.selectById(id);
        subDocumentEntity.setBidFlag(0);
        subDocumentEntity.setBidTime(new Date());
        super.updateById(subDocumentEntity);
        ProsubDocumentVO subDocumentVO = queryDetail(id);
//        开标之后给专家发送微信+内部消息通知：xx专家您好，XXX（项目名称）已开标，后续的评标开始时间我们会以短信+消息
        List<ProsubDocumentExpertEntity> entityList = documentExpertService.list(new QueryWrapper<ProsubDocumentExpertEntity>().eq("document_id", subDocumentVO.getId()).eq("dr", 0));
        for (ProsubDocumentExpertEntity entity : entityList) {
            //审批通过给专家发内部消息
            List<String> messageType = new ArrayList<>();
            //系统消息
            messageType.add("sys");
            //微信消息
            //messageType.add("weChat");
            List<String> sender = new ArrayList<>();
            sender.add(entity.getExpertId() + "");
            String name = subDocumentVO.getPurchaseType()==0?subDocumentVO.getProjectName():subDocumentVO.getOrgName();
            logger.info("发送信息给专家:>----------" + sender);
            String subject = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            String content = entity.getExpertName() + "专家您好，" +name+ "已开标，后续的评标开始时间我们会以短信+消息的形式通知您，请注意查看，避免遗忘";
            logger.info("发送信息的内容:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, pushMessageApi);
        }
        return subDocumentVO;
    }

    @Override
    public ProsubDocumentVO queryDetail(Long id) {
        return queryDocDetail(id,0);
    }

    @Override
    public ProsubDocumentVO queryDetail1(Long id, Integer num) {
        return queryDocDetail(id,num);
    }

    @Override
    public ProsubDocumentVO queryDetailNum(Long id) {
        ProsubDocumentSchemeEntity subDocumentSchemeEntity = subDocumentSchemeService.list(new QueryWrapper<ProsubDocumentSchemeEntity>().eq("document_id", id).orderByDesc("talk_num")).get(0);
        return queryDocDetail(id,subDocumentSchemeEntity.getTalkNum());
    }

    @Transactional
    @Override
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {

        logger.info("专业分包进入报价接口request-{},file-{}", request, file);
        String notice = request.getParameter("bjNoticeVO");
        logger.info("专业分包实体信息-{}",notice);
        ProsubSupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<ProsubSupplierSellVO>() { });

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = subInviteEntity.getTenderStage();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10){
            talkNum = 0;
        }
        if (tenderStage == 7){
            //查询轮数
            LambdaQueryWrapper<ProsubTalkEntity> lambdaTalk = Wrappers.<ProsubTalkEntity>lambdaQuery();
            lambdaTalk.eq(ProsubTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            ProsubTalkEntity subTalkEntity = subTalkService.getOne(lambdaTalk);
            talkNum = subTalkEntity.getTalkNum();
        }

        //转换
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();

        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<ProsubDocumentEntity> lambdaDocument = Wrappers.<ProsubDocumentEntity>lambdaQuery();
        lambdaDocument.eq(ProsubDocumentEntity::getInviteId, inviteId);
        ProsubDocumentEntity subDocumentEntity = baseMapper.selectOne(lambdaDocument);
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplier = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId,subDocumentEntity.getId());
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum,talkNum);
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = subDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (subDocumentSupplierEntity != null){
            //更新供应商信息
            subDocumentSupplierEntity.setOfferTime(new Date());
            subDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            subDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            subDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            subDocumentSupplierService.updateById(subDocumentSupplierEntity);
            documentSupplierId = subDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId,subDocumentSupplierEntity.getId() );
            subDocumentSchemeService.remove(lambdaScheme);
        }
        if (subDocumentSupplierEntity == null){
            //新增供应商信息
            ProsubDocumentSupplierEntity subDocumentSupplierEntityAdd = new ProsubDocumentSupplierEntity();
            subDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            subDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            subDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            subDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            subDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            subDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            subDocumentSupplierEntityAdd.setOfferTime(new Date());
            subDocumentSupplierEntityAdd.setDocumentId(subDocumentEntity.getId());
            subDocumentSupplierEntityAdd.setTalkNum(talkNum);
            subDocumentSupplierService.save(subDocumentSupplierEntityAdd);
            documentSupplierId = subDocumentSupplierEntityAdd.getId();
        }

        //处理方案信息
        List<ProsubSupplierSellSchemeVO> schemeList = pushVO.getSubSchemeList();
        List<ProsubDocumentSchemeEntity> subDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<ProsubDocumentSellVO> subDocumentSellVOList = new ArrayList<>();
        for (ProsubSupplierSellSchemeVO supplierSellSchemeVO : schemeList){
            ProsubDocumentSchemeEntity subDocumentSchemeEntity = new ProsubDocumentSchemeEntity();
            subDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            subDocumentSchemeEntity.setDocumentId(subDocumentEntity.getId());
            subDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            subDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            subDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            subDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            subDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMny());
            subDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getTaxMny());
            subDocumentSchemeEntity.setTalkNum(talkNum);
            subDocumentSchemeEntity.setId(IdWorker.getId());
            subDocumentSchemeEntity.setPassFlag(1);

            subDocumentSchemeEntityArrayList.add(subDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<ProsubSupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getSubSchemeDetailList();
            for (ProsubSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList){
                ProsubDocumentSellVO subDocumentSellVO = new ProsubDocumentSellVO();
//                subDocumentSellVO.setProjectId(subDocumentEntity.getProjectId());
//                subDocumentSellVO.setProjectName(subDocumentEntity.getProjectName());
                subDocumentSellVO.setSchemeId(subDocumentSchemeEntity.getId());
                subDocumentSellVO.setDocumentId(subDocumentEntity.getId());
                subDocumentSellVO.setSupplierId(sourceSupplierId);
                subDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                subDocumentSellVO.setSupplierName(supplierVO.getName());
                subDocumentSellVO.setDetailId(Long.parseLong(supplierSellSchemeDetailVO.getSourceDetailId()));
                ProsubInviteDetailRecordEntity subRecordEntity = subInviteDetailRecordService.selectById(Long.parseLong(supplierSellSchemeDetailVO.getSourceDetailId()));
                subDocumentSellVO.setMaterialId(subRecordEntity.getDocId());
                subDocumentSellVO.setMaterialTypeId(subRecordEntity.getDocCategoryId());
                subDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getDetailName());
                subDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getDetailCode());
                subDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                subDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                subDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                subDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                subDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                subDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                subDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getTaxPrice());
//                subDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMny());
//                subDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getTaxMny());
//                subDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                subDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                subDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                subDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                subDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                subDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                subDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                subDocumentSellVO.setReferFlag(2);
                subDocumentSellVO.setPassFlag(1);
                subDocumentSellVO.setTalkNum(talkNum);
                subDocumentSellVO.setContent(supplierSellSchemeDetailVO.getContent());
                subDocumentSellVO.setRule(supplierSellSchemeDetailVO.getRule());
                subDocumentSellVO.setInfoPrice(supplierSellSchemeDetailVO.getInfoPrice());//信息价
                subDocumentSellVO.setFallRate(supplierSellSchemeDetailVO.getFallRate());//下浮率

                subDocumentSellVOList.add(subDocumentSellVO);

            }

        }
        //新增方案
        subDocumentSchemeService.saveBatch(subDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getSupplierId,sourceSupplierId);
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum,talkNum);
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId,subDocumentEntity.getId());
        subDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<ProsubDocumentDetailEntity> lambdaDetail = Wrappers.<ProsubDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(ProsubDocumentDetailEntity::getDocumentId,subDocumentEntity.getId());


        List<ProsubDocumentDetailEntity> subDocumentDetailList = subDocumentDetailService.list(lambdaDetail);

        List<ProsubDocumentSellEntity> subDocumentSellEntityArrayList = new ArrayList<>();
        for (ProsubDocumentDetailEntity subDocumentDetailEntity : subDocumentDetailList) {
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                //判断是否只有分类
                if (subDocumentDetailEntity.getMaterialId() != null) {
                    if (subInviteEntity.getPurchaseType() == 1) {
                        if (subDocumentDetailEntity.getContent() != null && subDocumentSellVO.getContent() != null){
                            if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                                    subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) &&
                                    subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) &&
                                    subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule()) &&
                                    subDocumentDetailEntity.getContent().equals(subDocumentSellVO.getContent())) {
                                ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                                subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                                subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                                subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                                subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                                subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                                subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                                subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                                // 备注拆分
                                subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());

                                subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                            }
                    }else {
                            if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                                    subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) &&
                                    subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) &&
                                    subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule()) ) {
                                ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                                subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                                subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                                subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                                subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                                subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                                subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                                subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                                // 备注拆分
                                subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());

                                subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                            }
                        }
                    } else {
                        if (subDocumentDetailEntity.getContent() != null && subDocumentSellVO.getContent() != null){
                            if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                                    subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) &&
                                    //subDocumentDetailEntity.getCalculateType().equals(subDocumentSellVO.getCalculateType()) &&
                                    subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) &&
                                    subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule()) &&
                                    subDocumentDetailEntity.getContent().equals(subDocumentSellVO.getContent())) {
                                ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                                subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                                subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                                subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                                subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                                subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                                subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                                subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                                // 备注拆分
                                subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                                subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                            }
                        }else {
                            if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                                    subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) &&
                                    //subDocumentDetailEntity.getCalculateType().equals(subDocumentSellVO.getCalculateType()) &&
                                    subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate()) &&
                                    subDocumentDetailEntity.getRule().equals(subDocumentSellVO.getRule()) ) {
                                ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                                subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                                subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                                subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                                subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                                subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                                subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                                subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                                // 备注拆分
                                subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                                subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                            }
                        }
                    }
                }
                if (subDocumentDetailEntity.getMaterialId() == null) {
                    if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                            // (subDocumentDetailEntity.getCalculateType() == null || subDocumentDetailEntity.getCalculateType().equals(subDocumentSellVO.getCalculateType())) &&
                            subDocumentDetailEntity.getRate().equals(subDocumentSellVO.getDetailRate())) {
                        ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                        subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                        subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                        subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                        subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                        subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                        subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                        subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                        // 备注拆分
                        subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                        subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                    }
                }

            }

        }


        // List<SubDocumentSellEntity> subDocumentSellEntities = BeanMapper.mapList(subDocumentSellVOList, SubDocumentSellEntity.class);
        //新增报价信息
        subDocumentSellService.saveBatch(subDocumentSellEntityArrayList);
        //List<ProsubDocumentSellEntity> subDocumentSellEntities = BeanMapper.mapList(subDocumentSellVOList, ProsubDocumentSellEntity.class);
        //新增报价信息
        //subDocumentSellService.saveBatch(subDocumentSellEntityArrayList);

        //先删除附件
        if(documentSupplierId != null){
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]",documentSupplierId, BILL_SUPPLIER_TYPE);
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId,BILL_SUPPLIER_TYPE,"supplierFileType",null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)){
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}",deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
        if(CollectionUtils.isNotEmpty(pzList)){
            List<AttachmentVO> list = new ArrayList<>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
            }
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info(request+"报名文件上传结果-{}",JSONObject.toJSONString(stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId,Long inviteId) {
        Map<String, String> fileMap = new HashMap<>();
        fileMap.put("fileIds",Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader(BASE_HOST + "ejc-file-web/attachment/batchdownflow", fileMap);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        //文件stream处理
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map<String, String> zbwjParam = JSONObject.parseObject(jsonwj.toJSONString(), new TypeReference<Map<String, String>>(){});
        String datawj = zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject(datawj);
        Map<String, byte[]> wjMap = JSONObject.parseObject(wListJson.toJSONString(), new TypeReference<Map<String, byte[]>>(){});
        Map<String, InputStream> streamMap = new HashMap<>();
        wjMap.forEach((key,value) ->{
            streamMap.put(key,new ByteArrayInputStream(value));
        });


        Map<String,String> params = new HashMap<>();
        params.put("sourceId", Long.toString(inviteId));
        Map<String,String> headers = new HashMap<>();
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        files.put("file",streamMap);

        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataAndFilesWithUniversal(addFileUrl, params, files, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("附件批量修改同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        Map<String,Object> map = new HashMap<>();
        map.put("sourceId",sourceId);
        map.put("fileNames",fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        //调用供方接口
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(delFileUrl, RequestMethod.POST, stringInfo, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
                throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
            }
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,delFileUrl, stringInfo,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("附加批量删除同步供方接口报错" + response.getMsg());
//        }
        return "同步成功";
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {

        ProsubDocumentEntity subDocumentEntity = super.selectById(documentId);
        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSchemeEntity subDocumentSchemeEntity = subDocumentSchemeService.selectById(schemeId);
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = subDocumentSupplierService.selectById(subDocumentSchemeEntity.getDocumentSupplierId());
        Long supplierDetailId = subDocumentSupplierEntity.getId();
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setSupplierName(subDocumentSupplierEntity.getSupplierName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        subDocumentSupplierSellVO.setPurchaseType(subDocumentEntity.getPurchaseType());
        LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<ProsubDocumentSchemeEntity> subDocumentSchemeEntityList = subDocumentSchemeService.list(lambdaScheme);
        List<ProsubDocumentSchemeVO> subDocumentSchemeVOList = BeanMapper.mapList(subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId,subDocumentSupplierEntity.getDocumentId());
        List<ProsubDocumentSellEntity> subDocumentSellEntityList = subDocumentSellService.list(lambdaSell);
        List<ProsubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(subDocumentSellEntityList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().
                collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
        for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList){
            List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
            if(CollectionUtils.isNotEmpty(subDocumentSellVOS)){
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    ProsubInviteDetailEntity subInviteDetailEntity = subInviteDetailService.selectById(subDocumentSellVO.getDetailId());
                    subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                    subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                }
            }
            subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
        }
        subDocumentSupplierSellVO.setSubDocumentSchemeList(subDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if(fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return subDocumentSupplierSellVO;
    }

    @Override
    public ProsubDocumentVO saveOrUpdate(ProsubDocumentVO saveorUpdateVO) {
        ProsubDocumentEntity entity = BeanMapper.map(saveorUpdateVO, ProsubDocumentEntity.class);
        service.saveOrUpdate(entity, false);
        ProsubDocumentVO vo = BeanMapper.map(entity, ProsubDocumentVO.class);
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(entity.getInviteId());
        List<ProsubInviteDetailRecordVO> subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getSubDetailRecord(), ProsubInviteDetailRecordVO.class);
        vo.setSubDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }


    @Override
    public ProsubDocumentVO queryDocDetail(Long id,Integer talkNum) {

        ProsubDocumentEntity entity = super.selectById(id);
        ProsubDocumentVO subDocumentVO = BeanMapper.map(entity, ProsubDocumentVO.class);
        subDocumentVO.setSubDocumentSchemeList(null);
        subDocumentVO.setSubDocumentSellList(null);
        //处理报名供应商信息
        if(subDocumentVO.getNoticeId()!=null){
            LambdaQueryWrapper<ProsubNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ProsubNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(ProsubNoticeSupplierEntity::getState, 1);
            List<ProsubNoticeSupplierEntity> list = subNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if(CollectionUtils.isNotEmpty(list)){
                List<ProsubNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, ProsubNoticeSupplierVO.class);
                Map<Long, ProsubDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(subDocumentVO.getSubDocumentSupplierList())){
                    documentSupplierVOMap = subDocumentVO.getSubDocumentSupplierList().stream().filter(t->t.getSupplierId()!=null).collect(Collectors.toMap(ProsubDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (ProsubNoticeSupplierVO noticeSupplier :  noticeSupplierVOS) {
                    if(documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())){
                        noticeSupplier.setDocumentType(0);//已报价
                    }else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                subDocumentVO.setSubDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambda = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambda.eq(ProsubDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(ProsubDocumentSupplierEntity::getTalkNum, talkNum);
        List<ProsubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)){
            List<ProsubDocumentSupplierVO> subDocumentSupplierVOS = BeanMapper.mapList(supplierList, ProsubDocumentSupplierVO.class);
            LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(ProsubDocumentSchemeEntity::getSchemeName);
            List<ProsubDocumentSchemeEntity> schemeList = subDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<ProsubDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(ProsubDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0){
                for (ProsubDocumentSupplierVO subDocumentSupplierEntity : subDocumentSupplierVOS){
                    List<ProsubDocumentSchemeEntity> subDocumentSchemeEntities = schemeMap.get(subDocumentSupplierEntity.getId());
                    String schemeMoney  = "";
                    for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : subDocumentSchemeEntities){
                        schemeMoney = schemeMoney + subDocumentSchemeEntity.getSchemeName() + ":" + subDocumentSchemeEntity.getMoneyTax().setScale(2,BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    subDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(subDocumentSupplierVOS)){
                    List<Long> attachIds = subDocumentSupplierVOS.stream().map(ProsubDocumentSupplierVO::getId).collect(Collectors.toList());
                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds",attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess()){
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)){
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(),(key1,key2)->key2));
                            for (ProsubDocumentSupplierVO subDocumentSupplierVO : subDocumentSupplierVOS){
                                AttachmentVO attachmentVO = attacMap.get(subDocumentSupplierVO.getId());
                                if(attachmentVO != null){
                                    subDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    subDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }

                    for (ProsubDocumentSupplierVO stuffDocumentSupplierVO : subDocumentSupplierVOS) {
                        if (stuffDocumentSupplierVO.getIsMobile() != null){//手机端报价
                            CommonResponse<List<AttachmentVO>> listCommonResponse1 = attachmentApi.queryListBySourceId(id, null, stuffDocumentSupplierVO.getSupplierName(), null);
                            if (listCommonResponse1.isSuccess()) {
                                List<AttachmentVO> data = listCommonResponse1.getData();
                                if (CollectionUtils.isNotEmpty(data)) {
                                    stuffDocumentSupplierVO.setAttachId(data.get(0).getId());
                                    stuffDocumentSupplierVO.setFileName(data.get(0).getFileName());
                                }
                            }
                        }
                    }
                }
            }

            //是否开标,0-是,1-否
//            if (entity.getBidFlag() == 1){
//                for (ProsubDocumentSupplierVO subDocumentSupplierVO : subDocumentSupplierVOS){
//                    subDocumentSupplierVO.setRegisterDate(null);
//                }
//            }
            //按供应商查看报价
            subDocumentVO.setSubDocumentSupplierList(subDocumentSupplierVOS);
            //前端键值重复设计
            subDocumentVO.setSubDocumentSupplierSchemeList(subDocumentSupplierVOS);
            //按材料查看报价
            List<ProsubDocumentDetailVO> subDocumentDetailList = subDocumentVO.getSubDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSchemeName);
            List<ProsubDocumentSellEntity> sellList = subDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)){
                List<ProsubDocumentSellVO> subDocumentSellVOS = BeanMapper.mapList(sellList, ProsubDocumentSellVO.class);
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS){
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1){
                        subDocumentSellVO.setPrice(null);
                        subDocumentSellVO.setPriceTax(null);
                        subDocumentSellVO.setMoney(null);
                        subDocumentSellVO.setMoneyTax(null);
                        subDocumentSellVO.setSellTax(null);
                        subDocumentSellVO.setTenderNum(null);
                        subDocumentSellVO.setTenderMoney(null);
                        subDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0){
                        subDocumentSellVO.setTenderNum(null);
                        subDocumentSellVO.setTenderMoney(null);
                        subDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(ProsubDocumentSellVO::getDetailId));
                for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList){
                    List<ProsubDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<ProsubDocumentSellVO> subDocumentSellEntities = sellMap.get(subDocumentDetailVO.getId());
                    Map<Long, List<ProsubDocumentSellVO>> sellDetailMap = subDocumentSellEntities.stream().
                            collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key,value) ->{
                        ProsubDocumentSupplierVO subDocumentSupplierVO = new ProsubDocumentSupplierVO();
                        subDocumentSupplierVO.setSupplierId(key);
                        ProsubDocumentSellVO subDocumentSellVO = value.stream().findFirst().get();
                        subDocumentSupplierVO.setSupplierName(subDocumentSellVO.getSupplierName());
                        subDocumentSupplierVO.setProsubDocumentSellVOList(value);
                        documentSupplierVOS.add(subDocumentSupplierVO);
                    });
                    subDocumentDetailVO.setProsubDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<ProsubDocumentDetailVO> subDocumentDetailSellList = subDocumentVO.getSubDocumentDetailList();
                subDocumentVO.setSubDocumentDetailSellList(subDocumentDetailSellList);
            }
        }
        //树形处理
        ProsubInviteVO subInviteVO = subInviteService.queryDetailTree(entity.getInviteId());
        List<ProsubInviteDetailRecordVO> subDetailRecord = subInviteVO.getSubDetailRecord();
        subDocumentVO.setSubDetailRecord(subDetailRecord);
        subDocumentVO.setSubDetailRecord(subDetailRecord);
        return subDocumentVO;
    }

    @Override
    public ProsubDocumentVO queryDocDetailTalk(Long id, Integer talkNum) {

        ProsubDocumentEntity entity = super.selectById(id);
        ProsubDocumentVO stuffDocumentVO = BeanMapper.map(entity, ProsubDocumentVO.class);

        stuffDocumentVO.setSubDocumentSchemeList(null);
        stuffDocumentVO.setSubDocumentSellList(null);
        //处理报名供应商信息
        if (stuffDocumentVO.getNoticeId() != null) {
            LambdaQueryWrapper<ProsubNoticeSupplierEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ProsubNoticeSupplierEntity::getNoticeId, entity.getNoticeId());
            wrapper.ne(ProsubNoticeSupplierEntity::getState, 1);
            List<ProsubNoticeSupplierEntity> list = subNoticeSupplierService.list(wrapper);//未剔除的报名供应商
            if (CollectionUtils.isNotEmpty(list)) {
                List<ProsubNoticeSupplierVO> noticeSupplierVOS = BeanMapper.mapList(list, ProsubNoticeSupplierVO.class);//报名供应商
                Map<Long, ProsubDocumentSupplierVO> documentSupplierVOMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(stuffDocumentVO.getSubDocumentSupplierList())) {//报价供应商
                    documentSupplierVOMap = stuffDocumentVO.getSubDocumentSupplierList().stream().filter(t -> t.getSupplierId() != null).collect(Collectors.toMap(ProsubDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (ProsubNoticeSupplierVO noticeSupplier : noticeSupplierVOS) {
                    if (documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())) {
                        noticeSupplier.setDocumentType(0);//已报价
                    } else {
                        noticeSupplier.setDocumentType(1);//未报价
                    }
                }
                stuffDocumentVO.setSubDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        //处理报价信息,开标之前不能显示
        //按供应商查看报价()
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambda = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambda.eq(ProsubDocumentSupplierEntity::getDocumentId, id);
        lambda.eq(ProsubDocumentSupplierEntity::getTalkNum, talkNum);
        List<ProsubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambda);

        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaDocument = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaDocument.eq(ProsubDocumentSupplierEntity::getDocumentId, id);
        lambdaDocument.ne(ProsubDocumentSupplierEntity::getTalkNum, talkNum);
        List<ProsubDocumentSupplierEntity> supplierListDocument = subDocumentSupplierService.list(lambda);

        if (CollectionUtils.isNotEmpty(supplierList)) {
            List<ProsubDocumentSupplierVO> stuffDocumentSupplierVOS = BeanMapper.mapList(supplierList, ProsubDocumentSupplierVO.class);
            LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, id);
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, talkNum);
            lambdaScheme.orderByAsc(ProsubDocumentSchemeEntity::getSchemeName);
            List<ProsubDocumentSchemeEntity> schemeList = subDocumentSchemeService.list(lambdaScheme);
            Map<Long, List<ProsubDocumentSchemeEntity>> schemeMap = schemeList.stream().
                    collect(Collectors.groupingBy(ProsubDocumentSchemeEntity::getDocumentSupplierId));
            //是否开标,0-是,1-否
            if (entity.getBidFlag() == 0) {
                for (ProsubDocumentSupplierVO stuffDocumentSupplierEntity : stuffDocumentSupplierVOS) {
                    List<ProsubDocumentSchemeEntity> stuffDocumentSchemeEntities = schemeMap.get(stuffDocumentSupplierEntity.getId());
                    String schemeMoney = "";
                    for (ProsubDocumentSchemeEntity stuffDocumentSchemeEntity : stuffDocumentSchemeEntities) {
                        schemeMoney = schemeMoney + stuffDocumentSchemeEntity.getSchemeName() + ":" + stuffDocumentSchemeEntity.getMoneyTax().setScale(2, BigDecimal.ROUND_HALF_DOWN) + "元" + ";";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    stuffDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }

                //处理供应商附件信息
                if (CollectionUtils.isNotEmpty(stuffDocumentSupplierVOS)) {
                    List<Long> attachIds = stuffDocumentSupplierVOS.stream().map(ProsubDocumentSupplierVO::getId).collect(Collectors.toList());

                    Map<String, List<Long>> map = new HashMap<>();
                    map.put("sourceIds", attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);

                    if (listCommonResponse.isSuccess()) {
                        List<AttachmentVO> data = listCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(data)) {
                            List<AttachmentVO> dataDocument = new ArrayList<>();
                            if (CollectionUtils.isNotEmpty(supplierListDocument)) {
                                List<ProsubDocumentSupplierVO> stuffDocumentSupplierVO = BeanMapper.mapList(supplierListDocument, ProsubDocumentSupplierVO.class);
                                List<Long> attachIdsDocument = stuffDocumentSupplierVO.stream().map(ProsubDocumentSupplierVO::getId).collect(Collectors.toList());

                                Map<String, List<Long>> mapDocument = new HashMap<>();
                                map.put("sourceIdsDocument", attachIdsDocument);
                                JSONObject itemJSONObjDocument = JSONObject.parseObject(JSON.toJSONString(mapDocument));
                                CommonResponse<List<AttachmentVO>> listCommonResponseDocument = attachmentApi.queryAllBySourceIdList(itemJSONObjDocument);
                                if (listCommonResponseDocument.isSuccess()) {
                                    dataDocument = listCommonResponseDocument.getData();
                                }
                            }
                            if (CollectionUtils.isNotEmpty(dataDocument)) {
                                for (AttachmentVO datum : data) {
                                    for (AttachmentVO dataDoc : dataDocument) {
                                        if (datum.getFilePath().equals(dataDoc.getFilePath()) && datum.getId() > dataDoc.getId()) {
                                            datum.setId(dataDoc.getId());
                                        }
                                    }
                                }
                            }
                            Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(),(k1, k2) -> k2));
                            for (ProsubDocumentSupplierVO stuffDocumentSupplierVO : stuffDocumentSupplierVOS) {
                                AttachmentVO attachmentVO = attacMap.get(stuffDocumentSupplierVO.getId());
                                if (attachmentVO != null) {
                                    stuffDocumentSupplierVO.setAttachId(attachmentVO.getId());
                                    stuffDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                                }
                            }
                        }
                    }

                    for (ProsubDocumentSupplierVO stuffDocumentSupplierVO : stuffDocumentSupplierVOS) {
                        if (stuffDocumentSupplierVO.getIsMobile() != null){//手机端报价

                            logger.info("-------------------------------id:{},supplierName:{}", id,stuffDocumentSupplierVO.getSupplierName());
                            CommonResponse<List<AttachmentVO>> listCommonResponse1 = attachmentApi.queryListBySourceId(id, null, stuffDocumentSupplierVO.getSupplierName(), null);
                            if (listCommonResponse1.isSuccess()) {
                                List<AttachmentVO> data = listCommonResponse1.getData();
                                logger.info("----------------------------------同步成功");
                                if (CollectionUtils.isNotEmpty(data)) {
                                    stuffDocumentSupplierVO.setAttachId(data.get(0).getId());
                                    stuffDocumentSupplierVO.setFileName(data.get(0).getFileName());
                                }
                            }
                        }
                    }

                }
            }

            //按供应商查看报价
            stuffDocumentVO.setSubDocumentSupplierList(stuffDocumentSupplierVOS);
            //前端键值重复设计
            stuffDocumentVO.setSubDocumentSupplierSchemeList(stuffDocumentSupplierVOS);
            //按材料查看报价
            List<ProsubDocumentDetailVO> stuffDocumentDetailList = stuffDocumentVO.getSubDocumentDetailList();
            //获取材料明细报价
            LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
            lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, id);
            lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, talkNum);
            lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSchemeName);
            List<ProsubDocumentSellEntity> sellList = subDocumentSellService.list(lambdaSell);
            if (CollectionUtils.isNotEmpty(sellList)) {
                List<ProsubDocumentSellVO> stuffDocumentSellVOS = BeanMapper.mapList(sellList, ProsubDocumentSellVO.class);
                for (ProsubDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS) {
                    //是否开标,0-是,1-否
                    if (entity.getBidFlag() == 1) {
                        stuffDocumentSellVO.setPrice(null);
                        stuffDocumentSellVO.setPriceTax(null);
                        stuffDocumentSellVO.setMoney(null);
                        stuffDocumentSellVO.setMoneyTax(null);
                        stuffDocumentSellVO.setSellTax(null);
                        stuffDocumentSellVO.setTenderNum(null);
                        stuffDocumentSellVO.setTenderMoney(null);
                        stuffDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() == 0) {
                        stuffDocumentSellVO.setTenderNum(null);
                        stuffDocumentSellVO.setTenderMoney(null);
                        stuffDocumentSellVO.setTenderFlag(null);
                    }
                }
                Map<Long, List<ProsubDocumentSellVO>> sellMap = stuffDocumentSellVOS.stream().
                        collect(Collectors.groupingBy(ProsubDocumentSellVO::getDetailId));
                for (ProsubDocumentDetailVO stuffDocumentDetailVO : stuffDocumentDetailList) {
                    List<ProsubDocumentSupplierVO> documentSupplierVOS = new ArrayList<>();
                    List<ProsubDocumentSellVO> stuffDocumentSellEntities = sellMap.get(stuffDocumentDetailVO.getId());
//                    Map<Long, List<ProsubDocumentSellVO>> sellDetailMap = stuffDocumentSellEntities.stream().
//                            collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));
//                    sellDetailMap.forEach((key, value) -> {
//                        ProsubDocumentSupplierVO stuffDocumentSupplierVO = new ProsubDocumentSupplierVO();
//                        stuffDocumentSupplierVO.setSupplierId(key);
//                        ProsubDocumentSellVO stuffDocumentSellVO = value.stream().findFirst().get();
//                        stuffDocumentSupplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
//                        stuffDocumentSupplierVO.setProsubDocumentSellVOList(value);
//                        documentSupplierVOS.add(stuffDocumentSupplierVO);
//                    });
                    //非库供应商和在库供应商单独筛选
                    List<ProsubDocumentSellVO> supplierIdVOS = stuffDocumentSellEntities.stream().filter(value -> value.getSupplierId() != null).collect(Collectors.toList());
                    Map<Long, List<ProsubDocumentSellVO>> sellDetailMap = supplierIdVOS.stream().
                            collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key, value) -> {
                        ProsubDocumentSupplierVO stuffDocumentSupplierVO = new ProsubDocumentSupplierVO();
                        stuffDocumentSupplierVO.setSupplierId(key);
                        ProsubDocumentSellVO stuffDocumentSellVO = value.stream().findFirst().get();
                        stuffDocumentSupplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
                        stuffDocumentSupplierVO.setProsubDocumentSellVOList(value);
                        documentSupplierVOS.add(stuffDocumentSupplierVO);
                    });


                    List<ProsubDocumentSellVO> noSupplierIdVOS = stuffDocumentSellEntities.stream().filter(value -> value.getSupplierId() == null && value.getLinkMobile() != null).collect(Collectors.toList());
                    Map<String, List<ProsubDocumentSellVO>> sellDetailNoSupplierIdMap = noSupplierIdVOS.stream().
                            collect(Collectors.groupingBy(ProsubDocumentSellVO::getLinkMobile));
                    sellDetailNoSupplierIdMap.forEach((key, value) -> {
                        ProsubDocumentSupplierVO stuffDocumentSupplierVO = new ProsubDocumentSupplierVO();
                        stuffDocumentSupplierVO.setSupplierId(Long.parseLong(key));
                        ProsubDocumentSellVO stuffDocumentSellVO = value.stream().findFirst().get();
                        stuffDocumentSupplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
                        stuffDocumentSupplierVO.setProsubDocumentSellVOList(value);
                        documentSupplierVOS.add(stuffDocumentSupplierVO);
                    });
                    stuffDocumentDetailVO.setProsubDocumentSupplierVOList(documentSupplierVOS);
                }
                //区分报价详情信息
                List<ProsubDocumentDetailVO> stuffDocumentDetailSellList = stuffDocumentVO.getSubDocumentDetailList();
                stuffDocumentVO.setSubDocumentDetailSellList(stuffDocumentDetailSellList);
            }
        }

        return stuffDocumentVO;
    }

    @Override
    public List<ProsubDocumentSellVO> getSchemeDetail(ProsubDocumentSellVO subDocumentSellVO) {
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getSupplierId,subDocumentSellVO.getSupplierId() );
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId,subDocumentSellVO.getDocumentId() );
        lambdaSell.eq(ProsubDocumentSellEntity::getSchemeId,subDocumentSellVO.getSchemeId() );
        List<ProsubDocumentSellEntity> list = subDocumentSellService.list(lambdaSell);
        List<ProsubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(list,ProsubDocumentSellVO.class);
        return subDocumentSellVOList;
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        ProsubDocumentEntity subDocumentEntity = super.selectById(documentId);
        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = subDocumentSupplierService.selectById(supplierDetailId);
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setSupplierId(subDocumentSupplierEntity.getSupplierId());
        subDocumentSupplierSellVO.setSupplierName(subDocumentSupplierEntity.getSupplierName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        subDocumentSupplierSellVO.setPurchaseType(subDocumentEntity.getPurchaseType());
        subDocumentSupplierSellVO.setValueType(subDocumentEntity.getValueType());
        LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<ProsubDocumentSchemeEntity> subDocumentSchemeEntityList = subDocumentSchemeService.list(lambdaScheme);
        List<ProsubDocumentSchemeVO> subDocumentSchemeVOList = BeanMapper.mapList(subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId,subDocumentSupplierEntity.getDocumentId());
        List<ProsubDocumentSellEntity> subDocumentSellEntityList = subDocumentSellService.list(lambdaSell);
        List<ProsubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(subDocumentSellEntityList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().
                collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
        for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList){
            List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
            if(CollectionUtils.isNotEmpty(subDocumentSellVOS)){
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    ProsubInviteDetailEntity subInviteDetailEntity = subInviteDetailService.selectById(subDocumentSellVO.getDetailId());
                    subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                    subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                }
            }
            subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
        }
        subDocumentSupplierSellVO.setSubDocumentSchemeList(subDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }


        return subDocumentSupplierSellVO;
    }
    @Transactional
    @Override
    public ProsubDocumentVO extendDocument(ProsubDocumentRecordVO subDocumentRecordVO) {
        ProsubDocumentRecordEntity subDocumentRecordEntity = BeanMapper.map(subDocumentRecordVO, ProsubDocumentRecordEntity.class);
        subDocumentRecordService.save(subDocumentRecordEntity);
        ProsubDocumentEntity subDocumentEntity = super.selectById(subDocumentRecordVO.getDocumentId());
        subDocumentEntity.setOfferEndTime(subDocumentRecordVO.getNewTime());
        boolean b = super.updateById(subDocumentEntity);

        //推送供方
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(subDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(subDocumentRecordVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("招标文件同步供方接口报错" + stringCommonResponse.getMsg());
        }

//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,updateTimeUrl, stringFb,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
//        }
        ProsubDocumentVO subDocumentVO = queryDetail(subDocumentRecordVO.getDocumentId());
        return subDocumentVO;
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {

        ProsubTalkEntity subTalkEntity = subTalkService.selectById(talkId);
        Integer talkNum = subTalkEntity.getTalkNum();
        if(subTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        List<ProsubTalkVO> talkVOArrayList = new ArrayList<>();
        String name = null;
        for (int a = 0;a <= talkNum;a++){
            ProsubTalkVO subTalkVO = new ProsubTalkVO();
            subTalkVO.setTalkNum(a);
            if (a == 0){
                name = "首次报价";
            }else {
                name = "第" + a + "轮报价";
            }
            subTalkVO.setTalkNumName(name);
            talkVOArrayList.add(subTalkVO);
        }

        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = subDocumentSupplierService.selectById(supplierDetailId);
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        subDocumentSupplierSellVO.setSupplierName(subDocumentSupplierEntity.getSupplierName());

        for (ProsubTalkVO subTalkVO : talkVOArrayList){
            LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId,subDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getSupplierId,subDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum,subTalkVO.getTalkNum());
            List<ProsubDocumentSchemeEntity> subDocumentSchemeEntityList = subDocumentSchemeService.list(lambdaScheme);
            if(CollectionUtils.isEmpty(subDocumentSchemeEntityList)){
                continue;
            }
            List<ProsubDocumentSchemeVO> subDocumentSchemeVOList = BeanMapper.mapList(subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);

            //获取报价方案详情
            List<Long> schemePkList = subDocumentSchemeVOList.stream().map(ProsubDocumentSchemeVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
            lambdaSell.in(ProsubDocumentSellEntity::getSchemeId,schemePkList);
            List<ProsubDocumentSellEntity> subDocumentSellEntityList = subDocumentSellService.list(lambdaSell);
            List<ProsubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(subDocumentSellEntityList, ProsubDocumentSellVO.class);
            Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().
                    collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
            for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList){
                List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
                if(CollectionUtils.isNotEmpty(subDocumentSellVOS)){
                    for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                        ProsubInviteDetailEntity subInviteDetailEntity = subInviteDetailService.selectById(subDocumentSellVO.getDetailId());
                        subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                        subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                    }
                }
                subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
            }
            subTalkVO.setSubDocumentSchemeList(subDocumentSchemeVOList);
        }
        subDocumentSupplierSellVO.setProsubTalkVOList(talkVOArrayList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return subDocumentSupplierSellVO;
    }

    private Map<String,Object> getFileInfo(Long sourceId) {
        Map<String, Object> map = new HashMap<>();
        //查询附件
        CommonResponse<List<AttachmentVO>> attachResponse = attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess()){
            List<AttachmentVO> data = attachResponse.getData();
            if(CollectionUtils.isNotEmpty(data)){
                AttachmentVO attachmentVO = data.stream().findFirst().get();
                if(attachmentVO != null){
                    map.put("fileName",attachmentVO.getFileName());
                    map.put("attachId",attachmentVO.getId());
                }


            }
        }
        return map;
    }

    @Override
    public ProsubDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        //更新发布状态
        ProsubDocumentEntity subDocumentEntity = super.selectById(id);
        subDocumentEntity.setPublishFlag(0);
        super.updateById(subDocumentEntity);


        ProsubNoticeSupplierTbVO subNoticeSupplierTbVO = new ProsubNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        subNoticeSupplierTbVO.setSourceType("郑州一建招标文件");
        subNoticeSupplierTbVO.setSourceId(subDocumentEntity.getInviteId().toString());
        ProsubInviteEntity inviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        if (subDocumentEntity.getTenderType()==2){
            subNoticeSupplierTbVO.setNoticeType(2);
        }else {
            subNoticeSupplierTbVO.setNoticeType(3);
        }
        if (subDocumentEntity.getPurchaseType()==1){
            subNoticeSupplierTbVO.setSourceProjectId(null);
            subNoticeSupplierTbVO.setProjectName(null);
            subNoticeSupplierTbVO.setProjectCode(null);
        }else {
            subNoticeSupplierTbVO.setSourceProjectId(subDocumentEntity.getProjectId().toString());
            subNoticeSupplierTbVO.setProjectName(subDocumentEntity.getProjectName());
            subNoticeSupplierTbVO.setProjectCode(subDocumentEntity.getProjectCode());
        }

        subNoticeSupplierTbVO.setSourceOrgId(subDocumentEntity.getOrgId().toString());
        subNoticeSupplierTbVO.setOrgName(subDocumentEntity.getOrgName());
        subNoticeSupplierTbVO.setSourceUnitId(subDocumentEntity.getUnitId().toString());
        subNoticeSupplierTbVO.setUnitName(subDocumentEntity.getUnitName());
        subNoticeSupplierTbVO.setMemo(subDocumentEntity.getMemo());
        subNoticeSupplierTbVO.setType("SUB");
        subNoticeSupplierTbVO.setTenderName(subDocumentEntity.getDocumentName());
        subNoticeSupplierTbVO.setTenderType(subDocumentEntity.getTenderType());
        subNoticeSupplierTbVO.setPurchaseType(subDocumentEntity.getPurchaseType().toString());
        subNoticeSupplierTbVO.setPurchaseName(subDocumentEntity.getPurchaseName());
        subNoticeSupplierTbVO.setSourceEmployeeId(subDocumentEntity.getEmployeeId().toString());
        subNoticeSupplierTbVO.setEmployeeName(subDocumentEntity.getEmployeeName());
        subNoticeSupplierTbVO.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        subNoticeSupplierTbVO.setValueType(subDocumentEntity.getValueType());
        subNoticeSupplierTbVO.setContent(subDocumentEntity.getDocumentContent());
        subNoticeSupplierTbVO.setOfferStartTime(sdf.format(subDocumentEntity.getOfferStartTime()));
        subNoticeSupplierTbVO.setOfferEndTime(sdf.format(subDocumentEntity.getOfferEndTime()));
        subNoticeSupplierTbVO.setBrandFlag(subDocumentEntity.getBrandFlag());
        subNoticeSupplierTbVO.setProjectLinkName(subDocumentEntity.getProjectLinkName());
        subNoticeSupplierTbVO.setProjectLinkPhone(subDocumentEntity.getProjectLinkPhone());
        subNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        subNoticeSupplierTbVO.setSubType(inviteEntity.getSubType());
        subNoticeSupplierTbVO.setProjectQualification(inviteEntity.getProjectQualification());
        subNoticeSupplierTbVO.setPaymentId(inviteEntity.getPaymentId());
        subNoticeSupplierTbVO.setPaymentName(inviteEntity.getPaymentName());
        subNoticeSupplierTbVO.setPayScale(inviteEntity.getPayScale());
        subNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        subNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        subNoticeSupplierTbVO.setSubDescribe(subDocumentEntity.getSubDescribe());
        subNoticeSupplierTbVO.setSettlementClause(inviteEntity.getSettlementClause());
        //插入物资
        List<ProsubNoticeDetailTbVO> subNoticeDetailVOS = new ArrayList<>();
        List<ProsubInviteDetailVO> subInviteDetailVOS = baseMapper.selectSumDetail(subDocumentEntity.getInviteId());
        for (ProsubInviteDetailVO subDocumentDetailEntity : subInviteDetailVOS) {
            ProsubNoticeDetailTbVO subNoticeDetailTbVO = new ProsubNoticeDetailTbVO();
            BeanUtils.copyProperties(subNoticeDetailTbVO,subDocumentDetailEntity);
            subNoticeDetailTbVO.setSourceId(subDocumentEntity.getInviteId().toString());
            subNoticeDetailTbVO.setSourceDetailId(subDocumentDetailEntity.getId().toString());
            subNoticeDetailTbVO.setRate(subDocumentDetailEntity.getTaxRate());

            subNoticeDetailTbVO.setMemo(subDocumentDetailEntity.getSumMemo());
            subNoticeDetailTbVO.setNum(subDocumentDetailEntity.getSumNum());
            subNoticeDetailTbVO.setMny(subDocumentDetailEntity.getSumMoney());
            subNoticeDetailTbVO.setTaxMny(subDocumentDetailEntity.getSumMoneyTax());
            subNoticeDetailVOS.add(subNoticeDetailTbVO);
        }
        subNoticeSupplierTbVO.setSubDetailList(subNoticeDetailVOS);
        //是否是邀请招标
        if (subDocumentEntity.getTenderType()!=2){
            List<ProsubDocumentSupplierDetailEntity> detailEntityList = supplierDetailService.list(new LambdaQueryWrapper<ProsubDocumentSupplierDetailEntity>().eq(ProsubDocumentSupplierDetailEntity::getInviteId, subDocumentEntity.getInviteId()).eq(ProsubDocumentSupplierDetailEntity::getDr, 0));
            List<ProsubNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (ProsubDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                ProsubNoticeSupplierDetailTbVO subNoticeSupplierDetailTbVO = new ProsubNoticeSupplierDetailTbVO();
                subNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                subNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                subNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(subNoticeSupplierDetailTbVO);
            }
            subNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString(subNoticeSupplierTbVO);
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId,appSecret,appHost);
            if (!response.isSuccess()){
                throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            throw new BusinessException("招标文件同步供方接口报错" + response.getMsg());
        }
        return queryDetail(id);
    }
    @Override
    public CommonResponse delSupplier(Long id) {
        ProsubDocumentEntity subDocumentEntity = baseMapper.selectById(id);
        List<ProsubDocumentSupplierEntity> subDocumentSupplierList = supplierMapper.selectList(new QueryWrapper<ProsubDocumentSupplierEntity>().eq("document_id", subDocumentEntity.getId()).eq("dr", 0));
        List<ProsubDocumentSupplierDetailEntity> supplierDetailList = supplierDetailMapper.selectList(new QueryWrapper<ProsubDocumentSupplierDetailEntity>().eq("invite_id", subDocumentEntity.getInviteId()).eq("dr", 0));
        List<Long> oldIds = new ArrayList<>();
        List<Long> newIds = new ArrayList<>();
        subDocumentSupplierList.stream().forEach(it->oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it->newIds.add(it.getSupplierId()));
        List<Long> newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List<ProsubDocumentSupplierDetailEntity> newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        //装填数据
        List<ProsubNoticeSupplierDetailTbVO> signVOList = new ArrayList<>();
        for (ProsubDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            ProsubNoticeSupplierDetailTbVO subNoticeSupplierDetailTbVO = new ProsubNoticeSupplierDetailTbVO();
            subNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            subNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            subNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
            subNoticeSupplierDetailTbVO.setOutReason("超时未报价");
            signVOList.add(subNoticeSupplierDetailTbVO);
        }
        logger.info("剔除的供应商"+JSON.toJSONString(signVOList));
        //调用第三方接口
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), appId,appSecret,appHost);
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("剔除供应商成功");
    }

    @Override
    public ProsubDocumentVO saveManyDocument(Long id) {
        ProsubDocumentEntity subDocumentEntity = new ProsubDocumentEntity();
        //查询招标主表信息
        ProsubInviteEntity inviteEntity = subInviteService.selectById(id);
        //复制主表
        subDocumentEntity.setInviteId(inviteEntity.getId());
        subDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType()==0){
            subDocumentEntity.setProjectId(inviteEntity.getProjectId());
            subDocumentEntity.setProjectName(inviteEntity.getProjectName());
            subDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        subDocumentEntity.setSubType(inviteEntity.getSubType());
        subDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        subDocumentEntity.setOrgId(inviteEntity.getOrgId());
        subDocumentEntity.setOrgName(inviteEntity.getOrgName());
        subDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        subDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        subDocumentEntity.setValueType(inviteEntity.getValueType());
        subDocumentEntity.setUnitId(inviteEntity.getUnitId());
        subDocumentEntity.setUnitName(inviteEntity.getUnitName());
        subDocumentEntity.setTenderType(inviteEntity.getTenderType());
        subDocumentEntity.setSubDescribe(inviteEntity.getSubDescribe());
        subDocumentEntity.setSettlementClause(inviteEntity.getSettlementClause());

        //设置计价方式
        subDocumentEntity.setBidFlag(1);
        subDocumentEntity.setPublishFlag(1);
        subDocumentEntity.setNextFlag(1);


        //复制物资详情
        List<ProsubInviteDetailEntity> subInviteDetailList = inviteEntity.getSubDetail();
        List<ProsubDocumentDetailEntity> subDocumentDetailList = BeanMapper.mapList(subInviteDetailList, ProsubDocumentDetailEntity.class);
        Map<Long, ProsubInviteDetailEntity> detailInviteMap = subInviteDetailList.stream().collect(Collectors.toMap(ProsubInviteDetailEntity::getId, Function.identity()));

        for (ProsubDocumentDetailEntity subDocumentDetailEntity : subDocumentDetailList){
            ProsubInviteDetailEntity subInviteDetailEntity = detailInviteMap.get(subDocumentDetailEntity.getId());
            subDocumentDetailEntity.setMaterialName(subInviteDetailEntity.getDetailName());
            subDocumentDetailEntity.setMaterialCode(subInviteDetailEntity.getDetailCode());
            subDocumentDetailEntity.setMaterialId(subInviteDetailEntity.getDocId());
            subDocumentDetailEntity.setMaterialTypeId(subInviteDetailEntity.getDocCategoryId());
            subDocumentDetailEntity.setRate(subInviteDetailEntity.getTaxRate());
        }
        subDocumentEntity.setSubDocumentDetailList(subDocumentDetailList);

        //复制供应商
        List<ProsubInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List<ProsubDocumentSupplierDetailEntity> subDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, ProsubDocumentSupplierDetailEntity.class);
        for (ProsubDocumentSupplierDetailEntity subDocumentSupplierDetailVO : subDocumentSupplierDetailVOS) {
            subDocumentSupplierDetailVO.setId(null);
            documentSupplierDetailService.saveOrUpdate(subDocumentSupplierDetailVO);
        }

        service.saveOrUpdate(subDocumentEntity, false);

        ProcessEntity processEntity = new ProcessEntity();
        //回写招标阶段
        switch(inviteEntity.getTenderType()){
            case 3:
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("竞争性谈判");
                break;
            case 4:
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("单一来源");
                break;
            case 5:
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("紧急招标");
                break;
            case 2:
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("询价公告");
                break;
        }
        subInviteService.updateById(inviteEntity);
        //回写进展表
        processEntity.setBillId(subDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/fourJzDyJjXj");
        processService.saveOrUpdate(processEntity);
        ProsubDocumentVO vo = BeanMapper.map(subDocumentEntity, ProsubDocumentVO.class);
        return vo;
    }

    @Override
    public ProsubDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        //获取轮数
        ProsubTalkRecordEntity subTalkRecordEntity = subTalkRecordService.selectById(talkId);
        Integer talkNum = subTalkRecordEntity.getTalkNum();
        if (subTalkRecordEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }

        //
        ProsubDocumentSupplierSellVO subDocumentSupplierSellVO = new ProsubDocumentSupplierSellVO();
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = subDocumentSupplierService.selectById(supplierDetailId);
        subDocumentSupplierSellVO.setLinkName(subDocumentSupplierEntity.getLinkName());
        subDocumentSupplierSellVO.setLinkMobile(subDocumentSupplierEntity.getLinkMobile());
        subDocumentSupplierSellVO.setOfferTime(subDocumentSupplierEntity.getOfferTime());
        subDocumentSupplierSellVO.setTaxMemo(subDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId,supplierDetailId);
        List<ProsubDocumentSchemeEntity> subDocumentSchemeEntityList = subDocumentSchemeService.list(lambdaScheme);
        List<ProsubDocumentSchemeVO> subDocumentSchemeVOList = BeanMapper.mapList(subDocumentSchemeEntityList, ProsubDocumentSchemeVO.class);

        //获取报价方案详情
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId,subDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum,talkNum);
        List<ProsubDocumentSellEntity> subDocumentSellEntityList = subDocumentSellService.list(lambdaSell);
        List<ProsubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(subDocumentSellEntityList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOList.stream().
                collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeId));
        for (ProsubDocumentSchemeVO subDocumentSchemeVO : subDocumentSchemeVOList){
            List<ProsubDocumentSellVO> subDocumentSellVOS = sellMap.get(subDocumentSchemeVO.getId());
            if(CollectionUtils.isNotEmpty(subDocumentSellVOS)){
                for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    ProsubInviteDetailEntity subInviteDetailEntity = subInviteDetailService.selectById(subDocumentSellVO.getDetailId());
                    subDocumentSellVO.setInvitePrice(subInviteDetailEntity.getPrice());
                    subDocumentSellVO.setInvitePriceTax(subInviteDetailEntity.getTaxPrice());
                }
            }
            subDocumentSchemeVO.setSubDocumentSellList(subDocumentSellVOS);
        }
        subDocumentSupplierSellVO.setSubDocumentSchemeList(subDocumentSchemeVOList);

        //处理附件
        Map<String, Object> fileInfo = getFileInfo(supplierDetailId);
        if (fileInfo != null){
            if (fileInfo.containsKey("attachId")){
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                subDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")){
                subDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }

        return subDocumentSupplierSellVO;
    }

    @Override
    public ProsubDocumentVO saveDocument(Long noticeId) {
        ProsubDocumentEntity entity = new ProsubDocumentEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询公告主表信息
        ProsubNoticeEntity subNoticeEntity = subNoticeService.selectById(noticeId);
        ProsubInviteEntity subInvite = subInviteService.selectById(subNoticeEntity.getInviteId());
        //复制物资详情
        List<ProsubInviteDetailEntity> subInviteDetailList = subInvite.getSubDetail();
        List<ProsubDocumentDetailEntity> subDocumentDetailList = BeanMapper.mapList(subInviteDetailList, ProsubDocumentDetailEntity.class);
        Map<Long, ProsubInviteDetailEntity> detailInviteMap = subInviteDetailList.stream().collect(Collectors.toMap(ProsubInviteDetailEntity::getId, Function.identity()));

        for (ProsubDocumentDetailEntity subDocumentDetailEntity : subDocumentDetailList){
            ProsubInviteDetailEntity subInviteDetailEntity = detailInviteMap.get(subDocumentDetailEntity.getId());
            subDocumentDetailEntity.setMaterialName(subInviteDetailEntity.getDetailName());
            subDocumentDetailEntity.setMaterialCode(subInviteDetailEntity.getDetailCode());
            subDocumentDetailEntity.setMaterialId(subInviteDetailEntity.getDocId());
            subDocumentDetailEntity.setMaterialTypeId(subInviteDetailEntity.getDocCategoryId());
            subDocumentDetailEntity.setRate(subInviteDetailEntity.getTaxRate());
        }

        entity.setSubDocumentDetailList(subDocumentDetailList);

        //复制主表信息
        entity.setProjectId(subNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(subNoticeEntity.getProjectName());
        entity.setOrgId(subNoticeEntity.getOrgId());
        entity.setOrgName(subNoticeEntity.getOrgName());
        entity.setParentOrgId(subNoticeEntity.getParentOrgId());
        entity.setParentOrgName(subNoticeEntity.getParentOrgName());
        entity.setProjectCode(subNoticeEntity.getProjectCode());
        entity.setDocumentName(subNoticeEntity.getNoticeName());
        entity.setEmployeeId(subNoticeEntity.getEmployeeId());
        entity.setEmployeeName(subNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(subNoticeEntity.getEmployeeMobile());
        entity.setInviteId(subNoticeEntity.getInviteId());
        entity.setPurchaseType(subNoticeEntity.getPurchaseType());
        entity.setTenderType(subNoticeEntity.getTenderType());
        //设置计价方式
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(subNoticeEntity.getInviteId());
        entity.setValueType(subInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSubType(subInviteEntity.getSubType());

        service.saveOrUpdate(entity, false);

        //回写招标阶段
        subInviteEntity.setTenderStage(3);
        subInviteService.updateById(subInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("招标文件");
        processEntity.setTenderId(subNoticeEntity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/document");
        processService.saveOrUpdate(processEntity);
        ProsubDocumentVO vo = BeanMapper.map(entity, ProsubDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        //根据documentId查询数据库中专家数量
        List<ProsubDocumentExpertEntity> expertEntityList = documentExpertService.list(Wrappers.<ProsubDocumentExpertEntity>lambdaQuery()
                .eq(ProsubDocumentExpertEntity::getDocumentId, documentId)
                .eq(ProsubDocumentExpertEntity::getDr, 0)
        );
        int totalNum = expertEntityList.size();
        if(totalNum < 3){
            return CommonResponse.error("所选专家数量至少为3人！",false);
        }
        //判断专家数量是否为单数
        if(totalNum % 2 == 0){
            return CommonResponse.error("所选专家数量必须为单数！",false);
        }

        /**
         * !!!数据量大时会损失精度，目前业务不可能超过，所以进行强制转换
         */
        //筛选出库中集团、项目专家数量
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "集团".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "项目".equals(entity.getExpertFromName())).count();
        //实际需要的数量
        int trueDepartmentExpertNum = (int)Math.ceil(totalNum * 1.0 / 3);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if(departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum){
            return CommonResponse.error("所选专家数量不符合要求！" +
                    "集团专家" + trueDepartmentExpertNum + "个," +
                    "项目专家" + trueProjectExpertNum + "个！",false);
        }
        return CommonResponse.success("专家选取成功！",true);
    }


    @Transactional
    @Override
    public Boolean localPushSell(Map<String, Object> params, MultipartFile file) {

        logger.info("专业分包进入本地报价接口request-{}", params);
        String notice = JSON.toJSONString(params);
        logger.info("实体信息-{}", notice);
        ProsubSupplierSellVO pushVO = JSON.parseObject(notice, new TypeReference<ProsubSupplierSellVO>() {
        });

        JSONObject jsonObject = new JSONObject(params);
        String sourceSupplierName = jsonObject.getString("sourceSupplierName");
        String signEmployeeMobile = jsonObject.getString("signEmployeeMobile");
        if (StringUtils.isEmpty(sourceSupplierName)){
            throw new BusinessException("手机号为空!请联系系统管理员处理！");
        }
        String signEmployeeName = jsonObject.getString("signEmployeeName");

        //处理业务数据
        //noticeType,类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判
        //转换轮数
       ProsubInviteEntity subInviteEntity = subInviteService.selectById(Long.parseLong(pushVO.getSourceId()));
        Integer tenderStage = subInviteEntity.getTenderStage();
        long time = new Date().getTime();
        //招标阶段(3-招标文件,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            //查询轮数
            LambdaQueryWrapper<ProsubTalkEntity> lambdaTalk = Wrappers.<ProsubTalkEntity>lambdaQuery();
            lambdaTalk.eq(ProsubTalkEntity::getInviteId, Long.parseLong(pushVO.getSourceId()));
            ProsubTalkEntity subTalkEntity = subTalkService.getOne(lambdaTalk);
            talkNum = subTalkEntity.getTalkNum();

            if (time < subTalkEntity.getTalkStartTime().getTime() || time > subTalkEntity.getTalkEndTime().getTime()) {
                throw new BusinessException("报价时间为：" + subTalkEntity.getTalkStartTime() + "-" + subTalkEntity.getTalkEndTime());
            }

        }

        long sourceSupplierId;
        SupplierDTO supplierVO = new SupplierDTO();

        if (pushVO.getSourceSupplierId() != null) {
            //转换
            sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
            supplierVO = shareSupplierApi.queryById(sourceSupplierId).getData();
        } else {
            sourceSupplierId = -1;
        }
        //处理供应商信息
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper<ProsubDocumentEntity> lambdaDocument = Wrappers.<ProsubDocumentEntity>lambdaQuery();
        lambdaDocument.eq(ProsubDocumentEntity::getInviteId, inviteId);
        ProsubDocumentEntity subDocumentEntity = baseMapper.selectOne(lambdaDocument);

        CommonResponse<List<AttachmentVO>> listCommonResponse1 = attachmentApi.queryListBySourceId(subDocumentEntity.getId(), null, sourceSupplierName, null);
        if (listCommonResponse1.isSuccess()) {
            List<AttachmentVO> data = listCommonResponse1.getData();
            if (CollectionUtils.isEmpty(data)) {
                throw new BusinessException("投标文件未上传成功，请更换浏览器重新上传！");
            }
        }
        if (tenderStage != 7) {
            if (time < subDocumentEntity.getOfferStartTime().getTime() || time > subDocumentEntity.getOfferEndTime().getTime()) {
                throw new BusinessException("报价时间为：" + subDocumentEntity.getOfferStartTime() + "-" + subDocumentEntity.getOfferEndTime());
            }
        }
        if(subDocumentEntity.getBillState() != 1  &&  subDocumentEntity.getBillState() != 3) {
            throw new BusinessException("单据尚未提交!");
        }
        //先删后增
        //根据供应商主键和招标文件主键查询供应商信息,判断新增和修改
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplier = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();

        /**如果手机端报价供应商不在库中**/
        if (sourceSupplierId != -1 && supplierVO != null) {
            lambdaSupplier.eq(ProsubDocumentSupplierEntity::getSupplierId, sourceSupplierId);
        } else {
            lambdaSupplier.eq(ProsubDocumentSupplierEntity::getLinkMobile, signEmployeeMobile);
        }

        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, subDocumentEntity.getId());
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, talkNum);
        ProsubDocumentSupplierEntity subDocumentSupplierEntity = subDocumentSupplierService.getOne(lambdaSupplier);

        Long documentSupplierId = null;
        if (subDocumentSupplierEntity != null) {
            //更新供应商信息
            subDocumentSupplierEntity.setOfferTime(new Date());
            subDocumentSupplierEntity.setLinkName(signEmployeeName);
            subDocumentSupplierEntity.setLinkMobile(signEmployeeMobile);
            subDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            subDocumentSupplierEntity.setIsMobile(1);
            subDocumentSupplierService.updateById(subDocumentSupplierEntity);
            /**
             * 处理手机端报价附件
             */
            CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                    String.valueOf(subDocumentEntity.getId()), "BT211119000000003", "mobilePush",
                    String.valueOf(subDocumentSupplierEntity.getId()), "BT202202000004", "supplierFileType");
            logger.info("手机端合同同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());

            documentSupplierId = subDocumentSupplierEntity.getId();

            //删除方案信息
            LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
            lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentSupplierId, subDocumentSupplierEntity.getId());
            subDocumentSchemeService.remove(lambdaScheme);
        }
        if (subDocumentSupplierEntity == null) {
            //新增供应商信息
            ProsubDocumentSupplierEntity subDocumentSupplierEntityAdd = new ProsubDocumentSupplierEntity();
            if (sourceSupplierId != -1  && supplierVO != null) {
                subDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
                subDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
                subDocumentSupplierEntityAdd.setSupplierName(sourceSupplierName);
                subDocumentSupplierEntityAdd.setIsMobile(1);
            } else {
                subDocumentSupplierEntityAdd.setSupplierName(sourceSupplierName);
                subDocumentSupplierEntityAdd.setSupplierId(Long.parseLong(signEmployeeMobile));
            }
            subDocumentSupplierEntityAdd.setLinkName(signEmployeeName);
            subDocumentSupplierEntityAdd.setLinkMobile(signEmployeeMobile);
            subDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            subDocumentSupplierEntityAdd.setOfferTime(new Date());
            subDocumentSupplierEntityAdd.setDocumentId(subDocumentEntity.getId());
            subDocumentSupplierEntityAdd.setTalkNum(talkNum);
            subDocumentSupplierEntityAdd.setIsMobile(1);
            boolean save = subDocumentSupplierService.save(subDocumentSupplierEntityAdd);

            documentSupplierId = subDocumentSupplierEntityAdd.getId();
            /**
             * 处理手机端报价附件
             */
            CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                    String.valueOf(subDocumentEntity.getId()), "BT211119000000003", "mobilePush",
                    String.valueOf(documentSupplierId), "BT202202000004", "supplierFileType");
            logger.info("手机端合同同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());

        }

        //处理方案信息
        List<ProsubSupplierSellSchemeVO> schemeList = pushVO.getSubSchemeList();
        List<ProsubDocumentSchemeEntity> subDocumentSchemeEntityArrayList = new ArrayList<>();
        //所有报价详情信息
        List<ProsubDocumentSellVO> subDocumentSellVOList = new ArrayList<>();
        for (ProsubSupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            ProsubDocumentSchemeEntity subDocumentSchemeEntity = new ProsubDocumentSchemeEntity();
            subDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            subDocumentSchemeEntity.setDocumentId(subDocumentEntity.getId());
            if (sourceSupplierId != -1 && supplierVO != null) {
                subDocumentSchemeEntity.setSupplierId(sourceSupplierId);
                subDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
                subDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            } else {
                subDocumentSchemeEntity.setSupplierName(sourceSupplierName);
                subDocumentSchemeEntity.setSupplierId(Long.parseLong(signEmployeeMobile));
            }
            subDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            subDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMny());
            subDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getTaxMny());
            subDocumentSchemeEntity.setTalkNum(talkNum);
            subDocumentSchemeEntity.setId(IdWorker.getId());
            subDocumentSchemeEntity.setPassFlag(1);
            subDocumentSchemeEntity.setIsMobile(1);

            subDocumentSchemeEntityArrayList.add(subDocumentSchemeEntity);

            //处理报价详情与方案的关联关系
            List<ProsubSupplierSellSchemeDetailVO> schemeDetailList = supplierSellSchemeVO.getSubSchemeDetailList();
            for (ProsubSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                ProsubDocumentSellVO subDocumentSellVO = new ProsubDocumentSellVO();
//                subDocumentSellVO.setProjectId(subDocumentEntity.getProjectId());
//                subDocumentSellVO.setProjectName(subDocumentEntity.getProjectName());
                subDocumentSellVO.setSchemeId(subDocumentSchemeEntity.getId());
                subDocumentSellVO.setDocumentId(subDocumentEntity.getId());
                if (sourceSupplierId != -1 && supplierVO != null) {
                    subDocumentSellVO.setSupplierId(sourceSupplierId);
                    subDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                    subDocumentSellVO.setSupplierName(supplierVO.getName());
                } else {
                    subDocumentSellVO.setLinkMobile(signEmployeeMobile);
                    subDocumentSellVO.setSupplierName(sourceSupplierName);
                    subDocumentSellVO.setSupplierId(Long.parseLong(signEmployeeMobile));
                }
                subDocumentSellVO.setMaterialId(supplierSellSchemeDetailVO.getSourceDetailId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceDetailId()) : null);
                subDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getDetailName());
                subDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getDetailCode());
                subDocumentSellVO.setMaterialTypeId(supplierSellSchemeDetailVO.getSourceMaterialTypeId() != null ? Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId()) : null);
                subDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                subDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                subDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
//                subDocumentSellVO.setNum(supplierSellSchemeDetailVO.getNum());
                subDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                subDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                subDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                subDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
//                subDocumentSellVO.setMoney(supplierSellSchemeDetailVO.getMoney());
//                subDocumentSellVO.setMoneyTax(supplierSellSchemeDetailVO.getMoneyTax());
//                subDocumentSellVO.setSellTax(supplierSellSchemeDetailVO.getTax());
                subDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                subDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());

//                subDocumentSellVO.setInfoPrice(supplierSellSchemeDetailVO.getInfoPrice());
//                subDocumentSellVO.setFallRate(supplierSellSchemeDetailVO.getFallRate());
//                subDocumentSellVO.setFallMny(supplierSellSchemeDetailVO.getFallMny());

                subDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                subDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                subDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                //subDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                subDocumentSellVO.setReferFlag(2);
                subDocumentSellVO.setPassFlag(1);
                subDocumentSellVO.setTalkNum(talkNum);
                subDocumentSellVO.setIsMobile(1);

                subDocumentSellVOList.add(subDocumentSellVO);

            }

        }
        //新增方案
        subDocumentSchemeService.saveBatch(subDocumentSchemeEntityArrayList);

        //处理报价详情信息
        //删除报价信息
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        if (sourceSupplierId != -1 && supplierVO != null) {
            lambdaSell.eq(ProsubDocumentSellEntity::getSupplierId, sourceSupplierId);
        } else {
            lambdaSell.eq(ProsubDocumentSellEntity::getLinkMobile, signEmployeeMobile);
        }
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, talkNum);
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, subDocumentEntity.getId());
        subDocumentSellService.remove(lambdaSell);

        //处理报价详情信息
        LambdaQueryWrapper<ProsubDocumentDetailEntity> lambdaDetail = Wrappers.<ProsubDocumentDetailEntity>lambdaQuery();
        lambdaDetail.eq(ProsubDocumentDetailEntity::getDocumentId, subDocumentEntity.getId());
        List<ProsubDocumentDetailEntity> subDocumentDetailList = subDocumentDetailService.list(lambdaDetail);

        List<ProsubDocumentSellEntity> subDocumentSellEntityArrayList = new ArrayList<>();
        for (ProsubDocumentDetailEntity subDocumentDetailEntity : subDocumentDetailList) {
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                //判断是否只有分类
                if (subDocumentDetailEntity.getMaterialId() != null) {
                    if (subInviteEntity.getPurchaseType() == 1) {//单位采购
                        if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                                subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) &&
                                subDocumentDetailEntity.getRate().compareTo(subDocumentSellVO.getDetailRate()) == 0) {
                            ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                            subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                            subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                            subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                            subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                            subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                            subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                            subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                            // 备注拆分
                            subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                            subDocumentSellEntity.setIsMobile(1);

                            subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                        }
                    } else {
                        if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                                subDocumentDetailEntity.getMaterialId().equals(subDocumentSellVO.getMaterialId()) &&
                                // subDocumentDetailEntity.getCalculateType().equals(subDocumentSellVO.getCalculateType()) &&
                                subDocumentDetailEntity.getRate().compareTo(subDocumentSellVO.getDetailRate()) == 0) {
                            ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                            subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                            subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                            subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                            subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                            subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                            subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                            subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                            // 备注拆分
                            subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                            subDocumentSellEntity.setIsMobile(1);
                            subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                        }
                    }
                }
                if (subDocumentDetailEntity.getMaterialId() == null) {
                    if (subDocumentDetailEntity.getMaterialTypeId().equals(subDocumentSellVO.getMaterialTypeId()) &&
                            //(subDocumentDetailEntity.getCalculateType() == null || subDocumentDetailEntity.getCalculateType().equals(subDocumentSellVO.getCalculateType())) &&
                            subDocumentDetailEntity.getRate().compareTo(subDocumentSellVO.getDetailRate()) == 0) {
                        ProsubDocumentSellEntity subDocumentSellEntity = BeanMapper.map(subDocumentSellVO, ProsubDocumentSellEntity.class);
                        subDocumentSellEntity.setDetailId(subDocumentDetailEntity.getId());
                        subDocumentSellEntity.setProjectId(subDocumentDetailEntity.getDetailProjectId());
                        subDocumentSellEntity.setProjectName(subDocumentDetailEntity.getDetailProjectName());
                        subDocumentSellEntity.setNum(subDocumentDetailEntity.getNum());
                        subDocumentSellEntity.setMoney(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPrice()));
                        subDocumentSellEntity.setMoneyTax(subDocumentDetailEntity.getNum().multiply(subDocumentSellEntity.getPriceTax()));
                        subDocumentSellEntity.setSellTax(subDocumentSellEntity.getMoneyTax().subtract(subDocumentSellEntity.getMoney()));
                        // 备注拆分
                        subDocumentSellEntity.setMaterialMemo(subDocumentDetailEntity.getMemo());
                        subDocumentSellEntity.setIsMobile(1);
                        subDocumentSellEntityArrayList.add(subDocumentSellEntity);
                    }
                }

            }

        }
        //新增报价信息
        subDocumentSellService.saveBatch(subDocumentSellEntityArrayList);

        //先删除附件
        if (documentSupplierId != null) {
            logger.info("删除供应商[{}]附件信息，billType[{}]，sourceType[supplierFileType]", documentSupplierId, BILL_SUPPLIER_TYPE);
//            CommonResponse<String> deleteRtn = attachmentApi.deleteFileByParam(documentSupplierId, BILL_SUPPLIER_TYPE,"supplierFileType");
            CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List<AttachmentVO> attachmentVOList = attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOList)) {
                logger.info("开始删除附件信息-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
                logger.info("删除文件结束，删除结果：{}", deleteResponse.getData());
            }
        }
        //处理附件
//        if(file != null){
//            logger.info(request+"报价文件名称- {}",file.getOriginalFilename());
//            logger.info(request+"供应商表主键- {}",documentSupplierId);
//            Boolean upFlag = new ThirdSystemUtils().upFile(BASE_HOST,"supplierFileType",Long.toString(documentSupplierId),BILL_SUPPLIER_TYPE,file,request);
//            logger.info(request+"文件上传结果-{}",upFlag);
//        }
        //TODO
//        List<SupplyFileVo> pzList = pushVO.getSupplyFileList();
//        logger.info("报名文件:{}", JSONObject.toJSONString(pzList));
//        if (CollectionUtils.isNotEmpty(pzList)) {
//            List<AttachmentVO> list = new ArrayList<>();
//            for (SupplyFileVo e : pzList) {
//                AttachmentVO attachmentVO = new AttachmentVO();
//                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
//                attachmentVO.setSourceId(documentSupplierId);
//                attachmentVO.setSourceType("supplierFileType");
//                attachmentVO.setFilePath(e.getFilePath());
//                attachmentVO.setOnlinePath(e.getFilePath());
//                attachmentVO.setFileName(e.getFileName());
//                attachmentVO.setId(e.getFileId());
//                list.add(attachmentVO);
//                logger.info("保存文件信息:{}", JSONObject.toJSONString(attachmentVO));
//            }
//            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
//            logger.info(request + "报名文件上传结果-{}", JSONObject.toJSONString(stringCommonResponse));
//        }
        return true;
    }

    @Autowired
    private IStuffCheckService stuffCheckService;
    @Override
    public CommonResponse<Boolean> synSupplier(Long documentId) {

        //从报价详情表查找 中标的供应商是否同步信息
        List<ProsubDocumentSellEntity> stuffDocumentSell = subDocumentSellService.list(Wrappers.<ProsubDocumentSellEntity>lambdaQuery()
                .eq(ProsubDocumentSellEntity::getDocumentId, documentId)
                .eq(ProsubDocumentSellEntity::getTenderFlag,1)
        );
        if (CollectionUtils.isNotEmpty(stuffDocumentSell)) {
            //从报价详情表查找supplierId为空的供应商
            List<ProsubDocumentSellEntity> stuffDocumentSellEntities = subDocumentSellService.list(Wrappers.<ProsubDocumentSellEntity>lambdaQuery()
                    .eq(ProsubDocumentSellEntity::getDocumentId, documentId)
                    .eq(ProsubDocumentSellEntity::getTenderFlag,1)
                    .isNull(ProsubDocumentSellEntity::getSupplierTenantId)
            );
            if (ListUtil.isNotEmpty(stuffDocumentSellEntities)) {
                //查找供应商为空的手机号
                List<String> phones = stuffDocumentSellEntities.stream().map(ProsubDocumentSellEntity::getLinkMobile).collect(Collectors.toList());
                Map<String, Long> stuffDocumentSchemeIdMap = stuffDocumentSellEntities.stream().collect(Collectors.toMap(ProsubDocumentSellEntity::getLinkMobile, ProsubDocumentSellEntity::getSchemeId,(k1,k2)->k1));
                //根据手机号查找纳税人识别号
                List<StuffCheckEntity> list = stuffCheckService.list(Wrappers.<StuffCheckEntity>lambdaQuery()
                        .in(StuffCheckEntity::getPhone, phones)
                        .eq(StuffCheckEntity::getDocumentId, documentId)
                );
                boolean updateDocumentSell = false;
                boolean updateDocumentScheme = false;
                boolean updateDocumentSupplier = false;
                //map<手机号，纳税人识别号>转化为<手机号，供应商id>
                Map<Long, String> taxPayerIdentifierMap = list.stream().collect(Collectors.toMap(StuffCheckEntity::getPhone, StuffCheckEntity::getTaxPayerIdentifier));
                for (Map.Entry<Long, String> entry : taxPayerIdentifierMap.entrySet()) {
                    CommonResponse<SupplierDTO> supplierDTOCommonResponse = shareSupplierApi.selectByTaxpayerNum(entry.getValue());
                    if (supplierDTOCommonResponse.isSuccess()) {
                        SupplierDTO supplierDTO = supplierDTOCommonResponse.getData();
                        if (supplierDTO.getTenant() == null) {
                            return CommonResponse.error("供应商邀请准入后，请先进行供方协同！");
                        }
                        entry.setValue(supplierDTO.getId().toString());
                        updateDocumentSell = subDocumentSellService.update(Wrappers.<ProsubDocumentSellEntity>lambdaUpdate()
                                .set(ProsubDocumentSellEntity::getSupplierTenantId, supplierDTO.getTenant())
                                .set(ProsubDocumentSellEntity::getSupplierId, supplierDTO.getId())
                                .eq(ProsubDocumentSellEntity::getDocumentId, documentId)
                                .isNull(ProsubDocumentSellEntity::getSupplierTenantId)
                                .eq(ProsubDocumentSellEntity::getLinkMobile, entry.getKey().toString())
                        );
                        logger.info("供应商id同步报价详情表{}", updateDocumentSell);

                        updateDocumentScheme = subDocumentSchemeService.update(Wrappers.<ProsubDocumentSchemeEntity>lambdaUpdate()
                                .set(ProsubDocumentSchemeEntity::getSupplierTenantId, supplierDTO.getTenant())
                                .set(ProsubDocumentSchemeEntity::getSupplierId, supplierDTO.getId())
                                .eq(ProsubDocumentSchemeEntity::getDocumentId, documentId)
                                .isNull(ProsubDocumentSchemeEntity::getSupplierTenantId)
                                .eq(ProsubDocumentSchemeEntity::getId, stuffDocumentSchemeIdMap.get(entry.getKey().toString()))
                        );
                        logger.info("供应商id同步报价方案表{}", updateDocumentScheme);

                        updateDocumentSupplier = subDocumentSupplierService.update(Wrappers.<ProsubDocumentSupplierEntity>lambdaUpdate()
                                .set(ProsubDocumentSupplierEntity::getSupplierId, supplierDTO.getId())
                                .set(ProsubDocumentSupplierEntity::getSupplierTenantId, supplierDTO.getTenant())
                                .eq(ProsubDocumentSupplierEntity::getDocumentId, documentId)
                                .isNull(ProsubDocumentSupplierEntity::getSupplierTenantId)
                                .eq(ProsubDocumentSupplierEntity::getLinkMobile, entry.getKey().toString())
                        );
                        logger.info("供应商id同步供应商表{}", updateDocumentSupplier);

//                    updateDocumentSupplier = stuffPicketageSupplierService.update(Wrappers.<ProsubPicketageSupplierEntity>lambdaUpdate()
//                            .set(ProsubPicketageSupplierEntity::getSupplierId, supplierDTO.getId())
//                            .eq(ProsubPicketageSupplierEntity::getPicketageId, picketageId)
//                            .isNull(ProsubPicketageSupplierEntity::getSupplierId)
//                            .eq(ProsubDocumentSupplierEntity::getLinkMobile, entry.getKey().toString())
//                    );
//                    logger.info("供应商id同步供应商表{}",updateDocumentSupplier);

                    } else {
                        return CommonResponse.error("请先进行供应商邀请进行准入！");
                    }
                }
                if (updateDocumentSell && updateDocumentScheme && updateDocumentSupplier) {
                    return CommonResponse.success("供应商信息同步成功！");
                } else {
                    return CommonResponse.error("供应商信息同步失败！");
                }
            }
            return CommonResponse.success("供应商信息同步成功！");
        }else {
            return CommonResponse.success("请先选择中标的供应商，再同步供应商信息！");
        }
    }
}
