package com.ejianc.business.tender.rmat.controller;

import com.ejianc.business.tender.rmat.vo.RmatWinnoticeVO;
import com.ejianc.business.tender.rmat.bean.RmatWinnoticeEntity;
import com.ejianc.business.tender.rmat.service.IRmatWinnoticeService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 中标公告表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rmatWinnotice")
@Api(value = "中标公告表", tags = {"中标公告表"})
public class RmatWinnoticeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRmatWinnoticeService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "rmat-winnotice-code";

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatWinnoticeVO> saveOrUpdates(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody RmatWinnoticeVO saveorUpdateVO) {
    	RmatWinnoticeEntity entity = BeanMapper.map(saveorUpdateVO, RmatWinnoticeEntity.class);
        if(entity.getBillCode() == null){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        RmatWinnoticeVO vo = service.saveOrUpdates(entity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishWinnotice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatWinnoticeVO> publishWinnotice(@RequestParam Long id) throws Exception {
        return CommonResponse.success("发布成功！",service.publishWinnotice(id));
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatWinnoticeVO> queryDetail(@RequestParam Long id) {
        RmatWinnoticeVO rmatWinnoticeVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",rmatWinnoticeVO);
    }
    @ApiOperation("生成中公告接口")
    @RequestMapping(value = "/saveWinnotice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatWinnoticeVO> saveWinnotice(@RequestParam Long picketageId) {
        RmatWinnoticeVO rmatWinnoticeVO = service.saveWinnotice(picketageId);
        return CommonResponse.success("保存或修改单据成功！",rmatWinnoticeVO);
    }

}
