package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jcajce.provider.symmetric.Camellia;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.tender.stuff.bean.StuffDocumentExpertEntity;
import com.ejianc.business.tender.stuff.service.IStuffDocumentExpertService;
import com.ejianc.business.tender.stuff.vo.StuffDocumentExpertVO;

/**
 * 招标文件专家表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("stuffDocumentExpert")
@Api(value = "招标文件专家表", tags = {"招标文件专家表"})
public class StuffDocumentExpertController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IStuffDocumentExpertService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffDocumentExpertVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody StuffDocumentExpertVO saveOrUpdateVO) {
    	StuffDocumentExpertEntity entity = BeanMapper.map(saveOrUpdateVO, StuffDocumentExpertEntity.class);
    	service.saveOrUpdate(entity, false);
    	StuffDocumentExpertVO vo = BeanMapper.map(entity, StuffDocumentExpertVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffDocumentExpertVO> queryDetail(@RequestParam Long id) {
    	StuffDocumentExpertEntity entity = service.selectById(id);
    	StuffDocumentExpertVO vo = BeanMapper.map(entity, StuffDocumentExpertVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量新增")
    @RequestMapping(value = "/addBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<StuffDocumentExpertEntity>> addBatch(@RequestBody StuffDocumentVO stuffDocumentVO) {
        List<StuffDocumentExpertEntity> list = service.addBatch(stuffDocumentVO);
        return CommonResponse.success("新增成功！",list);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deleteByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<StuffDocumentExpertEntity>> deleteByIds(@RequestBody List<Long> vos) {
        List<StuffDocumentExpertEntity> list = service.deleteByIds(vos);

        return CommonResponse.success("删除成功！",list);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




}
