/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatWinnoticeEntity;
import com.ejianc.business.tender.rmat.mapper.RmatWinnoticeMapper;
import com.ejianc.business.tender.rmat.service.IRmatBidDetailService;
import com.ejianc.business.tender.rmat.service.IRmatBidSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSellService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatWinnoticeService;
import com.ejianc.business.tender.rmat.vo.RmatPicketageSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatWinDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatWinVO;
import com.ejianc.business.tender.rmat.vo.RmatWinnoticeVO;
import com.ejianc.business.tender.rmat.vo.TenderStageEnum;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rmatWinnoticeService")
public class RmatWinnoticeServiceImpl
extends BaseServiceImpl<RmatWinnoticeMapper, RmatWinnoticeEntity>
implements IRmatWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatNoticeService rmatNoticeService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatBidDetailService rmatBidDetailService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatBidSupplierService rmatBidSupplierService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRmatPicketageSupplierService rmatPicketageSupplierService;
    private static final String BILL_TYPE = "BT220210000000014";
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional
    public RmatWinnoticeVO saveWinnotice(Long picketageId) {
        RmatWinnoticeEntity entity = new RmatWinnoticeEntity();
        entity.setPicketageId(picketageId);
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)this.rmatPicketageService.selectById(picketageId));
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatPicketageEntity.getInviteId()));
        entity.setInviteId(rmatPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName() + "\u4e2d\u6807\u516c\u544a");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        if (inviteEntity.getPurchaseType().equals(0)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)this.rmatDocumentService.selectById(rmatPicketageEntity.getDocumentId()));
        entity.setEmployeeId(rmatDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);
        entity.setLineTypeName(CommonUtils.getTypeName(4));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate((Object)entity, false);
        rmatPicketageEntity.setWinnoticeStatus(1);
        rmatPicketageEntity.setWinnoticeId(entity.getId());
        this.rmatPicketageService.updateById((Object)rmatPicketageEntity);
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        this.rmatInviteService.updateById((Object)inviteEntity);
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        for (RmatPicketageSupplierEntity rmatPicketageSupplierEntity : picketageSupplierList) {
            rmatPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        this.rmatPicketageSupplierService.updateBatchById(picketageSupplierList);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rmat/winnotice");
        this.processService.saveOrUpdate((Object)processEntity);
        RmatWinnoticeVO rmatWinnoticeVO = (RmatWinnoticeVO)BeanMapper.map((Object)((Object)entity), RmatWinnoticeVO.class);
        return rmatWinnoticeVO;
    }

    @Override
    public RmatWinnoticeVO queryDetail(Long id) {
        Map attacMap;
        AttachmentVO attachmentVO;
        List data;
        Long id1;
        CommonResponse listCommonResponse;
        RmatWinnoticeEntity rmatWinnoticeEntity = (RmatWinnoticeEntity)((Object)super.selectById((Serializable)id));
        RmatWinnoticeVO rmatWinnoticeVO = (RmatWinnoticeVO)BeanMapper.map((Object)((Object)rmatWinnoticeEntity), RmatWinnoticeVO.class);
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)this.rmatPicketageService.selectById(rmatWinnoticeEntity.getPicketageId()));
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        List rmatPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, RmatPicketageSupplierVO.class);
        rmatWinnoticeVO.setPicketageSupplierList(rmatPicketageSupplierList);
        if (rmatWinnoticeVO != null && (listCommonResponse = this.attachmentApi.queryListBySourceId(id1 = rmatWinnoticeVO.getId(), BILL_TYPE, "tenderWinnotice", "")).isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData())) && (attachmentVO = (AttachmentVO)(attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()))).get(rmatWinnoticeVO.getId())) != null) {
            rmatWinnoticeVO.setAttachId(attachmentVO.getId());
            rmatWinnoticeVO.setFileName(attachmentVO.getFileName());
            rmatWinnoticeVO.setFilePath(attachmentVO.getFilePath());
        }
        return rmatWinnoticeVO;
    }

    @Override
    public RmatWinnoticeVO publishWinnotice(Long id) {
        RmatWinnoticeEntity rmatWinnoticeEntity = (RmatWinnoticeEntity)((Object)super.selectById((Serializable)id));
        rmatWinnoticeEntity.setPublishFlag(0);
        super.updateById((Object)rmatWinnoticeEntity);
        RmatPicketageEntity rmatPicketageEntity = (RmatPicketageEntity)((Object)this.rmatPicketageService.selectById(rmatWinnoticeEntity.getPicketageId()));
        rmatPicketageEntity.setWinnoticeStatus(2);
        this.rmatPicketageService.updateById((Object)rmatPicketageEntity);
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatPicketageEntity.getInviteId()));
        RmatWinVO winVO = new RmatWinVO();
        winVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u4e2d\u6807\u516c\u544a");
        winVO.setSourceId(Long.toString(rmatWinnoticeEntity.getInviteId()));
        winVO.setBillCode(rmatInviteEntity.getBillCode());
        if (rmatInviteEntity.getPurchaseType() == 0) {
            winVO.setSourceProjectId(Long.toString(rmatInviteEntity.getProjectId()));
            winVO.setProjectName(rmatInviteEntity.getProjectName());
            winVO.setProjectCode(rmatInviteEntity.getProjectCode());
        }
        if (rmatInviteEntity.getPurchaseType() == 1) {
            winVO.setOrgName(rmatInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(rmatInviteEntity.getOrgId()));
        }
        winVO.setSourceUnitId(Long.toString(rmatInviteEntity.getUnitId()));
        winVO.setUnitName(rmatInviteEntity.getUnitName());
        winVO.setType("RMAT");
        winVO.setTenderName(rmatInviteEntity.getTenderName());
        winVO.setTenderType(rmatInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(rmatWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(rmatWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(rmatWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(rmatInviteEntity.getPurchaseType());
        winVO.setWinDate(rmatWinnoticeEntity.getWinDate());
        winVO.setStopDate(rmatWinnoticeEntity.getStopDate());
        winVO.setWinTitle(rmatWinnoticeEntity.getTitleName());
        winVO.setMemo(rmatWinnoticeEntity.getMemo());
        winVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        ArrayList<RmatWinDetailVO> winDetailVOS = new ArrayList<RmatWinDetailVO>();
        for (RmatPicketageSupplierEntity rmatPicketageSupplierEntity : picketageSupplierList) {
            RmatWinDetailVO winDetailVO = new RmatWinDetailVO();
            winDetailVO.setWinId(rmatWinnoticeEntity.getId());
            winDetailVO.setSupplierName(rmatPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(rmatPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(rmatPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(rmatPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString((Object)winVO);
        this.logger.info("\u4e2d\u6807\u516c\u544a\u53d1\u5e03" + stringFb);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winSaveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u516c\u544a\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public RmatWinnoticeVO saveOrUpdates(RmatWinnoticeEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        RmatWinnoticeEntity rmatWinnoticeEntity = (RmatWinnoticeEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            rmatWinnoticeEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            rmatWinnoticeEntity.setSignFlag(1);
        }
        if (status == 4) {
            rmatWinnoticeEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(rmatWinnoticeEntity.getId());
            cv.setContractName(rmatWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)rmatWinnoticeEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }
}

