
package com.ejianc.business.tender.abolish.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.material.api.IMaterialBatchPlanApi;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.purchaseplan.vo.api.IPurchasePlanApi;
import com.ejianc.business.rent.api.IRentPlanApi;
import com.ejianc.business.rent.vo.RentPlanEnum;
import com.ejianc.business.tender.abolish.bean.FlowEntity;
import com.ejianc.business.tender.abolish.service.IFlowService;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentExpertEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailRecordEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentExpertService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteDetailRecordService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentExpertEntity;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentExpertEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailRecordEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentExpertEntity;
import com.ejianc.business.tender.rent.bean.RentInviteDetailRecordEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentDocumentExpertService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentInviteDetailRecordService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentExpertEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatDocumentExpertService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentExpertEntity;
import com.ejianc.business.tender.sub.bean.SubInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("flow")
public class FlowBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IFlowService service;
	@Autowired
	private IPushMessageApi pushMessageApi;
	@Autowired
	private IStuffInviteService stuffInviteService;
	@Autowired
	private ISubInviteService subInviteService;
	@Autowired
	private IProsubInviteService prosubInviteService;
	@Autowired
	private IEquipmentInviteService equipmentInviteService;
	@Autowired
	private IEquipmentInviteDetailRecordService equipmentInviteDetailRecordService;
	@Autowired
	private IRentInviteService rentInviteService;
	@Autowired
	private IRmatInviteService rmatInviteService;
	@Autowired
	private IOtherInviteService otherInviteService;
	@Autowired
	private IStuffInviteDetailRecordService stuffInviteDetailRecordService;
	@Autowired
	private ISubInviteDetailRecordService subInviteDetailRecordService;
	@Autowired
	private IProsubInviteDetailRecordService prosubInviteDetailRecordService;
	@Autowired
	private IBatPlanApi batPlanApi;
	@Autowired
	private IPurchasePlanApi purchasePlanApi;
	@Autowired
	private IRentPlanApi rentPlanApi;
	@Autowired
	private IRentInviteDetailRecordService rentInviteDetailRecordService;

	/** 招标文件 */
	@Autowired
	private IStuffDocumentService stuffDocumentService;
	/** 分包招标文件 */
	@Autowired
	private ISubDocumentService subDocumentService;
	/** 分包招标文件 */
	@Autowired
	private IProsubDocumentService prosubDocumentService;
	/** 设备招标文件 */
	@Autowired
	private IEquipmentDocumentService equipmentDocumentService;
	/** 设备租赁文件 */
	@Autowired
	private IRentDocumentService rentDocumentService;
	/** 周转材租赁文件 */
	@Autowired
	private IRmatDocumentService rmatDocumentService;
	/** 其他文件 */
	@Autowired
	private IOtherDocumentService otherDocumentService;
	/** 专家 */
	@Autowired
	private IStuffDocumentExpertService stuffDocumentExpertService;
	/** 分包专家 */
	@Autowired
	private ISubDocumentExpertService subDocumentExpertService;
	/** 分包专家 */
	@Autowired
	private IProsubDocumentExpertService prosubDocumentExpertService;
	/** 设备采购专家 */
	@Autowired
	private IEquipmentDocumentExpertService equipmentDocumentExpertService;
	/** 设备租赁专家 */
	@Autowired
	private IRentDocumentExpertService rentDocumentExpertService;
	/** 周转材租赁专家 */
	@Autowired
	private IRmatDocumentExpertService rmatDocumentExpertService;
	@Autowired
	private IMaterialBatchPlanApi materialBatchPlanApi;
	/** 其他专家 */
	@Autowired
	private IOtherDocumentExpertService otherDocumentExpertService;
	@Autowired
	private IOtherInviteDetailRecordService otherInviteDetailRecordService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE
				.getBillStateCode().equals(state)) {
			service.updateBidOut(billId);//修改状态
			//获取流标信息
			FlowEntity flowEntity = service.getById(billId);
			// 材料
			if (CommonUtils.TYPE_MATERIAL == flowEntity.getType()) {
				this.execStuff(flowEntity.getTenderId());
			}
			// 分包
			else if (CommonUtils.TYPE_SUB == flowEntity.getType()) {
				this.execSub(flowEntity.getTenderId());
			}
			// 设备采购
			else if (CommonUtils.TYPE_EQUIPMENT == flowEntity.getType()) {
				this.execEquipment(flowEntity.getTenderId());
			}
			// 设备租赁
			else if (CommonUtils.TYPE_RENT == flowEntity.getType()) {
				this.execRent(flowEntity.getTenderId());
			}
			// 周转材租赁
			else if (CommonUtils.TYPE_RMAT == flowEntity.getType()) {
				this.execRmat(flowEntity.getTenderId());
			}
			// 其他租赁
			else if (CommonUtils.TYPE_OTHER == flowEntity.getType()) {
				this.execOther(flowEntity.getTenderId());
			}// 分包
			else if (CommonUtils.TYPE_PROSUB == flowEntity.getType()) {
				this.execProsub(flowEntity.getTenderId());
			}
			else {
				throw new BusinessException("不存在招标立项类型[" + flowEntity.getType() + "]");
			}

		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 处理材料招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execStuff(Long tenderId) {
		// 获取招标立项信息
		StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(tenderId);
		QueryParam stuffInviteDetailQueryParam = new QueryParam();
		stuffInviteDetailQueryParam.getParams()
				.put("invite_id", new Parameter(QueryParam.EQ, stuffInviteEntity.getId()));
		List<StuffInviteDetailRecordEntity> stuffInviteDetailEntityList = stuffInviteDetailRecordService
				.queryList(stuffInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(stuffInviteDetailEntityList)) {
			List<String> planIdList = stuffInviteDetailEntityList.stream()
					.map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
			//if (stuffInviteEntity.getPurchaseType() == 0 ){
				CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
				if (!response.isSuccess()) {
					throw new BusinessException("修改批次计划状态失败" + response.getMsg());
				}
//			}else {
//				CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
//				if (!response.isSuccess()) {
//					throw new BusinessException("修改采购申请状态失败" + response.getMsg());
//				}
//			}
		}
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<StuffDocumentEntity> stuffDocumentEntityList = stuffDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(stuffDocumentEntityList)) {
			Long documentId = stuffDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<StuffDocumentExpertEntity> stuffInviteExpertEntityList = stuffDocumentExpertService
					.list(new QueryWrapper<StuffDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(stuffInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (StuffInviteExpertEntity stuffInviteExpertEntity : stuffInviteExpertEntityList) {
//                    sender.add(stuffInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = stuffInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(StuffDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = stuffInviteEntity.getPurchaseType() == 0 ? stuffInviteEntity
						.getProjectName() : stuffInviteEntity.getOrgName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = stuffInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = stuffInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}
	@Autowired
	private ISubBatPlanService subBatPlanService;
	@Autowired
	private IProSubBatPlanService prosubBatPlanService;
	@Autowired
	private IOtherBatPlanService otherBatPlanService;
	/**
	 * 处理分包招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execSub(Long tenderId) {
		// 获取招标立项信息
		SubInviteEntity subInviteEntity = subInviteService.selectById(tenderId);
		//修改mark
		QueryParam stuffInviteDetailQueryParam = new QueryParam();
		stuffInviteDetailQueryParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, subInviteEntity.getId()));
		List<SubInviteDetailRecordEntity> subInviteDetailRecordEntities = subInviteDetailRecordService.queryList(stuffInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(subInviteDetailRecordEntities)) {
			List<String> planIdList = subInviteDetailRecordEntities.stream()
					.map(SubInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
			subBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
		}
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<SubDocumentEntity> subDocumentEntityList = subDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(subDocumentEntityList)) {
			Long documentId = subDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<SubDocumentExpertEntity> subInviteExpertEntityList = subDocumentExpertService
					.list(new QueryWrapper<SubDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(subInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (SubInviteExpertEntity subInviteExpertEntity : subInviteExpertEntityList) {
//                    sender.add(subInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = subInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(SubDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = subInviteEntity.getProjectName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = subInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = subInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}

	/**
	 * 处理设备采购招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execEquipment(Long tenderId) {
		// 获取招标立项信息
		EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(tenderId);
		equipmentInviteService.updateApiState(equipmentInviteEntity, PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState(),
				PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState());
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<EquipmentDocumentEntity> equipmentDocumentEntityList = equipmentDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(equipmentDocumentEntityList)) {
			Long documentId = equipmentDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<EquipmentDocumentExpertEntity> equipmentInviteExpertEntityList = equipmentDocumentExpertService
					.list(new QueryWrapper<EquipmentDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(equipmentInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (EquipmentInviteExpertEntity equipmentInviteExpertEntity : equipmentInviteExpertEntityList) {
//                    sender.add(equipmentInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = equipmentInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(EquipmentDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = equipmentInviteEntity.getProjectName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = equipmentInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = equipmentInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}

	/**
	 * 处理设备租赁招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execRent(Long tenderId) {
		// 获取招标立项信息
		RentInviteEntity rentInviteEntity = rentInviteService.selectById(tenderId);
		rentInviteService.updateApiState(rentInviteEntity, RentPlanEnum.PLAN_STATE_WAIT.getPlanState(),
				RentPlanEnum.PLAN_STATE_WAIT.getPlanState());
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<RentDocumentEntity> rentDocumentEntityList = rentDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(rentDocumentEntityList)) {
			Long documentId = rentDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<RentDocumentExpertEntity> rentInviteExpertEntityList = rentDocumentExpertService
					.list(new QueryWrapper<RentDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(rentInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (RentInviteExpertEntity rentInviteExpertEntity : rentInviteExpertEntityList) {
//                    sender.add(rentInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = rentInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(RentDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = rentInviteEntity.getProjectName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = rentInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = rentInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}

	/**
	 * 处理周转材租赁招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execRmat(Long tenderId) {
		// 获取招标立项信息
		RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(tenderId);
		// 释放计划
//		RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(tenderId);
		rmatInviteService.updateApiState(rmatInviteEntity, BatchPlanEnum.PLAN_STATE_WAIT.getPlanState(),
				MaterialBatchPlanEnum.PLAN_STATE_WAIT.getPlanState());
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<RmatDocumentEntity> rmatDocumentEntityList = rmatDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(rmatDocumentEntityList)) {
			Long documentId = rmatDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<RmatDocumentExpertEntity> rmatInviteExpertEntityList = rmatDocumentExpertService
					.list(new QueryWrapper<RmatDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(rmatInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (RmatInviteExpertEntity rmatInviteExpertEntity : rmatInviteExpertEntityList) {
//                    sender.add(rmatInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = rmatInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(RmatDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = rmatInviteEntity.getProjectName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = rmatInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = rmatInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}

	/**
	 * 处理其他招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execOther(Long tenderId) {
		// 获取招标立项信息
		OtherInviteEntity otherInviteEntity = otherInviteService.selectById(tenderId);

		//修改mark
		QueryParam stuffInviteDetailQueryParam = new QueryParam();
		stuffInviteDetailQueryParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, otherInviteEntity.getId()));
		List<OtherInviteDetailRecordEntity> otherInviteDetailRecordEntities = otherInviteDetailRecordService.queryList(stuffInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(otherInviteDetailRecordEntities)) {
			List<String> planIdList = otherInviteDetailRecordEntities.stream()
					.map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
			otherBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
		}
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<OtherDocumentEntity> otherDocumentEntityList = otherDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(otherDocumentEntityList)) {
			Long documentId = otherDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<OtherDocumentExpertEntity> otherInviteExpertEntityList = otherDocumentExpertService
					.list(new QueryWrapper<OtherDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(otherInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (OtherInviteExpertEntity otherInviteExpertEntity : otherInviteExpertEntityList) {
//                    sender.add(otherInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = otherInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(OtherDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = otherInviteEntity.getProjectName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = otherInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = otherInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}


	/**
	 * 处理专业分包招标信息
	 *
	 * @param tenderId 招标立项id
	 */
	private void execProsub(Long tenderId) {
		// 获取招标立项信息
		ProsubInviteEntity subInviteEntity = prosubInviteService.selectById(tenderId);
		//修改mark
		QueryParam stuffInviteDetailQueryParam = new QueryParam();
		stuffInviteDetailQueryParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, subInviteEntity.getId()));
		List<ProsubInviteDetailRecordEntity> subInviteDetailRecordEntities = prosubInviteDetailRecordService.queryList(stuffInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(subInviteDetailRecordEntities)) {
			List<String> planIdList = subInviteDetailRecordEntities.stream()
					.map(ProsubInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
			prosubBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
		}
		// 获取招标文件信息
		QueryParam documentParam = new QueryParam();
		documentParam.getParams().put("invite_id", new Parameter(QueryParam.EQ, tenderId));
		List<ProsubDocumentEntity> subDocumentEntityList = prosubDocumentService.queryList(documentParam);
		if (CollectionUtils.isNotEmpty(subDocumentEntityList)) {
			Long documentId = subDocumentEntityList.get(0).getId();
			// 获取专家信息
			List<ProsubDocumentExpertEntity> subInviteExpertEntityList = prosubDocumentExpertService
					.list(new QueryWrapper<ProsubDocumentExpertEntity>().eq("document_id", documentId)
							.eq("dr", 0));
			if (CollectionUtils.isNotEmpty(subInviteExpertEntityList)) {
//                List<String> sender = new ArrayList<>();
//                //审批通过给专家发内部消息
//                for (SubInviteExpertEntity subInviteExpertEntity : subInviteExpertEntityList) {
//                    sender.add(subInviteExpertEntity.getExpertId().toString());
//                }
				List<String> userList = subInviteExpertEntityList.stream().filter(p -> p.getExpertId() != null)
						.map(ProsubDocumentExpertEntity::getExpertId)
						.map(String::valueOf).collect(Collectors.toList());
				// 项目采购使用项目名称，公司采购使用公司名称（0-项目采购）
				String name = subInviteEntity.getProjectName();
				logger.info("发送信息给专家:>----------" + userList);
				// 【招标单位】招标的【项目名称】已废标
				String subject = subInviteEntity.getUnitName() + "招标的" + name + "已流标";
				String content = subInviteEntity.getUnitName() + "招标的" + name + "已流标";
				logger.info("发送信息的内容:>----------" + content);
				new SendMsgUtils().sendSysMsg(userList, subject, content, pushMessageApi);
			}
		}
	}
}
