package com.ejianc.business.tender.common.controller;

import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.tender.common.service.ICheckService;
import com.ejianc.business.tender.common.vo.CheckVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;


/**
 * 流程表
 *
 * @author generator
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {

    @Autowired
    private ICheckService service;

    /**
     * 报名报价校验
     */
    @RequestMapping(value = "/checkSupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> checkSupplier(@RequestBody CheckVo checkVo) {
        Long inviteId = Long.valueOf(checkVo.getInviteId());
        Long supplierId = Long.valueOf(checkVo.getSupplierId());
        String type = checkVo.getType();
        Integer flag = checkVo.getFlag();
        return service.checkSupplier(inviteId, supplierId, type, flag);
    }

//    @Autowired
//    private ICheckSupplierApi checkSupplierApi;
//
//    @RequestMapping(value = "/test", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<CheckSupplierDTO> test(Long id){
//        CommonResponse<CheckSupplierDTO> checkSupplierDTOCommonResponse = checkSupplierApi.queryCheckDTO(id);
//        return checkSupplierDTOCommonResponse;
//    }

}
