package com.ejianc.business.tender.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import com.ejianc.business.pro.supplier.vo.LimitVO;
import com.ejianc.business.tender.common.service.ICheckService;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubInviteSupplierEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.CertsDTO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("checkService")
public class CheckServiceImpl implements ICheckService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IStuffInviteService stuffInviteService;

    @Autowired
    private ISubInviteService subInviteService;

    @Autowired
    private IProsubInviteService prosubInviteService;

    @Autowired
    private IEquipmentInviteService equipmentInviteService;

    @Autowired
    private IRentInviteService rentInviteService;

    @Autowired
    private IRmatInviteService rmatInviteService;

    @Autowired
    private IOtherInviteService otherInviteService;

    @Autowired
    private ICheckSupplierApi checkSupplierApi;

    @Autowired
    private IShareSubleadersApi shareSubleadersApi;

    @Override
    public CommonResponse<String> checkSupplier(Long inviteId, Long supplierId, String type, Integer flag) {
        String supplierType = null;
        String name = flag == 0 ? "报名" : "报价";
        logger.info("进行供应商报名报价校验");
        logger.info("校验数据:招标主键:" + inviteId + ",供应商主键:" + supplierId + ",招标类型:" + type + ",类型:" + name);
        logger.info("调用api");
        CommonResponse<CheckSupplierDTO> response = checkSupplierApi.queryCheckDTO(supplierId);
        logger.info("查询供应商response：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            if (type.equals("SUB")){
                //判断是否分包负责人
//                SubInviteEntity subInviteEntity = subInviteService.selectById(inviteId);
//                if (subInviteEntity!= null){
//                    List<SubInviteSupplierEntity> supplierDetail = subInviteEntity.getSupplierDetail();
//                    for (SubInviteSupplierEntity subInviteSupplierEntity : supplierDetail) {
//                        if (supplierId.equals(subInviteSupplierEntity.getSupplierId())){
//                            response = checkSupplierApi.queryCheckDTO(subInviteSupplierEntity.getTeamId());
//                        }
//                    }
//                }

                //分包负责人id查询详情
                CommonResponse<SubleadersVO> subleadersVOCommonResponse = shareSubleadersApi.querySupplierByLeaderId(supplierId);
                if (subleadersVOCommonResponse.getCode()== 0){
                    response = checkSupplierApi.queryCheckDTO(subleadersVOCommonResponse.getData().getPid());
                }
                logger.info("查询分包供应商/负责人response：{}", JSONObject.toJSONString(response));
                if (!response.isSuccess()) {
                    throw new BusinessException("查询供应商详情报错" + response.getMsg());
                }
            }else {
                throw new BusinessException("查询供应商详情报错" + response.getMsg());
            }

        }
        //异常供应商校验
        CheckSupplierDTO supplierDTO = response.getData();
        logger.info("供应商查询结果：{}", JSONObject.toJSONString(supplierDTO));
        if (supplierDTO.getInException() != null && supplierDTO.getInException()) {
            throw new BusinessException("很抱歉，您已被招标单位列入异常供应商,无法" + name);
        }
        //供货内容校验
        StuffInviteEntity inviteEntity = null;
        String supplierIdContent = null;
        String supplierContent = null;
        if (type.equals("MATERIAL")) {
            inviteEntity = stuffInviteService.selectById(inviteId);
            supplierType = "material";
            supplierIdContent = supplierDTO.getMaterialContentId();
            supplierContent = supplierDTO.getMaterialContent();
            if (supplierDTO.getRevolvMaterialContentId() != null) {
                supplierIdContent = supplierIdContent + "," + supplierDTO.getRevolvMaterialContentId();
                supplierContent = supplierContent + "," + supplierDTO.getRevolvMaterialContent();
            }
        }
        else if (type.equals("SUB")) {

            //专业，劳务需要查询两次
            SubInviteEntity subInviteEntity = subInviteService.selectById(inviteId);
            String[] projectQualificationIds = new String[0];
            if (subInviteEntity == null){//劳务为空则去查询专业
                ProsubInviteEntity prosubInviteEntity = prosubInviteService.selectById(inviteId);
                projectQualificationIds = prosubInviteEntity.getProjectQualificationId().split(",");
                prosubInviteEntity.setProjectQualificationId(null);//专业分包资质为string类型
                subInviteEntity = BeanMapper.map(prosubInviteEntity, SubInviteEntity.class);
            }

            inviteEntity = BeanMapper.map(subInviteEntity, StuffInviteEntity.class);
            //判断资质条件
            List<CertsDTO> certs = supplierDTO.getCerts();
            List<CertificateVO> certificateVOS = supplierDTO.getfCertificateVOS();
            List<Long> certsList = certs.stream().map(CertsDTO::getCertId).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(certificateVOS)) {
                List<Long> certificateList = certificateVOS.stream().map(CertificateVO::getSuperiorId).filter(Objects::nonNull).map(Long::valueOf).collect(Collectors.toList());
                certsList.addAll(certificateList);
            }
            //专业分包
            if (subInviteEntity.getSubType() == 1471313836879101953L) {
                supplierIdContent = supplierDTO.getMajorContentId();
                supplierContent = supplierDTO.getMajorContent();
                supplierType = "major";

                //招标工程资质ID
                long[] longs = Arrays.asList(projectQualificationIds).stream().mapToLong(Long::parseLong).toArray();
                List<Long> collect = Arrays.stream(longs).boxed().collect(Collectors.toList());
                boolean cerFlag = false;
//                for (Long projectQualificationId : collect) {
//                    if (certsList.contains(projectQualificationId)) {
//                        cerFlag = true;
//                    }
//                }
                //专业分包要求必须要含所有资质
                if (certsList.containsAll(collect)){
                    cerFlag = true;
                }
                if (!cerFlag) {
                    throw new BusinessException("您的资质证件不满足本次招标的资质证件要求，无法" + name);
                }

            }
            else {
                supplierIdContent = supplierDTO.getLaborContentId();
                supplierContent = supplierDTO.getLaborContent();
                supplierType = "labor";
            }
        }
        else if (type.equals("PURCHASE")) {
            EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(equipmentInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getEquipmentContentId();
            supplierContent = supplierDTO.getEquipmentContent();
            supplierType = "equipment";
        }
        else if (type.equals("RENT")) {
            RentInviteEntity rentInviteEntity = rentInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(rentInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getEquipmentContentId();
            supplierContent = supplierDTO.getEquipmentContent();
            supplierType = "equipment";
        }
        else if (type.equals("RMAT")) {
            //周转才中供应商等级为C的不允许报名报价
            if (supplierDTO.getGradeName() != null && "C".equals(supplierDTO.getGradeName())) {
                throw new BusinessException("很抱歉，您已被招标单位列入异常供应商等级,无法" + name);
            }

            RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(rmatInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getRevolvMaterialContentId();
            supplierContent = supplierDTO.getRevolvMaterialContent();
            if (supplierDTO.getMaterialContentId() != null) {
                supplierIdContent = supplierIdContent + "," + supplierDTO.getMaterialContentId();
                supplierContent = supplierContent + "," + supplierDTO.getMaterialContent();
            }
            supplierType = "material";
        }
        else if (type.equals("OTHER")) {
            OtherInviteEntity otherInviteEntity = otherInviteService.selectById(inviteId);
            inviteEntity = BeanMapper.map(otherInviteEntity, StuffInviteEntity.class);
            supplierIdContent = supplierDTO.getOtherContentId();
            supplierContent = supplierDTO.getOtherContent();
            supplierType = "other";
        }
        //类型限制
        String[] supplyType = supplierDTO.getSupplyType().split(",");
        logger.info("供应商类别" + supplierDTO.getSupplyTypeName());
        if (!(Arrays.asList(supplyType).contains(supplierType))) {
            if (!(supplierType.equals("material") && (Arrays.asList(supplyType).contains("revolvMaterial")))){
                throw new BusinessException("很抱歉，您的供应商类型与招标类型不一致,无法" + name);
            }
        }

        //25-07-25全部不校验供货内容
        if(false) {
            //3月20号，梁丁反馈专业分包只要资质控制，不要供货内容控制
            if (!supplierType.equals("major")) {
                //判断招标是否有供货内容
                if (StringUtils.isNotEmpty(inviteEntity.getPurchaseId())) {
                    logger.info("招标供货内容" + inviteEntity.getPurchaseName());
                    logger.info("供应商供货内容" + supplierContent);
                    String[] purchaseId = inviteEntity.getPurchaseId().split(",");
//                if (StringUtils.isEmpty(supplierIdContent)) {
//                    throw new BusinessException("很抱歉，您的供货内容与招标不匹配,无法" + name);
//                }
                    String[] contentId = supplierIdContent.split(",");
                    List<String> purchaseIdList = Arrays.asList(purchaseId);
                    List<String> contentIdList = Arrays.asList(contentId);
                    logger.info("招标供货内容ID" + JSONObject.toJSONString(purchaseIdList));
                    logger.info("供应商供货内容ID" + JSONObject.toJSONString(contentIdList));
                    List<String> list = purchaseIdList.stream().filter(contentIdList::contains).collect(Collectors.toList());
//                if (CollectionUtils.isEmpty(list)) {
//                    throw new BusinessException("很抱歉，您的供货内容与招标不匹配,无法" + name);
//                }
                    //获取供应商限额详情
                    List<LimitVO> limitVOS = supplierDTO.getLimitVOS();
                    List<String> limitList = limitVOS.stream().filter(LimitVO::getState).map(LimitVO::getContentId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
                    Map<Long, BigDecimal> limitSingleMap = limitVOS.stream().filter(a -> a.getSingle() != null).collect(Collectors.toMap(LimitVO::getContentId, LimitVO::getSingle, (k1, k2) -> k2));
                    Map<Long, BigDecimal> limitAllYearMap = limitVOS.stream().filter(a -> a.getAllYear() != null).collect(Collectors.toMap(LimitVO::getContentId, LimitVO::getAllYear, (k1, k2) -> k2));
                    List<String> list1 = purchaseIdList.stream().filter(limitList::contains).collect(Collectors.toList());

                    //供货内容没有设置年度经营额
                    if (CollectionUtils.isEmpty(list1)) {
                        List<LimitVO> list2 = limitVOS.stream().filter(a -> a.getContentId() == null && a.getContentName() == null).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(list2)) {
                            if (type.equals("MATERIAL")) {
                                List<BigDecimal> materialSingleList = list2.stream().filter(a -> a.getSupplyType().equals("material")).map(LimitVO::getSingle).collect(Collectors.toList());
                                List<BigDecimal> revolvMaterialSingleList = list2.stream().filter(a -> a.getSupplyType().equals("revolvMaterial")).map(LimitVO::getSingle).collect(Collectors.toList());
                                List<BigDecimal> materialAllYearList = list2.stream().filter(a -> a.getSupplyType().equals("material")).map(LimitVO::getAllYear).collect(Collectors.toList());
                                List<BigDecimal> revolvMaterialAllYearList = list2.stream().filter(a -> a.getSupplyType().equals("revolvMaterial")).map(LimitVO::getAllYear).collect(Collectors.toList());
                                if (CollectionUtils.isNotEmpty(materialSingleList) && CollectionUtils.isNotEmpty(revolvMaterialSingleList)) {
                                    materialSingleList.addAll(revolvMaterialSingleList);
                                    BigDecimal singleMin = Collections.min(materialSingleList);
                                    if (inviteEntity.getTenderMoney().compareTo(singleMin) > 0) {
                                        throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                                    }
                                }
                                if (CollectionUtils.isNotEmpty(materialAllYearList) && CollectionUtils.isNotEmpty(revolvMaterialAllYearList)) {
                                    materialAllYearList.addAll(revolvMaterialAllYearList);
                                    BigDecimal allYearMin = Collections.min(materialAllYearList);
                                    if ((supplierDTO.getSumContractMny().add(inviteEntity.getTenderMoney())).compareTo(allYearMin) > 0) {
                                        throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                                    }
                                }
                            } else {
                                String finalSupplierType = supplierType;
                                List<LimitVO> list3 = list2.stream().filter(a -> a.getSupplyType().equals(finalSupplierType)).collect(Collectors.toList());
                                if (list3.get(0).getSingle() != null) {
                                    if (inviteEntity.getTenderMoney().compareTo(list3.get(0).getSingle()) > 0) {
                                        logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                                        logger.info("单次签订限额-{}", list3.get(0).getSingle());
                                        throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                                    }
                                    if ((supplierDTO.getSumContractMny().add(inviteEntity.getTenderMoney())).compareTo(list3.get(0).getAllYear()) > 0) {
                                        logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                                        logger.info("年度签订合同金额-{}", list3.get(0).getAllYear());
                                        throw new BusinessException("很抱歉，您本年度签订合同金额超出年度签订金额，无法" + name);
                                    }
                                }
                            }
                        }
                    }
                    BigDecimal minSingle = null;
                    BigDecimal minAllYear = null;
                    boolean singleFlag = true;
                    boolean allYearFlag = true;
                    for (String id : list1) {
                        //单次经营额
                        if (limitSingleMap.get(Long.parseLong(id)) != null) {
                            if (minSingle == null) {
                                minSingle = limitSingleMap.get(Long.parseLong(id));
                            } else {
                                if (limitSingleMap.get(Long.parseLong(id)).compareTo(minSingle) > 0) {
                                    minSingle = limitSingleMap.get(Long.parseLong(id));
                                }
                            }
                        } else {
                            singleFlag = false;
                        }
                        //年度经营额
                        if (limitAllYearMap.get(Long.parseLong(id)) != null) {
                            if (minAllYear == null) {
                                minAllYear = limitAllYearMap.get(Long.parseLong(id));
                            } else {
                                if (limitAllYearMap.get(Long.parseLong(id)).compareTo(minAllYear) > 0) {
                                    minAllYear = limitAllYearMap.get(Long.parseLong(id));
                                }
                            }
                        } else {
                            allYearFlag = false;
                        }
                    }
                    if (singleFlag && minSingle != null) {
                        logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                        logger.info("单次签订限额-{}", minSingle);
                        if (inviteEntity.getTenderMoney().compareTo(minSingle) > 0) {
                            throw new BusinessException("很抱歉，您的单次签订限额不满足本次招标控制金额，无法" + name);
                        }
                    }
                    if (allYearFlag && minAllYear != null) {
                        logger.info("招标控制金额-{}", inviteEntity.getTenderMoney());
                        logger.info("年度签订合同金额-{}", minAllYear);
                        if ((supplierDTO.getSumContractMny().add(inviteEntity.getTenderMoney())).compareTo(minAllYear) > 0) {
                            throw new BusinessException("很抱歉，您本年度签订合同金额超出年度签订金额，无法" + name);
                        }
                    }

                }
            }
        }
        return CommonResponse.success("供应商校验成功!");
    }

    static  String  PC_URL = "https://pms.zzyjjt.com";
    @Autowired
    private IPushMessageApi pushMessageApi;
    static  String  TEST_AGENTID = "1000038";
    static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static  String  PRO_AGENTID = "1000036";
    static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";
    //预警代办提醒
    @Override
    public boolean sendMsg(String receiverId,String subject){

        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
        //channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        String[] receivers = {receiverId};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("task");//消息
        parameter.setSubject("评标提醒");// 标题
        parameter.setContent("内容");// 内容
        parameter.setPcUrl(PC_URL);// pc端url
        parameter.setMobileUrl(PC_URL);// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", PRO_AGENTID);//企业微信应用id
        weixineeParams.put("secret", PRO_SECRET);//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "请前往电脑端完成专家评标");
        weixineeParams.put("description",subject);
        weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
                "&targeturl=https%3A%2F%2Fpms.zzyjjt.com"));//移动端点击的url
        weixineeParams.put("btntxt", "请前往电脑端评标，手机端无法评标");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.error("消息发送成功---------------->,接收人:{}," + result.getMsg(), Arrays.toString(receivers));

            return true;
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return false;
        }
    }

}
