package com.ejianc.business.tender.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.desktop.api.IShareCategoryApi;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.business.tender.cost.bean.PlanControlRuleDetailEntity;
import com.ejianc.business.tender.cost.bean.PlanControlRuleEntity;
import com.ejianc.business.tender.cost.service.IPlanControlRuleDetailService;
import com.ejianc.business.tender.cost.service.IPlanControlRuleService;
import com.ejianc.business.tender.cost.vo.AllPlanDetailVO;
import com.ejianc.business.tender.cost.vo.CategoryPlusVO;
import com.ejianc.business.tender.cost.vo.TargetcostDutyDetailVO;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSellEntity;
import com.ejianc.business.tender.prosub.vo.ProsubAdviceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.cost.mapper.AllPlanDetailMapper;
import com.ejianc.business.tender.cost.bean.AllPlanDetailEntity;
import com.ejianc.business.tender.cost.service.IAllPlanDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购计划中间库
 * 
 * @author generator
 * 
 */


@Service("allPlanDetailService")
public class AllPlanDetailServiceImpl extends BaseServiceImpl<AllPlanDetailMapper, AllPlanDetailEntity> implements IAllPlanDetailService{
    @Autowired
    private IPlanControlRuleDetailService planControlRuleService;
    @Autowired
    private IShareCategoryApi shareCategoryApi;

    @Override
    public List<PlanControlRuleDetailEntity> compareWithCost(List<AllPlanDetailVO> list) {
        /**
         * 1.
         * 2.
         * 3.
         * 4.
         * 5.
         */
        List<AllPlanDetailEntity> allPlanDetail = new ArrayList<>();
        List<TargetcostDutyDetailVO> targetcostDutyDetail = new ArrayList<>();
        if (list.size()>0){
            AllPlanDetailVO allPlanDetailVO = list.get(0);//获取项目id使用
            //中间库中所有材料数量
             allPlanDetail = baseMapper.getAllPlanDetail(allPlanDetailVO.getProjectId());
//            Map<Long, BigDecimal> collect4 = allPlanDetail.stream()
//                    .collect(Collectors.toMap(AllPlanDetailEntity::getMaterialTypeId, AllPlanDetailEntity::getNum));

            //获取目标责任成本中每个档案的数量
             targetcostDutyDetail = baseMapper.getTargetcostDutyDetail(allPlanDetailVO.getProjectId());
//            Map<Long, BigDecimal> collect3 = targetcostDutyDetail.stream()
//                    .collect(Collectors.toMap(TargetcostDutyDetailVO::getCategoryId, TargetcostDutyDetailVO::getAmount));
        }

        //获取控制规则，暂时只允许一条，暂时写死
//        LambdaQueryWrapper<PlanControlRuleDetailEntity> listWrapper = Wrappers.lambdaQuery();
//        listWrapper.eq(PlanControlRuleDetailEntity::getEnabled, 1);//启用
//        listWrapper.eq(PlanControlRuleDetailEntity::getDr, 0);//
//        listWrapper.eq(PlanControlRuleDetailEntity::getPId, 693064658269032522L);//暂时写死
        //需求修改
        List<PlanControlRuleDetailEntity> documentSellList = baseMapper.getControlList();
        //需要控制的档案id
        List<String> collect = documentSellList.stream().map(PlanControlRuleDetailEntity::getInnerCode).collect(Collectors.toList());
        String[] strings = collect.toArray(new String[collect.size()]);
        //获取需要控制的档案的所有子节点
        CommonResponse<List<CategoryVO>> query = shareCategoryApi.query(strings);
        List<PlanControlRuleDetailEntity> planControlRuleDetailEntityList = new ArrayList<>();
        if (query.getCode() == 0){
            List<CategoryVO> data = query.getData();
            List<CategoryPlusVO> categoryPlusVOS = BeanMapper.mapList(data, CategoryPlusVO.class);
            for (CategoryPlusVO categoryPlusVO : categoryPlusVOS) {
                //计划值
                for (AllPlanDetailEntity allPlanDetailEntity : allPlanDetail) {
                    if (categoryPlusVO.getId().equals(allPlanDetailEntity.getMaterialTypeId())){
                        categoryPlusVO.setPlanNum(allPlanDetailEntity.getNum());
                    }
                }
                //目标责任成本值
                for (TargetcostDutyDetailVO targetcostDutyDetailVO : targetcostDutyDetail) {
                    if (categoryPlusVO.getId().equals(targetcostDutyDetailVO.getCategoryId())){
                        categoryPlusVO.setCostNum(targetcostDutyDetailVO.getAmount());
                    }
                }
                //是否在本次计划中
                for (AllPlanDetailVO allPlanDetailVO : list) {
                    if (categoryPlusVO.getId().equals(allPlanDetailVO.getMaterialTypeId())){
                        categoryPlusVO.getPlanIds().add(allPlanDetailVO.getId());
                    }
                }
                //
//                if (categoryPlusVO.getCostNum()!= null && categoryPlusVO.getPlanNum() != null){
//                    categoryPlusVO.setDifNum(categoryPlusVO.getCostNum().subtract(categoryPlusVO.getPlanNum()));
//                }
            }
            //将控制类别与其下所有档案子节点关联

            for (PlanControlRuleDetailEntity planControlRuleDetailEntity : documentSellList) {
                //计划值之和
                BigDecimal totalPlan = new BigDecimal(0.00);
                //目标成本之和
                BigDecimal totalCost = new BigDecimal(0.00);
                //包含本次计划的明细
                ArrayList<Long> totalId = new ArrayList<>();

                for (CategoryPlusVO categoryPlusVO : categoryPlusVOS) {
                    if (categoryPlusVO.getInnerCode().contains(planControlRuleDetailEntity.getInnerCode())
                            && categoryPlusVO.getCostNum()!=null
                            && categoryPlusVO.getPlanNum()!=null){
                        totalPlan =  totalPlan.add(categoryPlusVO.getPlanNum());
                        totalCost =  totalCost.add(categoryPlusVO.getCostNum());
                        totalId.addAll(categoryPlusVO.getPlanIds());
                    }
                }
                //小于0的超出控制范围
                //包含此次计划内容才返回
                //修改————需要根据控制值 进行控制
                //暂未按照控制规则进行控制，统一为明细量控-----------
                BigDecimal controlRuleNum = planControlRuleDetailEntity.getControlRuleNum().divide(new BigDecimal(100)).multiply(totalCost);
                if(controlRuleNum.compareTo(totalPlan) == -1  //控制值小于计划值
                    && totalId.size() > 0){
                    planControlRuleDetailEntity.setPlanIds(StringUtils.join(totalId.toArray(),","));
                    planControlRuleDetailEntity.setTotal(totalPlan.subtract(controlRuleNum));//超出计划的值
                    planControlRuleDetailEntityList.add(planControlRuleDetailEntity);
                }
//                List<Long> collect5 = data.stream().
//                        filter(s -> s.getInnerCode().contains(planControlRuleDetailEntity.getInnerCode())).
//                        map(CategoryVO::getId).
//                        collect(Collectors.toList());
                //longListHashMap.put(planControlRuleDetailEntity.getDocId(),collect5);
            }

             //collect1 = data.stream().map(CategoryVO::getId).collect(Collectors.toList());
        }

        //本次采购计划所有的档案id
        //List<Long> collect2 = list.stream().map(AllPlanDetailVO::getMaterialTypeId).collect(Collectors.toList());





        return planControlRuleDetailEntityList;
    }


}
