package com.ejianc.business.tender.equipment.mapper;

import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailBidderVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface EquipmentInviteMapper extends BaseCrudMapper<EquipmentInviteEntity> {
    @Update("UPDATE ejc_tender_equipment_invite SET tender_stage = #{tenderStage} WHERE id = #{id} ")
    void updateTenderStage(String id, int tenderStage);
    @Update("UPDATE ejc_tender_equipment_invite SET abolish_type = #{abolishType} WHERE id = #{id} ")
    void updateAbolishType(String id, int abolishType);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money,SUM(plan_num) sum_plan_num  FROM `ejc_tender_equipment_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_id ,material_type_id,rate,detail_project_id,calculate_type")
    List<EquipmentInviteDetailVO> selectSumDetail(Long inviteId);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money,SUM(plan_num) sum_plan_num  FROM `ejc_tender_equipment_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_id ,material_type_id,rate,detail_project_id,calculate_type")
    List<EquipmentInviteDetailVO> selectOrgSumDetail(Long inviteId);
    @Select("SELECT c.*,sum( c.tax_money ) sum_tax_money,sum( c.money ) sum_money,sum( c.num ) sum_num FROM  (SELECT a.*,b.detail_project_id,b.detail_project_name,b.detail_org_id,b.detail_org_name FROM  `ejc_tender_equipment_invite_detail_bidder` a LEFT join ejc_tender_equipment_invite_detail_record b on a.invite_detail_id = b.id WHERE a.invite_id = #{inviteId}) c  GROUP BY c.supplier_id,c.detail_project_id")
    List<EquipmentInviteDetailBidderVO> selectDetailBidder(Long inviteId);
}
