package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageRefsupplierService;
import com.ejianc.business.tender.equipment.mapper.EquipmentPicketageRefsupplierMapper;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 * 
 * @author generator
 * 
 */
@Service("equipmentPicketageRefsupplierService")
public class EquipmentPicketageRefsupplierServiceImpl extends BaseServiceImpl<EquipmentPicketageRefsupplierMapper, EquipmentPicketageRefsupplierEntity> implements IEquipmentPicketageRefsupplierService {
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentInviteDetailBidderService equipmentInviteDetailBidderService;
    @Autowired
    private IEquipmentInviteDetailService equipmentInviteDetailService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public String updateById(Long id,Integer occupyFlag) {
//        占用状态0-未占用,1-已占用,2-已完成
        EquipmentPicketageRefsupplierEntity equipmentPicketageRefsupplierEntity = super.selectById(id);
        equipmentPicketageRefsupplierEntity.setOccupyFlag(occupyFlag);
        super.updateById(equipmentPicketageRefsupplierEntity);
        return "更新成功!";
    }

    @Override
    @Transactional
    public String updateStatus(TenderPicketageVO tenderPicketageVO,Integer type) {
        logger.info("修改类型"+type);
        String stringFb = JSONObject.toJSONString(tenderPicketageVO);
        logger.info("设备采购定标占用参数"+stringFb);
        EquipmentPicketageRefsupplierEntity equipmentPicketageRefsupplierEntity = super.selectById(tenderPicketageVO.getId());
        //picketageFlag 定标类型0-流程定标,1-直接定标

        Integer picketageFlag = equipmentPicketageRefsupplierEntity.getPicketageFlag();
        if (type == 1){
            tenderPicketageVO.setContractMoney(tenderPicketageVO.getContractMoney().negate());
            tenderPicketageVO.setContractMoneyTax(tenderPicketageVO.getContractMoneyTax().negate());
            List<TenderPicketageDetailVO> detailList = tenderPicketageVO.getTenderPicketageDetailList();
            for (TenderPicketageDetailVO tenderPicketageDetailVO : detailList){
                tenderPicketageDetailVO.setSignNum(tenderPicketageDetailVO.getSignNum().negate());
            }
        }
        EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(equipmentPicketageRefsupplierEntity.getPicketageId());
        EquipmentInviteEntity equipmentInviteEntity = null;
        if(picketageFlag == 0){
            equipmentInviteEntity = equipmentInviteService.selectById(equipmentPicketageEntity.getInviteId());
        }
        if(picketageFlag == 1){
            equipmentInviteEntity = equipmentInviteService.selectById(equipmentPicketageRefsupplierEntity.getPicketageId());
        }

        //根据子表id更新签订数量
        List<TenderPicketageDetailVO> tenderPicketageDetailList = tenderPicketageVO.getTenderPicketageDetailList();
        List<Long> sellIds = tenderPicketageDetailList.stream().map(TenderPicketageDetailVO::getId).collect(Collectors.toList());
        Map<Long, TenderPicketageDetailVO> detailVOMap = tenderPicketageDetailList.stream().collect(Collectors.toMap(TenderPicketageDetailVO::getId, Function.identity()));
        if (picketageFlag == 0) {
            LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
            lambdaSell.in(EquipmentDocumentSellEntity::getId, sellIds);
            List<EquipmentDocumentSellEntity> sellEntityList = equipmentDocumentSellService.list(lambdaSell);
            for (EquipmentDocumentSellEntity equipmentDocumentSellEntity : sellEntityList) {
                TenderPicketageDetailVO tenderPicketageDetailVO = detailVOMap.get(equipmentDocumentSellEntity.getId());
                BigDecimal num = equipmentDocumentSellEntity.getSignNum() == null ? BigDecimal.ZERO : equipmentDocumentSellEntity.getSignNum();
                BigDecimal signNum = num.add(tenderPicketageDetailVO.getSignNum());
                equipmentDocumentSellEntity.setSignNum(signNum);
            }
            equipmentDocumentSellService.updateBatchById(sellEntityList);
        }
        if (picketageFlag == 1) {
            LambdaQueryWrapper<EquipmentInviteDetailBidderEntity> lambdaBidder = Wrappers.<EquipmentInviteDetailBidderEntity>lambdaQuery();
            lambdaBidder.in(EquipmentInviteDetailBidderEntity::getId, sellIds);
            List<EquipmentInviteDetailBidderEntity> bidderEntityList = equipmentInviteDetailBidderService.list(lambdaBidder);
            for (EquipmentInviteDetailBidderEntity equipmentInviteDetailBidderEntity : bidderEntityList) {
                TenderPicketageDetailVO tenderPicketageDetailVO = detailVOMap.get(equipmentInviteDetailBidderEntity.getId());
                BigDecimal num = equipmentInviteDetailBidderEntity.getSignNum() == null ? BigDecimal.ZERO : equipmentInviteDetailBidderEntity.getSignNum();
                BigDecimal signNum = num.add(tenderPicketageDetailVO.getSignNum());
                equipmentInviteDetailBidderEntity.setSignNum(signNum);
            }
            equipmentInviteDetailBidderService.updateBatchById(bidderEntityList);
        }
        Boolean allSign = null;
        Boolean wqSign = null;
        if (picketageFlag == 0) {

            LambdaQueryWrapper<EquipmentDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(EquipmentDocumentSellEntity::getDocumentId,equipmentPicketageEntity.getDocumentId());
            listWrapper.eq(EquipmentDocumentSellEntity::getSupplierId,equipmentPicketageRefsupplierEntity.getSupplierId());
            if (equipmentPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(EquipmentDocumentSellEntity::getProjectId,equipmentPicketageRefsupplierEntity.getProjectId());
            }

            listWrapper.eq(EquipmentDocumentSellEntity::getTenderFlag,1);
            List<EquipmentDocumentSellEntity> documentSellList = equipmentDocumentSellService.list(listWrapper);

            //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
            allSign = documentSellList.stream().allMatch(e -> (e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(e.getTenderNum()) > -1);
            wqSign = documentSellList.stream().allMatch(e ->(e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(BigDecimal.ZERO) == 0);
        }
        if (picketageFlag == 1) {

            LambdaQueryWrapper<EquipmentInviteDetailBidderEntity> listDetailBidder = Wrappers.lambdaQuery();
            listDetailBidder.eq(EquipmentInviteDetailBidderEntity::getInviteId,equipmentPicketageRefsupplierEntity.getPicketageId());
            listDetailBidder.eq(EquipmentInviteDetailBidderEntity::getSupplierId,equipmentPicketageRefsupplierEntity.getSupplierId());
            List<EquipmentInviteDetailBidderEntity> detailBidderList = equipmentInviteDetailBidderService.list(listDetailBidder);

            List<Long> detailIds = detailBidderList.stream().map(EquipmentInviteDetailBidderEntity::getInviteDetailId).collect(Collectors.toList());
            LambdaQueryWrapper<EquipmentInviteDetailEntity> lambdaDetail = Wrappers.<EquipmentInviteDetailEntity>lambdaQuery();
            lambdaDetail.in(EquipmentInviteDetailEntity::getId, detailIds);
            List<EquipmentInviteDetailEntity> detailEntityList = equipmentInviteDetailService.list(lambdaDetail);

            Map<Long, EquipmentInviteDetailEntity> detailEntityMap = detailEntityList.stream().collect(Collectors.toMap(EquipmentInviteDetailEntity::getId, Function.identity()));
            List<EquipmentInviteDetailBidderEntity> equipmentInviteDetailBidderEntities = new ArrayList<>();
            for (EquipmentInviteDetailBidderEntity equipmentInviteDetailBidderEntity : detailBidderList){
                EquipmentInviteDetailEntity equipmentInviteDetailEntity = detailEntityMap.get(equipmentInviteDetailBidderEntity.getInviteDetailId());
                if (equipmentPicketageRefsupplierEntity.getPurchaseType() == 0){
                    if (equipmentPicketageRefsupplierEntity.getProjectId().equals(equipmentInviteDetailEntity.getDetailProjectId())){
                        equipmentInviteDetailBidderEntities.add(equipmentInviteDetailBidderEntity);
                    }
                }
            }
            if (equipmentPicketageRefsupplierEntity.getPurchaseType() == 1){
                equipmentInviteDetailBidderEntities = detailBidderList;
            }

            //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
            allSign = equipmentInviteDetailBidderEntities.stream().allMatch(e -> (e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(e.getNum()) > -1);
            wqSign = equipmentInviteDetailBidderEntities.stream().allMatch(e ->(e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(BigDecimal.ZERO) == 0);
        }


        Integer signStatus = null;
        if (allSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (wqSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (!equipmentPicketageRefsupplierEntity.getSignStatus().equals(TenderSignStatusEnum.已关闭.getCode()) && !allSign && !wqSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }
        if (equipmentPicketageRefsupplierEntity.getSignStatus().equals(TenderSignStatusEnum.已关闭.getCode())) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }
        equipmentPicketageRefsupplierEntity.setSignStatus(signStatus);
        //更新参照表状态
        BigDecimal contractMoney = equipmentPicketageRefsupplierEntity.getContractMoney() == null ? BigDecimal.ZERO : equipmentPicketageRefsupplierEntity.getContractMoney();
        BigDecimal contractMoneyTax = equipmentPicketageRefsupplierEntity.getContractMoneyTax() == null ? BigDecimal.ZERO : equipmentPicketageRefsupplierEntity.getContractMoneyTax();
        equipmentPicketageRefsupplierEntity.setContractMoney(contractMoney.add(tenderPicketageVO.getContractMoney()));
        equipmentPicketageRefsupplierEntity.setContractMoneyTax(contractMoneyTax.add(tenderPicketageVO.getContractMoneyTax()));
        super.updateById(equipmentPicketageRefsupplierEntity);

        //更新招标状态
        LambdaQueryWrapper<EquipmentPicketageRefsupplierEntity> lambdaRef = Wrappers.<EquipmentPicketageRefsupplierEntity>lambdaQuery();
        lambdaRef.eq(EquipmentPicketageRefsupplierEntity::getPicketageId, equipmentPicketageRefsupplierEntity.getPicketageId());
        List<EquipmentPicketageRefsupplierEntity> picketageRefsupplierList = super.list(lambdaRef);
        //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
        Boolean inviteWSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.未签订.getCode());
        Boolean inviteAllSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.全部已签.getCode());
        Boolean inviteAllCloseSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.已关闭.getCode());
        if (inviteWSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (inviteAllSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }
        if (!inviteWSign && !inviteAllSign && !inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }

        equipmentInviteEntity.setSignStatus(signStatus);
        //更新参照表状态
        equipmentInviteService.updateById(equipmentInviteEntity);

        return "更新成功";
    }
}
