package com.ejianc.business.tender.exhibition.controller;

import java.io.Serializable;

import com.ejianc.business.tender.equipment.bean.EquipmentNoticeDetailEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentNoticeEntity;
import com.ejianc.business.tender.equipment.service.IEquipmentNoticeService;
import com.ejianc.business.tender.exhibition.vo.TenderExhibitionDetailVO;
import com.ejianc.business.tender.other.bean.OtherNoticeDetailEntity;
import com.ejianc.business.tender.other.bean.OtherNoticeEntity;
import com.ejianc.business.tender.other.service.IOtherNoticeService;
import com.ejianc.business.tender.prosub.bean.ProsubNoticeDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubNoticeEntity;
import com.ejianc.business.tender.prosub.service.IProsubNoticeService;
import com.ejianc.business.tender.rent.bean.RentNoticeDetailEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeEntity;
import com.ejianc.business.tender.rent.service.IRentNoticeService;
import com.ejianc.business.tender.rmat.bean.RmatNoticeDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeEntity;
import com.ejianc.business.tender.rmat.service.IRmatNoticeService;
import com.ejianc.business.tender.stuff.bean.StuffNoticeDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffNoticeEntity;
import com.ejianc.business.tender.stuff.service.IStuffNoticeDetailService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import com.ejianc.business.tender.sub.bean.SubNoticeDetailEntity;
import com.ejianc.business.tender.sub.bean.SubNoticeEntity;
import com.ejianc.business.tender.sub.service.ISubNoticeService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.exhibition.bean.TenderExhibitionEntity;
import com.ejianc.business.tender.exhibition.service.ITenderExhibitionService;
import com.ejianc.business.tender.exhibition.vo.TenderExhibitionVO;

/**
 * 招标公告对外展示
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("tenderExhibition")
public class TenderExhibitionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ITenderExhibitionService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IStuffNoticeService stuffNoticeService;
    @Autowired
    private ISubNoticeService subNoticeService;
    @Autowired
    private IProsubNoticeService prosubNoticeService;
    @Autowired
    private IOtherNoticeService otherNoticeService;
    @Autowired
    private IEquipmentNoticeService equipmentNoticeService;
    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private IRmatNoticeService rmatNoticeService;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TenderExhibitionVO> queryDetail(Long id) {
    	TenderExhibitionEntity entity = service.selectById(id);
        TenderExhibitionVO exhibitionVO = BeanMapper.map(entity, TenderExhibitionVO.class);
        String flag = entity.getFlag();
        if ("stuff".equals(flag)){
            StuffNoticeEntity stuffNoticeEntity = stuffNoticeService.selectById(entity.getNoticeId());
            List<TenderExhibitionDetailVO> detailVOS = new ArrayList<>();
            for (StuffNoticeDetailEntity stuffNoticeDetailEntity : stuffNoticeEntity.getNoticeDetail()) {
                TenderExhibitionDetailVO vo = new TenderExhibitionDetailVO();
                vo.setId(stuffNoticeDetailEntity.getId());
                vo.setDetailName(stuffNoticeDetailEntity.getMaterialName());//材料名称
                vo.setSpec(stuffNoticeDetailEntity.getSpec());//规格
                vo.setNum(stuffNoticeDetailEntity.getNum());//数量
                detailVOS.add(vo);
            }
            exhibitionVO.setDetailVOS(detailVOS);
        }else if ("sub".equals(flag)){
            SubNoticeEntity subNoticeEntity = subNoticeService.selectById(entity.getNoticeId());
            List<TenderExhibitionDetailVO> detailVOS = new ArrayList<>();
            for (SubNoticeDetailEntity stuffNoticeDetailEntity : subNoticeEntity.getNoticeDetail()) {
                TenderExhibitionDetailVO vo = new TenderExhibitionDetailVO();
                vo.setId(stuffNoticeDetailEntity.getId());
                vo.setDetailName(stuffNoticeDetailEntity.getDetailName());//材料名称
                vo.setSpec(stuffNoticeDetailEntity.getContent());//规格
                vo.setNum(stuffNoticeDetailEntity.getNum());//数量
                detailVOS.add(vo);
            }
            exhibitionVO.setDetailVOS(detailVOS);
        }
        else if ("prosub".equals(flag)){
            ProsubNoticeEntity prosubNoticeEntity = prosubNoticeService.selectById(entity.getNoticeId());
            List<TenderExhibitionDetailVO> detailVOS = new ArrayList<>();
            for (ProsubNoticeDetailEntity stuffNoticeDetailEntity : prosubNoticeEntity.getNoticeDetail()) {
                TenderExhibitionDetailVO vo = new TenderExhibitionDetailVO();
                vo.setId(stuffNoticeDetailEntity.getId());
                vo.setDetailName(stuffNoticeDetailEntity.getDetailName());//材料名称
                vo.setSpec(stuffNoticeDetailEntity.getContent());//规格
                vo.setNum(stuffNoticeDetailEntity.getNum());//数量
                detailVOS.add(vo);
            }
            exhibitionVO.setDetailVOS(detailVOS);
        }
        else if ("equipment".equals(flag)){
            EquipmentNoticeEntity equipmentNoticeEntity = equipmentNoticeService.selectById(entity.getNoticeId());
            List<TenderExhibitionDetailVO> detailVOS = new ArrayList<>();
            for (EquipmentNoticeDetailEntity stuffNoticeDetailEntity : equipmentNoticeEntity.getNoticeDetail()) {
                TenderExhibitionDetailVO vo = new TenderExhibitionDetailVO();
                vo.setId(stuffNoticeDetailEntity.getId());
                vo.setDetailName(stuffNoticeDetailEntity.getMaterialName());//材料名称
                vo.setSpec(stuffNoticeDetailEntity.getSpec());//规格
                vo.setNum(stuffNoticeDetailEntity.getNum());//数量
                detailVOS.add(vo);
            }
            exhibitionVO.setDetailVOS(detailVOS);
        }
        else if ("other".equals(flag)){
            OtherNoticeEntity otherNoticeEntity = otherNoticeService.selectById(entity.getNoticeId());
            List<TenderExhibitionDetailVO> detailVOS = new ArrayList<>();
            for (OtherNoticeDetailEntity stuffNoticeDetailEntity : otherNoticeEntity.getNoticeDetail()) {
                TenderExhibitionDetailVO vo = new TenderExhibitionDetailVO();
                vo.setId(stuffNoticeDetailEntity.getId());
                vo.setDetailName(stuffNoticeDetailEntity.getMaterialName());//材料名称
                vo.setSpec(stuffNoticeDetailEntity.getSpec());//规格
                vo.setNum(stuffNoticeDetailEntity.getNum());//数量
                detailVOS.add(vo);
            }
            exhibitionVO.setDetailVOS(detailVOS);
        }
        else if ("rent".equals(flag)){
            RentNoticeEntity rentNoticeEntity = rentNoticeService.selectById(entity.getNoticeId());
            List<TenderExhibitionDetailVO> detailVOS = new ArrayList<>();
            for (RentNoticeDetailEntity stuffNoticeDetailEntity : rentNoticeEntity.getNoticeDetail()) {
                TenderExhibitionDetailVO vo = new TenderExhibitionDetailVO();
                vo.setId(stuffNoticeDetailEntity.getId());
                vo.setDetailName(stuffNoticeDetailEntity.getMaterialName());//材料名称
                vo.setSpec(stuffNoticeDetailEntity.getSpec());//规格
                vo.setNum(stuffNoticeDetailEntity.getNum());//数量
                detailVOS.add(vo);
            }
            exhibitionVO.setDetailVOS(detailVOS);
        }
        else if ("rmat".equals(flag)){
            RmatNoticeEntity rmatNoticeEntity = rmatNoticeService.selectById(entity.getNoticeId());
            List<TenderExhibitionDetailVO> detailVOS = new ArrayList<>();
            for (RmatNoticeDetailEntity stuffNoticeDetailEntity : rmatNoticeEntity.getNoticeDetail()) {
                TenderExhibitionDetailVO vo = new TenderExhibitionDetailVO();
                vo.setId(stuffNoticeDetailEntity.getId());
                vo.setDetailName(stuffNoticeDetailEntity.getMaterialName());//材料名称
                vo.setSpec(stuffNoticeDetailEntity.getSpec());//规格
                vo.setNum(stuffNoticeDetailEntity.getNum());//数量
                detailVOS.add(vo);
            }
            exhibitionVO.setDetailVOS(detailVOS);
        }

        return CommonResponse.success("查询详情数据成功！",exhibitionVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenderExhibitionVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TenderExhibitionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TenderExhibitionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderExhibitionVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("tenderMoney");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("undefined")){
                params.remove("undefined");
        }
        IPage<TenderExhibitionEntity> page = service.queryPage(param,false);
        IPage<TenderExhibitionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderExhibitionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TenderExhibitionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TenderExhibition-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTenderExhibitionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TenderExhibitionVO>> refTenderExhibitionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TenderExhibitionEntity> page = service.queryPage(param,false);
        IPage<TenderExhibitionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderExhibitionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
