package com.ejianc.business.tender.expert.bean;

import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料专家评标主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_expert_evaluating")
public class ExpertEvaluatingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="template_id")
    private Long templateId; // 模板Id
    @TableField(value="template_name")
    private String templateName; // 模板名称
    @TableField(value="evaluation_name")
    private String evaluationName; // 评标名称
    @TableField(value="employee_id")
    private Long employeeId; // 招标联系人
    @TableField(value="employee_name")
    private String employeeName; // 招标联系人名称
    @TableField(value="employee_mobile")
    private String employeeMobile; // 招标联系人电话
    @TableField(value="start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date startTime; // 评标开始日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="invite_id")
    private Long inviteId; // 招标ID
    @TableField(value="document_id")
    private Long documentId; // 招标文件主键
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式
    @TableField(value="gather_status")
    private Integer gatherStatus; // 汇总状态(0-待汇总,1-已汇总
    @TableField(value="gather_reason")
    private String gatherReason; // 汇总原因
    @TableField(value="invite_type")
    private Integer inviteType; // 招标类型
    @TableField(value="distinction_flag")
    private Integer distinctionFlag; // 是否区分商务/技术（0-是，1-否）
    @TableField(value="sub_type")
    private Long subType; // 分包类型 ,0-专业分包,1-劳务分包(分包线专用)
    @TableField(value="unit_id")
    private Long unitId; // 招标单位ID
    @TableField(value="unit_name")
    private String unitName; // 招标单位名称
    
    @TableField(exist=false)
    @SubEntity(serviceName="expertEvaluatingDetailService",pidName = "evaluationId")
    private List<ExpertEvaluatingDetailEntity> stuffEvaluationDetailEntities = new ArrayList<>(); // 材料专家评标专家子表

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    /**
     *  分包类型 ,0-专业分包,1-劳务分包(分包线专用)
     *
     */
    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    /**
     *  是否区分商务/技术
     *
     */
    public Integer getDistinctionFlag() {
        return distinctionFlag;
    }

    public void setDistinctionFlag(Integer distinctionFlag) {
        this.distinctionFlag = distinctionFlag;
    }

    /**
     *  招标类型
     *
     */
    public Integer getInviteType() {
        return inviteType;
    }

    public void setInviteType(Integer inviteType) {
        this.inviteType = inviteType;
    }

    /**
     *  采购方式
     *
     */

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getGatherReason() {
        return gatherReason;
    }

    public void setGatherReason(String gatherReason) {
        this.gatherReason = gatherReason;
    }

    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 模板Id
     */
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * 模板Id
     */
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
    /**
     * 模板名称
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * 模板名称
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
    /**
     * 评标名称
     */
    public String getEvaluationName() {
        return evaluationName;
    }

    /**
     * 评标名称
     */
    public void setEvaluationName(String evaluationName) {
        this.evaluationName = evaluationName;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 评标开始日期
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * 评标开始日期
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 招标ID
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标ID
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 招标文件主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
    /**
     * 材料专家评标专家子表
     */
    public List<ExpertEvaluatingDetailEntity> getStuffEvaluationDetailEntities() {
        return stuffEvaluationDetailEntities;
    }

    /**
     * 材料专家评标专家子表
     */
    public void setStuffEvaluationDetailEntities(List<ExpertEvaluatingDetailEntity> stuffEvaluationDetailEntities) {
        this.stuffEvaluationDetailEntities = stuffEvaluationDetailEntities;
    }

    public Integer getGatherStatus() {
        return gatherStatus;
    }

    public void setGatherStatus(Integer gatherStatus) {
        this.gatherStatus = gatherStatus;
    }
}
