package com.ejianc.business.tender.expert.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 评标记录汇总表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_expert_record_total")
public class ExpertRecordTotalEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标ID
    @TableField(value="employee_id")
    private Long employeeId; // 评标专家ID
    @TableField(value="employee_name")
    private String employeeName; // 评标专家名称
    @TableField(value="template_id")
    private Long templateId; // 模板ID
    @TableField(value="evaluation_id")
    private Long evaluationId; // 专家评标主键
    @TableField(value="document_id")
    private Long documentId; // 招标文件ID
    @TableField(value="document_scheme_id")
    private Long documentSchemeId; // 招标文件方案主键
    @TableField(value="reject_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date rejectTime; // 驳回时间
    @TableField(value="reject_reason")
    private String rejectReason; // 驳回原因
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="evaluation_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date evaluationTime; // 评标时间
    
    
    

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
    public Long getEvaluationId() {
        return evaluationId;
    }

    public void setEvaluationId(Long evaluationId) {
        this.evaluationId = evaluationId;
    }
    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    public Long getDocumentSchemeId() {
        return documentSchemeId;
    }

    public void setDocumentSchemeId(Long documentSchemeId) {
        this.documentSchemeId = documentSchemeId;
    }
    public Date getRejectTime() {
        return rejectTime;
    }

    public void setRejectTime(Date rejectTime) {
        this.rejectTime = rejectTime;
    }
    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getEvaluationTime() {
        return evaluationTime;
    }

    public void setEvaluationTime(Date evaluationTime) {
        this.evaluationTime = evaluationTime;
    }
    
}
