package com.ejianc.business.tender.expert.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.business.tender.expert.service.IExpertRecordScoreService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.tender.expert.service.IExpertRecordService;

/**
 * 评标记录表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("expertRecord")
@Api(value = "评标记录表", tags = {"评标记录表"})
public class ExpertRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IExpertRecordService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExpertRecordScoreService recordScoreService;

    @Autowired
    private IExpertEvaluatingService evaluatingService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, Object>> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody Map<String, Object> detail) {
        List<List<Map>> supplierDetail = (List<List<Map>>) detail.get("supplierDetail");
        detail.put("supplierDetail",service.saveOrUpdateList(supplierDetail));
        return CommonResponse.success("保存或修改单据成功！",detail);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpertRecordVO> queryDetail(@RequestParam Long id) {
    	ExpertRecordEntity entity = service.selectById(id);
    	ExpertRecordVO vo = BeanMapper.map(entity, ExpertRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertRecordVO> vos) {
        service.removeByIds(vos.stream().map(ExpertRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpertRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ExpertRecordEntity> page = service.queryPage(param,false);
        IPage<ExpertRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertRecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExpertRecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffRecord-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refStuffRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExpertRecordVO>> refStuffRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                    String condition,
                                                                    String searchObject,
                                                                    String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExpertRecordEntity> page = service.queryPage(param,false);
        IPage<ExpertRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpertRecordVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 查询供应商列表
     * @param
     * @Return void
     */
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> querySupplierList(@RequestParam Long documentId,@RequestParam Long templateId,@RequestParam Long id) throws InvocationTargetException, IllegalAccessException {
        Map<String, Object> detailMap = service.querySupplierList(documentId, templateId, id);
        return  CommonResponse.success("查询列表数据成功！",detailMap);
    }

    @ApiOperation("提交")
    @RequestMapping(value = "/submit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse submit( @RequestBody List<ExpertRecordEntity> recordVOList) {
        for (ExpertRecordEntity recordEntity : recordVOList) {
            recordEntity.setFlag(1);
            service.saveOrUpdate(recordEntity);
        }
        //更新专家评标状态
        Integer evaluationState = 1;
        evaluatingService.updateState(evaluationState,recordVOList.get(0).getEvaluationId(),sessionManager.getUserContext().getEmployeeId(),new DateTime());
        return CommonResponse.success("保存或修改单据成功！");
    }

}
