package com.ejianc.business.tender.expert.service.impl;

import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.service.IExpertService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("expert") 
public class ExpertBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IExpertService service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("撤回单据信息：【billId】:"+billId+"----【state】:"+state+"----【billTypeCode】:"+billTypeCode);
		ExpertEntity expertEntity = service.selectById(billId);
		Long expertId = expertEntity.getExpertId();
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, expertId);
		logger.info("引用判断信息："+res);
		if (!res.isSuccess()){
			logger.info("进入引用判断");
			return CommonResponse.error("单据被引用不能撤回！");
		}
		logger.info("未进入引用判断");
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("弃审单据信息：【billId】:"+billId+"----【state】:"+state+"----【billTypeCode】:"+billTypeCode);
		ExpertEntity expertEntity = service.selectById(billId);
		Long expertId = expertEntity.getExpertId();
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, expertId);
		logger.info("引用判断信息："+res);
		if (!res.isSuccess()){
			logger.info("进入引用判断");
			return CommonResponse.error("单据被引用不能弃审！");
		}
		logger.info("未进入引用判断");
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
