package com.ejianc.business.tender.other.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 定标主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_other_picketage")
public class OtherPicketageEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="invite_id")
    private Long inviteId; // 招标立项主键
    @TableField(value="evaluation_id")
    private Long evaluationId; // 评标主键
    @TableField(value="document_id")
    private Long documentId; // 招标文件主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="picketage_name")
    private String picketageName; // 定标名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="employee_id")
    private Long employeeId; // 招标联系人
    @TableField(value="employee_name")
    private String employeeName; // 招标联系人名称
    @TableField(value="employee_mobile")
    private String employeeMobile; // 招标联系人电话
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="value_type")
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    @TableField(value="project_link_name")
    private String projectLinkName; // 项目联系人
    @TableField(value="project_link_phone")
    private String projectLinkPhone; // 项目联系人电话
    @TableField(value="picketage_flag")
    private Integer picketageFlag; // 是否生成定标通知书,0-是,1-否
    @TableField(value="purchase_id")
    private String purchaseId; // 采购方式ID
    @TableField(value="purchase_name")
    private String purchaseName; // 采购方式名称
    @TableField(value="next_flag")
    private Integer nextFlag; // 是否下一步,0-是,1-否
    @TableField(value="bid_id")
    private Long bidId; // 中标通知书主键
    @TableField(value="bid_status")
    private Integer bidStatus; // 生成中标通知书状态,0-未点击,1-已点击未发布,2-已发布
    @TableField(value="winnotice_id")
    private Long winnoticeId;//中标公告主键
    @TableField(value="winnotice_status")
    private Integer winnoticeStatus;//生成中标公告状态,0-未点击,1-已点击未发布,2-已发布
    @TableField(value="trustees_id")
    private Long trusteesId; // 经办人ID
    @TableField(value="trustees_name")
    private String trusteesName; // 经办人名称
    @TableField(value="picketage_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date picketageTime; // 定标时间
    @TableField(value="line_type_name")
    private String lineTypeName; // 材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
    @TableField(value="trustees_phone")
    private String trusteesPhone; //经办人电话
    @TableField(value="tender_type_name")
    private String tenderTypeName; //招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    @TableField(value="unit_name")
    private String unitName; //招标单位名称
    @TableField(value="is_low_price")
    private java.lang.Integer isLowPrice; // 低价中标
    @TableField(value="gather_reason")
    private String gatherReason; // 汇总原因

    public String getGatherReason() {
        return gatherReason;
    }

    public void setGatherReason(String gatherReason) {
        this.gatherReason = gatherReason;
    }

    public Integer getIsLowPrice() {
        return isLowPrice;
    }

    public void setIsLowPrice(Integer isLowPrice) {
        this.isLowPrice = isLowPrice;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getLineTypeName() {
        return lineTypeName;
    }

    public void setLineTypeName(String lineTypeName) {
        this.lineTypeName = lineTypeName;
    }

    public String getTrusteesPhone() {
        return trusteesPhone;
    }

    public void setTrusteesPhone(String trusteesPhone) {
        this.trusteesPhone = trusteesPhone;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }
    @TableField(exist=false)
    @SubEntity(serviceName="otherPicketageSupplierService", pidName= "picketageId")
    private List<OtherPicketageSupplierEntity> picketageSupplierList = new ArrayList<>(); //中标供应商表
    @TableField(exist=false)
    @SubEntity(serviceName="otherPicketageSupplierService", pidName= "picketageId")
    private List<OtherPicketageRefsupplierEntity> refsupplierList = new ArrayList<>(); //中标供应商参照表

    public List<OtherPicketageRefsupplierEntity> getRefsupplierList() {
        return refsupplierList;
    }

    public void setRefsupplierList(List<OtherPicketageRefsupplierEntity> refsupplierList) {
        this.refsupplierList = refsupplierList;
    }

    public Long getTrusteesId() {
        return trusteesId;
    }

    public void setTrusteesId(Long trusteesId) {
        this.trusteesId = trusteesId;
    }

    public String getTrusteesName() {
        return trusteesName;
    }

    public void setTrusteesName(String trusteesName) {
        this.trusteesName = trusteesName;
    }

    public Date getPicketageTime() {
        return picketageTime;
    }

    public void setPicketageTime(Date picketageTime) {
        this.picketageTime = picketageTime;
    }

    public Long getWinnoticeId() {
        return winnoticeId;
    }

    public void setWinnoticeId(Long winnoticeId) {
        this.winnoticeId = winnoticeId;
    }

    public Integer getWinnoticeStatus() {
        return winnoticeStatus;
    }

    public void setWinnoticeStatus(Integer winnoticeStatus) {
        this.winnoticeStatus = winnoticeStatus;
    }

    public List<OtherPicketageSupplierEntity> getPicketageSupplierList() {
        return picketageSupplierList;
    }

    public void setPicketageSupplierList(List<OtherPicketageSupplierEntity> picketageSupplierList) {
        this.picketageSupplierList = picketageSupplierList;
    }

    public Long getBidId() {
        return bidId;
    }

    public void setBidId(Long bidId) {
        this.bidId = bidId;
    }

    public Integer getBidStatus() {
        return bidStatus;
    }

    public void setBidStatus(Integer bidStatus) {
        this.bidStatus = bidStatus;
    }

    public Integer getNextFlag() {
        return nextFlag;
    }

    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public Long getEvaluationId() {
        return evaluationId;
    }

    public void setEvaluationId(Long evaluationId) {
        this.evaluationId = evaluationId;
    }

    /**
     * 招标文件主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 定标名称
     */
    public String getPicketageName() {
        return picketageName;
    }

    /**
     * 定标名称
     */
    public void setPicketageName(String picketageName) {
        this.picketageName = picketageName;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目联系人
     */
    public String getProjectLinkName() {
        return projectLinkName;
    }

    /**
     * 项目联系人
     */
    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    /**
     * 项目联系人电话
     */
    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    /**
     * 项目联系人电话
     */
    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    /**
     * 是否生成定标通知书,0-是,1-否
     */
    public Integer getPicketageFlag() {
        return picketageFlag;
    }

    /**
     * 是否生成定标通知书,0-是,1-否
     */
    public void setPicketageFlag(Integer picketageFlag) {
        this.picketageFlag = picketageFlag;
    }
    /**
     * 采购方式ID
     */
    public String getPurchaseId() {
        return purchaseId;
    }

    /**
     * 采购方式ID
     */
    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }
    /**
     * 采购方式名称
     */
    public String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购方式名称
     */
    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    
}
