package com.ejianc.business.tender.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.service.impl.OtherPicketageBpmServiceImpl;
import com.ejianc.business.tender.other.vo.OtherPicketageRefsupplierVO;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.service.IOtherDocumentSellService;
import com.ejianc.business.tender.other.service.IOtherInviteDetailBidderService;
import com.ejianc.business.tender.other.service.IOtherInviteDetailRecordService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.vo.OtherDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageRefsupplierVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherPicketageRefsupplier")
@Api(value = "定标供应商参照表(下游单据使用)", tags = {"定标供应商参照表(下游单据使用)"})
public class OtherPicketageRefsupplierController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private OtherPicketageBpmServiceImpl otherPicketageBpmService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOtherPicketageRefsupplierService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherInviteDetailBidderService otherInviteDetailBidderService;
    @Autowired
    private IOtherInviteDetailRecordService otherInviteDetailRecordService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherPicketageRefsupplierVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OtherPicketageRefsupplierVO saveOrUpdateVO) {
    	OtherPicketageRefsupplierEntity entity = BeanMapper.map(saveOrUpdateVO, OtherPicketageRefsupplierEntity.class);
    	service.saveOrUpdate(entity, false);
    	OtherPicketageRefsupplierVO vo = BeanMapper.map(entity, OtherPicketageRefsupplierVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherPicketageRefsupplierVO> queryDetail(@RequestParam Long id) {
    	OtherPicketageRefsupplierEntity entity = service.selectById(id);
    	OtherPicketageRefsupplierVO vo = BeanMapper.map(entity, OtherPicketageRefsupplierVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    @ApiOperation("参照")
    @RequestMapping(value = "/refOthersupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherPicketageRefsupplierVO>> refOthersupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("picketageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //未占用状态
//        param.getParams().put("occupyFlag", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("picketageDate",QueryParam.DESC);
        //查询本下范围内日的合同
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        if(CollectionUtils.isNotEmpty(orgVOList)) {
            List<Long> ids = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, ids));
        }

        List<Integer> listStatus = new ArrayList<>();
        listStatus.add(TenderSignStatusEnum.未签订.getCode());
        listStatus.add(TenderSignStatusEnum.部分签订.getCode());
        param.getParams().put("signStatus", new Parameter(QueryParam.IN, listStatus));
        IPage<OtherPicketageRefsupplierEntity> page = service.queryPage(param,false);
        IPage<OtherPicketageRefsupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OtherPicketageRefsupplierEntity> records = page.getRecords();
        if (CollectionUtils.isNotEmpty(records)) {

            for (OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity : records) {
                if (otherPicketageRefsupplierEntity.getPurchaseType() == 0) {
//                    (0-项目采购,1-单位采购)
                    otherPicketageRefsupplierEntity.setPurchaseTypeName("项目采购");
                }
                if (otherPicketageRefsupplierEntity.getPurchaseType() == 1) {
//                    (0-项目采购,1-单位采购)
                    otherPicketageRefsupplierEntity.setPurchaseTypeName("公司采购");
                }

            }

        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherPicketageRefsupplierVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("定标子表参照")
    @RequestMapping(value = "/refOtherDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherDocumentSellVO>> refOtherDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long id = null;

        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("id")) {
                id = Long.valueOf(conditionMap.get("id").toString());
            }
        }
        OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = service.selectById(id);
        Integer picketageFlag = otherPicketageRefsupplierEntity.getPicketageFlag();
        //定标类型0-流程定标,1-直接定标  区分数据源
        if (picketageFlag == 0) {
            OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(otherPicketageRefsupplierEntity.getPicketageId());
            param.getParams().put("documentId", new Parameter(QueryParam.EQ, otherPicketageEntity.getDocumentId()));
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, otherPicketageRefsupplierEntity.getSupplierId()));
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, otherPicketageRefsupplierEntity.getProjectId()));
            param.getParams().put("tenderFlag", new Parameter(QueryParam.EQ, 1));
            IPage<OtherDocumentSellEntity> page = otherDocumentSellService.queryPage(param, false);
            IPage<OtherDocumentSellVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<OtherDocumentSellVO> otherDocumentSellVOList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(page.getRecords())) {
                otherDocumentSellVOList = BeanMapper.mapList(page.getRecords(), OtherDocumentSellVO.class);
            }
            pageData.setRecords(otherDocumentSellVOList);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }

        if (picketageFlag == 1) {
            List<OtherDocumentSellVO> otherDocumentSellVOS = new ArrayList<>();
            List<OtherInviteDetailBidderEntity> bidderEntityList1 = otherInviteDetailBidderService.list(new QueryWrapper<OtherInviteDetailBidderEntity>()
                    .eq("invite_id", otherPicketageRefsupplierEntity.getPicketageId())
                    .eq("supplier_id", otherPicketageRefsupplierEntity.getSupplierId())
                    .eq("dr", 0));
            for (OtherInviteDetailBidderEntity bidderEntity : bidderEntityList1) {
                OtherDocumentSellVO otherDocumentSellVO = new OtherDocumentSellVO();
                OtherInviteDetailRecordEntity recordEntity = otherInviteDetailRecordService.selectById(bidderEntity.getInviteDetailId());
                otherDocumentSellVO.setId(bidderEntity.getId());
                otherDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                otherDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                otherDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                otherDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                otherDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                otherDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                otherDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                otherDocumentSellVO.setUnit(recordEntity.getUnit());
                otherDocumentSellVO.setSpec(recordEntity.getSpec());
                otherDocumentSellVO.setDetailId(bidderEntity.getId());
                otherDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                otherDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                otherDocumentSellVO.setBrand(bidderEntity.getBrand());
                otherDocumentSellVO.setPrice(bidderEntity.getPrice());
                otherDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                otherDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                otherDocumentSellVO.setTenderNum(bidderEntity.getNum());
                otherDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                otherDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                otherDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                otherDocumentSellVOS.add(otherDocumentSellVO);
            }
            IPage<OtherDocumentSellVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), otherDocumentSellVOS.size());
            // 进行分页处理
            pageDate.setRecords(otherDocumentSellVOS.stream().skip((long) (param.getPageIndex() - 1) * param.getPageSize())
                    .limit(param.getPageSize()).collect(Collectors.toList()));
            return CommonResponse.success("查询参照数据成功！", pageDate);
        }
        return null;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
