package com.ejianc.business.tender.other.mapper;

import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface OtherInviteMapper extends BaseCrudMapper<OtherInviteEntity> {
    @Update("UPDATE ejc_tender_other_invite SET tender_stage = #{tenderStage} WHERE id = #{id} ")
    void updateTenderStage(String id, int tenderStage);
    @Update("UPDATE ejc_tender_other_invite SET abolish_type = #{abolishType} WHERE id = #{id} ")
    void updateAbolishType(String id, int abolishType);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money  FROM `ejc_tender_other_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_name ,material_type_name,rate")
    List<OtherInviteDetailVO> selectSumDetail(Long inviteId);
    @Select("SELECT *,sum(num) sum_num,sum(money_tax) sum_money_tax,sum(money) sum_money  FROM `ejc_tender_other_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr = 0 GROUP BY material_name ,material_type_name,rate")
    List<OtherInviteDetailVO> selectOrgSumDetail(Long inviteId);
    @Select("SELECT *,sum( tax_money ) sum_tax_money,sum( money ) sum_money,sum( num ) sum_num FROM `ejc_tender_other_invite_detail_bidder` WHERE invite_id = #{inviteId} GROUP BY supplier_id ")
    List<OtherInviteDetailBidderVO> selectDetailBidder(Long inviteId);
}
