package com.ejianc.business.tender.prosub.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.prosub.api.IContractApi;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailBidderVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailRecordVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteVO;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailBidderEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.bean.SubInviteDetailBidderEntity;
import com.ejianc.business.tender.sub.bean.SubInviteDetailRecordEntity;
import com.ejianc.business.tender.sub.service.ISubBatPlanService;
import com.ejianc.business.tender.sub.vo.TenderStageEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("prosub/prosubInvite")
public class ProsubInviteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TENDER_PROSUB";//此处需要根据实际修改

    /** 参照查询：项目ID */
    private static final String CONDITION_PROJECT_ID = "projectId";
    /** 参照查询：组织ID */
    private static final String CONDITION_ORG_ID = "orgId";

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IProsubInviteService service;

    @Autowired
    private IProsubInviteDetailRecordService detailRecordService;
    @Autowired
    private IProsubInviteDetailBidderService detailBidderService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private IBatPlanApi batPlanApi;

    @Autowired
    private IProsubPicketageService picketageService;

    @Autowired
    private IProsubPicketageRefsupplierService refsupplierService;

    @Autowired
    private IContractApi contractApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProSubBatPlanService prosubBatPlanService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubInviteVO> saveOrUpdate(@RequestBody ProsubInviteVO saveorUpdateVO) {
        //处理子表供应商中标信息
        List<ProsubInviteDetailRecordVO> subInviteDetailList = saveorUpdateVO.getSubDetailRecord();
        List<ProsubInviteDetailBidderEntity> bidderEntityList = new ArrayList<ProsubInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty(subInviteDetailList)){
            for (ProsubInviteDetailRecordVO subInviteDetailVO : subInviteDetailList){
                if (subInviteDetailVO.getId() == null){
                    long id = IdWorker.getId();
                    subInviteDetailVO.setId(id);
                }
                List<ProsubInviteDetailBidderVO> bidderList = subInviteDetailVO.getSubDetailBidder();
                if(CollectionUtils.isNotEmpty(bidderList)){
                    for (ProsubInviteDetailBidderVO bidderVO : bidderList){
                        bidderVO.setId(subInviteDetailVO.getId());
                        ProsubInviteDetailBidderEntity bidderEntity = BeanMapper.map(bidderVO, ProsubInviteDetailBidderEntity.class);
                        bidderEntityList.add(bidderEntity);
                    }
                }
            }
        }

        ProsubInviteEntity entity = BeanMapper.map(saveorUpdateVO, ProsubInviteEntity.class);
        if (CollectionUtils.isNotEmpty(bidderEntityList)){
            entity.setSubDetailBidder(bidderEntityList);
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //修改批次计划状态
        // 获取采购计划ID
        List<String> planIdListOld;
        if (entity.getEstablishType() == 0 ) {//招标立项
            planIdListOld = detailRecordService.list(new LambdaQueryWrapper<ProsubInviteDetailRecordEntity>()
                    .eq(ProsubInviteDetailRecordEntity::getInviteId, saveorUpdateVO.getId())).stream()
                    .map(ProsubInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
                    .collect(Collectors.toList());
        }  else {
            planIdListOld = detailBidderService.list(new LambdaQueryWrapper<ProsubInviteDetailBidderEntity>()
                    .eq(ProsubInviteDetailBidderEntity::getInviteId, saveorUpdateVO.getId())).stream()
                    .map(ProsubInviteDetailBidderEntity::getPlanId).map(String::valueOf).distinct()
                    .collect(Collectors.toList());
        }

        // 释放采购计划
        if (CollectionUtils.isNotEmpty(planIdListOld)) {
            prosubBatPlanService.updateBatPlanByQuoteType(planIdListOld, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
        }
        //保存前清空主键和父主键，重新生成
        List<ProsubInviteDetailRecordEntity> detailList = entity.getSubDetailRecord();
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap=new HashMap<>();
            for(ProsubInviteDetailRecordEntity cdEntity : detailList){
                if (cdEntity.getId() == null){
                    cdEntity.setId(com.baomidou.mybatisplus.core.toolkit.IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(),cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for(ProsubInviteDetailRecordEntity cdEntity : detailList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ProsubInviteDetailBidderEntity> bidderList = entity.getSubDetailBidder();
        if(CollectionUtils.isNotEmpty(bidderList)){
            Map<String,Long> idMap=new HashMap<>();
            for(ProsubInviteDetailBidderEntity cdEntity : bidderList){
                if (cdEntity.getId() == null){
                    cdEntity.setId(com.baomidou.mybatisplus.core.toolkit.IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(),cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for(ProsubInviteDetailBidderEntity cdEntity : bidderList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
        }
        entity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
    	service.saveOrUpdate(entity, false);
    	ProsubInviteVO vo = BeanMapper.map(entity, ProsubInviteVO.class);

        //处理供应商子表信息
        List<ProsubInviteDetailRecordVO> subInviteDetailVOList = vo.getSubDetailRecord();
        List<ProsubInviteDetailBidderVO> subInviteDetailBidderVOList = vo.getSubDetailBidder();
        if (CollectionUtils.isNotEmpty(subInviteDetailBidderVOList)){
            Map<Long, List<ProsubInviteDetailBidderVO>> bidderMap = subInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(ProsubInviteDetailBidderVO::getId));
            if (CollectionUtils.isNotEmpty(subInviteDetailVOList)){
                for (ProsubInviteDetailRecordVO subInviteDetailVO : subInviteDetailVOList){
                    List<ProsubInviteDetailBidderVO> subInviteDetailBidderVOS = bidderMap.get(subInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(subInviteDetailBidderVOS)){
                        subInviteDetailVO.setSubDetailBidder(subInviteDetailBidderVOS);
                    }
                }
            }
        }

        // 获取采购计划ID
        List<String> planIdList;
        if (entity.getEstablishType() == 0 ) {//招标立项
            planIdList = entity.getSubDetailRecord().stream().map(ProsubInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
        }  else {
            planIdList = entity.getSubDetailBidder().stream().map(ProsubInviteDetailBidderEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
        }
        // 释放采购计划
        if (CollectionUtils.isNotEmpty(planIdList)) {
            prosubBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState(),0);
        }
        if (entity.getEstablishType()==1){
            //修改招标状态
            List<Long> inviteIdList = entity.getSubDetailBidder().stream().map(ProsubInviteDetailBidderEntity::getSourceId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inviteIdList)) {
                UpdateWrapper<ProsubInviteEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("occupy_state",1).in("id", inviteIdList);
                service.update(wrapper);
            }
        }

        //保存招标过程记录表
        if (!processService.selectByBillId(entity.getId())){
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType()==1){
                processEntity.setBillName("定标立项");
            }else {
                processEntity.setBillName("招标立项");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(6);
            processEntity.setFrontendUrl("prosub/invite/card");
            processService.saveOrUpdate(processEntity);
        }
        return CommonResponse.success("保存或修改单据成功！",service.queryDetailTree(vo.getId()));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubInviteVO> queryDetail(Long id) {
        ProsubInviteVO vo = service.queryDetailTree(id);
        //处理供应商子表信息
        List<ProsubInviteDetailRecordVO> subInviteDetailVOList = vo.getSubDetailRecord();
        List<ProsubInviteDetailBidderVO> subInviteDetailBidderVOList = vo.getSubDetailBidder();
        if (CollectionUtils.isNotEmpty(subInviteDetailBidderVOList)){
            Map<Long, List<ProsubInviteDetailBidderVO>> bidderMap = subInviteDetailBidderVOList.stream().
                    collect(Collectors.groupingBy(ProsubInviteDetailBidderVO::getId));
            if (CollectionUtils.isNotEmpty(subInviteDetailVOList)){
                for (ProsubInviteDetailRecordVO subInviteDetailVO : subInviteDetailVOList){
                    List<ProsubInviteDetailBidderVO> subInviteDetailBidderVOS = bidderMap.get(subInviteDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(subInviteDetailBidderVOS)){
                        subInviteDetailVO.setSubDetailBidder(subInviteDetailBidderVOS);
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubInviteVO> vos) {
        for (ProsubInviteVO vo : vos) {
            // 获取采购计划ID
            List<String> planIdList;

            //修改招标状态
            ProsubInviteEntity inviteEntity = service.selectById(vo.getId());
            if (inviteEntity.getEstablishType()==1){
                List<String> inviteIdList = detailBidderService.list(new LambdaQueryWrapper<ProsubInviteDetailBidderEntity>()
                        .eq(ProsubInviteDetailBidderEntity::getInviteId, vo.getId()))
                        .stream().map(ProsubInviteDetailBidderEntity::getSourceId)
                        .map(String::valueOf).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(inviteIdList)) {
                    UpdateWrapper<ProsubInviteEntity> wrapper = new UpdateWrapper<>();
                    wrapper.set("occupy_state",0).in("id", inviteIdList);
                    service.update(wrapper);
                }


                planIdList = detailBidderService.list(new LambdaQueryWrapper<ProsubInviteDetailBidderEntity>()
                        .eq(ProsubInviteDetailBidderEntity::getInviteId, vo.getId())).stream()
                        .map(ProsubInviteDetailBidderEntity::getPlanId).map(String::valueOf).distinct()
                        .collect(Collectors.toList());
            }else {
                planIdList = detailRecordService.list(new LambdaQueryWrapper<ProsubInviteDetailRecordEntity>()
                        .eq(ProsubInviteDetailRecordEntity::getInviteId, vo.getId())).stream()
                        .map(ProsubInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
                        .collect(Collectors.toList());
            }


            // 释放采购计划
            if (CollectionUtils.isNotEmpty(planIdList)) {
                prosubBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_WAIT.getPlanState(),0);
            }
        }
        service.removeByIds(vos.stream().map(ProsubInviteVO::getId).collect(Collectors.toList()),true);
        processService.remove(new LambdaQueryWrapper<ProcessEntity>().in(ProcessEntity::getBillId,vos.stream().map(ProsubInviteVO::getId).collect(Collectors.toList())));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProsubInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("subType");
        fuzzyFields.add("billCode");
//        fuzzyFields.add("purchaseTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("employeeId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().put("employeeId", new Parameter(QueryParam.NE, Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProsubInviteEntity> page = service.queryPage(param,false);
        IPage<ProsubInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProsubInviteVO.class));
        for (ProsubInviteVO record : pageData.getRecords()) {
            if(record.getTenderType() != null){
                switch (record.getTenderType()){
                    case 0:
                        record.setTenderTypeName("平台公开招标");
                        break;
                    case 1:
                        record.setTenderTypeName("邀请招标");
                        break;
                    case 2:
                        record.setTenderTypeName("询价");
                        break;
                    case 3:
                        record.setTenderTypeName("竞争性谈判");
                        break;
                    case 4:
                        record.setTenderTypeName("单一来源");
                        break;
                    case 5:
                        record.setTenderTypeName("紧急招标");
                        break;
                }
                switch (record.getSignStatus()){
                    case 0:
                        record.setSignStatusName("未签订");
                        break;
                    case 1:
                        record.setSignStatusName("部分签订");
                        break;
                    case 2:
                        record.setSignStatusName("全部已签");
                        break;
                    case 3:
                        record.setSignStatusName("已关闭");
                        break;
                }
            }

            record.setEstablishTypeName(record.getEstablishType()==0?"招标立项":"定标立项");
            record.setPurchaseTypeName(record.getPurchaseType()==0?"项目采购":"单位采购");
            record.setSubTypeName(record.getSubType()==1471313836879101953L?"专业分包":"劳务分包");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode(record.getTenderStage()).getDescription());
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProsubInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ProsubInviteVO> voList = JSON.parseArray(JSON.toJSONString(list), ProsubInviteVO.class);
        for (ProsubInviteVO subInviteVO : voList) {
            switch (subInviteVO.getTenderType()){
                case 0:
                    subInviteVO.setTenderTypeName("平台公开招标");
                    break;
                case 1:
                    subInviteVO.setTenderTypeName("邀请招标");
                    break;
                case 2:
                    subInviteVO.setTenderTypeName("询价");
                    break;
                case 3:
                    subInviteVO.setTenderTypeName("竞争性谈判");
                    break;
                case 4:
                    subInviteVO.setTenderTypeName("单一来源");
                    break;
                case 5:
                    subInviteVO.setTenderTypeName("紧急招标");
                    break;
            }
            subInviteVO.setEstablishTypeName(subInviteVO.getEstablishType()==0?"招标立项":"定标立项");
            subInviteVO.setPurchaseTypeName(subInviteVO.getPurchaseType()==0?"项目采购":"单位采购");
            subInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode(subInviteVO.getBillState()).getDescription());
            subInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode(subInviteVO.getTenderStage()).getDescription());
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("材料立项.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProsubInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProsubInviteVO>> refProsubInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {

            QueryParam param = new QueryParam();
            param.setPageSize(pageSize);
            param.setPageIndex(pageNumber);
            param.setSearchText(searchText);
            param.setSearchObject(searchObject);
            /** 租户隔离 */
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
            param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            param.getParams().put("tenderPlatform", new Parameter(QueryParam.EQ, 2));
            param.getParams().put("occupyState", new Parameter(QueryParam.EQ, 0));

            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("billCode");
            fuzzyFields.add("tenderName");

            if (StringUtils.isNotEmpty(condition)) {
                /** 处理condition */
                JSONObject _con = JSONObject.parseObject(condition);
                // 项目id
                if (_con.containsKey(CONDITION_PROJECT_ID)) {
                    Long projectId = Long.parseLong(_con.get(CONDITION_PROJECT_ID).toString());
                    CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                    if (!projectResponse.isSuccess()) {
                        throw new BusinessException("查询项目信息失败！");
                    }
                    param.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
                }
                // 组织id
                if (_con.containsKey(CONDITION_ORG_ID)) {
                    Long orgId = Long.valueOf(_con.get(CONDITION_ORG_ID).toString());
                    CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
                    OrgVO orgVO = orgResp.getData();
                    /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
                    if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                        param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
                    }
                    else {
                        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                                .findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId)
                                .collect(Collectors.toList())));
                    }
                }
                if (_con.containsKey("subType")) {
                    Long subType = Long.valueOf(_con.get("subType").toString());
                    param.getParams().put("subType", new Parameter(QueryParam.EQ, subType));
                }
                if(_con.containsKey("purchaseType")){
                    Integer purchaseType = _con.getInteger("purchaseType");
                    param.getParams().put("purchaseType", new Parameter(QueryParam.EQ,purchaseType));
                }
            }
            IPage<ProsubInviteEntity> page = service.queryPage(param, false);
            IPage<ProsubInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProsubInviteVO.class));

            if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
                List<ProsubInviteVO> subInviteVOList = pageData.getRecords();
                List<String> idList = subInviteVOList.stream().map(ProsubInviteVO::getId).map(String::valueOf)
                        .collect(Collectors.toList());
                // 查询子表
                QueryParam detailParam = new QueryParam();
                detailParam.getParams().put("inviteId", new Parameter(QueryParam.IN, idList));
                List<ProsubInviteDetailRecordEntity> detailEntityList = detailRecordService.queryList(detailParam);
                List<ProsubInviteDetailRecordVO> detailVOList = BeanMapper.mapList(detailEntityList, ProsubInviteDetailRecordVO.class);
                Map<Long, List<ProsubInviteDetailRecordVO>> detailMap = new HashMap<>();
                List<ProsubInviteDetailRecordVO> mapList;
                // 按照planID对子表结果分组
                for (ProsubInviteDetailRecordVO vo : detailVOList) {
                    if (detailMap.containsKey(vo.getInviteId())) {
                        detailMap.get(vo.getInviteId()).add(vo);
                    }
                    else {
                        mapList = new ArrayList<>();
                        mapList.add(vo);
                        detailMap.put(vo.getInviteId(), mapList);
                    }
                }
                // 将清单添加到主表中
                subInviteVOList.forEach(t -> {
                    t.setSubDetailRecord(detailMap.get(t.getId()));
                });
            }
            return CommonResponse.success("查询参照数据成功！", pageData);
     }

    /**
     * @Description saveOrUpdate 获取流/废标状态
     */
    @RequestMapping(value = "/getAType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> getAType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        ProsubInviteEntity subInviteEntity = service.selectById(tenderId);
        ProsubInviteVO vo = BeanMapper.map(subInviteEntity, ProsubInviteVO.class);
        if(vo.getAbolishType()==null){
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId",vo.getEmployeeId());
        return CommonResponse.success("查询流/废标状态成功！",map);
    }
    /**
     * @Description 子表导出
     * @param
     * @Return void
     */
    @RequestMapping(value = "/detailExcelExport", method = RequestMethod.GET)
    @ResponseBody
    public void detailExcelExport(Long id,HttpServletResponse response) {
        List<ProsubInviteDetailBidderVO> detailList = service.querySonDetail(id);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("subInviteDetail.xlsx", beans, response);
    }
    @RequestMapping(value = "/queryContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody ProsubInviteVO inviteVO) {
        Long refId;
        //招标立项
        if (inviteVO.getEstablishType()==0){
            ProsubPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<ProsubPicketageEntity>().eq("invite_id", inviteVO.getId())).get(0);
            refId=picketageEntity.getId();
        }else {
            refId = inviteVO.getId();
        }
        logger.info("定标ID"+refId);
        List<ProsubPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<ProsubPicketageRefsupplierEntity>().eq("picketage_id", refId));
        List<String> idList = refsupplierList.stream().map(ProsubPicketageRefsupplierEntity::getId).map(String::valueOf).collect(Collectors.toList());
        logger.info("定标参照ID"+JSONObject.toJSONString(idList));
        CommonResponse<List<SignContractVo>> response = contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()){
            throw new BusinessException("查询合同失败"+response.getMsg());
        }
        response.getData().forEach(t->t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        return CommonResponse.success(response.getData());
    }
    @RequestMapping(value = "/closeSignStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        ProsubInviteEntity entity = service.selectById(id);
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            //处于未签订、部分签订
            if (entity.getSignStatus() == 0 || entity.getSignStatus() == 1) {
                //招标立项
                if (establishType == 0) {
                    if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                        ProsubPicketageEntity picketageEntity = picketageService.list(new QueryWrapper<ProsubPicketageEntity>().eq("invite_id", id)).get(0);
                        refId = picketageEntity.getId();
                    }
                }
                //定标立项
                else {
                    if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                        refId = id;
                    }
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
            if (refId != null) {
                logger.info("定标ID" + refId);
                List<ProsubPicketageRefsupplierEntity> refsupplierList = refsupplierService.list(new QueryWrapper<ProsubPicketageRefsupplierEntity>().eq("picketage_id", refId));
                if (CollectionUtils.isNotEmpty(refsupplierList)){
                    refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.已关闭.getCode()));
                    refsupplierService.saveOrUpdateBatch(refsupplierList);
                    entity.setSignStatus(TenderSignStatusEnum.已关闭.getCode());
                    service.saveOrUpdate(entity);
                }else {
                    throw new BusinessException("不符合关闭条件");
                }
            }
            else {
                throw new BusinessException("不符合关闭条件");
            }
        }
        else {
            throw new BusinessException("只有招标经办人才能关闭");
        }
        return CommonResponse.success("关闭成功！");
    }
    /**
     * @Description  判断当前登录人和招标经办人是否相同
     */
    @RequestMapping(value = "/judgeEmployee", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee (Long inviteId) {
        boolean flag = false;
        ProsubInviteEntity entity = service.selectById(inviteId);
        if (sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            flag = true;
        }
        return CommonResponse.success("查询数据成功！", flag);
    }

    /**
     * @Description  根据子表数据获取价格区间
     */

    @RequestMapping(value = "/queryHistoryPrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceContractCollectVO>> queryHistoryPrice (@RequestBody Map<String,Object> param) {

        IPage<PriceContractCollectVO> vos = service.queryHistoryPrice(param);
        return CommonResponse.success("查询成功!",vos);

    }
}
