package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSellMapper;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailBidderVO;
import com.ejianc.business.tender.prosub.vo.ProsubSupplierDataVO;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubDocumentSellMapper;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubSupplierDataVO;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

/**
 * 招标文件报价表
 *
 * @author generator
 */
@Service("prosubDocumentSellService")
public class ProsubDocumentSellServiceImpl extends BaseServiceImpl<ProsubDocumentSellMapper, ProsubDocumentSellEntity> implements IProsubDocumentSellService {
    @Autowired
    private IProsubPicketageService subPicketageService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentDetailService subDocumentDetailService;
    @Autowired
    private IProsubInviteDetailBidderService bidderService;
    @Autowired
    private IProsubPicketageRefsupplierService subPicketageRefsupplierService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public List<ProsubDocumentSellEntity> selectMaterialType(Long documentId) {
        return baseMapper.selectMaterialType(documentId);
    }

    @Override
    public List<ProsubDocumentSellVO> queryListByIds(Long projectId, Long supplierId, Long picketageId) {
        ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(picketageId);
        LambdaQueryWrapper<ProsubDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(ProsubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
        listWrapper.eq(ProsubDocumentSellEntity::getSupplierId, supplierId);
        listWrapper.eq(ProsubDocumentSellEntity::getProjectId, projectId);
        listWrapper.eq(ProsubDocumentSellEntity::getTenderFlag, 1);
        listWrapper.eq(ProsubDocumentSellEntity::getPassFlag, 1);
        List<ProsubDocumentSellEntity> documentSellList = super.list(listWrapper);
        List<ProsubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(documentSellList, ProsubDocumentSellVO.class);
        return subDocumentSellVOList;
    }

    @Override
    public List<ProsubDocumentSellVO> queryTreeByIds(Long id) {
        ProsubPicketageRefsupplierEntity subPicketageRefsupplierEntity = subPicketageRefsupplierService.selectById(id);
        List<ProsubDocumentSellVO> subDocumentSellVOS = new ArrayList<>();
        //流程定标
        if (subPicketageRefsupplierEntity.getPicketageFlag() == 0) {
            ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId());
            LambdaQueryWrapper<ProsubDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(ProsubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
            listWrapper.eq(ProsubDocumentSellEntity::getSupplierId, subPicketageRefsupplierEntity.getSupplierId());
            if (subPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(ProsubDocumentSellEntity::getProjectId, subPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(ProsubDocumentSellEntity::getTenderFlag, 1);
            listWrapper.eq(ProsubDocumentSellEntity::getPassFlag, 1);
            List<ProsubDocumentSellEntity> documentSellList = super.list(listWrapper);


            List<ProsubDocumentSellEntity> listSell = documentSellList.stream().filter(map->(map.getSignNum() == null ? BigDecimal.ZERO :map.getSignNum()).compareTo(map.getTenderNum()) == -1).collect(Collectors.toList());

            if (CollectionUtils.isEmpty(listSell)) {
                return  null;
            }
            ProsubInviteEntity subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());
            List<ProsubInviteDetailRecordEntity> subDetailRecord = subInviteEntity.getSubDetailRecord();
            //获取计价方式
            Integer valueType = subInviteEntity.getValueType();

            List<ProsubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(listSell, ProsubDocumentSellVO.class);
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOList){
                subDocumentSellVO.setSurplusNum(subDocumentSellVO.getTenderNum().subtract(subDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : subDocumentSellVO.getSignNum()));
            }
            List<ProsubDocumentSellVO> listAll = new ArrayList<>();
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                ProsubDocumentDetailEntity subDocumentDetailEntity = subDocumentDetailService.selectById(subDocumentSellVO.getDetailId());
                Long parentId = subDocumentDetailEntity.getParentId();
                List<ProsubDocumentSellVO> detailByPid = getDetailByPid(parentId, subDetailRecord);
                listAll.addAll(detailByPid);
                sellList.clear();
                subDocumentSellVO.setSellId(subDocumentSellVO.getId());
                subDocumentSellVO.setParentId(subDocumentDetailEntity.getParentId());
                subDocumentSellVO.setId(subDocumentSellVO.getDetailId());
                listAll.add(subDocumentSellVO);
            }
            //实体去重
            listAll = listAll.stream().collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(ProsubDocumentSellVO::getId))), ArrayList::new)
            );
            if (valueType == 3) {//费率招标
                for (ProsubDocumentSellVO prosubDocumentSellVO : listAll) {
                    BigDecimal priceTax = prosubDocumentSellVO.getPriceTax();//含税单价
                    prosubDocumentSellVO.setPriceTax(new BigDecimal(1));//单价(含税)
                    if (prosubDocumentSellVO.getPrice() != null) {
                        prosubDocumentSellVO.setPrice(prosubDocumentSellVO.getPrice().divide(priceTax, 8, BigDecimal.ROUND_HALF_UP));//单价
                    }
                    if (prosubDocumentSellVO.getMoney() != null) {
                    prosubDocumentSellVO.setMoney(prosubDocumentSellVO.getMoney());//总额
                    }
                    if (prosubDocumentSellVO.getSellTax() != null) {
                    prosubDocumentSellVO.setSellTax(prosubDocumentSellVO.getSellTax());//税额
                    }
                    if (prosubDocumentSellVO.getMoneyTax() != null) {
                    prosubDocumentSellVO.setMoneyTax(prosubDocumentSellVO.getMoneyTax());//总额(含税)
                    }
                    if (prosubDocumentSellVO.getTenderNum() != null) {
                    prosubDocumentSellVO.setTenderNum(priceTax);//中标数量
                    }
                    if (prosubDocumentSellVO.getTenderMoney() != null) {
                    prosubDocumentSellVO.setTenderMoney(prosubDocumentSellVO.getTenderMoney());//中标金额
                    }
                    if (prosubDocumentSellVO.getTenderMoneyTax() != null) {
                    prosubDocumentSellVO.setTenderMoneyTax(prosubDocumentSellVO.getTenderMoneyTax());//中标金额(含税)
                    }
                    if (prosubDocumentSellVO.getInvitePrice() != null) {
                    prosubDocumentSellVO.setInvitePrice(prosubDocumentSellVO.getInvitePrice().divide(priceTax,8,BigDecimal.ROUND_HALF_UP));//招标控制单价
                    }
                    if (prosubDocumentSellVO.getInvitePriceTax() != null) {
                    prosubDocumentSellVO.setInvitePriceTax(prosubDocumentSellVO.getInvitePriceTax().divide(priceTax,8,BigDecimal.ROUND_HALF_UP));//招标控制单价(含税)
                    }
                    //可签数量（专业分包费率合同的特殊性）
                    if (prosubDocumentSellVO.getPriceTax() != null){
                        prosubDocumentSellVO.setSurplusNum(priceTax.subtract(prosubDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : prosubDocumentSellVO.getSignNum()));
                    }
                }
            }
            List<ProsubDocumentSellVO> sellList = listAll.stream().collect(Collectors.toList());
            subDocumentSellVOS = TreeNodeBUtil.buildTree(sellList);
        }
        //直接定标
        else {
            List<ProsubInviteDetailBidderEntity> bidderEntityList1 = subInviteService.selectById(subPicketageRefsupplierEntity.getPicketageId()).getSubDetailBidder();
            List<ProsubInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t->t.getNum()!=null).filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            for (ProsubInviteDetailBidderEntity bidderEntity : bidderEntityList1) {
                if (bidderEntity.getNum()==null){
                    bidderEntityList.add(bidderEntity);
                }
            }
            List<ProsubInviteDetailBidderVO> subDetailBidder = BeanMapper.mapList(bidderEntityList, ProsubInviteDetailBidderVO.class);
            for (ProsubInviteDetailBidderVO bidderVO : subDetailBidder) {
                ProsubDocumentSellVO subDocumentSellVO = new ProsubDocumentSellVO();
                subDocumentSellVO.setId(bidderVO.getId());
                subDocumentSellVO.setSellId(bidderVO.getId());
                subDocumentSellVO.setTreeIndex(bidderVO.getTreeIndex());
                subDocumentSellVO.setParentId(bidderVO.getParentId());
                subDocumentSellVO.setChildren(bidderVO.getChildren());
                subDocumentSellVO.setContent(bidderVO.getContent());
                subDocumentSellVO.setRule(bidderVO.getRule());
                subDocumentSellVO.setMaterialId(bidderVO.getDocId());
                subDocumentSellVO.setMaterialTypeId(bidderVO.getDocCategoryId());
                subDocumentSellVO.setMaterialCode(bidderVO.getDetailCode());
                subDocumentSellVO.setMaterialName(bidderVO.getDetailName());
                subDocumentSellVO.setUnit(bidderVO.getUnit());
                subDocumentSellVO.setTenderNum(bidderVO.getNum());
                subDocumentSellVO.setRate(bidderVO.getTaxRate());
                subDocumentSellVO.setMemo(bidderVO.getMemo());
                subDocumentSellVO.setPrice(bidderVO.getPrice());
                subDocumentSellVO.setPriceTax(bidderVO.getTaxPrice());
                subDocumentSellVO.setTenderMoney(bidderVO.getMny());
                subDocumentSellVO.setTenderMoneyTax(bidderVO.getTaxMny());
                subDocumentSellVO.setSellTax(bidderVO.getTax());
                if (bidderVO.getNum()!=null){
                    subDocumentSellVO.setSignNum(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum());
                    subDocumentSellVO.setSurplusNum(bidderVO.getNum().subtract(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum()));
                }

                subDocumentSellVOS.add(subDocumentSellVO);
            }
            subDocumentSellVOS = TreeNodeBUtil.buildTree(subDocumentSellVOS);
        }

        return subDocumentSellVOS;
    }

    @Override
    public List<ProsubSupplierDataVO> queryTreeList(Long id) {
        ProsubPicketageRefsupplierEntity subPicketageRefsupplierEntity = subPicketageRefsupplierService.selectById(id);
        //流程定标
        List<ProsubSupplierDataVO> subSupplierDataVOS = new ArrayList<>();
        if (subPicketageRefsupplierEntity.getPicketageFlag() == 0) {
            ProsubPicketageEntity subPicketageEntity = subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId());
            LambdaQueryWrapper<ProsubDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(ProsubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
            listWrapper.eq(ProsubDocumentSellEntity::getSupplierId, subPicketageRefsupplierEntity.getSupplierId());
            if (subPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(ProsubDocumentSellEntity::getProjectId, subPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(ProsubDocumentSellEntity::getTenderFlag, 1);
            listWrapper.eq(ProsubDocumentSellEntity::getPassFlag, 1);
            List<ProsubDocumentSellEntity> documentSellList = super.list(listWrapper);

            logger.info("流程定标数据{}", JSONObject.toJSONString(documentSellList));

            List<ProsubDocumentSellEntity> listSell = documentSellList.stream().filter(map->(map.getSignNum() == null ? BigDecimal.ZERO :map.getSignNum()).compareTo(map.getTenderNum()) == -1).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(listSell)) {
                return  null;
            }

            subSupplierDataVOS = BeanMapper.mapList(listSell, ProsubSupplierDataVO.class);
            for (ProsubSupplierDataVO subDocumentSellVO : subSupplierDataVOS){
                subDocumentSellVO.setSellId(subDocumentSellVO.getId());
                subDocumentSellVO.setSurplusNum(subDocumentSellVO.getTenderNum().subtract(subDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : subDocumentSellVO.getSignNum()));
            }
        }
        //直接定标
        else {
            List<ProsubInviteDetailBidderEntity> bidderEntityList1 = subInviteService.selectById(subPicketageRefsupplierEntity.getPicketageId()).getSubDetailBidder();
            List<ProsubInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t->t.getNum()!=null).filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            List<ProsubInviteDetailBidderVO> subDetailBidder = BeanMapper.mapList(bidderEntityList, ProsubInviteDetailBidderVO.class);
            for (ProsubInviteDetailBidderVO bidderVO : subDetailBidder) {
                ProsubSupplierDataVO subDocumentSellVO = new ProsubSupplierDataVO();
                subDocumentSellVO.setId(bidderVO.getId());
                subDocumentSellVO.setSellId(bidderVO.getId());
                subDocumentSellVO.setTreeIndex(bidderVO.getTreeIndex());
                subDocumentSellVO.setParentId(bidderVO.getParentId());
                subDocumentSellVO.setContent(bidderVO.getContent());
                subDocumentSellVO.setRule(bidderVO.getRule());
                subDocumentSellVO.setMaterialId(bidderVO.getDocId());
                subDocumentSellVO.setMaterialTypeId(bidderVO.getDocCategoryId());
                subDocumentSellVO.setMaterialCode(bidderVO.getDetailCode());
                subDocumentSellVO.setMaterialName(bidderVO.getDetailName());
                subDocumentSellVO.setUnit(bidderVO.getUnit());
                subDocumentSellVO.setTenderNum(bidderVO.getNum());
                subDocumentSellVO.setRate(bidderVO.getTaxRate());
                subDocumentSellVO.setMemo(bidderVO.getMemo());
                subDocumentSellVO.setPrice(bidderVO.getPrice());
                subDocumentSellVO.setPriceTax(bidderVO.getTaxPrice());
                subDocumentSellVO.setTenderMoney(bidderVO.getMny());
                subDocumentSellVO.setTenderMoneyTax(bidderVO.getTaxMny());
                subDocumentSellVO.setSellTax(bidderVO.getTax());
                if (bidderVO.getNum()!=null){
                    subDocumentSellVO.setSignNum(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum());
                    subDocumentSellVO.setSurplusNum(bidderVO.getNum().subtract(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum()));
                }

                subSupplierDataVOS.add(subDocumentSellVO);
            }
        }

        return subSupplierDataVOS;
    }

    List<ProsubDocumentSellVO> sellList = new ArrayList<ProsubDocumentSellVO>();

    private List<ProsubDocumentSellVO> getDetailByPid(Long id, List<ProsubInviteDetailRecordEntity> list) {

        for (ProsubInviteDetailRecordEntity recordEntity : list) {
            if (id != null && id.equals(recordEntity.getId())) {
                id = recordEntity.getParentId();
                getDetailByPid(id, list);

                //转换
                ProsubDocumentSellVO subDocumentSellVO = new ProsubDocumentSellVO();
                subDocumentSellVO.setMaterialCode(recordEntity.getDetailCode());
                subDocumentSellVO.setMaterialName(recordEntity.getDetailName());
                subDocumentSellVO.setRule(recordEntity.getRule());
                subDocumentSellVO.setContent(recordEntity.getContent());
                subDocumentSellVO.setUnit(recordEntity.getUnit());
                subDocumentSellVO.setParentId(recordEntity.getParentId());
                subDocumentSellVO.setId(recordEntity.getId());
                subDocumentSellVO.setTreeIndex(recordEntity.getTreeIndex());
                subDocumentSellVO.setMemo(recordEntity.getMemo());
                subDocumentSellVO.setMaterialId(recordEntity.getDocId());
                subDocumentSellVO.setMaterialTypeId(recordEntity.getDocCategoryId());
                sellList.add(subDocumentSellVO);
            }
        }
        return sellList;
    }
}

