package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.mapper.ProsubTalkMapper;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.*;
import com.ejianc.business.tender.stuff.vo.SupplierSellVO;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubTalkMapper;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@Service("prosubTalkService")
public class ProsubTalkServiceImpl extends BaseServiceImpl<ProsubTalkMapper, ProsubTalkEntity> implements IProsubTalkService {
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IProsubTalkDetailService subTalkDetailService;
    @Autowired
    private IProsubTalkRecordService subTalkRecordService;
    @Autowired
    private IProsubTalkRecordDetailService subTalkRecordDetailService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProsubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000002";
    @Transactional
    @Override
    public ProsubTalkVO publishTalk(Long id) {
        //更新发布状态
        ProsubTalkEntity subTalkEntity = super.selectById(id);
        subTalkEntity.setPublishFlag(0);
        super.updateById(subTalkEntity);

        //推送供应商
        ProsubDocumentSupplierTbVO subDocumentSupplierTbVO = new ProsubDocumentSupplierTbVO();
        subDocumentSupplierTbVO.setSourceId(subTalkEntity.getInviteId().toString());
        subDocumentSupplierTbVO.setSourceType("郑州一建洽商谈判");
        subDocumentSupplierTbVO.setNoticeType(4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(subTalkEntity.getTalkStartTime());
        subDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(subTalkEntity.getTalkEndTime());
        subDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        subDocumentSupplierTbVO.setMemo(subTalkEntity.getMemo());
        subDocumentSupplierTbVO.setTalkMoney(subTalkEntity.getTalkMoney());
        subDocumentSupplierTbVO.setTalkNum(subTalkEntity.getTalkNum());
        subDocumentSupplierTbVO.setTenderName(subTalkEntity.getTalkName());
        subDocumentSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString(subDocumentSupplierTbVO);
        logger.info("洽商谈判发布" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public ProsubTalkVO extendTalk(ProsubTalkDetailVO subTalkDetailVO) {
        ProsubTalkDetailEntity subDocumentRecordEntity = BeanMapper.map(subTalkDetailVO, ProsubTalkDetailEntity.class);
        subTalkDetailService.save(subDocumentRecordEntity);
        ProsubTalkEntity subTalkEntity = super.selectById(subTalkDetailVO.getTalkId());
        subTalkEntity.setTalkEndTime(subTalkDetailVO.getNewTime());
        boolean b = super.updateById(subTalkEntity);

        //推送供方
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(subTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(subTalkDetailVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);

        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,updateTimeUrl, stringFb,cacheManager);
//            if(!response.isSuccess()) {
//                throw new BusinessException("洽商谈判同步供方接口报错" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new BusinessException("洽商谈判同步供方接口报错" + response.getMsg());
//        }

        return queryDetail(subTalkDetailVO.getTalkId());
    }

    @Override
    public ProsubTalkVO saveTalk(Long documentId) {
        ProsubTalkEntity entity = new ProsubTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        ProsubDocumentEntity documentEntity = subDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        subDocumentService.saveOrUpdate(documentEntity);
        //查询招标立项信息
        ProsubDocumentEntity subDocumentEntity = subDocumentService.selectById(documentId);
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setProjectCode(subDocumentEntity.getProjectCode());
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setProjectId(subDocumentEntity.getProjectId());
        entity.setProjectName(subDocumentEntity.getProjectName());
        entity.setOrgId(subDocumentEntity.getOrgId());
        entity.setOrgName(subDocumentEntity.getOrgName());
        entity.setParentOrgId(subDocumentEntity.getParentOrgId());
        entity.setParentOrgName(subDocumentEntity.getParentOrgName());
        entity.setBrandFlag(subDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subDocumentEntity.getPurchaseType());
        entity.setTalkName(subInviteEntity.getTenderName());
        super.save(entity);

        //回写招标阶段

        subInviteEntity.setTenderStage(7);
        subInviteService.updateById(subInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(subDocumentEntity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/talkNegotiate");
        processService.saveOrUpdate(processEntity);

        ProsubTalkVO vo = BeanMapper.map(entity, ProsubTalkVO.class);

        ProsubTalkVO subTalkVO = queryDetail(vo.getId());
        return subTalkVO;
    }

    @Override
    public ProsubTalkVO queryDetail(Long id) {
        ProsubTalkEntity subTalkEntity = super.selectById(id);
        ProsubTalkVO subTalkVO = BeanMapper.map(subTalkEntity, ProsubTalkVO.class);

        //确认轮数
        Integer talkNum = subTalkEntity.getTalkNum();
        if (subTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
//        ProsubDocumentVO subDocumentVO = subDocumentService.queryDocDetail(subTalkEntity.getBillId(), talkNum);

        ProsubDocumentVO subDocumentVO = subDocumentService.queryDocDetailTalk(subTalkEntity.getBillId(), talkNum);

        //查询供应商报价方案数据


        subTalkVO.setSubDocumentDetailSellList(subDocumentVO.getSubDocumentDetailSellList());
        subTalkVO.setSubDocumentSupplierSchemeList(subDocumentVO.getSubDocumentSupplierSchemeList());

        //查询首轮报价的供应商信息
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambda = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambda.eq(ProsubDocumentSupplierEntity::getDocumentId, subTalkEntity.getBillId());
        lambda.eq(ProsubDocumentSupplierEntity::getTalkNum, 0);
        List<ProsubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambda);
        List<ProsubDocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(supplierList,ProsubDocumentSupplierVO.class);
        subTalkVO.setSubDocumentSupplierList(documentSupplierVOList);

        //查询变更历史记录
        LambdaQueryWrapper<ProsubTalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(ProsubTalkRecordEntity::getBillId,subTalkEntity.getBillId());
        lambdaRecord.orderByAsc(ProsubTalkRecordEntity::getTalkNum);
        List<ProsubTalkRecordEntity> subTalkRecordEntityList = subTalkRecordService.list(lambdaRecord);
        List<ProsubTalkRecordVO> subTalkRecordList = BeanMapper.mapList(subTalkRecordEntityList, ProsubTalkRecordVO.class);
        subTalkVO.setTalkRecordEntityList(subTalkRecordList);
        return subTalkVO;
    }
    @Transactional
    @Override
    public ProsubTalkVO againSaveTalk(Long id) {
        ProsubTalkEntity entity = new ProsubTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        ProsubTalkEntity subTalkEntity = super.selectById(id);
        entity.setProjectCode(subTalkEntity.getProjectCode());
        entity.setProjectId(subTalkEntity.getProjectId());
        entity.setProjectName(subTalkEntity.getProjectName());
        entity.setOrgId(subTalkEntity.getOrgId());
        entity.setOrgName(subTalkEntity.getOrgName());
        entity.setParentOrgId(subTalkEntity.getParentOrgId());
        entity.setParentOrgName(subTalkEntity.getParentOrgName());
        entity.setBrandFlag(subTalkEntity.getBrandFlag());
        entity.setBillId(subTalkEntity.getBillId());
        entity.setInviteId(subTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(subTalkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subTalkEntity.getPurchaseType());
        super.save(entity);

        //保存历史记录表
        ProsubTalkRecordEntity subTalkRecordEntity =  BeanMapper.map(subTalkEntity, ProsubTalkRecordEntity.class);
        subTalkRecordEntity.setTalkId(subTalkEntity.getId());
        subTalkRecordEntity.setId(null);
        subTalkRecordService.save(subTalkRecordEntity);
        //新增历史记录子表
        List<ProsubTalkDetailEntity> subTalkDetailList = subTalkEntity.getSubTalkDetailList();
        List<ProsubTalkRecordDetailEntity> subTalkRecordDetailEntityList = BeanMapper.mapList(subTalkDetailList, ProsubTalkRecordDetailEntity.class);
        for (ProsubTalkRecordDetailEntity subTalkRecordDetailEntity : subTalkRecordDetailEntityList){
            subTalkRecordDetailEntity.setId(null);
            subTalkRecordDetailEntity.setRecordId(subTalkRecordEntity.getId());
        }
        subTalkRecordDetailService.saveBatch(subTalkRecordDetailEntityList);

        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,subTalkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);
        ProsubTalkVO vo = BeanMapper.map(entity, ProsubTalkVO.class);
        addLastSell(subTalkEntity.getTalkNum(),subTalkEntity.getBillId());

        return queryDetail(entity.getId());
    }

    @Override
    public ProsubTalkVO replenishSell(Long id) {
        ProsubTalkEntity subTalkEntity = super.selectById(id);

        Integer talkNum = subTalkEntity.getTalkNum();
        Long billId = subTalkEntity.getBillId();
        addLastSell(talkNum,billId);

        return new ProsubTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        ProsubTalkEntity subTalkEntity = super.selectById(id);
        Integer talkNum = subTalkEntity.getTalkNum();
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplier = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, subTalkEntity.getBillId());
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, talkNum);
        List<ProsubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(ProsubDocumentSupplierEntity::getDocumentId, subTalkEntity.getBillId());
        lambdaSupplierFirst.eq(ProsubDocumentSupplierEntity::getTalkNum, 0);
        List<ProsubDocumentSupplierEntity> supplierListFirst = subDocumentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        Map<String, Object> stringListMap = new HashMap<>();
        ProsubTalkEntity subTalkEntity = baseMapper.selectById(talkId);
        List<ProsubQuotationMaterialVO> materialVOList = new ArrayList<>();
        //查询所有数据
        List<ProsubDocumentSellEntity> subDocumentSellEntities = subDocumentSellService.selectMaterialType(subTalkEntity.getBillId());
        Integer talkNum = subDocumentSellEntities.get(0).getTalkNum();
        List<ProsubDocumentSellVO> sellEntityList = BeanMapper.mapList(subDocumentSellEntities, ProsubDocumentSellVO.class);
        //根据材料分类
        Map<String, List<ProsubDocumentSellVO>> listMap = sellEntityList.stream().filter(map->map.getMaterialCode() != null).collect(Collectors.groupingBy(ProsubDocumentSellVO::getMaterialCode));
            for (String materialTypeId : listMap.keySet()) {
                ProsubQuotationMaterialVO materialVO = new ProsubQuotationMaterialVO();
                //获取供应商
                List<ProsubDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (ProsubDocumentSellVO sellVO : materialTypeList) {
                    materialVO  =  BeanMapper.map(sellVO, ProsubQuotationMaterialVO.class);
                }
                List<ProsubQuotationSupplierVO> subQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, ProsubQuotationSupplierVO.class);
                //供应商ID去重
                List<ProsubQuotationSupplierVO> supplierVOS = subQuotationSupplierVOS.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSupplierId()))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                //根据供应商分类
                Map<Long, List<ProsubDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map->map.getSupplierId() != null).collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));

                for (ProsubQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    //获取方案
                    List<ProsubDocumentSellVO> subDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                        supplierVO.setSupplierName(subDocumentSellVO.getSupplierName());
                    }
                    List<ProsubQuotationSchemeVO> subQuotationSchemeVOS = BeanMapper.mapList(subDocumentSellVOS, ProsubQuotationSchemeVO.class);
                    //根据方案名称去重
                    List<ProsubQuotationSchemeVO> schemeVOS = subQuotationSchemeVOS.stream()
                            .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<ProsubDocumentSellVO>> schemeMap = subDocumentSellVOS.stream().filter(map->map.getSchemeName() != null).collect(Collectors.groupingBy(ProsubDocumentSellVO::getSchemeName));
                    for (ProsubQuotationSchemeVO subQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<ProsubDocumentSellVO> priceList = schemeMap.get(subQuotationSchemeVO.getSchemeName());
                        //如果轮数小于最大轮数，添加一个空的对象
                        if (priceList.size()<talkNum+1){
                            ProsubDocumentSellVO documentSellVO = new ProsubDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0,documentSellVO);
                        }
                        subQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        stringListMap.put("MaterialTypeList",materialVOList);
        stringListMap.put("offerNum",subDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public ProsubTalkVO saveOrUpdates(ProsubTalkVO saveorUpdateVO) {
        ProsubTalkEntity entity = BeanMapper.map(saveorUpdateVO, ProsubTalkEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        ProsubTalkVO vo = BeanMapper.map(entity, ProsubTalkVO.class);
        ProsubTalkVO subTalkVO = queryDetail(vo.getId());
        return subTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplier = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, talkNum);
        List<ProsubDocumentSupplierEntity> supplierList = subDocumentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplierLast = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(ProsubDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(ProsubDocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<ProsubDocumentSupplierEntity> supplierListLast = subDocumentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(ProsubDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<ProsubDocumentSupplierEntity> documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<ProsubDocumentSupplierEntity> documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList, ProsubDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0) {
            return;
        }

        //推送供应商数据提示信息
        List<SupplierReplenishVO> replenishVOArrayList = new ArrayList<>();
        ProsubDocumentEntity subDocumentEntity = subDocumentService.selectById(docId);
        for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(subDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            if (subDocumentSupplierEntity.getSupplierTenantId() != null) {
                supplierReplenishVO.setTenantId(Long.toString(subDocumentSupplierEntity.getSupplierTenantId()));
            }
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        logger.info("再次洽商推送供方接口数据:" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateSupOffer, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("再次洽商推送供方接口数据response:" + stringCommonResponse.getMsg());
        }


        List<Long> supplierPkNew = documentSupplierEntityNewList.stream().map(ProsubDocumentSupplierEntity::getId).collect(Collectors.toList());

        for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            subDocumentSupplierEntity.setId(IdWorker.getId());
            subDocumentSupplierEntity.setTalkNum(talkNum);
        }
        subDocumentSupplierService.saveBatch(documentSupplierEntityNewList);

        //复制上一轮未报价的供应商的附件信息
        for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            for (ProsubDocumentSupplierEntity subDocumentSupplierLastEntity : supplierListLast) {
                if (subDocumentSupplierEntity.getSupplierId() != null) {
                    if (subDocumentSupplierEntity.getSupplierId().equals(subDocumentSupplierLastEntity.getSupplierId())) {
                        CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                                subDocumentSupplierLastEntity.getId().toString(),
                                BILL_SUPPLIER_TYPE,
                                "supplierFileType",
                                subDocumentSupplierEntity.getId().toString(),
                                BILL_SUPPLIER_TYPE,
                                "supplierFileType"
                        );
                        if (!responseCopy.isSuccess()) {
                            throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                        }
                    }
                } else {
                    if (subDocumentSupplierEntity.getLinkMobile().equals(subDocumentSupplierEntity.getLinkMobile())) {
                        CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                                subDocumentSupplierEntity.getId().toString(),
                                BILL_SUPPLIER_TYPE,
                                "supplierFileType",
                                subDocumentSupplierEntity.getId().toString(),
                                BILL_SUPPLIER_TYPE,
                                "supplierFileType"
                        );
                        if (!responseCopy.isSuccess()) {
                            throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                        }
                    }
                }

            }
        }

        //查询上一轮未报价供应商的方案
        LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, docId);
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, talkNum - 1);
        lambdaScheme.in(ProsubDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List<ProsubDocumentSchemeEntity> schemeList = subDocumentSchemeService.list(lambdaScheme);
        List<Long> schemePkList = schemeList.stream().map(ProsubDocumentSchemeEntity::getId).collect(Collectors.toList());
        for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
            subDocumentSchemeEntity.setId(IdWorker.getId());
            subDocumentSchemeEntity.setTalkNum(talkNum);
            for (ProsubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {

                if (subDocumentSchemeEntity.getIsMobile() != 1) {//二维码报价
                    if (subDocumentSchemeEntity.getSupplierId().equals(subDocumentSupplierEntity.getSupplierId())) {
                        subDocumentSchemeEntity.setDocumentSupplierId(subDocumentSupplierEntity.getId());
                    }
                } else {
                    if (subDocumentSchemeEntity.getSupplierName().equals(subDocumentSupplierEntity.getSupplierName())) {
                        subDocumentSchemeEntity.setDocumentSupplierId(subDocumentSupplierEntity.getId());
                    }
                }
            }
        }
        subDocumentSchemeService.saveBatch(schemeList);

        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(ProsubDocumentSellEntity::getSchemeId, schemePkList);
        List<ProsubDocumentSellEntity> sellList = subDocumentSellService.list(lambdaSell);
        for (ProsubDocumentSellEntity subDocumentSellEntity : sellList) {
            subDocumentSellEntity.setId(null);
            subDocumentSellEntity.setTalkNum(talkNum);
            for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
                if (subDocumentSellEntity.getIsMobile() != null) {
                    if (subDocumentSellEntity.getSupplierId().equals(subDocumentSchemeEntity.getSupplierId()) &&
                            subDocumentSellEntity.getSchemeName().equals(subDocumentSchemeEntity.getSchemeName())) {
                        subDocumentSellEntity.setSchemeId(subDocumentSchemeEntity.getId());
                    }
                } else {
                    if (subDocumentSellEntity.getSupplierName().equals(subDocumentSchemeEntity.getSupplierName()) &&
                            subDocumentSellEntity.getSchemeName().equals(subDocumentSchemeEntity.getSchemeName())) {
                        subDocumentSellEntity.setSchemeId(subDocumentSchemeEntity.getId());
                    }
                }
            }
        }
        subDocumentSellService.saveBatch(sellList);
    }
}
