package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.rent.vo.RentPlanEnum;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentPicketageRefsupplierService;
import com.ejianc.business.tender.rent.vo.RentInviteDetailVO;
import com.ejianc.business.tender.rent.bean.RentInviteDetailEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.service.IRentInviteDetailService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.bean.RentPicketageRefsupplierEntity;
import com.ejianc.business.tender.rent.vo.RentInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("rentInvite")
public class RentInviteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private IRentInviteService service;

	@Autowired
	private IRentInviteDetailService detailService;

	@Autowired
	private IRentPicketageRefsupplierService picketageRefsupplierService;

	@Autowired
	private IProjectPoolApi projectPoolApi;
	

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state ||BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			RentInviteEntity inviteEntity = service.selectById(billId);
			List<RentInviteDetailVO> detailVOList = new ArrayList<>();
			if (inviteEntity.getPurchaseType()==0){
				 detailVOList = service.selectSumDetail(billId);
			}else {
				 detailVOList  =  service.selectOrgSumDetail(billId);
			}
			for (RentInviteDetailVO rentInviteDetailVO : detailVOList) {
				rentInviteDetailVO.setNum(rentInviteDetailVO.getSumNum());
				rentInviteDetailVO.setMoney(rentInviteDetailVO.getSumMoney());
				rentInviteDetailVO.setMoneyTax(rentInviteDetailVO.getSumMoneyTax());
				rentInviteDetailVO.setPlanNum(rentInviteDetailVO.getSumPlanNum());
				detailService.saveOrUpdate(BeanMapper.map(rentInviteDetailVO, RentInviteDetailEntity.class));
			}
			if (inviteEntity.getEstablishType()==1){
				// 获取采购计划ID
				if (CollectionUtils.isNotEmpty(inviteEntity.getRentDetailRecord())) {
					// 释放采购计划
					service.updateApiState(inviteEntity, RentPlanEnum.PLAN_STATE_OVER.getPlanState(), RentPlanEnum.PLAN_STATE_OVER.getPlanState());
				}
			}
			List<RentInviteDetailBidderVO> detailBidderList =  service.selectDetailBidder(billId);
			String tenderUnitNum = "";
			for (RentInviteDetailBidderVO detailBidderVO : detailBidderList) {
				RentPicketageRefsupplierEntity rentPicketageRefsupplierEntity = new RentPicketageRefsupplierEntity();
				rentPicketageRefsupplierEntity.setPicketageId(billId);
				rentPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName()+"定标");
				rentPicketageRefsupplierEntity.setPicketageDate(new Date());

				rentPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
				rentPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
				rentPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
				rentPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
				rentPicketageRefsupplierEntity.setProjectId(detailBidderVO.getDetailProjectId());
				rentPicketageRefsupplierEntity.setProjectName(detailBidderVO.getDetailProjectName());
				//如果是项目招标，子表orgId为项目部id
				if (inviteEntity.getPurchaseType()==0){
					Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
					CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(Collections.singletonList(detailBidderVO.getDetailProjectId()));
					if (jsonArrayCommonResponse.isSuccess()){
						JSONArray data = jsonArrayCommonResponse.getData();
						List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
						proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
						ProjectPoolSetVO projectPoolSetVO = proMap.get(detailBidderVO.getDetailProjectId());
						if (projectPoolSetVO != null){
							rentPicketageRefsupplierEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
							rentPicketageRefsupplierEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
						}
					}
				}else {
					rentPicketageRefsupplierEntity.setOrgId(detailBidderVO.getDetailOrgId());
					rentPicketageRefsupplierEntity.setOrgName(detailBidderVO.getDetailOrgName());
				}
				//暂时使用主表
//				rentPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
//				rentPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
//				rentPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
//				rentPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
//				rentPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
//				rentPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
//				rentPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
				rentPicketageRefsupplierEntity.setOccupyFlag(0);
				rentPicketageRefsupplierEntity.setPicketageFlag(1);
				rentPicketageRefsupplierEntity.setRentType(inviteEntity.getRentType());
				rentPicketageRefsupplierEntity.setSignStatus(0);
				rentPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
				picketageRefsupplierService.saveOrUpdate(rentPicketageRefsupplierEntity);
				BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4,BigDecimal.ROUND_HALF_UP);
				tenderUnitNum+=detailBidderVO.getSupplierName()+"("+sumNum+"),";
			}
			if (tenderUnitNum.length() > 1) {
				tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
			}
			inviteEntity.setTenderUnitNum(tenderUnitNum);
			service.saveOrUpdate(inviteEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getOccupyState()!= null && inviteEntity.getOccupyState()==1){
			return CommonResponse.error("招标已被占用,不能撤回!");
		}
		if (inviteEntity.getTenderStage()>1){
			return CommonResponse.error("招标处于"+ TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription()+",不能撤回!");
		}
		if (inviteEntity.getEstablishType()==1){
			QueryWrapper<RentPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
			refWrapper.eq("picketage_id",inviteEntity.getId());
			List<RentPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
			for (RentPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
				if (refsupplierEntity.getSignStatus()!=0){
					return CommonResponse.error("存在已签订合同,不能撤回!");
				}
			}
			picketageRefsupplierService.remove(refWrapper);
		}
		detailService.delByInviteId(inviteEntity.getId());
//		QueryWrapper<RentInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//		detailWrapper.eq("invite_id",inviteEntity.getId());
//		detailService.remove(detailWrapper);
		return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getEstablishType()==1){
			// 获取采购计划ID
			if (CollectionUtils.isNotEmpty(inviteEntity.getRentDetailRecord())) {
				// 释放采购计划
				service.updateApiState(inviteEntity, RentPlanEnum.PLAN_STATE_EXEC.getPlanState(), RentPlanEnum.PLAN_STATE_EXEC.getPlanState());
			}
		}
		return CommonResponse.success();
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			RentInviteEntity entity = service.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
