package com.ejianc.business.tender.rmat.controller;

import com.ejianc.business.tender.rmat.vo.RmatPicketageSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatPicketageVO;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 定标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rmatPicketage")
@Api(value = "定标主表", tags = {"定标主表"})
public class RmatPicketageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IRmatPicketageService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatPicketageVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody RmatPicketageVO saveorUpdateVO) {
        RmatPicketageVO rmatPicketageVO = service.saveOrUpdates(saveorUpdateVO);
    	return CommonResponse.success("初始化基础数据成功！",rmatPicketageVO);
    }
    @ApiOperation("新增或者修改子表供应商")
    @RequestMapping(value = "/saveSupplierBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatPicketageVO> saveSupplierBatch(@RequestBody RmatPicketageVO saveorUpdateVO) {
        RmatPicketageVO rmatPicketageVO = service.saveSupplierBatch(saveorUpdateVO);
        return CommonResponse.success("更新成功！",rmatPicketageVO);
    }
    @ApiOperation("专家评标下一步接口")
    @RequestMapping(value = "/savePicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatPicketageVO> savePicketage(@RequestParam Long evaluationId) {
        RmatPicketageVO rmatPicketageVO = service.savePicketage(evaluationId);
        return CommonResponse.success("初始化基础数据成功！",rmatPicketageVO);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatPicketageVO> queryDetail(@RequestParam Long id) {
        RmatPicketageVO rmatPicketageVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",rmatPicketageVO);
    }

    @ApiOperation("紧急招标询价等下一步接口")
    @RequestMapping(value = "/saveManyPicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatPicketageVO> saveManyPicketage(@RequestParam Long documentId) {
        RmatPicketageVO rmatPicketageVO = service.saveManyPicketage(documentId);
        return CommonResponse.success("初始化基础数据成功！",rmatPicketageVO);
    }

    @ApiOperation("查询供应商列表详情")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RmatPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
        List<RmatPicketageSupplierVO> list = service.querySupplierList(picketageId);
        return CommonResponse.success("查询详情数据成功！",list);
    }


}
