package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.vo.*;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.mapper.RmatWinnoticeMapper;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffWinnoticeEntity;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标公告表
 * 
 * @author generator
 * 
 */
@Service("rmatWinnoticeService")
public class RmatWinnoticeServiceImpl extends BaseServiceImpl<RmatWinnoticeMapper, RmatWinnoticeEntity> implements IRmatWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatNoticeService rmatNoticeService;
    @Autowired
    private IRmatDocumentService rmatDocumentService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatBidDetailService rmatBidDetailService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private IRmatBidSupplierService rmatBidSupplierService;
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value("${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRmatPicketageSupplierService rmatPicketageSupplierService;
    private static final String BILL_TYPE = "BT220210000000014";//此处需要根据实际修改
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Transactional
    @Override
    public RmatWinnoticeVO saveWinnotice(Long picketageId) {
        RmatWinnoticeEntity entity = new RmatWinnoticeEntity();
        entity.setPicketageId(picketageId);
        RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(picketageId);
        RmatInviteEntity inviteEntity = rmatInviteService.selectById(rmatPicketageEntity.getInviteId());
        entity.setInviteId(rmatPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName()+"中标公告");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());

        //采购方式(0-项目采购,1-单位采购)
        if (inviteEntity.getPurchaseType().equals(0)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }

        RmatDocumentEntity rmatDocumentEntity = rmatDocumentService.selectById(rmatPicketageEntity.getDocumentId());
        entity.setEmployeeId(rmatDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);//签章状态，未签章
        entity.setLineTypeName(CommonUtils.getTypeName(4));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate(entity, false);

        //回写定标数据
        rmatPicketageEntity.setWinnoticeStatus(1);
        rmatPicketageEntity.setWinnoticeId(entity.getId());
        rmatPicketageService.updateById(rmatPicketageEntity);

        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        rmatInviteService.updateById(inviteEntity);
//回写定标子表数据
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        for (RmatPicketageSupplierEntity rmatPicketageSupplierEntity : picketageSupplierList){
            rmatPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        rmatPicketageSupplierService.updateBatchById(picketageSupplierList);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rmat/winnotice");
        processService.saveOrUpdate(processEntity);
        RmatWinnoticeVO rmatWinnoticeVO = BeanMapper.map(entity, RmatWinnoticeVO.class);
        return rmatWinnoticeVO;
    }

    @Override
    public RmatWinnoticeVO queryDetail(Long id) {
        RmatWinnoticeEntity rmatWinnoticeEntity = super.selectById(id);
        RmatWinnoticeVO rmatWinnoticeVO = BeanMapper.map(rmatWinnoticeEntity, RmatWinnoticeVO.class);
        RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(rmatWinnoticeEntity.getPicketageId());
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        List<RmatPicketageSupplierVO> rmatPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, RmatPicketageSupplierVO.class);
        rmatWinnoticeVO.setPicketageSupplierList(rmatPicketageSupplierList);



        //处理签章附件信息
        if (rmatWinnoticeVO!=null) {
            Long id1 = rmatWinnoticeVO.getId();
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(id1, BILL_TYPE, "tenderWinnotice", "");
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));

                    AttachmentVO attachmentVO = attacMap.get(rmatWinnoticeVO.getId());
                    if (attachmentVO != null) {
                        rmatWinnoticeVO.setAttachId(attachmentVO.getId());
                        rmatWinnoticeVO.setFileName(attachmentVO.getFileName());
                        rmatWinnoticeVO.setFilePath(attachmentVO.getFilePath());
                    }

                }
            }
        }
        return rmatWinnoticeVO;
    }

    @Override
    public RmatWinnoticeVO publishWinnotice(Long id) {
        
        //更新发布状态
        RmatWinnoticeEntity rmatWinnoticeEntity = super.selectById(id);
        rmatWinnoticeEntity.setPublishFlag(0);
        super.updateById(rmatWinnoticeEntity);

        //回写定标数据
        RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(rmatWinnoticeEntity.getPicketageId());
        rmatPicketageEntity.setWinnoticeStatus(2);
        rmatPicketageService.updateById(rmatPicketageEntity);

        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatPicketageEntity.getInviteId());

        //调用供方接口
        //调用第三方报名接口
        //推送供应商
        RmatWinVO winVO = new RmatWinVO();
        winVO.setSourceType("郑州一建中标公告");
        winVO.setSourceId(Long.toString(rmatWinnoticeEntity.getInviteId()));
        winVO.setBillCode(rmatInviteEntity.getBillCode());
        //采购方式(0-项目采购,1-单位采购)
        if (rmatInviteEntity.getPurchaseType() == 0){
            winVO.setSourceProjectId(Long.toString(rmatInviteEntity.getProjectId()));
            winVO.setProjectName(rmatInviteEntity.getProjectName());
            winVO.setProjectCode(rmatInviteEntity.getProjectCode());
        }

        if (rmatInviteEntity.getPurchaseType() == 1){
            winVO.setOrgName(rmatInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(rmatInviteEntity.getOrgId()));

        }
        winVO.setSourceUnitId(Long.toString(rmatInviteEntity.getUnitId()));
        winVO.setUnitName(rmatInviteEntity.getUnitName());
        winVO.setType("RMAT");
        winVO.setTenderName(rmatInviteEntity.getTenderName());
        winVO.setTenderType(rmatInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(rmatWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(rmatWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(rmatWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(rmatInviteEntity.getPurchaseType());
        winVO.setWinDate(rmatWinnoticeEntity.getWinDate());
        winVO.setStopDate(rmatWinnoticeEntity.getStopDate());
        winVO.setWinTitle(rmatWinnoticeEntity.getTitleName());
        winVO.setMemo(rmatWinnoticeEntity.getMemo());
        winVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        //明细设置
        List<RmatPicketageSupplierEntity> picketageSupplierList = rmatPicketageEntity.getPicketageSupplierList();
        ArrayList<RmatWinDetailVO> winDetailVOS = new ArrayList<>();
        for (RmatPicketageSupplierEntity rmatPicketageSupplierEntity : picketageSupplierList){
            RmatWinDetailVO winDetailVO = new RmatWinDetailVO();
            winDetailVO.setWinId(rmatWinnoticeEntity.getId());
            winDetailVO.setSupplierName(rmatPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(rmatPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = shareSupplierApi.queryById(rmatPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(rmatPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString(winVO);
        logger.info("中标公告发布" + stringFb);
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winSaveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标公告同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public RmatWinnoticeVO saveOrUpdates(RmatWinnoticeEntity entity) {
        super.saveOrUpdate(entity,false);
        return queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        RmatWinnoticeEntity rmatWinnoticeEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            rmatWinnoticeEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            rmatWinnoticeEntity.setSignFlag(1);
        }
        if(status == 4){
            rmatWinnoticeEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(rmatWinnoticeEntity.getId());
            cv.setContractName(rmatWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(rmatWinnoticeEntity);

        return CommonResponse.success("更新成功!");
    }
}
